/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzig;
import com.google.android.gms.internal.measurement.zzih;
import java.util.Map;

public final class zzdu
extends zzdy {
    private final Map<String, Long> zzaeu;
    private final Map<String, Integer> zzaev = new ArrayMap();
    private long zzaew;

    public zzdu(zzgn zzgn2) {
        super(zzgn2);
        this.zzaeu = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhi)this).zzgi().zziv().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhi)this).zzbt().elapsedRealtime();
        ((zzhi)this).zzgh().zzc(new zzdv(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzhi)this).zzfv();
        ((zzhi)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzaev.isEmpty()) {
            this.zzaew = l;
        }
        if ((n = this.zzaev.get(string)) != null) {
            this.zzaev.put(string, n + 1);
            return;
        }
        if (this.zzaev.size() >= 100) {
            ((zzhi)this).zzgi().zziy().log("Too many ads visible");
            return;
        }
        this.zzaev.put(string, 1);
        this.zzaeu.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzhi)this).zzgi().zziv().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzhi)this).zzbt().elapsedRealtime();
        ((zzhi)this).zzgh().zzc(new zzdw(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzhi)this).zzfv();
        ((zzhi)this).zzab();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzaev.get(string);
        if (n != null) {
            zzig zzig2 = ((zzdy)this).zzgb().zzkn();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzaev.remove(string);
                Long l2 = this.zzaeu.get(string);
                if (l2 == null) {
                    ((zzhi)this).zzgi().zziv().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzaeu.remove(string);
                    this.zza(string, l3, zzig2);
                }
                if (this.zzaev.isEmpty()) {
                    if (this.zzaew == 0L) {
                        ((zzhi)this).zzgi().zziv().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzaew, zzig2);
                    this.zzaew = 0L;
                }
                return;
            }
            this.zzaev.put(string, n2);
            return;
        }
        ((zzhi)this).zzgi().zziv().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzig zzig2) {
        if (zzig2 == null) {
            ((zzhi)this).zzgi().zzjc().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhi)this).zzgi().zzjc().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzih.zza(zzig2, bundle, true);
        ((zzdy)this).zzfy().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzig zzig2) {
        if (zzig2 == null) {
            ((zzhi)this).zzgi().zzjc().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzhi)this).zzgi().zzjc().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzih.zza(zzig2, bundle, true);
        ((zzdy)this).zzfy().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzp(long l) {
        zzig zzig2 = ((zzdy)this).zzgb().zzkn();
        for (String string : this.zzaeu.keySet()) {
            long l2 = this.zzaeu.get(string);
            this.zza(string, l - l2, zzig2);
        }
        if (!this.zzaeu.isEmpty()) {
            this.zza(l - this.zzaew, zzig2);
        }
        this.zzq(l);
    }

    @WorkerThread
    private final void zzq(long l) {
        for (String string : this.zzaeu.keySet()) {
            this.zzaeu.put(string, l);
        }
        if (!this.zzaeu.isEmpty()) {
            this.zzaew = l;
        }
    }

    static /* synthetic */ void zza(zzdu zzdu2, String string, long l) {
        zzdu2.zza(string, l);
    }

    static /* synthetic */ void zzb(zzdu zzdu2, String string, long l) {
        zzdu2.zzb(string, l);
    }

    static /* synthetic */ void zza(zzdu zzdu2, long l) {
        zzdu2.zzq(l);
    }
}

