/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkd;
import java.util.ArrayList;
import java.util.List;

public final class zzfe
extends zzdz {
    private final zzff zzakf = new zzff(this, ((zzhi)this).getContext(), "google_app_measurement_local.db");
    private boolean zzakg;

    zzfe(zzgn zzgn2) {
        super(zzgn2);
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }

    @WorkerThread
    public final void resetAnalyticsData() {
        ((zzhi)this).zzfv();
        ((zzhi)this).zzab();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0 + sQLiteDatabase.delete("messages", null, null);
            if (n > 0) {
                ((zzhi)this).zzgi().zzjc().zzg("Reset local analytics data. records", n);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzhi)this).zzgi().zziv().zzg("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        ((zzhi)this).zzfv();
        ((zzhi)this).zzab();
        if (this.zzakg) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzhi)this).zzgi().zziy().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzhi)this).zzgi().zziv().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzhi)this).zzgi().zziv().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzakg = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzhi)this).zzgi().zziv().zzg("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzakg = true;
                    break block20;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzhi)this).zzgi().zziv().zzg("Error writing entry to local database", (Object)sQLiteException);
                    this.zzakg = true;
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzex zzex2) {
        Parcel parcel = Parcel.obtain();
        zzex2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzhi)this).zzgi().zziy().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zzka zzka2) {
        Parcel parcel = Parcel.obtain();
        zzka2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzhi)this).zzgi().zziy().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    public final boolean zzc(zzef zzef2) {
        ((zzhi)this).zzgg();
        byte[] byArray = zzkd.zza((Parcelable)zzef2);
        if (byArray.length > 131072) {
            ((zzhi)this).zzgi().zziy().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<AbstractSafeParcelable> zzp(int n) {
        ((zzhi)this).zzab();
        ((zzhi)this).zzfv();
        if (this.zzakg) {
            return null;
        }
        ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
        if (!((zzhi)this).getContext().getDatabasePath("google_app_measurement_local.db").exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzhi)this).zzgi().zziy().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            AbstractSafeParcelable abstractSafeParcelable;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzex)((Object)zzex.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzhi)this).zzgi().zziv().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzka)((Object)zzka.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzhi)this).zzgi().zziv().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzef)((Object)zzef.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzhi)this).zzgi().zziv().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            ((zzhi)this).zzgi().zziv().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzhi)this).zzgi().zziv().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzakg = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzhi)this).zzgi().zziv().zzg("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzakg = true;
                    break block41;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzhi)this).zzgi().zziv().zzg("Error reading entries from local database", (Object)sQLiteException);
                    this.zzakg = true;
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @VisibleForTesting
    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() throws SQLiteException {
        if (this.zzakg) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzakf.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzakg = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

