/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zzik;
import com.google.android.gms.internal.measurement.zziz;
import com.google.android.gms.internal.measurement.zzja;
import com.google.android.gms.internal.measurement.zzjb;
import com.google.android.gms.internal.measurement.zzjc;
import com.google.android.gms.internal.measurement.zzjd;

@VisibleForTesting
public final class zziy
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzarb;
    private volatile zzfh zzarc;
    final /* synthetic */ zzik zzaqv;

    protected zziy(zzik zzik2) {
        this.zzaqv = zzik2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzc(Intent intent) {
        ((zzhi)this.zzaqv).zzab();
        Context context = ((zzhi)this.zzaqv).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zziy zziy2 = this;
        synchronized (zziy2) {
            if (this.zzarb) {
                ((zzhi)this.zzaqv).zzgi().zzjc().log("Connection attempt already in progress");
                return;
            }
            ((zzhi)this.zzaqv).zzgi().zzjc().log("Using local app measurement service");
            this.zzarb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzik.zza(this.zzaqv), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zziy zziy2 = this;
        synchronized (zziy2) {
            String string;
            if (iBinder == null) {
                this.zzarb = false;
                ((zzhi)this.zzaqv).zzgi().zziv().log("Service connected with null binder");
                return;
            }
            zzfa zzfa2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfa2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfa ? (zzfa)iInterface : new zzfc(iBinder2));
                    ((zzhi)this.zzaqv).zzgi().zzjc().log("Bound to IMeasurementService interface");
                } else {
                    ((zzhi)this.zzaqv).zzgi().zziv().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzhi)this.zzaqv).zzgi().zziv().log("Service connect failed to get IMeasurementService");
            }
            if (zzfa2 == null) {
                this.zzarb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzhi)this.zzaqv).getContext(), (ServiceConnection)zzik.zza(this.zzaqv));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfa2;
                ((zzhi)this.zzaqv).zzgh().zzc(new zziz(this, (zzfa)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzhi)this.zzaqv).zzgi().zzjb().log("Service disconnected");
        ((zzhi)this.zzaqv).zzgh().zzc(new zzja(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzkt() {
        ((zzhi)this.zzaqv).zzab();
        Context context = ((zzhi)this.zzaqv).getContext();
        zziy zziy2 = this;
        synchronized (zziy2) {
            if (this.zzarb) {
                ((zzhi)this.zzaqv).zzgi().zzjc().log("Connection attempt already in progress");
                return;
            }
            if (this.zzarc != null) {
                ((zzhi)this.zzaqv).zzgi().zzjc().log("Already awaiting connection attempt");
                return;
            }
            this.zzarc = new zzfh(context, Looper.getMainLooper(), this, this);
            ((zzhi)this.zzaqv).zzgi().zzjc().log("Connecting to remote service");
            this.zzarb = true;
            this.zzarc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zziy zziy2 = this;
        synchronized (zziy2) {
            try {
                zzfa zzfa2 = (zzfa)this.zzarc.getService();
                this.zzarc = null;
                ((zzhi)this.zzaqv).zzgh().zzc(new zzjb(this, zzfa2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzarc = null;
                this.zzarb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzhi)this.zzaqv).zzgi().zzjb().log("Service connection suspended");
        ((zzhi)this.zzaqv).zzgh().zzc(new zzjc(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfi zzfi2 = this.zzaqv.zzacv.zzjy();
        if (zzfi2 != null) {
            zzfi2.zziy().zzg("Service connection failed", connectionResult);
        }
        zziy zziy2 = this;
        synchronized (zziy2) {
            this.zzarb = false;
            this.zzarc = null;
        }
        ((zzhi)this.zzaqv).zzgh().zzc(new zzjd(this));
    }

    static /* synthetic */ boolean zza(zziy zziy2, boolean bl) {
        zziy2.zzarb = false;
        return false;
    }
}

