/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdn;
import com.google.android.gms.measurement.internal.zzdp;
import com.google.android.gms.measurement.internal.zzdq;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfk;
import java.util.Map;

public final class zzdo
extends zzf {
    @VisibleForTesting
    protected zzdn zzaro;
    private volatile zzdn zzarp;
    private zzdn zzarq;
    private final Map<Activity, zzdn> zzarr = new ArrayMap();
    private zzdn zzars;
    private String zzart;

    public zzdo(zzbt zzbt2) {
        super(zzbt2);
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }

    @WorkerThread
    public final zzdn zzla() {
        this.zzcl();
        ((zzco)this).zzaf();
        return this.zzaro;
    }

    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzarp == null) {
            ((zzco)this).zzgo().zzjg().zzbx("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzarr.get(activity) == null) {
            ((zzco)this).zzgo().zzjg().zzbx("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzdo.zzcn(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzarp.zzarl.equals(string2);
        boolean bl2 = zzfk.zzu(this.zzarp.zzuw, string);
        if (bl && bl2) {
            ((zzco)this).zzgo().zzji().zzbx("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzco)this).zzgo().zzjg().zzg("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzco)this).zzgo().zzjg().zzg("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzco)this).zzgo().zzjl().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzdn zzdn2 = new zzdn(string, string2, ((zzco)this).zzgm().zzmc());
        this.zzarr.put(activity, zzdn2);
        this.zza(activity, zzdn2, true);
    }

    public final zzdn zzlb() {
        ((zzco)this).zzgb();
        return this.zzarp;
    }

    @MainThread
    private final void zza(Activity activity, zzdn zzdn2, boolean bl) {
        zzdn zzdn3;
        zzdn zzdn4 = zzdn3 = this.zzarp == null ? this.zzarq : this.zzarp;
        if (zzdn2.zzarl == null) {
            zzdn2 = new zzdn(zzdn2.zzuw, zzdo.zzcn(activity.getClass().getCanonicalName()), zzdn2.zzarm);
        }
        zzdn zzdn5 = zzdn2;
        this.zzarq = this.zzarp;
        this.zzarp = zzdn5;
        ((zzco)this).zzgn().zzc(new zzdp(this, bl, zzdn3, zzdn5));
    }

    @WorkerThread
    private final void zza(@NonNull zzdn zzdn2) {
        ((zze)this).zzgd().zzq(((zzco)this).zzbx().elapsedRealtime());
        if (((zze)this).zzgj().zzn(zzdn2.zzarn)) {
            zzdn2.zzarn = false;
        }
    }

    public static void zza(zzdn zzdn2, Bundle bundle, boolean bl) {
        if (bundle != null && zzdn2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzdn2.zzuw != null) {
                bundle.putString("_sn", zzdn2.zzuw);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzdn2.zzarl);
            bundle.putLong("_si", zzdn2.zzarm);
            return;
        }
        if (bundle != null && zzdn2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzdn zzdn2) {
        ((zzco)this).zzaf();
        zzdo zzdo2 = this;
        synchronized (zzdo2) {
            if (this.zzart == null || this.zzart.equals(string) || zzdn2 != null) {
                this.zzart = string;
                this.zzars = zzdn2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzcn(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzdn zze(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzdn zzdn2 = this.zzarr.get(activity);
        if (zzdn2 == null) {
            String string = zzdo.zzcn(activity.getClass().getCanonicalName());
            zzdn2 = new zzdn(null, string, ((zzco)this).zzgm().zzmc());
            this.zzarr.put(activity, zzdn2);
        }
        return zzdn2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzdn zzdn2 = new zzdn(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzarr.put(activity, zzdn2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzdn zzdn2 = this.zze(activity);
        this.zza(activity, zzdn2, false);
        zza zza2 = ((zze)this).zzgd();
        long l = ((zzco)zza2).zzbx().elapsedRealtime();
        ((zzco)zza2).zzgn().zzc(new zzd(zza2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzdn zzdn2 = this.zze(activity);
        this.zzarq = this.zzarp;
        this.zzarp = null;
        ((zzco)this).zzgn().zzc(new zzdq(this, zzdn2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzdn zzdn2 = this.zzarr.get(activity);
        if (zzdn2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzdn2.zzarm);
        bundle2.putString("name", zzdn2.zzuw);
        bundle2.putString("referrer_name", zzdn2.zzarl);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzarr.remove(activity);
    }

    static /* synthetic */ void zza(zzdo zzdo2, zzdn zzdn2) {
        zzdo2.zza(zzdn2);
    }
}

