/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzdn;
import com.google.android.gms.measurement.internal.zzds;
import com.google.android.gms.measurement.internal.zzdt;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzv;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzdr
extends zzf {
    private final zzef zzarz;
    private zzag zzasa;
    private volatile Boolean zzasb;
    private final zzv zzasc;
    private final zzev zzasd;
    private final List<Runnable> zzase = new ArrayList<Runnable>();
    private final zzv zzasf;

    protected zzdr(zzbt zzbt2) {
        super(zzbt2);
        this.zzasd = new zzev(zzbt2.zzbx());
        this.zzarz = new zzef(this);
        this.zzasc = new zzds(this, zzbt2);
        this.zzasf = new zzdx(this, zzbt2);
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzco)this).zzaf();
        this.zzcl();
        return this.zzasa != null;
    }

    @WorkerThread
    protected final void zzlc() {
        ((zzco)this).zzaf();
        this.zzcl();
        zzh zzh2 = this.zzm(true);
        this.zzf(new zzdy(this, zzh2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzag zzag2, AbstractSafeParcelable abstractSafeParcelable, zzh zzh2) {
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        this.zzcl();
        boolean bl = this.zzld();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zze)this).zzgi().zzr(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzad) {
                    try {
                        zzag2.zza((zzad)abstractSafeParcelable2, zzh2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzco)this).zzgo().zzjd().zzg("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzfh) {
                    try {
                        zzag2.zza((zzfh)abstractSafeParcelable2, zzh2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzco)this).zzgo().zzjd().zzg("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzl) {
                    try {
                        zzag2.zza((zzl)abstractSafeParcelable2, zzh2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzco)this).zzgo().zzjd().zzg("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzco)this).zzgo().zzjd().zzbx("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzb(zzad zzad2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzad2));
        ((zzco)this).zzaf();
        this.zzcl();
        boolean bl = this.zzld();
        boolean bl2 = bl && ((zze)this).zzgi().zza(zzad2);
        zzh zzh2 = this.zzm(true);
        this.zzf(new zzdz(this, bl, bl2, zzad2, zzh2, string));
    }

    @WorkerThread
    protected final void zzd(zzl zzl2) {
        Preconditions.checkNotNull((Object)((Object)zzl2));
        ((zzco)this).zzaf();
        this.zzcl();
        zzk zzk2 = ((zzco)this).zzgr();
        boolean bl = true;
        boolean bl2 = true && ((zze)this).zzgi().zzc(zzl2);
        zzl zzl3 = new zzl(zzl2);
        zzh zzh2 = this.zzm(true);
        this.zzf(new zzea(this, bl, bl2, zzl3, zzh2, zzl2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzl>> atomicReference, String string, String string2, String string3) {
        ((zzco)this).zzaf();
        this.zzcl();
        zzh zzh2 = this.zzm(false);
        this.zzf(new zzeb(this, atomicReference, string, string2, string3, zzh2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzfh>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzco)this).zzaf();
        this.zzcl();
        zzh zzh2 = this.zzm(false);
        this.zzf(new zzec(this, atomicReference, string, string2, string3, bl, zzh2));
    }

    @WorkerThread
    protected final void zzb(zzfh zzfh2) {
        ((zzco)this).zzaf();
        this.zzcl();
        boolean bl = this.zzld() && ((zze)this).zzgi().zza(zzfh2);
        zzh zzh2 = this.zzm(true);
        this.zzf(new zzed(this, bl, zzfh2, zzh2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzfh>> atomicReference, boolean bl) {
        ((zzco)this).zzaf();
        this.zzcl();
        zzh zzh2 = this.zzm(false);
        this.zzf(new zzee(this, atomicReference, zzh2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzco)this).zzaf();
        ((zzco)this).zzgb();
        this.zzcl();
        zzh zzh2 = this.zzm(false);
        if (this.zzld()) {
            ((zze)this).zzgi().resetAnalyticsData();
        }
        this.zzf(new zzdt(this, zzh2));
    }

    private final boolean zzld() {
        zzk zzk2 = ((zzco)this).zzgr();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzco)this).zzaf();
        this.zzcl();
        zzh zzh2 = this.zzm(false);
        this.zzf(new zzdu(this, atomicReference, zzh2));
    }

    @WorkerThread
    protected final void zzkz() {
        ((zzco)this).zzaf();
        this.zzcl();
        zzh zzh2 = this.zzm(true);
        this.zzf(new zzdv(this, zzh2));
    }

    @WorkerThread
    protected final void zzb(zzdn zzdn2) {
        ((zzco)this).zzaf();
        this.zzcl();
        this.zzf(new zzdw(this, zzdn2));
    }

    @WorkerThread
    private final void zzcy() {
        ((zzco)this).zzaf();
        this.zzasd.start();
        this.zzasc.zzh(zzaf.zzakj.get());
    }

    @WorkerThread
    final void zzdj() {
        zzk zzk2;
        Boolean bl;
        zzdr zzdr2;
        ((zzco)this).zzaf();
        this.zzcl();
        if (this.isConnected()) {
            return;
        }
        if (this.zzasb == null) {
            boolean bl2;
            zzdr2 = this;
            ((zzco)zzdr2).zzaf();
            zzdr2.zzcl();
            bl = ((zzco)zzdr2).zzgp().zzju();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzk2 = ((zzco)zzdr2).zzgr();
                if (((zze)zzdr2).zzgf().zzjb() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzco)zzdr2).zzgo().zzjl().zzbx("Checking service availability");
                    zzfk zzfk2 = ((zzco)zzdr2).zzgm();
                    int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzco)zzfk2).getContext(), 12451000);
                    switch (n) {
                        case 0: {
                            ((zzco)zzdr2).zzgo().zzjl().zzbx("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzco)zzdr2).zzgo().zzjl().zzbx("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzco)zzdr2).zzgo().zzjg().zzbx("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzco)zzdr2).zzgo().zzjk().zzbx("Service container out of date");
                            if (((zzco)zzdr2).zzgm().zzme() < 13000) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzco)zzdr2).zzgp().zzju();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzco)zzdr2).zzgo().zzjg().zzbx("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzco)zzdr2).zzgo().zzjg().zzbx("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzco)zzdr2).zzgo().zzjg().zzg("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzco)zzdr2).zzgq().zzib()) {
                    ((zzco)zzdr2).zzgo().zzjd().zzbx("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzco)zzdr2).zzgp().zzg(bl4);
                }
                bl2 = bl4;
            }
            this.zzasb = bl2;
        }
        if (this.zzasb.booleanValue()) {
            this.zzarz.zzlh();
            return;
        }
        if (!((zzco)this).zzgq().zzib()) {
            Intent intent;
            zzdr2 = this;
            zzk2 = ((zzco)zzdr2).zzgr();
            bl = ((zzco)zzdr2).getContext().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzco)zzdr2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzk2 = ((zzco)this).zzgr();
                intent2.setComponent(new ComponentName(((zzco)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzarz.zzc(intent2);
                return;
            }
            ((zzco)this).zzgo().zzjd().zzbx("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzle() {
        return this.zzasb;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzag zzag2) {
        ((zzco)this).zzaf();
        Preconditions.checkNotNull((Object)zzag2);
        this.zzasa = zzag2;
        this.zzcy();
        this.zzlf();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzco)this).zzaf();
        this.zzcl();
        if (zzn.zzia()) {
            this.zzarz.zzlg();
        }
        try {
            ConnectionTracker.getInstance().unbindService(((zzco)this).getContext(), (ServiceConnection)this.zzarz);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzasa = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzco)this).zzaf();
        if (this.zzasa != null) {
            this.zzasa = null;
            ((zzco)this).zzgo().zzjl().zzg("Disconnected from device MeasurementService", componentName);
            zzdr zzdr2 = this;
            ((zzco)zzdr2).zzaf();
            zzdr2.zzdj();
        }
    }

    @WorkerThread
    private final void zzcz() {
        ((zzco)this).zzaf();
        if (!this.isConnected()) {
            return;
        }
        ((zzco)this).zzgo().zzjl().zzbx("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzf(Runnable runnable) throws IllegalStateException {
        ((zzco)this).zzaf();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzase.size() >= 1000L) {
            ((zzco)this).zzgo().zzjd().zzbx("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzase.add(runnable);
        this.zzasf.zzh(60000L);
        this.zzdj();
    }

    @WorkerThread
    private final void zzlf() {
        ((zzco)this).zzaf();
        ((zzco)this).zzgo().zzjl().zzg("Processing queued up service tasks", this.zzase.size());
        for (Runnable runnable : this.zzase) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzco)this).zzgo().zzjd().zzg("Task exception while flushing queue", exception);
            }
        }
        this.zzase.clear();
        this.zzasf.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzh zzm(boolean bl) {
        zzk zzk2 = ((zzco)this).zzgr();
        return ((zze)this).zzgf().zzbr(bl ? ((zzco)this).zzgo().zzjn() : null);
    }

    static /* synthetic */ zzef zza(zzdr zzdr2) {
        return zzdr2.zzarz;
    }

    static /* synthetic */ void zza(zzdr zzdr2, ComponentName componentName) {
        zzdr2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzag zza(zzdr zzdr2, zzag zzag2) {
        zzdr2.zzasa = null;
        return null;
    }

    static /* synthetic */ void zzb(zzdr zzdr2) {
        zzdr2.zzlf();
    }

    static /* synthetic */ void zzc(zzdr zzdr2) {
        zzdr2.zzcz();
    }

    static /* synthetic */ zzag zzd(zzdr zzdr2) {
        return zzdr2.zzasa;
    }

    static /* synthetic */ void zze(zzdr zzdr2) {
        zzdr2.zzcy();
    }
}

