/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzfr;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    public static final String FIAM_ORIGIN = "fiam";
    private final zzbu zzadp;

    @Deprecated
    @ShowFirstParty
    @Keep
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return zzbu.zza(context, null).zzkm();
    }

    @ShowFirstParty
    public final void logEvent(@NonNull @Size(min=1L, max=40L) String string, Bundle bundle) {
        this.zzadp.zzgj().zza("app", string, bundle, true);
    }

    @ShowFirstParty
    public final void setUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable @Size(max=36L) String string2) {
        this.zzadp.zzgj().zzb("app", string, (Object)string2, false);
    }

    @Deprecated
    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zzadp.zzgj().setMeasurementEnabled(bl);
    }

    public final void zzd(boolean bl) {
        this.zzadp.zzgj().zzd(bl);
    }

    @ShowFirstParty
    public final void setMinimumSessionDuration(long l) {
        this.zzadp.zzgj().setMinimumSessionDuration(l);
    }

    @ShowFirstParty
    public final void setSessionTimeoutDuration(long l) {
        this.zzadp.zzgj().setSessionTimeoutDuration(l);
    }

    public AppMeasurement(zzbu zzbu2) {
        Preconditions.checkNotNull((Object)zzbu2);
        this.zzadp = zzbu2;
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        this.zzadp.zzgj().logEvent(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        Bundle bundle2 = bundle;
        String string3 = string2;
        String string4 = string;
        this.zzadp.zzgj().logEvent(string4, string3, bundle2, true, false, l);
    }

    @ShowFirstParty
    @KeepForSdk
    public void setUserPropertyInternal(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        this.zzadp.zzgj().zzb(string, string2, object, true);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        List<zzfr> list = this.zzadp.zzgj().zzk(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzfr zzfr2 : list) {
            arrayMap.put(zzfr2.name, zzfr2.getValue());
        }
        return arrayMap;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zzadp.zzgj().zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzadp.zzgj().zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzadp.zzgj().zzb(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        return this.zzadp.zzgj().getCurrentScreenName();
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        return this.zzadp.zzgj().getCurrentScreenClass();
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        return this.zzadp.zzgj().zzgc();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        return this.zzadp.zzgj().getGmpAppId();
    }

    @Keep
    public long generateEventId() {
        return this.zzadp.zzgr().zzmj();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzadp.zzgi().beginAdUnitExposure(string, this.zzadp.zzbx().elapsedRealtime());
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzadp.zzgi().endAdUnitExposure(string, this.zzadp.zzbx().elapsedRealtime());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        this.zzadp.zzgj().setConditionalUserProperty(conditionalUserProperty);
    }

    @Keep
    @VisibleForTesting
    protected void setConditionalUserPropertyAs(@NonNull ConditionalUserProperty conditionalUserProperty) {
        this.zzadp.zzgj().setConditionalUserPropertyAs(conditionalUserProperty);
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zzadp.zzgj().clearConditionalUserProperty(string, string2, bundle);
    }

    @Keep
    @VisibleForTesting
    protected void clearConditionalUserPropertyAs(@NonNull @Size(min=1L) String string, @NonNull @Size(min=1L, max=24L) String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzadp.zzgj().clearConditionalUserPropertyAs(string, string2, string3, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zzadp.zzgj().getUserProperties(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3, boolean bl) {
        return this.zzadp.zzgj().getUserPropertiesAs(string, string2, string3, bl);
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zzadp.zzgj().getConditionalUserProperties(string, string2);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected List<ConditionalUserProperty> getConditionalUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3) {
        return this.zzadp.zzgj().getConditionalUserPropertiesAs(string, string2, string3);
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        this.zzadp.zzgj();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        return this.zzadp.zzgj().zzkx();
    }

    @KeepForSdk
    public String getString() {
        return this.zzadp.zzgj().zzky();
    }

    @KeepForSdk
    public Long getLong() {
        return this.zzadp.zzgj().zzkz();
    }

    @KeepForSdk
    public Integer getInteger() {
        return this.zzadp.zzgj().zzla();
    }

    @KeepForSdk
    public Double getDouble() {
        return this.zzadp.zzgj().zzlb();
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        public ConditionalUserProperty() {
        }

        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzdu.zze((Object)conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzcw {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzcv {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class UserProperty
    extends zzcu {
        @ShowFirstParty
        @KeepForSdk
        public static final String FIREBASE_LAST_NOTIFICATION = "_ln";

        private UserProperty() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Param
    extends zzct {
        @ShowFirstParty
        @KeepForSdk
        public static final String FATAL = "fatal";
        @ShowFirstParty
        @KeepForSdk
        public static final String TIMESTAMP = "timestamp";
        @ShowFirstParty
        @KeepForSdk
        public static final String TYPE = "type";

        private Param() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Event
    extends zzcs {
        @ShowFirstParty
        @KeepForSdk
        public static final String APP_EXCEPTION = "_ae";
        @ShowFirstParty
        @KeepForSdk
        public static final String AD_REWARD = "_ar";

        private Event() {
        }
    }
}

