/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zze;
import java.util.Map;

public final class zza
extends zze {
    private final Map<String, Long> zzafq;
    private final Map<String, Integer> zzafr = new ArrayMap();
    private long zzafs;

    public zza(zzbu zzbu2) {
        super(zzbu2);
        this.zzafq = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzcp)this).zzgt().zzjg().zzca("Ad unit id must be a non-empty string");
            return;
        }
        ((zzcp)this).zzgs().zzc(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzcp)this).zzgg();
        ((zzcp)this).zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzafr.isEmpty()) {
            this.zzafs = l;
        }
        if ((n = this.zzafr.get(string)) != null) {
            this.zzafr.put(string, n + 1);
            return;
        }
        if (this.zzafr.size() >= 100) {
            ((zzcp)this).zzgt().zzjj().zzca("Too many ads visible");
            return;
        }
        this.zzafr.put(string, 1);
        this.zzafq.put(string, l);
    }

    public final void endAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzcp)this).zzgt().zzjg().zzca("Ad unit id must be a non-empty string");
            return;
        }
        ((zzcp)this).zzgs().zzc(new zzc(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzcp)this).zzgg();
        ((zzcp)this).zzaf();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzafr.get(string);
        if (n != null) {
            zzdv zzdv2 = ((zze)this).zzgm().zzle();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzafr.remove(string);
                Long l2 = this.zzafq.get(string);
                if (l2 == null) {
                    ((zzcp)this).zzgt().zzjg().zzca("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzafq.remove(string);
                    this.zza(string, l3, zzdv2);
                }
                if (this.zzafr.isEmpty()) {
                    if (this.zzafs == 0L) {
                        ((zzcp)this).zzgt().zzjg().zzca("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzafs, zzdv2);
                    this.zzafs = 0L;
                }
                return;
            }
            this.zzafr.put(string, n2);
            return;
        }
        ((zzcp)this).zzgt().zzjg().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzdv zzdv2) {
        if (zzdv2 == null) {
            ((zzcp)this).zzgt().zzjo().zzca("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcp)this).zzgt().zzjo().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzdw.zza(zzdv2, bundle, true);
        ((zze)this).zzgj().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzdv zzdv2) {
        if (zzdv2 == null) {
            ((zzcp)this).zzgt().zzjo().zzca("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcp)this).zzgt().zzjo().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzdw.zza(zzdv2, bundle, true);
        ((zze)this).zzgj().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzq(long l) {
        zzdv zzdv2 = ((zze)this).zzgm().zzle();
        for (String string : this.zzafq.keySet()) {
            long l2 = this.zzafq.get(string);
            this.zza(string, l - l2, zzdv2);
        }
        if (!this.zzafq.isEmpty()) {
            this.zza(l - this.zzafs, zzdv2);
        }
        this.zzr(l);
    }

    @WorkerThread
    private final void zzr(long l) {
        for (String string : this.zzafq.keySet()) {
            this.zzafq.put(string, l);
        }
        if (!this.zzafq.isEmpty()) {
            this.zzafs = l;
        }
    }

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        zza2.zza(string, l);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        zza2.zzb(string, l);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzr(l);
    }
}

