/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzo;

public final class zzak
extends zzf {
    private String zztt;
    private String zzts;
    private int zzalv;
    private String zzage;
    private String zztr;
    private long zzalw;
    private long zzagh;
    private int zzahb;
    private String zzafx;
    private String zzagk;

    zzak(zzbu zzbu2) {
        super(zzbu2);
    }

    @Override
    protected final boolean zzgy() {
        return true;
    }

    @Override
    protected final void zzgz() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcp)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcp)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcp)this).zzgt().zzjg().zzg("PackageManager is null, app identity information might be inaccurate. appId", zzaq.zzby(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcp)this).zzgt().zzjg().zzg("Error retrieving app installer package name. appId", zzaq.zzby(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcp)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcp)this).zzgt().zzjg().zze("Error retrieving package info. appId, appName", zzaq.zzby(string4), string3);
            }
        }
        this.zztt = string4;
        this.zzage = string;
        this.zzts = string2;
        this.zzalv = n;
        this.zztr = string3;
        this.zzalw = 0L;
        zzl zzl2 = ((zzcp)this).zzgw();
        packageInfo = GoogleServices.initialize((Context)((zzcp)this).getContext());
        boolean bl = (packageInfo != null && packageInfo.isSuccess()) | (!TextUtils.isEmpty((CharSequence)this.zzadp.zzko()) && "am".equals(this.zzadp.zzkp()));
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzak zzak2 = this;
            if (packageInfo2 == null) {
                ((zzcp)zzak2).zzgt().zzjg().zzca("GoogleService failed to initialize (no status)");
            } else {
                ((zzcp)zzak2).zzgt().zzjg().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcp)this).zzgv().zzia();
            if (((zzcp)this).zzgv().zzhz()) {
                if (this.zzadp.zzkn()) {
                    ((zzcp)this).zzgt().zzjm().zzca("Collection disabled with firebase_analytics_collection_deactivated=1");
                }
            } else if (object != null && !((Boolean)object).booleanValue()) {
                if (this.zzadp.zzkn()) {
                    ((zzcp)this).zzgt().zzjm().zzca("Collection disabled with firebase_analytics_collection_enabled=0");
                }
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzcp)this).zzgt().zzjm().zzca("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcp)this).zzgt().zzjo().zzca("Collection enabled");
            }
        }
        this.zzafx = "";
        this.zzagk = "";
        this.zzagh = 0L;
        zzl2 = ((zzcp)this).zzgw();
        if (!TextUtils.isEmpty((CharSequence)this.zzadp.zzko()) && "am".equals(this.zzadp.zzkp())) {
            this.zzagk = this.zzadp.zzko();
        }
        try {
            object = GoogleServices.getGoogleAppId();
            Object object2 = this.zzafx = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (!TextUtils.isEmpty((CharSequence)object)) {
                StringResourceValueReader stringResourceValueReader = new StringResourceValueReader(((zzcp)this).getContext());
                this.zzagk = stringResourceValueReader.getString("admob_app_id");
            }
            if (bl2) {
                ((zzcp)this).zzgt().zzjo().zze("App package, google app id", this.zztt, this.zzafx);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcp)this).zzgt().zzjg().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzaq.zzby(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzahb = InstantApps.isInstantApp((Context)((zzcp)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzahb = 0;
    }

    @WorkerThread
    final zzi zzbu(String string) {
        ((zzcp)this).zzaf();
        ((zzcp)this).zzgg();
        String string2 = this.zzal();
        String string3 = this.getGmpAppId();
        zzcp zzcp2 = this;
        ((zzf)zzcp2).zzcl();
        String string4 = ((zzak)zzcp2).zzts;
        long l = this.zzjd();
        zzcp2 = this;
        ((zzf)zzcp2).zzcl();
        String string5 = ((zzak)zzcp2).zzage;
        long l2 = ((zzcp)this).zzgv().zzhh();
        zzcp2 = this;
        ((zzf)zzcp2).zzcl();
        zzcp2.zzaf();
        if (((zzak)zzcp2).zzalw == 0L) {
            ((zzak)zzcp2).zzalw = ((zzak)zzcp2).zzadp.zzgr().zzd(zzcp2.getContext(), zzcp2.getContext().getPackageName());
        }
        long l3 = ((zzak)zzcp2).zzalw;
        boolean bl = this.zzadp.isEnabled();
        boolean bl2 = !((zzcp)this).zzgu().zzaob;
        zzcp2 = this;
        zzcp2.zzaf();
        zzcp2.zzgg();
        String string6 = zzcp2.zzgv().zzbb(((zzak)zzcp2).zztt) && !((zzak)zzcp2).zzadp.isEnabled() ? null : ((zzak)zzcp2).zzjc();
        zzcp2 = this;
        ((zzf)zzcp2).zzcl();
        long l4 = ((zzak)zzcp2).zzagh;
        long l5 = this.zzadp.zzkt();
        int n = this.zzje();
        zzcp2 = ((zzcp)this).zzgv();
        zzcp2.zzgg();
        Boolean bl3 = ((zzo)zzcp2).zzat("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzcp2 = ((zzcp)this).zzgv();
        zzcp2.zzgg();
        bl3 = ((zzo)zzcp2).zzat("google_analytics_ssaid_collection_enabled");
        return new zzi(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, l4, l5, n, bl4, bl3 == null || bl3 != false, ((zzcp)this).zzgu().zzkb(), this.zzhb());
    }

    @WorkerThread
    @VisibleForTesting
    private final String zzjc() {
        Object object;
        Class<?> clazz;
        try {
            clazz = ((zzcp)this).getContext().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
            if (clazz == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            object = clazz.getDeclaredMethod("getInstance", Context.class).invoke(null, ((zzcp)this).getContext());
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            ((zzcp)this).zzgt().zzjk().zzca("Failed to obtain Firebase Analytics instance");
            return null;
        }
        try {
            return (String)clazz.getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            ((zzcp)this).zzgt().zzjl().zzca("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzal() {
        this.zzcl();
        return this.zztt;
    }

    final String getGmpAppId() {
        this.zzcl();
        return this.zzafx;
    }

    final String zzhb() {
        this.zzcl();
        return this.zzagk;
    }

    final int zzjd() {
        this.zzcl();
        return this.zzalv;
    }

    final int zzje() {
        this.zzcl();
        return this.zzahb;
    }
}

