/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzfu;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzbb
extends zzcq {
    @VisibleForTesting
    static final Pair<String, Long> zzanj = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzabr;
    public zzbf zzank;
    public final zzbe zzanl = new zzbe(this, "last_upload", 0L);
    public final zzbe zzanm = new zzbe(this, "last_upload_attempt", 0L);
    public final zzbe zzann = new zzbe(this, "backoff", 0L);
    public final zzbe zzano = new zzbe(this, "last_delete_stale", 0L);
    public final zzbe zzanp;
    public final zzbe zzanq;
    public final zzbe zzanr;
    public final zzbg zzans;
    private String zzant;
    private boolean zzanu;
    private long zzanv;
    public final zzbe zzanw = new zzbe(this, "time_before_start", 10000L);
    public final zzbe zzanx = new zzbe(this, "session_timeout", 1800000L);
    public final zzbd zzany = new zzbd(this, "start_new_session", true);
    public final zzbe zzanz = new zzbe(this, "last_pause_time", 0L);
    public final zzbe zzaoa = new zzbe(this, "time_active", 0L);
    public boolean zzaob;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzcb(String string) {
        this.zzaf();
        long l = this.zzbx().elapsedRealtime();
        if (this.zzant != null && l < this.zzanv) {
            return new Pair((Object)this.zzant, (Object)this.zzanu);
        }
        String string2 = string;
        this.zzanv = l + this.zzgv().zza(string2, zzag.zzajh);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzant = info.getId();
                this.zzanu = info.isLimitAdTrackingEnabled();
            }
            if (this.zzant == null) {
                this.zzant = "";
            }
        }
        catch (Exception exception) {
            this.zzgt().zzjn().zzg("Unable to get advertising id", exception);
            this.zzant = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzant, (Object)this.zzanu);
    }

    @WorkerThread
    final String zzcc(String string) {
        this.zzaf();
        String string2 = (String)this.zzcb((String)string).first;
        MessageDigest messageDigest = zzfu.getMessageDigest();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzbb(zzbu zzbu2) {
        super(zzbu2);
        this.zzanp = new zzbe(this, "midnight_offset", 0L);
        this.zzanq = new zzbe(this, "first_open_time", 0L);
        this.zzanr = new zzbe(this, "app_install_time", 0L);
        this.zzans = new zzbg(this, "app_instance_id", null);
    }

    @Override
    protected final boolean zzgy() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzgz() {
        this.zzabr = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzaob = this.zzabr.getBoolean("has_been_opened", false);
        if (!this.zzaob) {
            SharedPreferences.Editor editor = this.zzabr.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzank = new zzbf(this, "health_monitor", Math.max(0L, zzag.zzaji.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zzju() {
        this.zzaf();
        this.zzcl();
        return this.zzabr;
    }

    @WorkerThread
    final void zzcd(String string) {
        this.zzaf();
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjv() {
        this.zzaf();
        return this.zzju().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzce(String string) {
        this.zzaf();
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzjw() {
        this.zzaf();
        return this.zzju().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzjx() {
        this.zzaf();
        if (!this.zzju().contains("use_service")) {
            return null;
        }
        return this.zzju().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzg(boolean bl) {
        this.zzaf();
        this.zzgt().zzjo().zzg("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzjy() {
        this.zzaf();
        this.zzgt().zzjo().zzca("Clearing collection preferences.");
        if (this.zzgv().zza(zzag.zzalo)) {
            Boolean bl = this.zzjz();
            SharedPreferences.Editor editor = this.zzju().edit();
            editor.clear();
            editor.apply();
            if (bl != null) {
                this.setMeasurementEnabled(bl);
            }
            return;
        }
        boolean bl = this.zzju().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzh(true);
        }
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzaf();
        this.zzgt().zzjo().zzg("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzh(boolean bl) {
        this.zzaf();
        return this.zzju().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    final Boolean zzjz() {
        this.zzaf();
        if (this.zzju().contains("measurement_enabled")) {
            return this.zzju().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzka() {
        this.zzaf();
        String string = this.zzju().getString("previous_os_version", null);
        this.zzgp().zzcl();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzju().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzi(boolean bl) {
        this.zzaf();
        this.zzgt().zzjo().zzg("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzju().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzkb() {
        this.zzaf();
        return this.zzju().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzkc() {
        return this.zzabr.contains("deferred_analytics_collection");
    }

    final boolean zzaj(long l) {
        return l - this.zzanx.get() > this.zzanz.get();
    }

    static /* synthetic */ SharedPreferences zza(zzbb zzbb2) {
        return zzbb2.zzju();
    }
}

