/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzbm;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzl;

public final class zzbk {
    private final zzbn zzaoo;

    public zzbk(zzbn zzbn2) {
        Preconditions.checkNotNull((Object)zzbn2);
        this.zzaoo = zzbn2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzbu zzbu2 = zzbu.zza(context, null);
        zzaq zzaq2 = zzbu2.zzgt();
        if (intent == null) {
            zzaq2.zzjj().zzca("Receiver called with null intent");
            return;
        }
        zzl zzl2 = zzbu2.zzgw();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzaq2.zzjo().zzg("Device receiver got", string);
        } else {
            zzaq2.zzjo().zzg("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzaq2.zzjo().zzca("Starting wakeful intent.");
            this.zzaoo.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzbu2.zzgs().zzc(new zzbl(this, zzbu2, zzaq2));
            }
            catch (Exception exception) {
                zzaq2.zzjj().zzg("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzaoo.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzaq2.zzjo().zzca("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzaq2.zzjm().zzg("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzbu2.zzgr().zza(uri);
            if (bundle == null) {
                zzaq2.zzjo().zzca("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzaq2.zzjj().zzca("Install referrer is missing timestamp");
                }
                zzbu2.zzgs().zzc(new zzbm(this, zzbu2, l, bundle, context, zzaq2, pendingResult));
            }
        }
    }
}

