/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.support.annotation.GuardedBy;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.internal.measurement.zzry;
import com.google.android.gms.internal.measurement.zzrz;
import com.google.android.gms.internal.measurement.zzsa;
import com.google.android.gms.internal.measurement.zzsb;
import com.google.android.gms.internal.measurement.zzsc;
import com.google.android.gms.internal.measurement.zzsi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzrx
implements zzsb {
    @GuardedBy(value="ConfigurationContentLoader.class")
    static final Map<Uri, zzrx> zzbrd = new ArrayMap();
    private final ContentResolver zzbre;
    private final Uri uri;
    private final Object zzbrf = new Object();
    private volatile Map<String, String> zzbrg;
    @GuardedBy(value="this")
    private final List<zzsa> zzbrh = new ArrayList<zzsa>();
    private static final String[] zzbri = new String[]{"key", "value"};

    private zzrx(ContentResolver contentResolver, Uri uri) {
        this.zzbre = contentResolver;
        this.uri = uri;
        this.zzbre.registerContentObserver(uri, false, (ContentObserver)new zzrz(this, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzrx zza(ContentResolver contentResolver, Uri uri) {
        Class<zzrx> clazz = zzrx.class;
        synchronized (zzrx.class) {
            zzrx zzrx2 = zzbrd.get(uri);
            if (zzrx2 == null) {
                try {
                    zzrx2 = new zzrx(contentResolver, uri);
                    zzbrd.put(uri, zzrx2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzrx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zztk() {
        Map<String, String> map = this.zzbrg;
        if (map == null) {
            Object object = this.zzbrf;
            synchronized (object) {
                map = this.zzbrg;
                if (map == null) {
                    this.zzbrg = map = this.zztm();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zztl() {
        zzrx zzrx2;
        Object object = this.zzbrf;
        synchronized (object) {
            this.zzbrg = null;
            zzsi.zztq();
        }
        zzrx zzrx3 = zzrx2 = this;
        synchronized (zzrx2) {
            Iterator<zzsa> iterator = zzrx2.zzbrh.iterator();
            while (iterator.hasNext()) {
                iterator.next().zztp();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zztm() {
        try {
            return (Map)zzsc.zza(new zzry(this));
        }
        catch (SQLiteException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
    }

    @Override
    public final /* synthetic */ Object zzfn(String string) {
        String string2 = string;
        return this.zztk().get(string2);
    }

    final /* synthetic */ Map zztn() {
        Cursor cursor = this.zzbre.query(this.uri, zzbri, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

