/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zze;
import java.util.Map;

public final class zza
extends zze {
    private final Map<String, Long> zzafb;
    private final Map<String, Integer> zzafc = new ArrayMap();
    private long zzafd;

    public zza(zzbw zzbw2) {
        super(zzbw2);
        this.zzafb = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzcr)this).zzgt().zzjg().zzby("Ad unit id must be a non-empty string");
            return;
        }
        ((zzcr)this).zzgs().zzc(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzcr)this).zzgg();
        ((zzcr)this).zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzafc.isEmpty()) {
            this.zzafd = l;
        }
        if ((n = this.zzafc.get(string)) != null) {
            this.zzafc.put(string, n + 1);
            return;
        }
        if (this.zzafc.size() >= 100) {
            ((zzcr)this).zzgt().zzjj().zzby("Too many ads visible");
            return;
        }
        this.zzafc.put(string, 1);
        this.zzafb.put(string, l);
    }

    public final void endAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzcr)this).zzgt().zzjg().zzby("Ad unit id must be a non-empty string");
            return;
        }
        ((zzcr)this).zzgs().zzc(new zzc(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzcr)this).zzgg();
        ((zzcr)this).zzaf();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzafc.get(string);
        if (n != null) {
            zzdx zzdx2 = ((zze)this).zzgm().zzle();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzafc.remove(string);
                Long l2 = this.zzafb.get(string);
                if (l2 == null) {
                    ((zzcr)this).zzgt().zzjg().zzby("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzafb.remove(string);
                    this.zza(string, l3, zzdx2);
                }
                if (this.zzafc.isEmpty()) {
                    if (this.zzafd == 0L) {
                        ((zzcr)this).zzgt().zzjg().zzby("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzafd, zzdx2);
                    this.zzafd = 0L;
                }
                return;
            }
            this.zzafc.put(string, n2);
            return;
        }
        ((zzcr)this).zzgt().zzjg().zzg("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzdx zzdx2) {
        if (zzdx2 == null) {
            ((zzcr)this).zzgt().zzjo().zzby("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcr)this).zzgt().zzjo().zzg("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzdy.zza(zzdx2, bundle, true);
        ((zze)this).zzgj().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzdx zzdx2) {
        if (zzdx2 == null) {
            ((zzcr)this).zzgt().zzjo().zzby("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcr)this).zzgt().zzjo().zzg("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzdy.zza(zzdx2, bundle, true);
        ((zze)this).zzgj().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzm(long l) {
        zzdx zzdx2 = ((zze)this).zzgm().zzle();
        for (String string : this.zzafb.keySet()) {
            long l2 = this.zzafb.get(string);
            this.zza(string, l - l2, zzdx2);
        }
        if (!this.zzafb.isEmpty()) {
            this.zza(l - this.zzafd, zzdx2);
        }
        this.zzn(l);
    }

    @WorkerThread
    private final void zzn(long l) {
        for (String string : this.zzafb.keySet()) {
            this.zzafb.put(string, l);
        }
        if (!this.zzafb.isEmpty()) {
            this.zzafd = l;
        }
    }

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        zza2.zza(string, l);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        zza2.zzb(string, l);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzn(l);
    }
}

