/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzsi;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbm;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzbx;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzq;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class zzbw
implements zzct {
    private static volatile zzbw zzapj;
    private final Context zzri;
    private final String zzadi;
    private final String zzapk;
    private final String zzapl;
    private final boolean zzadg;
    private final zzn zzaih;
    private final zzq zzapm;
    private final zzbd zzapn;
    private final zzas zzapo;
    private final zzbr zzapp;
    private final zzfd zzapq;
    private final AppMeasurement zzapr;
    private final zzfx zzaps;
    private final zzaq zzapt;
    private final Clock zzrz;
    private final zzdy zzapu;
    private final zzda zzapv;
    private final zza zzapw;
    private zzao zzapx;
    private zzeb zzapy;
    private zzaa zzapz;
    private zzam zzaqa;
    private zzbj zzaqb;
    private boolean zzvz = false;
    private Boolean zzaqc;
    private long zzaqd;
    private volatile Boolean zzaqe;
    @VisibleForTesting
    private Boolean zzaqf;
    @VisibleForTesting
    private Boolean zzaqg;
    private int zzaqh;
    private AtomicInteger zzaqi = new AtomicInteger(0);
    private final long zzago;

    private zzbw(zzcz zzcz2) {
        Object object;
        Preconditions.checkNotNull((Object)zzcz2);
        Object object2 = zzcz2.zzri;
        this.zzaih = new zzn((Context)object2);
        zzai.zza(this.zzaih);
        this.zzri = zzcz2.zzri;
        this.zzadi = zzcz2.zzadi;
        this.zzapk = zzcz2.zzapk;
        this.zzapl = zzcz2.zzapl;
        this.zzadg = zzcz2.zzadg;
        this.zzaqe = zzcz2.zzaqe;
        zzan zzan2 = zzcz2.zzaqz;
        if (zzan2 != null && zzan2.zzadj != null) {
            object = zzan2.zzadj.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzaqf = (Boolean)object;
            }
            if ((object = zzan2.zzadj.get("measurementDeactivated")) instanceof Boolean) {
                this.zzaqg = (Boolean)object;
            }
        }
        zzsi.zzae(this.zzri);
        this.zzrz = DefaultClock.getInstance();
        this.zzago = this.zzrz.currentTimeMillis();
        object2 = this;
        this.zzapm = new zzq((zzbw)object2);
        object2 = this;
        object = new zzbd((zzbw)object2);
        ((zzcs)object).zzq();
        this.zzapn = object;
        object2 = this;
        zzas zzas2 = new zzas((zzbw)object2);
        zzas2.zzq();
        this.zzapo = zzas2;
        object2 = this;
        zzfx zzfx2 = new zzfx((zzbw)object2);
        zzfx2.zzq();
        this.zzaps = zzfx2;
        object2 = this;
        zzaq zzaq2 = new zzaq((zzbw)object2);
        zzaq2.zzq();
        this.zzapt = zzaq2;
        object2 = this;
        this.zzapw = new zza((zzbw)object2);
        object2 = this;
        zzdy zzdy2 = new zzdy((zzbw)object2);
        zzdy2.zzq();
        this.zzapu = zzdy2;
        object2 = this;
        zzda zzda2 = new zzda((zzbw)object2);
        zzda2.zzq();
        this.zzapv = zzda2;
        object2 = this;
        this.zzapr = new AppMeasurement((zzbw)object2);
        object2 = this;
        zzfd zzfd2 = new zzfd((zzbw)object2);
        zzfd2.zzq();
        this.zzapq = zzfd2;
        object2 = this;
        zzbr zzbr2 = new zzbr((zzbw)object2);
        zzbr2.zzq();
        this.zzapp = zzbr2;
        object2 = this;
        zzn zzn2 = ((zzbw)object2).zzaih;
        if (((zzbw)object2).zzri.getApplicationContext() instanceof Application) {
            zzda zzda3 = ((zzbw)object2).zzgj();
            if (((zzcr)zzda3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcr)zzda3).getContext().getApplicationContext();
                if (zzda3.zzara == null) {
                    zzda3.zzara = new zzdu(zzda3, null);
                }
                zzdu zzdu2 = zzda3.zzara;
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdu2);
                zzdu2 = zzda3.zzara;
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdu2);
                ((zzcr)zzda3).zzgt().zzjo().zzby("Registered activity lifecycle callback");
            }
        } else {
            ((zzbw)object2).zzgt().zzjj().zzby("Application context is not an Application");
        }
        this.zzapp.zzc(new zzbx(this, zzcz2));
    }

    @WorkerThread
    private final void zza(zzcz zzcz2) {
        ((zzcr)this.zzgs()).zzaf();
        zzq.zzhy();
        zzbw zzbw2 = this;
        zzaa zzaa2 = new zzaa(zzbw2);
        zzaa2.zzq();
        this.zzapz = zzaa2;
        zzbw2 = this;
        zzam zzam2 = new zzam(zzbw2);
        zzam2.zzq();
        this.zzaqa = zzam2;
        zzbw2 = this;
        zzao zzao2 = new zzao(zzbw2);
        zzao2.zzq();
        this.zzapx = zzao2;
        zzbw2 = this;
        zzeb zzeb2 = new zzeb(zzbw2);
        zzeb2.zzq();
        this.zzapy = zzeb2;
        this.zzaps.zzgx();
        this.zzapn.zzgx();
        zzbw2 = this;
        this.zzaqb = new zzbj(zzbw2);
        this.zzaqa.zzgx();
        this.zzgt().zzjm().zzg("App measurement is starting up, version", this.zzapm.zzhh());
        zzn zzn2 = this.zzaih;
        this.zzgt().zzjm().zzby("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzn2 = this.zzaih;
        String string = zzam2.zzal();
        if (TextUtils.isEmpty((CharSequence)this.zzadi)) {
            String string2;
            zzau zzau2;
            if (this.zzgr().zzcz(string)) {
                zzau2 = this.zzgt().zzjm();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzau2 = this.zzgt().zzjm();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzau2.zzby(string2);
        }
        this.zzgt().zzjn().zzby("Debug-level message logging enabled");
        if (this.zzaqh != this.zzaqi.get()) {
            this.zzgt().zzjg().zze("Not all components initialized", this.zzaqh, this.zzaqi.get());
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzcr)this.zzgs()).zzaf();
        if (this.zzgu().zzanc.get() == 0L) {
            this.zzgu().zzanc.set(this.zzrz.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgu().zzanh.get()) == 0L) {
            this.zzgt().zzjo().zzg("Persisting first open", this.zzago);
            this.zzgu().zzanh.set(this.zzago);
        }
        if (!this.zzkv()) {
            if (this.isEnabled()) {
                if (!this.zzgr().zzx("android.permission.INTERNET")) {
                    this.zzgt().zzjg().zzby("App is missing INTERNET permission");
                }
                if (!this.zzgr().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgt().zzjg().zzby("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzn zzn2 = this.zzaih;
                if (!Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() && !this.zzapm.zzif()) {
                    if (!zzbm.zza(this.zzri)) {
                        this.zzgt().zzjg().zzby("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzfx.zza(this.zzri, false)) {
                        this.zzgt().zzjg().zzby("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgt().zzjg().zzby("Uploading is not possible. App measurement disabled");
                return;
            }
        } else {
            zzn zzn3 = this.zzaih;
            if (!TextUtils.isEmpty((CharSequence)this.zzgk().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb())) {
                this.zzgr();
                if (zzfx.zza(this.zzgk().getGmpAppId(), this.zzgu().zzjv(), this.zzgk().zzhb(), this.zzgu().zzjw())) {
                    this.zzgt().zzjm().zzby("Rechecking which service to use due to a GMP App Id change");
                    this.zzgu().zzjy();
                    this.zzgn().resetAnalyticsData();
                    this.zzapy.disconnect();
                    this.zzapy.zzdj();
                    this.zzgu().zzanh.set(this.zzago);
                    this.zzgu().zzanj.zzcd(null);
                }
                this.zzgu().zzcb(this.zzgk().getGmpAppId());
                this.zzgu().zzcc(this.zzgk().zzhb());
                if (this.zzapm.zzbi(this.zzgk().zzal())) {
                    this.zzapq.zzaj(this.zzago);
                }
            }
            this.zzgj().zzcp(this.zzgu().zzanj.zzkd());
            zzn3 = this.zzaih;
            if (!TextUtils.isEmpty((CharSequence)this.zzgk().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb())) {
                boolean bl = this.isEnabled();
                if (!this.zzgu().zzkc() && !this.zzapm.zzhz()) {
                    this.zzgu().zzi(!bl);
                }
                if (!this.zzapm.zzba(this.zzgk().zzal()) || bl) {
                    this.zzgj().zzld();
                }
                this.zzgl().zza(new AtomicReference<String>());
            }
        }
    }

    @Override
    public final zzn zzgw() {
        return this.zzaih;
    }

    public final zzq zzgv() {
        return this.zzapm;
    }

    public final zzbd zzgu() {
        zzbw.zza((zzcr)this.zzapn);
        return this.zzapn;
    }

    @Override
    public final zzas zzgt() {
        zzbw.zza(this.zzapo);
        return this.zzapo;
    }

    public final zzas zzkj() {
        if (this.zzapo != null && this.zzapo.isInitialized()) {
            return this.zzapo;
        }
        return null;
    }

    @Override
    public final zzbr zzgs() {
        zzbw.zza(this.zzapp);
        return this.zzapp;
    }

    public final zzfd zzgo() {
        zzbw.zza(this.zzapq);
        return this.zzapq;
    }

    public final zzbj zzkk() {
        return this.zzaqb;
    }

    final zzbr zzkl() {
        return this.zzapp;
    }

    public final zzda zzgj() {
        zzbw.zza(this.zzapv);
        return this.zzapv;
    }

    public final AppMeasurement zzkm() {
        return this.zzapr;
    }

    public final zzfx zzgr() {
        zzbw.zza((zzcr)this.zzaps);
        return this.zzaps;
    }

    public final zzaq zzgq() {
        zzbw.zza((zzcr)this.zzapt);
        return this.zzapt;
    }

    public final zzao zzgn() {
        zzbw.zza(this.zzapx);
        return this.zzapx;
    }

    @Override
    public final Context getContext() {
        return this.zzri;
    }

    public final boolean zzkn() {
        return TextUtils.isEmpty((CharSequence)this.zzadi);
    }

    public final String zzko() {
        return this.zzadi;
    }

    public final String zzkp() {
        return this.zzapk;
    }

    public final String zzkq() {
        return this.zzapl;
    }

    public final boolean zzkr() {
        return this.zzadg;
    }

    @Override
    public final Clock zzbx() {
        return this.zzrz;
    }

    public final zzdy zzgm() {
        zzbw.zza(this.zzapu);
        return this.zzapu;
    }

    public final zzeb zzgl() {
        zzbw.zza(this.zzapy);
        return this.zzapy;
    }

    public final zzaa zzgp() {
        zzbw.zza(this.zzapz);
        return this.zzapz;
    }

    public final zzam zzgk() {
        zzbw.zza(this.zzaqa);
        return this.zzaqa;
    }

    public final zza zzgi() {
        if (this.zzapw == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzapw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbw zza(Context context, zzan zzan2) {
        if (zzan2 != null && (zzan2.origin == null || zzan2.zzadi == null)) {
            zzan2 = new zzan(zzan2.zzade, zzan2.zzadf, zzan2.zzadg, zzan2.zzadh, null, null, zzan2.zzadj);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzapj == null) {
            Class<zzbw> clazz = zzbw.class;
            synchronized (zzbw.class) {
                if (zzapj == null) {
                    zzcz zzcz2 = new zzcz(context, zzan2);
                    zzapj = new zzbw(zzcz2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzan2 != null && zzan2.zzadj != null && zzan2.zzadj.containsKey("dataCollectionDefaultEnabled")) {
            zzapj.zzd(zzan2.zzadj.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzapj;
    }

    private final void zzcl() {
        if (!this.zzvz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzcs zzcs2) {
        if (zzcs2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcs2.isInitialized()) {
            String string = String.valueOf(zzcs2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.isInitialized()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzcr zzcr2) {
        if (zzcr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzaqe = bl;
    }

    @WorkerThread
    public final boolean zzks() {
        return this.zzaqe != null && this.zzaqe != false;
    }

    @WorkerThread
    public final boolean isEnabled() {
        boolean bl;
        ((zzcr)this.zzgs()).zzaf();
        this.zzcl();
        if (this.zzapm.zza(zzai.zzale)) {
            if (this.zzapm.zzhz()) {
                return false;
            }
            if (this.zzaqg != null && this.zzaqg.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzgu().zzjz();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzapm.zzia();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzaqf != null) {
                return this.zzaqf;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzapm.zza(zzai.zzala) && this.zzaqe != null) {
                return this.zzaqe;
            }
            return true;
        }
        if (this.zzapm.zzhz()) {
            return false;
        }
        Boolean bl4 = this.zzapm.zzia();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzaqe != null && zzai.zzala.get().booleanValue()) {
                bl = this.zzaqe;
            }
        }
        return this.zzgu().zzh(bl);
    }

    final long zzkt() {
        Long l = this.zzgu().zzanh.get();
        if (l == 0L) {
            return this.zzago;
        }
        return Math.min(this.zzago, l);
    }

    final void zzgg() {
        zzn zzn2 = this.zzaih;
    }

    final void zzgf() {
        zzn zzn2 = this.zzaih;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzcs zzcs2) {
        ++this.zzaqh;
    }

    final void zzb(zzf zzf2) {
        ++this.zzaqh;
    }

    final void zzku() {
        this.zzaqi.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzkv() {
        this.zzcl();
        ((zzcr)this.zzgs()).zzaf();
        if (this.zzaqc == null || this.zzaqd == 0L || this.zzaqc != null && !this.zzaqc.booleanValue() && Math.abs(this.zzrz.elapsedRealtime() - this.zzaqd) > 1000L) {
            this.zzaqd = this.zzrz.elapsedRealtime();
            zzn zzn2 = this.zzaih;
            this.zzaqc = this.zzgr().zzx("android.permission.INTERNET") && this.zzgr().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() || this.zzapm.zzif() || zzbm.zza(this.zzri) && zzfx.zza(this.zzri, false));
            if (this.zzaqc.booleanValue()) {
                this.zzaqc = this.zzgr().zzu(this.zzgk().getGmpAppId(), this.zzgk().zzhb()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb());
            }
        }
        return this.zzaqc;
    }

    static /* synthetic */ void zza(zzbw zzbw2, zzcz zzcz2) {
        zzbw2.zza(zzcz2);
    }
}

