/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zztx;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;

public final class zzae {
    private final Handler mHandler;
    private final Context mContext;
    private final zza zzbfL;
    private static Boolean zzTP;

    public zzae(zza zza2) {
        this.mContext = zza2.getContext();
        zzaa.zzz((Object)this.mContext);
        this.zzbfL = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzV(Context context) {
        zzaa.zzz((Object)context);
        if (zzTP != null) {
            return zzTP;
        }
        boolean bl = zzal.zzj(context, "com.google.android.gms.measurement.AppMeasurementService");
        zzTP = bl;
        return bl;
    }

    @MainThread
    public void onCreate() {
        zzx zzx2 = zzx.zzbd(this.mContext);
        zzp zzp2 = zzx2.zzFm();
        if (zzx2.zzFo().zzmW()) {
            zzp2.zzFL().log("Device AppMeasurementService is starting up");
        } else {
            zzp2.zzFL().log("Local AppMeasurementService is starting up");
        }
    }

    @MainThread
    public void onDestroy() {
        zzx zzx2 = zzx.zzbd(this.mContext);
        zzp zzp2 = zzx2.zzFm();
        if (zzx2.zzFo().zzmW()) {
            zzp2.zzFL().log("Device AppMeasurementService is shutting down");
        } else {
            zzp2.zzFL().log("Local AppMeasurementService is shutting down");
        }
    }

    @MainThread
    public int onStartCommand(Intent intent, int n, final int n2) {
        this.zzkp();
        final zzx zzx2 = zzx.zzbd(this.mContext);
        final zzp zzp2 = zzx2.zzFm();
        if (intent == null) {
            zzp2.zzFG().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        if (zzx2.zzFo().zzmW()) {
            zzp2.zzFL().zze("Device AppMeasurementService called. startId, action", n2, string);
        } else {
            zzp2.zzFL().zze("Local AppMeasurementService called. startId, action", n2, string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzx2.zzFl().zzg(new Runnable(){

                @Override
                public void run() {
                    zzx2.zzGq();
                    zzx2.zzGl();
                    zzae.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzae.this.zzbfL.callServiceStopSelfResult(n2);
                            if (bl) {
                                if (zzx2.zzFo().zzmW()) {
                                    zzp2.zzFL().log("Device AppMeasurementService processed last upload request");
                                } else {
                                    zzp2.zzFL().log("Local AppMeasurementService processed last upload request");
                                }
                            }
                        }
                    });
                }
            });
            return 2;
        }
        return 2;
    }

    @MainThread
    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzFm().zzFE().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzy(zzx.zzbd(this.mContext));
        }
        this.zzFm().zzFG().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzFm().zzFE().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzFm().zzFL().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzFm().zzFE().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzFm().zzFL().zzj("onRebind called. action", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkp() {
        try {
            Object object = zzu.zzrs;
            synchronized (object) {
                zztx zztx2 = zzu.zzTN;
                if (zztx2 != null && zztx2.isHeld()) {
                    zztx2.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private zzp zzFm() {
        return zzx.zzbd(this.mContext).zzFm();
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

