/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzn
extends zzaa {
    private static final X500Principal zzbcU = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzPx;
    private String zzVe;
    private int zzbcV;
    private String zzbby;
    private String zzVd;
    private long zzbcW;
    private String zzbbr;

    zzn(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzkO() {
        Object object;
        boolean bl;
        CharSequence charSequence;
        Object object2;
        String string;
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        PackageManager packageManager = this.getContext().getPackageManager();
        String string4 = packageManager.getInstallerPackageName(string = this.getContext().getPackageName());
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            object2 = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
            if (object2 != null) {
                charSequence = packageManager.getApplicationLabel(((PackageInfo)object2).applicationInfo);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string3 = charSequence.toString();
                }
                string2 = ((PackageInfo)object2).versionName;
                n = ((PackageInfo)object2).versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzFm().zzFE().zzj("Error retrieving package info: appName", string3);
        }
        this.zzPx = string;
        this.zzbby = string4;
        this.zzVe = string2;
        this.zzbcV = n;
        this.zzVd = string3;
        object2 = zzal.zzbZ("MD5");
        if (object2 == null) {
            this.zzFm().zzFE().log("Could not get MD5 instance");
            this.zzbcW = -1L;
        } else {
            this.zzbcW = 0L;
            try {
                if (!this.zzFD()) {
                    charSequence = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                    if (((PackageInfo)charSequence).signatures != null && ((PackageInfo)charSequence).signatures.length > 0) {
                        byte[] byArray = ((MessageDigest)object2).digest(((PackageInfo)charSequence).signatures[0].toByteArray());
                        this.zzbcW = zzal.zzs(byArray);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzFm().zzFE().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        charSequence = this.zzFo().zzmW() ? zzom.zzc((Context)this.getContext(), (String)"-", (boolean)true) : zzom.zzas((Context)this.getContext());
        boolean bl2 = bl = charSequence != null && charSequence.isSuccess();
        if (!bl) {
            this.zzbl((Status)charSequence);
        }
        boolean bl3 = false;
        if (bl) {
            object = this.zzFo().zzEN();
            if (this.zzFo().zzEM()) {
                this.zzFm().zzFJ().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                this.zzFm().zzFJ().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && this.zzFo().zzsB()) {
                this.zzFm().zzFJ().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl3 = true;
                this.zzFm().zzFL().log("Collection enabled");
            }
        }
        this.zzbbr = "";
        if (!this.zzFo().zzmW()) {
            try {
                object = zzom.zzsA();
                Object object3 = this.zzbbr = TextUtils.isEmpty((CharSequence)object) ? "" : object;
                if (bl3) {
                    this.zzFm().zzFL().zze("App package, google app id", this.zzPx, this.zzbbr);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.zzFm().zzFE().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
            }
        }
    }

    protected void zzbl(Status status) {
        if (status == null) {
            this.zzFm().zzFE().log("GoogleService failed to initialize (no status)");
        } else {
            this.zzFm().zzFE().zze("GoogleService failed to initialize, status", status.getStatusCode(), status.getStatusMessage());
        }
    }

    AppMetadata zzfs(String string) {
        return new AppMetadata(this.zziC(), this.zzEb(), this.zzkV(), this.zzFC(), this.zzEh(), this.zzEi(), this.zzEj(), string, this.zzbbl.isEnabled(), !this.zzFn().zzbdU, this.zzFn().zzEd());
    }

    String zziC() {
        this.zzma();
        return this.zzPx;
    }

    String zzEb() {
        this.zzma();
        return this.zzbbr;
    }

    String zzkV() {
        this.zzma();
        return this.zzVe;
    }

    int zzFC() {
        this.zzma();
        return this.zzbcV;
    }

    String zzEh() {
        this.zzma();
        return this.zzbby;
    }

    long zzEi() {
        return this.zzFo().zzEi();
    }

    long zzEj() {
        this.zzma();
        return this.zzbcW;
    }

    boolean zzFD() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(zzbcU);
            }
        }
        catch (CertificateException certificateException) {
            this.zzFm().zzFE().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzFm().zzFE().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

