/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzamc;
import com.google.android.gms.internal.zzso;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class zzx {
    private static volatile zzx zzbex;
    private final Context mContext;
    private final zzd zzbey;
    private final zzt zzbez;
    private final zzp zzbeA;
    private final zzw zzbeB;
    private final zzaf zzbeC;
    private final zzv zzbeD;
    private final AppMeasurement zzbeE;
    private final zzal zzbeF;
    private final zze zzbeG;
    private final zzq zzbeH;
    private final com.google.android.gms.common.util.zze zzsd;
    private final zzad zzbeI;
    private final zzg zzbeJ;
    private final zzac zzbeK;
    private final zzn zzbeL;
    private final zzr zzbeM;
    private final zzai zzbeN;
    private final zzc zzbeO;
    public final FirebaseAnalytics zzbeP;
    private final boolean zzWh;
    private boolean zzbeQ;
    private Boolean zzbeR;
    private FileLock zzbeS;
    private FileChannel zzbeT;
    private List<Long> zzbeU;
    private int zzbeV;
    private int zzbeW;

    zzx(zzab zzab2) {
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzab2);
        this.mContext = zzab2.mContext;
        this.zzsd = zzab2.zzl(this);
        this.zzbey = zzab2.zza(this);
        zzt zzt2 = zzab2.zzb(this);
        zzt2.initialize();
        this.zzbez = zzt2;
        zzp zzp2 = zzab2.zzc(this);
        zzp2.initialize();
        this.zzbeA = zzp2;
        this.zzFm().zzFJ().zzj("App measurement is starting up, version", this.zzFo().zzEi());
        this.zzFm().zzFJ().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        this.zzFm().zzFK().log("Debug logging enabled");
        this.zzFm().zzFK().zzj("AppMeasurement singleton hash", System.identityHashCode(this));
        this.zzbeF = zzab2.zzi(this);
        zzg zzg2 = zzab2.zzn(this);
        zzg2.initialize();
        this.zzbeJ = zzg2;
        zzn zzn2 = zzab2.zzo(this);
        zzn2.initialize();
        this.zzbeL = zzn2;
        zze zze2 = zzab2.zzj(this);
        zze2.initialize();
        this.zzbeG = zze2;
        zzc zzc2 = zzab2.zzr(this);
        zzc2.initialize();
        this.zzbeO = zzc2;
        zzq zzq2 = zzab2.zzk(this);
        zzq2.initialize();
        this.zzbeH = zzq2;
        zzad zzad2 = zzab2.zzm(this);
        zzad2.initialize();
        this.zzbeI = zzad2;
        zzac zzac2 = zzab2.zzh(this);
        zzac2.initialize();
        this.zzbeK = zzac2;
        zzai zzai2 = zzab2.zzq(this);
        zzai2.initialize();
        this.zzbeN = zzai2;
        this.zzbeM = zzab2.zzp(this);
        this.zzbeE = zzab2.zzg(this);
        this.zzbeP = new FirebaseAnalytics(this);
        zzaf zzaf2 = zzab2.zze(this);
        zzaf2.initialize();
        this.zzbeC = zzaf2;
        zzv zzv2 = zzab2.zzf(this);
        zzv2.initialize();
        this.zzbeD = zzv2;
        zzw zzw2 = zzab2.zzd(this);
        zzw2.initialize();
        this.zzbeB = zzw2;
        if (this.zzbeV != this.zzbeW) {
            this.zzFm().zzFE().zze("Not all components initialized", this.zzbeV, this.zzbeW);
        }
        this.zzWh = true;
        if (!this.zzbey.zzmW() && !this.zzGh()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                if (Build.VERSION.SDK_INT >= 14) {
                    this.zzFd().zzGw();
                } else {
                    this.zzFm().zzFK().log("Not tracking deep linking pre-ICS");
                }
            } else {
                this.zzFm().zzFG().log("Application context is not an Application");
            }
        }
        this.zzbeB.zzg(new Runnable(){

            @Override
            public void run() {
                zzx.this.start();
            }
        });
    }

    void zzma() {
        if (!this.zzWh) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzFX() {
        this.zzma();
        this.zzkN();
        if (this.zzbeR == null) {
            this.zzbeR = this.zzFi().zzbN("android.permission.INTERNET") && this.zzFi().zzbN("android.permission.ACCESS_NETWORK_STATE") && zzu.zzU(this.getContext()) && zzae.zzV(this.getContext());
            if (this.zzbeR.booleanValue() && !this.zzFo().zzmW()) {
                this.zzbeR = this.zzFi().zzfN(this.zzFe().zzEb());
            }
        }
        return this.zzbeR;
    }

    @WorkerThread
    protected void start() {
        this.zzkN();
        if (this.zzGh() && (!this.zzbeB.isInitialized() || this.zzbeB.zzGu())) {
            this.zzFm().zzFE().log("Scheduler shutting down before Scion.start() called");
            return;
        }
        this.zzFh().zzFq();
        if (!this.zzFX()) {
            if (this.isEnabled()) {
                if (!this.zzFi().zzbN("android.permission.INTERNET")) {
                    this.zzFm().zzFE().log("App is missing INTERNET permission");
                }
                if (!this.zzFi().zzbN("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzFm().zzFE().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzu.zzU(this.getContext())) {
                    this.zzFm().zzFE().log("AppMeasurementReceiver not registered/enabled");
                }
                if (!zzae.zzV(this.getContext())) {
                    this.zzFm().zzFE().log("AppMeasurementService not registered/enabled");
                }
                this.zzFm().zzFE().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!this.zzFo().zzmW() && !TextUtils.isEmpty((CharSequence)this.zzFe().zzEb())) {
                String string = this.zzFn().zzFR();
                if (string == null) {
                    this.zzFn().zzfw(this.zzFe().zzEb());
                } else if (!string.equals(this.zzFe().zzEb())) {
                    this.zzFm().zzFJ().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzFn().zzFT();
                    this.zzbeI.disconnect();
                    this.zzbeI.zzmC();
                    this.zzFn().zzfw(this.zzFe().zzEb());
                }
            }
            if (!(this.zzFo().zzmW() || this.zzGh() || TextUtils.isEmpty((CharSequence)this.zzFe().zzEb()))) {
                this.zzFd().zzGx();
            }
        }
        this.zzGn();
    }

    public zzd zzFo() {
        return this.zzbey;
    }

    public zzt zzFn() {
        this.zza((zzz)this.zzbez);
        return this.zzbez;
    }

    public zzp zzFm() {
        this.zza(this.zzbeA);
        return this.zzbeA;
    }

    public zzp zzFY() {
        return this.zzbeA != null && this.zzbeA.isInitialized() ? this.zzbeA : null;
    }

    public zzw zzFl() {
        this.zza(this.zzbeB);
        return this.zzbeB;
    }

    public zzaf zzFk() {
        this.zza(this.zzbeC);
        return this.zzbeC;
    }

    public zzv zzFj() {
        this.zza(this.zzbeD);
        return this.zzbeD;
    }

    zzw zzFZ() {
        return this.zzbeB;
    }

    public zzac zzFd() {
        this.zza(this.zzbeK);
        return this.zzbeK;
    }

    public AppMeasurement zzGa() {
        return this.zzbeE;
    }

    public zzal zzFi() {
        this.zza(this.zzbeF);
        return this.zzbeF;
    }

    public zze zzFh() {
        this.zza(this.zzbeG);
        return this.zzbeG;
    }

    public zzq zzGb() {
        this.zza(this.zzbeH);
        return this.zzbeH;
    }

    public Context getContext() {
        return this.mContext;
    }

    public com.google.android.gms.common.util.zze zzlQ() {
        return this.zzsd;
    }

    public zzad zzFg() {
        this.zza(this.zzbeI);
        return this.zzbeI;
    }

    public zzg zzFf() {
        this.zza(this.zzbeJ);
        return this.zzbeJ;
    }

    public zzn zzFe() {
        this.zza(this.zzbeL);
        return this.zzbeL;
    }

    public zzr zzGc() {
        if (this.zzbeM == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbeM;
    }

    public zzai zzGd() {
        this.zza(this.zzbeN);
        return this.zzbeN;
    }

    public zzc zzFc() {
        this.zza(this.zzbeO);
        return this.zzbeO;
    }

    @WorkerThread
    public void zzkN() {
        this.zzFl().zzkN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzx zzbd(Context context) {
        com.google.android.gms.common.internal.zzaa.zzz((Object)context);
        com.google.android.gms.common.internal.zzaa.zzz((Object)context.getApplicationContext());
        if (zzbex != null) return zzbex;
        Class<zzx> clazz = zzx.class;
        synchronized (zzx.class) {
            if (zzbex != null) return zzbex;
            zzab zzab2 = null;
            boolean bl = false;
            zzab2 = new zzab(context);
            zzbex = zzab2.zzGv();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbex;
        }
    }

    FileChannel zzGe() {
        return this.zzbeT;
    }

    private void zza(zzaa zzaa2) {
        if (zzaa2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzaa2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzz zzz2) {
        if (zzz2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzGf() {
        this.zzkN();
        this.zzma();
        if (this.zzGr() && this.zzGg()) {
            int n = this.zza(this.zzGe());
            int n2 = this.zzFe().zzFC();
            this.zzv(n, n2);
        }
    }

    @WorkerThread
    boolean zzGg() {
        this.zzkN();
        String string = this.zzbeG.zzmv();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbeT = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbeS = this.zzbeT.tryLock();
            if (this.zzbeS != null) {
                this.zzFm().zzFL().log("Storage concurrent access okay");
                return true;
            }
            this.zzFm().zzFE().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzFm().zzFE().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzv(int n, int n2) {
        this.zzkN();
        if (n > n2) {
            this.zzFm().zzFE().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzGe())) {
                this.zzFm().zzFL().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzFm().zzFE().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzkN();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzFm().zzFE().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n3 = fileChannel.read(byteBuffer);
            if (n3 != 4) {
                this.zzFm().zzFG().zzj("Unexpected data length or empty data in channel. Bytes read", n3);
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzkN();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzFm().zzFE().log("Bad chanel to read from");
            return false;
        }
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzFm().zzFE().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    protected boolean zzGh() {
        return false;
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzkN();
        this.zzma();
        if (this.zzFo().zzEM()) {
            return false;
        }
        Boolean bl = this.zzFo().zzEN();
        boolean bl2 = bl != null ? bl : !this.zzFo().zzsB();
        return this.zzFn().zzax(bl2);
    }

    void zzc(AppMetadata appMetadata) {
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzdl((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    @WorkerThread
    void zzb(EventParcel eventParcel, String string) {
        Object object;
        com.google.android.gms.measurement.internal.zza zza2;
        block4: {
            zza2 = this.zzFh().zzfk(string);
            if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzkV())) {
                this.zzFm().zzFK().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = this.getContext().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
                if (zza2.zzkV() != null && !zza2.zzkV().equals(object)) {
                    this.zzFm().zzFG().zzj("App version does not match; dropping event", string);
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(eventParcel.name)) break block4;
                this.zzFm().zzFG().zzj("Could not find package", string);
            }
        }
        object = new AppMetadata(string, zza2.zzEb(), zza2.zzkV(), zza2.zzEg(), zza2.zzEh(), zza2.zzEi(), zza2.zzEj(), null, zza2.zzEk(), false, zza2.zzEd());
        this.zzb(eventParcel, (AppMetadata)((Object)object));
    }

    long zzGi() {
        long l = this.zzlQ().currentTimeMillis() + this.zzFn().zzFP();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        long l = System.nanoTime();
        this.zzkN();
        this.zzma();
        String string = appMetadata.packageName;
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzbbK)) {
            return;
        }
        if (!appMetadata.zzbbP) {
            this.zze(appMetadata);
            return;
        }
        if (this.zzFj().zzV(string, eventParcel.name)) {
            this.zzFm().zzFG().zzj("Dropping blacklisted event", eventParcel.name);
            this.zzFi().zze(11, "_ev", eventParcel.name);
            return;
        }
        if (this.zzFm().zzX(2)) {
            this.zzFm().zzFL().zzj("Logging event", (Object)eventParcel);
        }
        this.zzFh().beginTransaction();
        try {
            zzi zzi2;
            Bundle bundle = eventParcel.zzbcq.zzFB();
            this.zze(appMetadata);
            if ("_iap".equals(eventParcel.name) || "ecommerce_purchase".equals(eventParcel.name)) {
                String string2 = bundle.getString("currency");
                long l2 = 0L;
                if ("ecommerce_purchase".equals(eventParcel.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzFm().zzFG().zzj("Data lost. Currency value is too big", d);
                        this.zzFh().setTransactionSuccessful();
                        return;
                    }
                    l2 = Math.round(d);
                } else {
                    l2 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzak zzak2 = this.zzFh().zzQ(string, string5);
                    if (zzak2 == null || !(zzak2.zzRF instanceof Long)) {
                        this.zzFh().zzy(string, this.zzFo().zzfe(string) - 1);
                        zzak2 = new zzak(string, string5, this.zzlQ().currentTimeMillis(), l2);
                    } else {
                        long l3 = (Long)zzak2.zzRF;
                        zzak2 = new zzak(string, string5, this.zzlQ().currentTimeMillis(), l3 + l2);
                    }
                    if (!this.zzFh().zza(zzak2)) {
                        this.zzFm().zzFE().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzRF);
                        this.zzFi().zze(9, null, null);
                    }
                }
            }
            boolean bl = zzal.zzfG(eventParcel.name);
            boolean bl2 = zzal.zzK(bundle);
            boolean bl3 = "_err".equals(eventParcel.name);
            zze.zza zza2 = this.zzFh().zza(this.zzGi(), string, bl, false, bl3);
            long l4 = zza2.zzbbY - this.zzFo().zzEE();
            if (l4 > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzFm().zzFE().zzj("Data loss. Too many events logged. count", zza2.zzbbY);
                }
                this.zzFi().zze(16, "_ev", eventParcel.name);
                this.zzFh().setTransactionSuccessful();
                return;
            }
            if (bl && (l4 = zza2.zzbbX - this.zzFo().zzEF()) > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzFm().zzFE().zzj("Data loss. Too many public events logged. count", zza2.zzbbX);
                }
                this.zzFi().zze(16, "_ev", eventParcel.name);
                this.zzFh().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l4 = zza2.zzbca - this.zzFo().zzEG()) > 0L) {
                if (l4 == 1L) {
                    this.zzFm().zzFE().zzj("Too many error events logged. count", zza2.zzbca);
                }
                this.zzFh().setTransactionSuccessful();
                return;
            }
            this.zzFi().zza(bundle, "_o", eventParcel.zzbcr);
            long l5 = this.zzFh().zzfl(string);
            if (l5 > 0L) {
                this.zzFm().zzFG().zzj("Data lost. Too many events stored on disk, deleted", l5);
            }
            zzh zzh2 = new zzh(this, eventParcel.zzbcr, string, eventParcel.name, eventParcel.zzbcs, 0L, bundle);
            zzi zzi3 = this.zzFh().zzO(string, zzh2.mName);
            if (zzi3 == null) {
                long l6 = this.zzFh().zzfr(string);
                if (l6 >= (long)this.zzFo().zzED()) {
                    this.zzFm().zzFE().zze("Too many event names used, ignoring event. name, supported count", zzh2.mName, this.zzFo().zzED());
                    this.zzFi().zze(8, null, null);
                    return;
                }
                zzi2 = new zzi(string, zzh2.mName, 0L, 0L, zzh2.zzajg);
            } else {
                zzh2 = zzh2.zza(this, zzi3.zzbcm);
                zzi2 = zzi3.zzag(zzh2.zzajg);
            }
            this.zzFh().zza(zzi2);
            this.zza(zzh2, appMetadata);
            this.zzFh().setTransactionSuccessful();
            if (this.zzFm().zzX(2)) {
                this.zzFm().zzFL().zzj("Event recorded", zzh2);
            }
        }
        finally {
            this.zzFh().endTransaction();
        }
        this.zzGn();
        this.zzFm().zzFL().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull EventParcel eventParcel, @Size(min=1L) String string) {
        Object object;
        zzamc zzamc2;
        Object object2;
        this.zzma();
        this.zzkN();
        this.zzGj();
        com.google.android.gms.common.internal.zzaa.zzz((Object)((Object)eventParcel));
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        zzsp.zzd zzd2 = new zzsp.zzd();
        this.zzFh().beginTransaction();
        try {
            zzi zzi2;
            long l;
            Object object3;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzFh().zzfk(string);
            if (zza2 == null) {
                this.zzFm().zzFK().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zza2.zzEk()) {
                this.zzFm().zzFK().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzsp.zze();
            zzd2.zzbhb = new zzsp.zze[]{object2};
            object2.zzbhd = 1;
            object2.zzbhl = "android";
            object2.appId = zza2.zziC();
            object2.zzbbL = zza2.zzEh();
            object2.zzaUf = zza2.zzkV();
            object2.zzbhy = (int)zza2.zzEg();
            object2.zzbhp = zza2.zzEi();
            object2.zzbbK = zza2.zzEb();
            object2.zzbhu = zza2.zzEj();
            zzamc2 = this.zzFn().zzfu(zza2.zziC());
            if (zzamc2 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)zzamc2.first))) {
                object2.zzbhr = (String)zzamc2.first;
                object2.zzbhs = (Boolean)zzamc2.second;
            }
            object2.zzbhm = this.zzFf().zzjb();
            object2.osVersion = this.zzFf().zzFx();
            object2.zzbho = (int)this.zzFf().zzFy();
            object2.zzbhn = this.zzFf().zzFz();
            object2.zzbht = zza2.zzvx();
            object2.zzbbS = zza2.zzEd();
            object = this.zzFh().zzfj(zza2.zziC());
            object2.zzbhf = new zzsp.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzsp.zzg();
                object2.zzbhf[i] = object3;
                ((zzsp.zzg)object3).name = object.get((int)i).mName;
                ((zzsp.zzg)object3).zzbhF = object.get((int)i).zzbgg;
                this.zzFi().zza((zzsp.zzg)object3, object.get((int)i).zzRF);
            }
            Bundle bundle = eventParcel.zzbcq.zzFB();
            if ("_iap".equals(eventParcel.name)) {
                bundle.putLong("_c", 1L);
            }
            bundle.putString("_o", eventParcel.zzbcr);
            object3 = this.zzFh().zzO(string, eventParcel.name);
            if (object3 == null) {
                l = 0L;
                zzi2 = new zzi(string, eventParcel.name, 1L, 0L, eventParcel.zzbcs);
                this.zzFh().zza(zzi2);
            } else {
                l = ((zzi)object3).zzbcm;
                zzi2 = ((zzi)object3).zzag(eventParcel.zzbcs);
                zzi2 = zzi2.zzFA();
                this.zzFh().zza(zzi2);
            }
            zzh zzh2 = new zzh(this, eventParcel.zzbcr, string, eventParcel.name, eventParcel.zzbcs, l, bundle);
            zzsp.zzb zzb2 = new zzsp.zzb();
            object2.zzbhe = new zzsp.zzb[]{zzb2};
            zzb2.zzbgX = zzh2.zzajg;
            zzb2.name = zzh2.mName;
            zzb2.zzbgY = zzh2.zzbci;
            zzb2.zzbgW = new zzsp.zzc[zzh2.zzbcj.size()];
            int n = 0;
            for (String string2 : zzh2.zzbcj) {
                zzsp.zzc zzc2 = new zzsp.zzc();
                zzb2.zzbgW[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzh2.zzbcj.get(string2);
                this.zzFi().zza(zzc2, object4);
            }
            object2.zzbhx = this.zza(zza2.zziC(), object2.zzbhf, object2.zzbhe);
            object2.zzbhh = zzb2.zzbgX;
            object2.zzbhi = zzb2.zzbgX;
            long l2 = zza2.zzEf();
            object2.zzbhk = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zza2.zzEe();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.zzbhj = l3 != 0L ? Long.valueOf(l3) : null;
            zza2.zzEo();
            object2.zzbhv = (int)zza2.zzEl();
            object2.zzbhq = this.zzFo().zzEi();
            object2.zzbhg = this.zzlQ().currentTimeMillis();
            object2.zzbhw = Boolean.TRUE;
            zza2.zzR(object2.zzbhh);
            zza2.zzS(object2.zzbhi);
            this.zzFh().zza(zza2);
            this.zzFh().setTransactionSuccessful();
        }
        finally {
            this.zzFh().endTransaction();
        }
        try {
            int n = zzd2.getSerializedSize();
            object2 = new byte[n];
            zzamc2 = zzamc.zzO((byte[])object2);
            zzd2.writeTo(zzamc2);
            zzamc2.zzWU();
            object = this.zzFi().zzh((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Data loss. Failed to bundle and serialize", iOException);
            return null;
        }
    }

    void zza(zzh zzh2, AppMetadata appMetadata) {
        Object object;
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)zzh2);
        com.google.android.gms.common.internal.zzaa.zzz((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzaa.zzdl((String)zzh2.zzPx);
        com.google.android.gms.common.internal.zzaa.zzaj((boolean)zzh2.zzPx.equals(appMetadata.packageName));
        zzsp.zze zze2 = new zzsp.zze();
        zze2.zzbhd = 1;
        zze2.zzbhl = "android";
        zze2.appId = appMetadata.packageName;
        zze2.zzbbL = appMetadata.zzbbL;
        zze2.zzaUf = appMetadata.zzaUf;
        zze2.zzbhy = (int)appMetadata.zzbbR;
        zze2.zzbhp = appMetadata.zzbbM;
        zze2.zzbbK = appMetadata.zzbbK;
        zze2.zzbhu = appMetadata.zzbbN == 0L ? null : Long.valueOf(appMetadata.zzbbN);
        Pair<String, Boolean> pair = this.zzFn().zzfu(appMetadata.packageName);
        if (pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.zzbhr = (String)pair.first;
            zze2.zzbhs = (Boolean)pair.second;
        } else if (!this.zzFf().zzbc(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzFm().zzFG().log("null secure ID");
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzFm().zzFG().log("empty secure ID");
            }
            zze2.zzbhB = object;
        }
        zze2.zzbhm = this.zzFf().zzjb();
        zze2.osVersion = this.zzFf().zzFx();
        zze2.zzbho = (int)this.zzFf().zzFy();
        zze2.zzbhn = this.zzFf().zzFz();
        zze2.zzbhq = null;
        zze2.zzbhg = null;
        zze2.zzbhh = null;
        zze2.zzbhi = null;
        object = this.zzFh().zzfk(appMetadata.packageName);
        if (object == null) {
            object = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            ((com.google.android.gms.measurement.internal.zza)object).zzeV(this.zzFn().zzFO());
            ((com.google.android.gms.measurement.internal.zza)object).zzeY(appMetadata.zzbbS);
            ((com.google.android.gms.measurement.internal.zza)object).zzeW(appMetadata.zzbbK);
            ((com.google.android.gms.measurement.internal.zza)object).zzeX(this.zzFn().zzfv(appMetadata.packageName));
            ((com.google.android.gms.measurement.internal.zza)object).zzW(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzR(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzS(0L);
            ((com.google.android.gms.measurement.internal.zza)object).setAppVersion(appMetadata.zzaUf);
            ((com.google.android.gms.measurement.internal.zza)object).zzT(appMetadata.zzbbR);
            ((com.google.android.gms.measurement.internal.zza)object).zzeZ(appMetadata.zzbbL);
            ((com.google.android.gms.measurement.internal.zza)object).zzU(appMetadata.zzbbM);
            ((com.google.android.gms.measurement.internal.zza)object).zzV(appMetadata.zzbbN);
            ((com.google.android.gms.measurement.internal.zza)object).setMeasurementEnabled(appMetadata.zzbbP);
            this.zzFh().zza((com.google.android.gms.measurement.internal.zza)object);
        }
        zze2.zzbht = ((com.google.android.gms.measurement.internal.zza)object).zzvx();
        zze2.zzbbS = ((com.google.android.gms.measurement.internal.zza)object).zzEd();
        List<zzak> list = this.zzFh().zzfj(appMetadata.packageName);
        zze2.zzbhf = new zzsp.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzsp.zzg zzg2;
            zze2.zzbhf[i] = zzg2 = new zzsp.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.zzbhF = list.get((int)i).zzbgg;
            this.zzFi().zza(zzg2, list.get((int)i).zzRF);
        }
        long l = 0L;
        try {
            l = this.zzFh().zzb(zze2);
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Data loss. Failed to insert raw event metadata", iOException);
            return;
        }
        this.zzFh().zza(zzh2, l);
    }

    void zzlP() {
        if (this.zzFo().zzmW()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    void zzGj() {
        if (!this.zzFo().zzmW()) {
            throw new IllegalStateException("Unexpected call on client side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzkN();
        this.zzma();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzbbK)) {
            return;
        }
        if (!appMetadata.zzbbP) {
            this.zze(appMetadata);
            return;
        }
        int n = this.zzFi().zzfK(userAttributeParcel.name);
        if (n != 0) {
            String string = this.zzFi().zza(userAttributeParcel.name, this.zzFo().zzEx(), true);
            this.zzFi().zze(n, "_ev", string);
            return;
        }
        n = this.zzFi().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (n != 0) {
            String string = this.zzFi().zza(userAttributeParcel.name, this.zzFo().zzEx(), true);
            this.zzFi().zze(n, "_ev", string);
            return;
        }
        Object object = this.zzFi().zzn(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzak zzak2 = new zzak(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.zzbgc, object);
        this.zzFm().zzFK().zze("Setting user property", zzak2.mName, object);
        this.zzFh().beginTransaction();
        try {
            this.zze(appMetadata);
            boolean bl = this.zzFh().zza(zzak2);
            this.zzFh().setTransactionSuccessful();
            if (bl) {
                this.zzFm().zzFK().zze("User property set", zzak2.mName, zzak2.zzRF);
            } else {
                this.zzFm().zzFE().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzRF);
                this.zzFi().zze(9, null, null);
            }
        }
        finally {
            this.zzFh().endTransaction();
        }
    }

    @WorkerThread
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzkN();
        this.zzma();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzbbK)) {
            return;
        }
        if (!appMetadata.zzbbP) {
            this.zze(appMetadata);
            return;
        }
        this.zzFm().zzFK().zzj("Removing user property", userAttributeParcel.name);
        this.zzFh().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzFh().zzP(appMetadata.packageName, userAttributeParcel.name);
            this.zzFh().setTransactionSuccessful();
            this.zzFm().zzFK().zzj("User property removed", userAttributeParcel.name);
        }
        finally {
            this.zzFh().endTransaction();
        }
    }

    @WorkerThread
    private boolean zzGk() {
        this.zzkN();
        return this.zzbeU != null;
    }

    private void zzD(List<Long> list) {
        com.google.android.gms.common.internal.zzaa.zzaj((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzbeU != null) {
            this.zzFm().zzFE().log("Set uploading progress before finishing the previous upload");
        } else {
            this.zzbeU = new ArrayList<Long>(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void zzGl() {
        String string;
        this.zzkN();
        this.zzma();
        if (!this.zzFo().zzmW()) {
            Boolean bl = this.zzFn().zzFS();
            if (bl == null) {
                this.zzFm().zzFG().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzFm().zzFE().log("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzGk()) {
            this.zzFm().zzFG().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzGb().zzod()) {
            this.zzFm().zzFG().log("Network not connected, ignoring upload request");
            this.zzGn();
            return;
        }
        long l = this.zzlQ().currentTimeMillis();
        this.zzai(l - this.zzFo().zzEU());
        long l2 = this.zzFn().zzbdG.get();
        if (l2 != 0L) {
            this.zzFm().zzFK().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzFh().zzFp()))) {
            int n = this.zzFo().zzfg(string);
            int n2 = this.zzFo().zzfh(string);
            List<Pair<zzsp.zze, Long>> list = this.zzFh().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzsp.zze, Long> object2 : list) {
                    zzsp.zze zze2 = (zzsp.zze)object2.first;
                    if (TextUtils.isEmpty((CharSequence)zze2.zzbhr)) continue;
                    string2 = zze2.zzbhr;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzsp.zze zze3 = (zzsp.zze)list.get((int)i).first;
                        if (TextUtils.isEmpty((CharSequence)zze3.zzbhr) || zze3.zzbhr.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                zzsp.zzd zzd2 = new zzsp.zzd();
                zzd2.zzbhb = new zzsp.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < zzd2.zzbhb.length; ++i) {
                    zzd2.zzbhb[i] = (zzsp.zze)list.get((int)i).first;
                    arrayList.add((Long)list.get((int)i).second);
                    zzd2.zzbhb[i].zzbhq = this.zzFo().zzEi();
                    zzd2.zzbhb[i].zzbhg = l;
                    zzd2.zzbhb[i].zzbhw = this.zzFo().zzmW();
                }
                String string3 = null;
                if (this.zzFm().zzX(2)) {
                    string3 = zzal.zzb(zzd2);
                }
                byte[] byArray = this.zzFi().zza(zzd2);
                String string4 = this.zzFo().zzET();
                try {
                    URL uRL = new URL(string4);
                    this.zzD(arrayList);
                    this.zzFn().zzbdH.set(l);
                    String string5 = "?";
                    if (zzd2.zzbhb.length > 0) {
                        string5 = zzd2.zzbhb[0].appId;
                    }
                    this.zzFm().zzFL().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzGb().zza(string, uRL, byArray, null, new zzq.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzx.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzFm().zzFE().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        } else {
            String string6 = this.zzFh().zzaf(l - this.zzFo().zzEU());
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                com.google.android.gms.measurement.internal.zza zza2 = this.zzFh().zzfk(string6);
                if (zza2 != null) {
                    String string7 = this.zzFo().zzN(zza2.zzEb(), zza2.zzvx());
                    try {
                        void var11_23;
                        URL uRL = new URL(string7);
                        this.zzFm().zzFL().zzj("Fetching remote configuration", zza2.zziC());
                        zzso.zzb zzb2 = this.zzFj().zzfy(zza2.zziC());
                        Object var11_21 = null;
                        String string8 = this.zzFj().zzfz(zza2.zziC());
                        if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string8)) {
                            ArrayMap arrayMap = new ArrayMap();
                            arrayMap.put("If-Modified-Since", string8);
                        }
                        this.zzGb().zza(string6, uRL, (Map<String, String>)var11_23, new zzq.zza(){

                            @Override
                            public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                                zzx.this.zzb(string, n, throwable, byArray, map);
                            }
                        });
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzFm().zzFE().zzj("Failed to parse config URL. Not fetching", string7);
                    }
                }
                return;
            }
        }
    }

    boolean zzai(long l) {
        return this.zzg(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzg(String string, long l) {
        this.zzFh().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzFh().zza(string, l, zza2);
            if (!zza2.isEmpty()) {
                int n;
                zzsp.zze zze2 = zza2.zzbeY;
                zze2.zzbhe = new zzsp.zzb[zza2.zzqD.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzqD.size(); ++n) {
                    if (this.zzFj().zzV(zza2.zzbeY.appId, zza2.zzqD.get((int)n).name)) {
                        this.zzFm().zzFG().zzj("Dropping blacklisted raw event", zza2.zzqD.get((int)n).name);
                        this.zzFi().zze(11, "_ev", zza2.zzqD.get((int)n).name);
                        continue;
                    }
                    if (this.zzFj().zzW(zza2.zzbeY.appId, zza2.zzqD.get((int)n).name)) {
                        boolean bl;
                        boolean bl2 = false;
                        if (zza2.zzqD.get((int)n).zzbgW == null) {
                            zza2.zzqD.get((int)n).zzbgW = new zzsp.zzc[0];
                        }
                        for (zzsp.zzc zzc2 : zza2.zzqD.get((int)n).zzbgW) {
                            if (!"_c".equals(zzc2.name)) continue;
                            zzc2.zzbha = 1L;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            this.zzFm().zzFL().zzj("Marking event as conversion", zza2.zzqD.get((int)n).name);
                            zzsp.zzc[] zzcArray = Arrays.copyOf(zza2.zzqD.get((int)n).zzbgW, zza2.zzqD.get((int)n).zzbgW.length + 1);
                            zzsp.zzc zzc3 = new zzsp.zzc();
                            zzc3.name = "_c";
                            zzc3.zzbha = 1L;
                            zzcArray[zzcArray.length - 1] = zzc3;
                            zza2.zzqD.get((int)n).zzbgW = zzcArray;
                        }
                        if (bl = zzal.zzfG(zza2.zzqD.get((int)n).name)) {
                            zze.zza zza3 = this.zzFh().zza(this.zzGi(), zza2.zzbeY.appId, false, bl, false);
                            long l2 = zza3.zzbbZ - (long)this.zzFo().zzfc(zza2.zzbeY.appId);
                            if (l2 > 0L) {
                                this.zzFm().zzFG().log("Too many conversions. Not logging as conversion.");
                                zzsp.zzb zzb2 = zza2.zzqD.get(n);
                                boolean bl3 = false;
                                zzsp.zzc zzc4 = null;
                                for (zzsp.zzc zzc5 : zza2.zzqD.get((int)n).zzbgW) {
                                    if ("_c".equals(zzc5.name)) {
                                        zzc4 = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl3 = true;
                                }
                                if (bl3 && zzc4 != null) {
                                    zzsp.zzc[] zzcArray = new zzsp.zzc[zzb2.zzbgW.length - 1];
                                    int n3 = 0;
                                    for (zzsp.zzc zzc6 : zzb2.zzbgW) {
                                        if (zzc6 == zzc4) continue;
                                        zzcArray[n3++] = zzc6;
                                    }
                                    zza2.zzqD.get((int)n).zzbgW = zzcArray;
                                } else if (zzc4 != null) {
                                    zzc4.name = "_err";
                                    zzc4.zzbha = 10L;
                                } else {
                                    this.zzFm().zzFE().log("Did not find conversion parameter. Error not tracked");
                                }
                            }
                        }
                    }
                    zze2.zzbhe[n2++] = zza2.zzqD.get(n);
                }
                if (n2 < zza2.zzqD.size()) {
                    zze2.zzbhe = Arrays.copyOf(zze2.zzbhe, n2);
                }
                zze2.zzbhx = this.zza(zza2.zzbeY.appId, zza2.zzbeY.zzbhf, zze2.zzbhe);
                zze2.zzbhh = zze2.zzbhe[0].zzbgX;
                zze2.zzbhi = zze2.zzbhe[0].zzbgX;
                for (n = 1; n < zze2.zzbhe.length; ++n) {
                    zzsp.zzb zzb3 = zze2.zzbhe[n];
                    if (zzb3.zzbgX < zze2.zzbhh) {
                        zze2.zzbhh = zzb3.zzbgX;
                    }
                    if (zzb3.zzbgX <= zze2.zzbhi) continue;
                    zze2.zzbhi = zzb3.zzbgX;
                }
                String string2 = zza2.zzbeY.appId;
                com.google.android.gms.measurement.internal.zza zza4 = this.zzFh().zzfk(string2);
                if (zza4 == null) {
                    this.zzFm().zzFE().log("Bundling raw events w/o app info");
                } else {
                    long l3 = zza4.zzEf();
                    zze2.zzbhk = l3 != 0L ? Long.valueOf(l3) : null;
                    long l4 = zza4.zzEe();
                    if (l4 == 0L) {
                        l4 = l3;
                    }
                    zze2.zzbhj = l4 != 0L ? Long.valueOf(l4) : null;
                    zza4.zzEo();
                    zze2.zzbhv = (int)zza4.zzEl();
                    zza4.zzR(zze2.zzbhh);
                    zza4.zzS(zze2.zzbhi);
                    this.zzFh().zza(zza4);
                }
                zze2.zzbbO = this.zzFm().zzFM();
                this.zzFh().zza(zze2);
                this.zzFh().zzC(zza2.zzbeZ);
                this.zzFh().zzfq(string2);
                this.zzFh().setTransactionSuccessful();
                boolean bl = true;
                return true;
            }
            this.zzFh().setTransactionSuccessful();
            boolean bl = false;
            return false;
        }
        finally {
            this.zzFh().endTransaction();
        }
    }

    private zzsp.zza[] zza(String string, zzsp.zzg[] zzgArray, zzsp.zzb[] zzbArray) {
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        return this.zzFc().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzdl((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzFh().beginTransaction();
        try {
            boolean bl;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzFh().zzfk(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zza2 == null) {
                this.zzFm().zzFG().zzj("App does not exist in onConfigFetched", string);
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzFj().zzfy(string) == null && !this.zzFj().zzb(string, null, null) : !this.zzFj().zzb(string, byArray, string2)) {
                    return;
                }
                zza2.zzX(this.zzlQ().currentTimeMillis());
                this.zzFh().zza(zza2);
                if (n == 404) {
                    this.zzFm().zzFG().log("Config not found. Using empty config");
                } else {
                    this.zzFm().zzFL().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzGb().zzod() && this.zzGm()) {
                    this.zzGl();
                } else {
                    this.zzGn();
                }
            } else {
                boolean bl3;
                zza2.zzY(this.zzlQ().currentTimeMillis());
                this.zzFh().zza(zza2);
                this.zzFm().zzFL().zze("Fetching config failed. code, error", n, throwable);
                this.zzFj().zzfA(string);
                this.zzFn().zzbdH.set(this.zzlQ().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzFn().zzbdI.set(this.zzlQ().currentTimeMillis());
                }
                this.zzGn();
            }
            this.zzFh().setTransactionSuccessful();
        }
        finally {
            this.zzFh().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzkN();
        this.zzma();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzbeU;
        this.zzbeU = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzFn().zzbdG.set(this.zzlQ().currentTimeMillis());
            this.zzFn().zzbdH.set(0L);
            this.zzGn();
            this.zzFm().zzFL().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzFh().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzFh().zzae(l);
                }
                this.zzFh().setTransactionSuccessful();
            }
            finally {
                this.zzFh().endTransaction();
            }
            if (this.zzGb().zzod() && this.zzGm()) {
                this.zzGl();
            } else {
                this.zzGn();
            }
        } else {
            boolean bl;
            this.zzFm().zzFL().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzFn().zzbdH.set(this.zzlQ().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzFn().zzbdI.set(this.zzlQ().currentTimeMillis());
            }
            this.zzGn();
        }
    }

    private boolean zzGm() {
        this.zzkN();
        this.zzma();
        boolean bl = this.zzFh().zzFu();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzFh().zzFp());
    }

    @WorkerThread
    private void zzGn() {
        this.zzkN();
        this.zzma();
        if (!this.zzGr()) {
            return;
        }
        if (!this.zzFX() || !this.zzGm()) {
            this.zzGc().unregister();
            this.zzGd().cancel();
            return;
        }
        long l = this.zzGo();
        if (l == 0L) {
            this.zzGc().unregister();
            this.zzGd().cancel();
            return;
        }
        if (!this.zzGb().zzod()) {
            this.zzGc().zzoa();
            this.zzGd().cancel();
            return;
        }
        long l2 = this.zzFn().zzbdI.get();
        long l3 = this.zzFo().zzEV();
        if (!this.zzFi().zzc(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzGc().unregister();
        long l4 = l - this.zzlQ().currentTimeMillis();
        if (l4 <= 0L) {
            this.zzGd().zzv(1L);
        } else {
            this.zzFm().zzFL().zzj("Upload scheduled in approximately ms", l4);
            this.zzGd().zzv(l4);
        }
    }

    private long zzGo() {
        long l;
        long l2 = this.zzlQ().currentTimeMillis();
        long l3 = this.zzFo().zzEY();
        long l4 = this.zzFo().zzEW();
        long l5 = this.zzFn().zzbdG.get();
        long l6 = this.zzFn().zzbdH.get();
        long l7 = this.zzFh().zzFs();
        long l8 = Math.max(l7, l = this.zzFh().zzFt());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (!this.zzFi().zzc(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzFo().zzFa(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzFo().zzEZ() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzR(boolean bl) {
        this.zzGn();
    }

    void zzb(zzaa zzaa2) {
        ++this.zzbeV;
    }

    void zzGp() {
        ++this.zzbeW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzd(AppMetadata appMetadata) {
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzaa.zzdl((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzbbK)) {
            return;
        }
        if (!appMetadata.zzbbP) {
            this.zze(appMetadata);
            return;
        }
        long l = this.zzlQ().currentTimeMillis();
        this.zzFh().beginTransaction();
        try {
            this.zza(appMetadata, l);
            this.zze(appMetadata);
            zzi zzi2 = this.zzFh().zzO(appMetadata.packageName, "_f");
            if (zzi2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
                this.zzb(userAttributeParcel, appMetadata);
                this.zzb(appMetadata, l);
                this.zzc(appMetadata, l);
            } else if (appMetadata.zzbbQ) {
                this.zzd(appMetadata, l);
            }
            this.zzFh().setTransactionSuccessful();
        }
        finally {
            this.zzFh().endTransaction();
        }
    }

    @WorkerThread
    void zza(AppMetadata appMetadata, long l) {
        com.google.android.gms.measurement.internal.zza zza2 = this.zzFh().zzfk(appMetadata.packageName);
        if (zza2 != null && zza2.zzEb() != null && !zza2.zzEb().equals(appMetadata.zzbbK)) {
            this.zzFm().zzFG().log("New GMP App Id passed in. Removing cached database data.");
            this.zzFh().zzfp(zza2.zziC());
            zza2 = null;
        }
        if (zza2 != null && zza2.zzkV() != null && !zza2.zzkV().equals(appMetadata.zzaUf)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zza2.zzkV());
            EventParcel eventParcel = new EventParcel("_au", new EventParams(bundle), "auto", l);
            this.zzb(eventParcel, appMetadata);
        }
    }

    @WorkerThread
    void zzb(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzc(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        EventParcel eventParcel = new EventParcel("_e", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzd(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        EventParcel eventParcel = new EventParcel("_cd", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    private void zze(AppMetadata appMetadata) {
        this.zzkN();
        this.zzma();
        com.google.android.gms.common.internal.zzaa.zzz((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzaa.zzdl((String)appMetadata.packageName);
        com.google.android.gms.measurement.internal.zza zza2 = this.zzFh().zzfk(appMetadata.packageName);
        String string = this.zzFn().zzfv(appMetadata.packageName);
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzeV(this.zzFn().zzFO());
            zza2.zzeX(string);
            bl = true;
        } else if (!string.equals(zza2.zzEc())) {
            zza2.zzeX(string);
            zza2.zzeV(this.zzFn().zzFO());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzbbK) && !appMetadata.zzbbK.equals(zza2.zzEb())) {
            zza2.zzeW(appMetadata.zzbbK);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzbbS) && !appMetadata.zzbbS.equals(zza2.zzEd())) {
            zza2.zzeY(appMetadata.zzbbS);
            bl = true;
        }
        if (appMetadata.zzbbM != 0L && appMetadata.zzbbM != zza2.zzEi()) {
            zza2.zzU(appMetadata.zzbbM);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzaUf) && !appMetadata.zzaUf.equals(zza2.zzkV())) {
            zza2.setAppVersion(appMetadata.zzaUf);
            bl = true;
        }
        if (appMetadata.zzbbR != zza2.zzEg()) {
            zza2.zzT(appMetadata.zzbbR);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzbbL) && !appMetadata.zzbbL.equals(zza2.zzEh())) {
            zza2.zzeZ(appMetadata.zzbbL);
            bl = true;
        }
        if (appMetadata.zzbbN != zza2.zzEj()) {
            zza2.zzV(appMetadata.zzbbN);
            bl = true;
        }
        if (appMetadata.zzbbP != zza2.zzEk()) {
            zza2.setMeasurementEnabled(appMetadata.zzbbP);
            bl = true;
        }
        if (bl) {
            this.zzFh().zza(zza2);
        }
    }

    @WorkerThread
    void zzGq() {
        this.zzkN();
        this.zzma();
        if (!this.zzbeQ) {
            this.zzFm().zzFJ().log("This instance being marked as an uploader");
            this.zzGf();
        }
        this.zzbeQ = true;
    }

    @WorkerThread
    boolean zzGr() {
        this.zzkN();
        this.zzma();
        return this.zzbeQ || this.zzGh();
    }

    private class zza
    implements zze.zzb {
        zzsp.zze zzbeY;
        List<Long> zzbeZ;
        List<zzsp.zzb> zzqD;
        long zzbfa;

        private zza() {
        }

        @Override
        public void zzc(zzsp.zze zze2) {
            com.google.android.gms.common.internal.zzaa.zzz((Object)zze2);
            this.zzbeY = zze2;
        }

        @Override
        public boolean zza(long l, zzsp.zzb zzb2) {
            com.google.android.gms.common.internal.zzaa.zzz((Object)zzb2);
            if (this.zzqD == null) {
                this.zzqD = new ArrayList<zzsp.zzb>();
            }
            if (this.zzbeZ == null) {
                this.zzbeZ = new ArrayList<Long>();
            }
            if (this.zzqD.size() > 0 && this.zza(this.zzqD.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.zzbfa + (long)zzb2.getSerializedSize();
            if (l2 >= (long)zzx.this.zzFo().zzER()) {
                return false;
            }
            this.zzbfa = l2;
            this.zzqD.add(zzb2);
            this.zzbeZ.add(l);
            return this.zzqD.size() < zzx.this.zzFo().zzES();
        }

        private long zza(zzsp.zzb zzb2) {
            return zzb2.zzbgX / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzqD == null || this.zzqD.isEmpty();
        }
    }
}

