/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.support.annotation.BinderThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzy
extends zzm.zza {
    private final zzx zzbbl;
    private final boolean zzbfb;

    public zzy(zzx zzx2) {
        zzaa.zzz((Object)zzx2);
        this.zzbbl = zzx2;
        this.zzbfb = false;
    }

    public zzy(zzx zzx2, boolean bl) {
        zzaa.zzz((Object)zzx2);
        this.zzbbl = zzx2;
        this.zzbfb = bl;
    }

    @WorkerThread
    void zzfB(String string) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string) && (stringArray = string.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzbbl.zzFm().zzFG().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.zzbbl.zzFn().zzbdF.zzf(stringArray[1], l);
            } else {
                this.zzbbl.zzFm().zzFG().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    @BinderThread
    public void zzb(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.zzbbl.zzFl().zzg(new Runnable(){

            @Override
            public void run() {
                zzy.this.zzbbl.zzGq();
                zzy.this.zzfB(appMetadata.zzbbO);
                zzy.this.zzbbl.zzc(appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzaa.zzz((Object)((Object)eventParcel));
        this.zzf(appMetadata);
        this.zzbbl.zzFl().zzg(new Runnable(){

            @Override
            public void run() {
                zzy.this.zzbbl.zzGq();
                zzy.this.zzfB(appMetadata.zzbbO);
                zzy.this.zzbbl.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final String string, final String string2) {
        zzaa.zzz((Object)((Object)eventParcel));
        zzaa.zzdl((String)string);
        this.zzfC(string);
        this.zzbbl.zzFl().zzg(new Runnable(){

            @Override
            public void run() {
                zzy.this.zzbbl.zzGq();
                zzy.this.zzfB(string2);
                zzy.this.zzbbl.zzb(eventParcel, string);
            }
        });
    }

    @Override
    @BinderThread
    public byte[] zza(final EventParcel eventParcel, final String string) {
        zzaa.zzdl((String)string);
        zzaa.zzz((Object)((Object)eventParcel));
        this.zzfC(string);
        this.zzbbl.zzFm().zzFK().zzj("Log and bundle. event", eventParcel.name);
        long l = this.zzbbl.zzlQ().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzbbl.zzFl().zze(new Callable<byte[]>(){

            public byte[] zzGs() throws Exception {
                zzy.this.zzbbl.zzGq();
                return zzy.this.zzbbl.zza(eventParcel, string);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzGs();
            }
        });
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzbbl.zzFm().zzFE().log("Log and bundle returned null");
                byArray = new byte[]{};
            }
            long l2 = this.zzbbl.zzlQ().nanoTime() / 1000000L;
            this.zzbbl.zzFm().zzFK().zzd("Log and bundle processed. event, size, time_ms", eventParcel.name, byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzbbl.zzFm().zzFE().zze("Failed to log and bundle. event, error", eventParcel.name, exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzaa.zzz((Object)((Object)userAttributeParcel));
        this.zzf(appMetadata);
        if (userAttributeParcel.getValue() == null) {
            this.zzbbl.zzFl().zzg(new Runnable(){

                @Override
                public void run() {
                    zzy.this.zzbbl.zzGq();
                    zzy.this.zzfB(appMetadata.zzbbO);
                    zzy.this.zzbbl.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.zzbbl.zzFl().zzg(new Runnable(){

                @Override
                public void run() {
                    zzy.this.zzbbl.zzGq();
                    zzy.this.zzfB(appMetadata.zzbbO);
                    zzy.this.zzbbl.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<UserAttributeParcel> zza(final AppMetadata appMetadata, boolean bl) {
        this.zzf(appMetadata);
        Future<List<zzak>> future = this.zzbbl.zzFl().zzd(new Callable<List<zzak>>(){

            public List<zzak> zzGt() throws Exception {
                zzy.this.zzbbl.zzGq();
                return zzy.this.zzbbl.zzFh().zzfj(appMetadata.packageName);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzGt();
            }
        });
        try {
            List<zzak> list = future.get();
            ArrayList<UserAttributeParcel> arrayList = new ArrayList<UserAttributeParcel>(list.size());
            for (zzak zzak2 : list) {
                if (!bl && zzal.zzfQ(zzak2.mName)) continue;
                arrayList.add(new UserAttributeParcel(zzak2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzbbl.zzFm().zzFE().zzj("Failed to get user attributes", exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.zzbbl.zzFl().zzg(new Runnable(){

            @Override
            public void run() {
                zzy.this.zzbbl.zzGq();
                zzy.this.zzfB(appMetadata.zzbbO);
                zzy.this.zzbbl.zzd(appMetadata);
            }
        });
    }

    @BinderThread
    private void zzf(AppMetadata appMetadata) {
        zzaa.zzz((Object)((Object)appMetadata));
        this.zzfC(appMetadata.packageName);
        this.zzbbl.zzFi().zzfN(appMetadata.zzbbK);
    }

    @BinderThread
    private void zzfC(String string) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzbbl.zzFm().zzFE().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzfD(string);
        }
        catch (SecurityException securityException) {
            this.zzbbl.zzFm().zzFE().zzj("Measurement Service called with invalid calling package", string);
            throw securityException;
        }
    }

    protected void zzfD(String string) throws SecurityException {
        int n = this.zzbfb ? Process.myUid() : Binder.getCallingUid();
        if (com.google.android.gms.common.util.zzy.zzd((Context)this.zzbbl.getContext(), (int)n, (String)string)) {
            return;
        }
        if (com.google.android.gms.common.util.zzy.zze((Context)this.zzbbl.getContext(), (int)n) && !this.zzbbl.zzGh()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string));
    }
}

