/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzamc;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class zzal
extends zzz {
    zzal(zzx zzx2) {
        super(zzx2);
    }

    static boolean zzfG(String string) {
        zzaa.zzdl((String)string);
        return string.charAt(0) != '_';
    }

    boolean zzX(String string, String string2) {
        if (string2 == null) {
            this.zzFm().zzFE().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzFm().zzFE().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        char c = string2.charAt(0);
        if (!Character.isLetter(c)) {
            this.zzFm().zzFE().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        for (int i = 1; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            this.zzFm().zzFE().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzY(String string, String string2) {
        if (string2 == null) {
            this.zzFm().zzFE().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzFm().zzFE().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            this.zzFm().zzFE().zze("Name must start with a letter or _ (underscores). Type, name", string, string2);
            return false;
        }
        for (int i = 1; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            this.zzFm().zzFE().zze("Name must start with a letter or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, Map<String, String> map, String string2) {
        if (string2 == null) {
            this.zzFm().zzFE().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.startsWith("firebase_")) {
            this.zzFm().zzFE().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (map != null && map.containsKey(string2)) {
            this.zzFm().zzFE().zze("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, int n, String string2) {
        if (string2 == null) {
            this.zzFm().zzFE().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() > n) {
            this.zzFm().zzFE().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public int zzfH(String string) {
        if (!this.zzX("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.zzbbm, string)) {
            return 13;
        }
        if (!this.zzc("event", this.zzFo().zzEw(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzfI(String string) {
        if (!this.zzY("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.zzbbm, string)) {
            return 13;
        }
        if (!this.zzc("event", this.zzFo().zzEw(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzfJ(String string) {
        if (!this.zzX("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zze.zzbbo, string)) {
            return 15;
        }
        if (!this.zzc("user property", this.zzFo().zzEx(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzfK(String string) {
        if (!this.zzY("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zze.zzbbo, string)) {
            return 15;
        }
        if (!this.zzc("user property", this.zzFo().zzEx(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzfL(String string) {
        if (!this.zzX("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzc("event param", this.zzFo().zzEy(), string)) {
            return 3;
        }
        return 0;
    }

    public int zzfM(String string) {
        if (!this.zzY("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzc("event param", this.zzFo().zzEy(), string)) {
            return 3;
        }
        return 0;
    }

    boolean zza(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.length() > n) {
                this.zzFm().zzFG().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean zzfN(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzFm().zzFE().log("Measurement Service called without google_app_id");
            return false;
        }
        if (!string.startsWith("1:")) {
            this.zzFm().zzFG().zzj("Measurement Service called with unknown id version", string);
            return true;
        }
        if (!this.zzfO(string)) {
            this.zzFm().zzFE().zzj("Invalid google_app_id. Firebase Analytics disabled. See", "https://goo.gl/FZRIUV");
            return false;
        }
        return true;
    }

    boolean zzfO(String string) {
        zzaa.zzz((Object)string);
        String string2 = "^1:\\d+:android:[a-f0-9]+$";
        return string.matches(string2);
    }

    private Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string = String.valueOf(object);
            return this.zza(string, n, bl);
        }
        return null;
    }

    public String zza(String string, int n, boolean bl) {
        if (string.length() > n) {
            if (bl) {
                return String.valueOf(string.substring(0, n)).concat("...");
            }
            return null;
        }
        return string;
    }

    public boolean zzk(String string, Object object) {
        return zzal.zzfQ(string) ? this.zza("param", string, this.zzFo().zzEA(), object) : this.zza("param", string, this.zzFo().zzEz(), object);
    }

    public Object zzl(String string, Object object) {
        if ("_ev".equals(string)) {
            Object object2 = this.zza(this.zzFo().zzEA(), object, true);
            return object2;
        }
        Object object3 = this.zza(zzal.zzfQ(string) ? this.zzFo().zzEA() : this.zzFo().zzEz(), object, false);
        return object3;
    }

    public Bundle zza(String string, Bundle bundle, @Nullable List<String> list, boolean bl) {
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            int n2 = this.zzFo().zzEv();
            for (String string2 : bundle.keySet()) {
                String string3;
                int n3 = 0;
                if (list == null || !list.contains(string2)) {
                    if (bl) {
                        n3 = this.zzfL(string2);
                    }
                    if (n3 == 0) {
                        n3 = this.zzfM(string2);
                    }
                }
                if (n3 != 0) {
                    if (this.zzb(bundle2, n3)) {
                        string3 = this.zza(string2, this.zzFo().zzEy(), true);
                        bundle2.putString("_ev", string3);
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!this.zzk(string2, bundle.get(string2)) && !"_ev".equals(string2)) {
                    if (this.zzb(bundle2, 4)) {
                        string3 = this.zza(string2, this.zzFo().zzEy(), true);
                        bundle2.putString("_ev", string3);
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!zzal.zzfG(string2) || ++n <= n2) continue;
                string3 = new StringBuilder(48).append("Event can't contain more then ").append(n2).append(" params").toString();
                this.zzFm().zzFE().zze(string3, string, bundle);
                this.zzb(bundle2, 5);
                bundle2.remove(string2);
            }
        }
        return bundle2;
    }

    public boolean zzb(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        long l = bundle.getLong("_err");
        if (l == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private int zzfP(String string) {
        if ("_ldl".equals(string)) {
            return this.zzFo().zzEC();
        }
        return this.zzFo().zzEB();
    }

    public int zzm(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, this.zzfP(string), object) : this.zza("user property", string, this.zzfP(string), object);
        return bl ? 0 : 7;
    }

    public Object zzn(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(this.zzfP(string), object, true);
        }
        return this.zza(this.zzfP(string), object, false);
    }

    public void zza(zzsp.zzg zzg2, Object object) {
        zzaa.zzz((Object)object);
        zzg2.zzasH = null;
        zzg2.zzbha = null;
        zzg2.zzbgf = null;
        if (object instanceof String) {
            zzg2.zzasH = (String)object;
        } else if (object instanceof Long) {
            zzg2.zzbha = (Long)object;
        } else if (object instanceof Double) {
            zzg2.zzbgf = (Double)object;
        } else {
            this.zzFm().zzFE().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzsp.zzc zzc2, Object object) {
        zzaa.zzz((Object)object);
        zzc2.zzasH = null;
        zzc2.zzbha = null;
        zzc2.zzbgf = null;
        if (object instanceof String) {
            zzc2.zzasH = (String)object;
        } else if (object instanceof Long) {
            zzc2.zzbha = (Long)object;
        } else if (object instanceof Double) {
            zzc2.zzbgf = (Double)object;
        } else {
            this.zzFm().zzFE().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            this.zzFm().zzFI().zze("Not putting event parameter. Invalid value type. name, type", string, string3);
        }
    }

    public void zze(int n, String string, String string2) {
        Bundle bundle = new Bundle();
        this.zzb(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString(string, string2);
        }
        this.zzbbl.zzFd().zze("auto", "_err", bundle);
    }

    public byte[] zzh(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzr(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzbZ(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    static long zzs(byte[] byArray) {
        zzaa.zzz((Object)byArray);
        zzaa.zzai((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    public long zzt(byte[] byArray) {
        zzaa.zzz((Object)byArray);
        MessageDigest messageDigest = zzal.zzbZ("MD5");
        if (messageDigest == null) {
            this.zzFm().zzFE().log("Failed to get MD5");
            return 0L;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return zzal.zzs(byArray2);
    }

    public byte[] zza(zzsp.zzd zzd2) {
        try {
            int n = zzd2.getSerializedSize();
            byte[] byArray = new byte[n];
            zzamc zzamc2 = zzamc.zzO((byte[])byArray);
            zzd2.writeTo(zzamc2);
            zzamc2.zzWU();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzFm().zzFE().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzc(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzlQ().currentTimeMillis() - l) > l2;
    }

    public static boolean zzb(Context context, String string, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, string), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zzj(Context context, String string) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, string), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @WorkerThread
    public boolean zzbN(String string) {
        this.zzkN();
        int n = this.getContext().checkCallingOrSelfPermission(string);
        if (n == 0) {
            return true;
        }
        this.zzFm().zzFK().zzj("Permission not granted", string);
        return false;
    }

    public static boolean zzfQ(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzZ(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean zzK(Bundle bundle) {
        long l = bundle.getLong("_c");
        return l == 1L;
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && 64 * i + j < bitSet.length(); ++j) {
                if (!bitSet.get(64 * i + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length * 64) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzal.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    private static void zza(StringBuilder stringBuilder, int n, zzsp.zze zze2) {
        if (zze2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("bundle {\n");
        zzal.zza(stringBuilder, n, "protocol_version", zze2.zzbhd);
        zzal.zza(stringBuilder, n, "platform", zze2.zzbhl);
        zzal.zza(stringBuilder, n, "gmp_version", zze2.zzbhp);
        zzal.zza(stringBuilder, n, "uploading_gmp_version", zze2.zzbhq);
        zzal.zza(stringBuilder, n, "gmp_app_id", zze2.zzbbK);
        zzal.zza(stringBuilder, n, "app_id", zze2.appId);
        zzal.zza(stringBuilder, n, "app_version", zze2.zzaUf);
        zzal.zza(stringBuilder, n, "app_version_major", zze2.zzbhy);
        zzal.zza(stringBuilder, n, "firebase_instance_id", zze2.zzbbS);
        zzal.zza(stringBuilder, n, "dev_cert_hash", zze2.zzbhu);
        zzal.zza(stringBuilder, n, "app_store", zze2.zzbbL);
        zzal.zza(stringBuilder, n, "upload_timestamp_millis", zze2.zzbhg);
        zzal.zza(stringBuilder, n, "start_timestamp_millis", zze2.zzbhh);
        zzal.zza(stringBuilder, n, "end_timestamp_millis", zze2.zzbhi);
        zzal.zza(stringBuilder, n, "previous_bundle_start_timestamp_millis", zze2.zzbhj);
        zzal.zza(stringBuilder, n, "previous_bundle_end_timestamp_millis", zze2.zzbhk);
        zzal.zza(stringBuilder, n, "app_instance_id", zze2.zzbht);
        zzal.zza(stringBuilder, n, "resettable_device_id", zze2.zzbhr);
        zzal.zza(stringBuilder, n, "device_id", zze2.zzbhB);
        zzal.zza(stringBuilder, n, "limited_ad_tracking", zze2.zzbhs);
        zzal.zza(stringBuilder, n, "os_version", zze2.osVersion);
        zzal.zza(stringBuilder, n, "device_model", zze2.zzbhm);
        zzal.zza(stringBuilder, n, "user_default_language", zze2.zzbhn);
        zzal.zza(stringBuilder, n, "time_zone_offset_minutes", zze2.zzbho);
        zzal.zza(stringBuilder, n, "bundle_sequential_index", zze2.zzbhv);
        zzal.zza(stringBuilder, n, "service_upload", zze2.zzbhw);
        zzal.zza(stringBuilder, n, "health_monitor", zze2.zzbbO);
        zzal.zza(stringBuilder, n, zze2.zzbhf);
        zzal.zza(stringBuilder, n, zze2.zzbhx);
        zzal.zza(stringBuilder, n, zze2.zzbhe);
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzsp.zzg[] zzgArray) {
        if (zzgArray == null) {
            return;
        }
        ++n;
        for (zzsp.zzg zzg2 : zzgArray) {
            if (zzg2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("user_property {\n");
            zzal.zza(stringBuilder, n, "set_timestamp_millis", zzg2.zzbhF);
            zzal.zza(stringBuilder, n, "name", zzg2.name);
            zzal.zza(stringBuilder, n, "string_value", zzg2.zzasH);
            zzal.zza(stringBuilder, n, "int_value", zzg2.zzbha);
            zzal.zza(stringBuilder, n, "double_value", zzg2.zzbgf);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzsp.zzc[] zzcArray) {
        if (zzcArray == null) {
            return;
        }
        ++n;
        for (zzsp.zzc zzc2 : zzcArray) {
            if (zzc2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzal.zza(stringBuilder, n, "name", zzc2.name);
            zzal.zza(stringBuilder, n, "string_value", zzc2.zzasH);
            zzal.zza(stringBuilder, n, "int_value", zzc2.zzbha);
            zzal.zza(stringBuilder, n, "double_value", zzc2.zzbgf);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzsp.zzb[] zzbArray) {
        if (zzbArray == null) {
            return;
        }
        ++n;
        for (zzsp.zzb zzb2 : zzbArray) {
            if (zzb2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("event {\n");
            zzal.zza(stringBuilder, n, "name", zzb2.name);
            zzal.zza(stringBuilder, n, "timestamp_millis", zzb2.zzbgX);
            zzal.zza(stringBuilder, n, "previous_timestamp_millis", zzb2.zzbgY);
            zzal.zza(stringBuilder, n, "count", zzb2.count);
            zzal.zza(stringBuilder, n, zzb2.zzbgW);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzsp.zza[] zzaArray) {
        if (zzaArray == null) {
            return;
        }
        ++n;
        for (zzsp.zza zza2 : zzaArray) {
            if (zza2 == null) continue;
            zzal.zza(stringBuilder, n);
            stringBuilder.append("audience_membership {\n");
            zzal.zza(stringBuilder, n, "audience_id", zza2.zzbgi);
            zzal.zza(stringBuilder, n, "new_audience", zza2.zzbgU);
            zzal.zza(stringBuilder, n, "current_data", zza2.zzbgS);
            zzal.zza(stringBuilder, n, "previous_data", zza2.zzbgT);
            zzal.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzsp.zzf zzf2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzf2 == null) {
            return;
        }
        zzal.zza(stringBuilder, ++n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzbhD != null) {
            zzal.zza(stringBuilder, n + 1);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzf2.zzbhD;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzf2.zzbhC != null) {
            zzal.zza(stringBuilder, n + 1);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzf2.zzbhC;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzsn.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzbgw != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzd2.zzbgw) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzal.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzal.zza(stringBuilder, n, "match_as_float", zzd2.zzbgx);
        zzal.zza(stringBuilder, n, "comparison_value", zzd2.zzbgy);
        zzal.zza(stringBuilder, n, "min_comparison_value", zzd2.zzbgz);
        zzal.zza(stringBuilder, n, "max_comparison_value", zzd2.zzbgA);
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzsn.zzf zzf2) {
        if (zzf2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzbgE != null) {
            String[] stringArray = "UNKNOWN_MATCH_TYPE";
            switch (zzf2.zzbgE) {
                case 1: {
                    stringArray = "REGEXP";
                    break;
                }
                case 2: {
                    stringArray = "BEGINS_WITH";
                    break;
                }
                case 3: {
                    stringArray = "ENDS_WITH";
                    break;
                }
                case 4: {
                    stringArray = "PARTIAL";
                    break;
                }
                case 5: {
                    stringArray = "EXACT";
                    break;
                }
                case 6: {
                    stringArray = "IN_LIST";
                }
            }
            zzal.zza(stringBuilder, n, "match_type", stringArray);
        }
        zzal.zza(stringBuilder, n, "expression", zzf2.zzbgF);
        zzal.zza(stringBuilder, n, "case_sensitive", zzf2.zzbgG);
        if (zzf2.zzbgH.length > 0) {
            zzal.zza(stringBuilder, n + 1);
            stringBuilder.append("expression_list {\n");
            for (String string2 : zzf2.zzbgH) {
                zzal.zza(stringBuilder, n + 2);
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            stringBuilder.append("}\n");
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzsn.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzal.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzal.zza(stringBuilder, n, "complement", zzc2.zzbgu);
        zzal.zza(stringBuilder, n, "param_name", zzc2.zzbgv);
        zzal.zza(stringBuilder, n + 1, "string_filter", zzc2.zzbgs);
        zzal.zza(stringBuilder, n + 1, "number_filter", zzc2.zzbgt);
        zzal.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    public static String zzb(zzsp.zzd zzd2) {
        if (zzd2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzd2.zzbhb != null) {
            for (zzsp.zze zze2 : zzd2.zzbhb) {
                if (zze2 == null) continue;
                zzal.zza(stringBuilder, 1, zze2);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzsn.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzal.zza(stringBuilder, 0, "filter_id", zzb2.zzbgm);
        zzal.zza(stringBuilder, 0, "event_name", zzb2.zzbgn);
        zzal.zza(stringBuilder, 1, "event_count_filter", zzb2.zzbgq);
        stringBuilder.append("  filters {\n");
        for (zzsn.zzc zzc2 : zzb2.zzbgo) {
            zzal.zza(stringBuilder, 2, zzc2);
        }
        zzal.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzsn.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzal.zza(stringBuilder, 0, "filter_id", zze2.zzbgm);
        zzal.zza(stringBuilder, 0, "property_name", zze2.zzbgC);
        zzal.zza(stringBuilder, 1, zze2.zzbgD);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

