/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzad
extends zzaa {
    private final zza anl;
    private zzm anm;
    private Boolean ann;
    private final zzf ano;
    private final zzah anp;
    private final List<Runnable> anq = new ArrayList<Runnable>();
    private final zzf anr;

    protected zzad(zzx zzx2) {
        super(zzx2);
        this.anp = new zzah(zzx2.zzyw());
        this.anl = new zza();
        this.ano = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzzu();
            }
        };
        this.anr = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzbsz().zzbtt().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzwv() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzwu();
        this.zzzg();
        return this.anm != null;
    }

    @WorkerThread
    protected void zzbvn() {
        this.zzwu();
        this.zzzg();
        this.zzn(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.anm;
                if (zzm2 == null) {
                    zzad.this.zzbsz().zzbtr().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzm2.zzb(zzad.this.zzbsr().zzlw(zzad.this.zzbsz().zzbtz()));
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsz().zzbtr().zzj("Failed to send measurementEnabled to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zzc(final EventParcel eventParcel, final String string) {
        zzab.zzaa((Object)((Object)eventParcel));
        this.zzwu();
        this.zzzg();
        this.zzn(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.anm;
                if (zzm2 == null) {
                    zzad.this.zzbsz().zzbtr().log("Discarding data. Failed to send event to service");
                    return;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        zzm2.zza(eventParcel, zzad.this.zzbsr().zzlw(zzad.this.zzbsz().zzbtz()));
                    } else {
                        zzm2.zza(eventParcel, string, zzad.this.zzbsz().zzbtz());
                    }
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsz().zzbtr().zzj("Failed to send event to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final UserAttributeParcel userAttributeParcel) {
        this.zzwu();
        this.zzzg();
        this.zzn(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.anm;
                if (zzm2 == null) {
                    zzad.this.zzbsz().zzbtr().log("Discarding data. Failed to set user attribute");
                    return;
                }
                try {
                    zzm2.zza(userAttributeParcel, zzad.this.zzbsr().zzlw(zzad.this.zzbsz().zzbtz()));
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsz().zzbtr().zzj("Failed to send attribute to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<UserAttributeParcel>> atomicReference, final boolean bl) {
        this.zzwu();
        this.zzzg();
        this.zzn(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzm zzm2 = zzad.this.anm;
                        if (zzm2 == null) {
                            zzad.this.zzbsz().zzbtr().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzm2.zza(zzad.this.zzbsr().zzlw(null), bl));
                        zzad.this.zzzt();
                    }
                    catch (RemoteException remoteException) {
                        zzad.this.zzbsz().zzbtr().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzbvk() {
        this.zzwu();
        this.zzzg();
        this.zzn(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.anm;
                if (zzm2 == null) {
                    zzad.this.zzbsz().zzbtr().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzm2.zza(zzad.this.zzbsr().zzlw(zzad.this.zzbsz().zzbtz()));
                    zzad.this.zzzt();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsz().zzbtr().zzj("Failed to send app launch to AppMeasurementService", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzzt() {
        this.zzwu();
        this.anp.start();
        if (!this.aja.zzbuu()) {
            this.ano.zzv(this.zzbtb().zzabx());
        }
    }

    @WorkerThread
    void zzaai() {
        this.zzwu();
        this.zzzg();
        if (this.isConnected()) {
            return;
        }
        if (this.ann == null) {
            this.ann = this.zzbta().zzbuf();
            if (this.ann == null) {
                this.zzbsz().zzbty().log("State of service unknown");
                this.ann = this.zzbvp();
                this.zzbta().zzca(this.ann);
            }
        }
        if (this.ann.booleanValue()) {
            this.zzbsz().zzbty().log("Using measurement service");
            this.anl.zzbvs();
        } else {
            if (!this.aja.zzbuu() && this.zzbvo()) {
                this.zzbsz().zzbty().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.anl.zzx(intent);
                return;
            }
            if (this.zzbtb().zzabd()) {
                this.zzbsz().zzbty().log("Using direct local measurement implementation");
                this.zza(new zzy(this.aja, true));
            } else {
                this.zzbsz().zzbtr().log("Not in main process. Unable to use local measurement implementation. Please register the AppMeasurementService service in the app manifest");
            }
        }
    }

    private boolean zzbvo() {
        Intent intent;
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzbvp() {
        this.zzwu();
        this.zzzg();
        if (this.zzbtb().zzabc()) {
            return true;
        }
        this.zzbsz().zzbty().log("Checking service availability");
        int n = zzc.zzand().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzbsz().zzbty().log("Service available");
                return true;
            }
            case 1: {
                this.zzbsz().zzbty().log("Service missing");
                return false;
            }
            case 18: {
                this.zzbsz().zzbtt().log("Service updating");
                return true;
            }
            case 2: {
                this.zzbsz().zzbtx().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzbsz().zzbtt().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzbsz().zzbtt().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzm zzm2) {
        this.zzwu();
        zzab.zzaa((Object)zzm2);
        this.anm = zzm2;
        this.zzzt();
        this.zzbvr();
    }

    @WorkerThread
    public void disconnect() {
        this.zzwu();
        this.zzzg();
        try {
            zzb zzb2 = zzb.zzaut();
            zzb2.zza(this.getContext(), (ServiceConnection)this.anl);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.anm = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzwu();
        if (this.anm != null) {
            this.anm = null;
            this.zzbsz().zzbty().zzj("Disconnected from device MeasurementService", componentName);
            this.zzbvq();
        }
    }

    @WorkerThread
    private void zzzu() {
        this.zzwu();
        if (!this.isConnected()) {
            return;
        }
        this.zzbsz().zzbty().log("Inactivity, disconnecting from AppMeasurementService");
        this.disconnect();
    }

    @WorkerThread
    private void zzbvq() {
        this.zzwu();
        this.zzaai();
    }

    @WorkerThread
    private void zzn(Runnable runnable) throws IllegalStateException {
        this.zzwu();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.anq.size() >= this.zzbtb().zzbsd()) {
                this.zzbsz().zzbtr().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.anq.add(runnable);
            if (!this.aja.zzbuu()) {
                this.anr.zzv(60000L);
            }
            this.zzaai();
        }
    }

    @WorkerThread
    private void zzbvr() {
        this.zzwu();
        this.zzbsz().zzbty().zzj("Processing queued up service tasks", this.anq.size());
        for (Runnable runnable : this.anq) {
            this.zzbsy().zzl(runnable);
        }
        this.anq.clear();
        this.anr.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zzd.zzb,
    zzd.zzc {
        private volatile boolean anu;
        private volatile zzo anv;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzx(Intent intent) {
            zzad.this.zzwu();
            Context context = zzad.this.getContext();
            zzb zzb2 = zzb.zzaut();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.anu) {
                    zzad.this.zzbsz().zzbty().log("Connection attempt already in progress");
                    return;
                }
                this.anu = true;
                zzb2.zza(context, intent, (ServiceConnection)zzad.this.anl, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzab.zzhj((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.anu = false;
                    zzad.this.zzbsz().zzbtr().log("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzjb(iBinder);
                        zzad.this.zzbsz().zzbty().log("Bound to IMeasurementService interface");
                    } else {
                        zzad.this.zzbsz().zzbtr().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbsz().zzbtr().log("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    this.anu = false;
                    try {
                        zzb.zzaut().zza(zzad.this.getContext(), (ServiceConnection)zzad.this.anl);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzad.this.zzbsy().zzl(new Runnable((zzm)object){
                        final /* synthetic */ zzm anw;
                        {
                            this.anw = zzm2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.anu = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzbsz().zzbty().log("Connected to service");
                                    zzad.this.zza(this.anw);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            zzab.zzhj((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzad.this.zzbsz().zzbtx().log("Service disconnected");
            zzad.this.zzbsy().zzl(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzbvs() {
            zzad.this.zzwu();
            Context context = zzad.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.anu) {
                    zzad.this.zzbsz().zzbty().log("Connection attempt already in progress");
                    return;
                }
                if (this.anv != null) {
                    zzad.this.zzbsz().zzbty().log("Already awaiting connection attempt");
                    return;
                }
                this.anv = new zzo(context, Looper.getMainLooper(), this, this);
                zzad.this.zzbsz().zzbty().log("Connecting to remote service");
                this.anu = true;
                this.anv.zzart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            zzab.zzhj((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzm zzm2 = (zzm)this.anv.zzarw();
                    this.anv = null;
                    zzad.this.zzbsy().zzl(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.anu = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzbsz().zzbtx().log("Connected to remote service");
                                    zzad.this.zza(zzm2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.anv = null;
                    this.anu = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            zzab.zzhj((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzad.this.zzbsz().zzbtx().log("Service connection suspended");
            zzad.this.zzbsy().zzl(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(new ComponentName(zzad.this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzab.zzhj((String)"MeasurementServiceConnection.onConnectionFailed");
            zzp zzp2 = zzad.this.aja.zzbul();
            if (zzp2 != null) {
                zzp2.zzbtt().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.anu = false;
                this.anv = null;
            }
        }
    }
}

