/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzx;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

public class zzw
extends zzaa {
    private zzd alW;
    private zzd alX;
    private final PriorityBlockingQueue<FutureTask<?>> alY;
    private final BlockingQueue<FutureTask<?>> alZ;
    private final Thread.UncaughtExceptionHandler ama;
    private final Thread.UncaughtExceptionHandler amb;
    private final Object amc = new Object();
    private final Semaphore amd = new Semaphore(2);
    private volatile boolean ame;
    private static final AtomicLong amf = new AtomicLong(Long.MIN_VALUE);

    zzw(zzx zzx2) {
        super(zzx2);
        this.alY = new PriorityBlockingQueue();
        this.alZ = new LinkedBlockingQueue();
        this.ama = new zzb("Thread death: Uncaught exception on worker thread");
        this.amb = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzwv() {
    }

    @Override
    public void zzwu() {
        if (Thread.currentThread() != this.alW) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzbso() {
        if (Thread.currentThread() != this.alX) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzzg();
        zzab.zzaa(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.alW) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzzg();
        zzab.zzaa(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.alW) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzl(Runnable runnable) throws IllegalStateException {
        this.zzzg();
        zzab.zzaa((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.amc;
        synchronized (object) {
            this.alY.add(zzc2);
            if (this.alW == null) {
                this.alW = new zzd("Measurement Worker", this.alY);
                this.alW.setUncaughtExceptionHandler(this.ama);
                this.alW.start();
            } else {
                this.alW.zznm();
            }
        }
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzzg();
        zzab.zzaa((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.amc;
        synchronized (object) {
            this.alZ.add(futureTask);
            if (this.alX == null) {
                this.alX = new zzd("Measurement Network", this.alZ);
                this.alX.setUncaughtExceptionHandler(this.amb);
                this.alX.start();
            } else {
                this.alX.zznm();
            }
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String amg;

        public zzb(String string) {
            zzab.zzaa((Object)string);
            this.amg = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzw.this.zzbsz().zzbtr().zzj(this.amg, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long ami;
        private final boolean amj;
        private final String amg;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzab.zzaa((Object)string);
            this.ami = amf.getAndIncrement();
            this.amg = string;
            this.amj = bl;
            if (this.ami == Long.MAX_VALUE) {
                zzw.this.zzbsz().zzbtr().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzab.zzaa((Object)string);
            this.ami = amf.getAndIncrement();
            this.amg = string;
            this.amj = bl;
            if (this.ami == Long.MAX_VALUE) {
                zzw.this.zzbsz().zzbtr().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzw.this.zzbsz().zzbtr().zzj(this.amg, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(zzc zzc2) {
            if (this.amj != zzc2.amj) {
                return this.amj ? -1 : 1;
            }
            if (this.ami < zzc2.ami) {
                return -1;
            }
            if (this.ami > zzc2.ami) {
                return 1;
            }
            zzw.this.zzbsz().zzbts().zzj("Two tasks share the same index. index", this.ami);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object amk;
        private final BlockingQueue<FutureTask<?>> aml;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzab.zzaa((Object)string);
            zzab.zzaa(blockingQueue);
            this.amk = new Object();
            this.aml = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzw.this.amd.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.aml.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.amk;
                    synchronized (object) {
                        if (this.aml.peek() == null && !zzw.this.ame) {
                            try {
                                this.amk.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzw.this.amc;
                    synchronized (object) {
                        if (this.aml.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzw.this.amc;
                synchronized (object) {
                    zzw.this.amd.release();
                    zzw.this.amc.notifyAll();
                    if (this == zzw.this.alW) {
                        zzw.this.alW = null;
                    } else if (this == zzw.this.alX) {
                        zzw.this.alX = null;
                    } else {
                        zzw.this.zzbsz().zzbtr().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zznm() {
            Object object = this.amk;
            synchronized (object) {
                this.amk.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzw.this.zzbsz().zzbtt().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

