/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzaov;
import com.google.android.gms.internal.zzuo;
import com.google.android.gms.internal.zzup;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class zzx {
    private static volatile zzx amm;
    private final Context mContext;
    private final zzd amn;
    private final zzt amo;
    private final zzp amp;
    private final zzw amq;
    private final zzaf amr;
    private final zzv ams;
    private final AppMeasurement amt;
    private final zzal amu;
    private final zze amv;
    private final zzq amw;
    private final com.google.android.gms.common.util.zze zzaoa;
    private final zzad amx;
    private final zzg amy;
    private final zzac amz;
    private final zzn amA;
    private final zzr amB;
    private final zzai amC;
    private final zzc amD;
    public final FirebaseAnalytics amE;
    private final boolean zzcwt;
    private boolean amF;
    private Boolean amG;
    private FileLock amH;
    private FileChannel amI;
    private List<Long> amJ;
    private int amK;
    private int amL;

    zzx(zzab zzab2) {
        com.google.android.gms.common.internal.zzab.zzaa((Object)zzab2);
        this.mContext = zzab2.mContext;
        this.zzaoa = zzab2.zzl(this);
        this.amn = zzab2.zza(this);
        zzt zzt2 = zzab2.zzb(this);
        zzt2.initialize();
        this.amo = zzt2;
        zzp zzp2 = zzab2.zzc(this);
        zzp2.initialize();
        this.amp = zzp2;
        this.zzbsz().zzbtw().zzj("App measurement is starting up, version", this.zzbtb().zzbqv());
        this.zzbsz().zzbtw().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        this.zzbsz().zzbtx().log("Debug logging enabled");
        this.zzbsz().zzbtx().zzj("AppMeasurement singleton hash", System.identityHashCode(this));
        this.amu = zzab2.zzi(this);
        zzg zzg2 = zzab2.zzn(this);
        zzg2.initialize();
        this.amy = zzg2;
        zzn zzn2 = zzab2.zzo(this);
        zzn2.initialize();
        this.amA = zzn2;
        zze zze2 = zzab2.zzj(this);
        zze2.initialize();
        this.amv = zze2;
        zzc zzc2 = zzab2.zzr(this);
        zzc2.initialize();
        this.amD = zzc2;
        zzq zzq2 = zzab2.zzk(this);
        zzq2.initialize();
        this.amw = zzq2;
        zzad zzad2 = zzab2.zzm(this);
        zzad2.initialize();
        this.amx = zzad2;
        zzac zzac2 = zzab2.zzh(this);
        zzac2.initialize();
        this.amz = zzac2;
        zzai zzai2 = zzab2.zzq(this);
        zzai2.initialize();
        this.amC = zzai2;
        this.amB = zzab2.zzp(this);
        this.amt = zzab2.zzg(this);
        this.amE = new FirebaseAnalytics(this);
        zzaf zzaf2 = zzab2.zze(this);
        zzaf2.initialize();
        this.amr = zzaf2;
        zzv zzv2 = zzab2.zzf(this);
        zzv2.initialize();
        this.ams = zzv2;
        zzw zzw2 = zzab2.zzd(this);
        zzw2.initialize();
        this.amq = zzw2;
        if (this.amK != this.amL) {
            this.zzbsz().zzbtr().zze("Not all components initialized", this.amK, this.amL);
        }
        this.zzcwt = true;
        if (!this.amn.zzabc() && !this.zzbuu()) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                if (Build.VERSION.SDK_INT >= 14) {
                    this.zzbsq().zzbvj();
                } else {
                    this.zzbsz().zzbtx().log("Not tracking deep linking pre-ICS");
                }
            } else {
                this.zzbsz().zzbtt().log("Application context is not an Application");
            }
        }
        this.amq.zzl(new Runnable(){

            @Override
            public void run() {
                zzx.this.start();
            }
        });
    }

    void zzzg() {
        if (!this.zzcwt) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzbuk() {
        this.zzzg();
        this.zzwu();
        if (this.amG == null) {
            this.amG = this.zzbsv().zzep("android.permission.INTERNET") && this.zzbsv().zzep("android.permission.ACCESS_NETWORK_STATE") && zzu.zzav(this.getContext()) && zzae.zzaw(this.getContext());
            if (this.amG.booleanValue() && !this.zzbtb().zzabc()) {
                this.amG = this.zzbsv().zzmr(this.zzbsr().zzbqo());
            }
        }
        return this.amG;
    }

    @WorkerThread
    protected void start() {
        this.zzwu();
        if (this.zzbuu() && (!this.amq.isInitialized() || this.amq.zzbvh())) {
            this.zzbsz().zzbtr().log("Scheduler shutting down before Scion.start() called");
            return;
        }
        this.zzbsu().zzbtd();
        if (!this.zzbuk()) {
            if (this.isEnabled()) {
                if (!this.zzbsv().zzep("android.permission.INTERNET")) {
                    this.zzbsz().zzbtr().log("App is missing INTERNET permission");
                }
                if (!this.zzbsv().zzep("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzbsz().zzbtr().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzu.zzav(this.getContext())) {
                    this.zzbsz().zzbtr().log("AppMeasurementReceiver not registered/enabled");
                }
                if (!zzae.zzaw(this.getContext())) {
                    this.zzbsz().zzbtr().log("AppMeasurementService not registered/enabled");
                }
                this.zzbsz().zzbtr().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!this.zzbtb().zzabc() && !TextUtils.isEmpty((CharSequence)this.zzbsr().zzbqo())) {
                String string = this.zzbta().zzbue();
                if (string == null) {
                    this.zzbta().zzma(this.zzbsr().zzbqo());
                } else if (!string.equals(this.zzbsr().zzbqo())) {
                    this.zzbsz().zzbtw().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzbta().zzbug();
                    this.amx.disconnect();
                    this.amx.zzaai();
                    this.zzbta().zzma(this.zzbsr().zzbqo());
                }
            }
            if (!(this.zzbtb().zzabc() || this.zzbuu() || TextUtils.isEmpty((CharSequence)this.zzbsr().zzbqo()))) {
                this.zzbsq().zzbvk();
            }
        }
        this.zzbva();
    }

    public zzd zzbtb() {
        return this.amn;
    }

    public zzt zzbta() {
        this.zza((zzz)this.amo);
        return this.amo;
    }

    public zzp zzbsz() {
        this.zza(this.amp);
        return this.amp;
    }

    public zzp zzbul() {
        return this.amp != null && this.amp.isInitialized() ? this.amp : null;
    }

    public zzw zzbsy() {
        this.zza(this.amq);
        return this.amq;
    }

    public zzaf zzbsx() {
        this.zza(this.amr);
        return this.amr;
    }

    public zzv zzbsw() {
        this.zza(this.ams);
        return this.ams;
    }

    zzw zzbum() {
        return this.amq;
    }

    public zzac zzbsq() {
        this.zza(this.amz);
        return this.amz;
    }

    public AppMeasurement zzbun() {
        return this.amt;
    }

    public zzal zzbsv() {
        this.zza(this.amu);
        return this.amu;
    }

    public zze zzbsu() {
        this.zza(this.amv);
        return this.amv;
    }

    public zzq zzbuo() {
        this.zza(this.amw);
        return this.amw;
    }

    public Context getContext() {
        return this.mContext;
    }

    public com.google.android.gms.common.util.zze zzyw() {
        return this.zzaoa;
    }

    public zzad zzbst() {
        this.zza(this.amx);
        return this.amx;
    }

    public zzg zzbss() {
        this.zza(this.amy);
        return this.amy;
    }

    public zzn zzbsr() {
        this.zza(this.amA);
        return this.amA;
    }

    public zzr zzbup() {
        if (this.amB == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.amB;
    }

    public zzai zzbuq() {
        this.zza(this.amC);
        return this.amC;
    }

    public zzc zzbsp() {
        this.zza(this.amD);
        return this.amD;
    }

    @WorkerThread
    public void zzwu() {
        this.zzbsy().zzwu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzx zzdo(Context context) {
        com.google.android.gms.common.internal.zzab.zzaa((Object)context);
        com.google.android.gms.common.internal.zzab.zzaa((Object)context.getApplicationContext());
        if (amm != null) return amm;
        Class<zzx> clazz = zzx.class;
        synchronized (zzx.class) {
            if (amm != null) return amm;
            zzab zzab2 = null;
            boolean bl = false;
            zzab2 = new zzab(context);
            amm = zzab2.zzbvi();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return amm;
        }
    }

    FileChannel zzbur() {
        return this.amI;
    }

    private void zza(zzaa zzaa2) {
        if (zzaa2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzaa2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzz zzz2) {
        if (zzz2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzbus() {
        this.zzwu();
        this.zzzg();
        if (this.zzbve() && this.zzbut()) {
            int n = this.zza(this.zzbur());
            int n2 = this.zzbsr().zzbtp();
            this.zzu(n, n2);
        }
    }

    @WorkerThread
    boolean zzbut() {
        this.zzwu();
        String string = this.amv.zzaab();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.amI = new RandomAccessFile(file2, "rw").getChannel();
            this.amH = this.amI.tryLock();
            if (this.amH != null) {
                this.zzbsz().zzbty().log("Storage concurrent access okay");
                return true;
            }
            this.zzbsz().zzbtr().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzbsz().zzbtr().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzbsz().zzbtr().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzu(int n, int n2) {
        this.zzwu();
        if (n > n2) {
            this.zzbsz().zzbtr().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzbur())) {
                this.zzbsz().zzbty().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzbsz().zzbtr().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzwu();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbsz().zzbtr().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n3 = fileChannel.read(byteBuffer);
            if (n3 != 4) {
                this.zzbsz().zzbtt().zzj("Unexpected data length or empty data in channel. Bytes read", n3);
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzbsz().zzbtr().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzwu();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbsz().zzbtr().log("Bad chanel to read from");
            return false;
        }
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzbsz().zzbtr().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzbsz().zzbtr().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    protected boolean zzbuu() {
        return false;
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzwu();
        this.zzzg();
        if (this.zzbtb().zzbrz()) {
            return false;
        }
        Boolean bl = this.zzbtb().zzbsa();
        boolean bl2 = bl != null ? bl : !this.zzbtb().zzaql();
        return this.zzbta().zzcb(bl2);
    }

    void zzc(AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzhs((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    @WorkerThread
    void zzb(EventParcel eventParcel, String string) {
        Object object;
        com.google.android.gms.measurement.internal.zza zza2;
        block4: {
            zza2 = this.zzbsu().zzlo(string);
            if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzxc())) {
                this.zzbsz().zzbtx().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = this.getContext().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
                if (zza2.zzxc() != null && !zza2.zzxc().equals(object)) {
                    this.zzbsz().zzbtt().zzj("App version does not match; dropping event", string);
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(eventParcel.name)) break block4;
                this.zzbsz().zzbtt().zzj("Could not find package", string);
            }
        }
        object = new AppMetadata(string, zza2.zzbqo(), zza2.zzxc(), zza2.zzbqt(), zza2.zzbqu(), zza2.zzbqv(), zza2.zzbqw(), null, zza2.zzbqx(), false, zza2.zzbqq());
        this.zzb(eventParcel, (AppMetadata)((Object)object));
    }

    long zzbuv() {
        long l = this.zzyw().currentTimeMillis() + this.zzbta().zzbuc();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        long l = System.nanoTime();
        this.zzwu();
        this.zzzg();
        String string = appMetadata.packageName;
        com.google.android.gms.common.internal.zzab.zzhs((String)string);
        if (TextUtils.isEmpty((CharSequence)appMetadata.ajz)) {
            return;
        }
        if (!appMetadata.ajE) {
            this.zze(appMetadata);
            return;
        }
        if (this.zzbsw().zzax(string, eventParcel.name)) {
            this.zzbsz().zzbtt().zzj("Dropping blacklisted event", eventParcel.name);
            this.zzbsv().zze(11, "_ev", eventParcel.name);
            return;
        }
        if (this.zzbsz().zzaz(2)) {
            this.zzbsz().zzbty().zzj("Logging event", (Object)eventParcel);
        }
        this.zzbsu().beginTransaction();
        try {
            zzi zzi2;
            Bundle bundle = eventParcel.akf.zzbto();
            this.zze(appMetadata);
            if ("_iap".equals(eventParcel.name) || "ecommerce_purchase".equals(eventParcel.name)) {
                String string2 = bundle.getString("currency");
                long l2 = 0L;
                if ("ecommerce_purchase".equals(eventParcel.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzbsz().zzbtt().zzj("Data lost. Currency value is too big", d);
                        this.zzbsu().setTransactionSuccessful();
                        return;
                    }
                    l2 = Math.round(d);
                } else {
                    l2 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzak zzak2 = this.zzbsu().zzas(string, string5);
                    if (zzak2 == null || !(zzak2.zzcnr instanceof Long)) {
                        this.zzbsu().zzy(string, this.zzbtb().zzli(string) - 1);
                        zzak2 = new zzak(string, string5, this.zzyw().currentTimeMillis(), l2);
                    } else {
                        long l3 = (Long)zzak2.zzcnr;
                        zzak2 = new zzak(string, string5, this.zzyw().currentTimeMillis(), l3 + l2);
                    }
                    if (!this.zzbsu().zza(zzak2)) {
                        this.zzbsz().zzbtr().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzcnr);
                        this.zzbsv().zze(9, null, null);
                    }
                }
            }
            boolean bl = zzal.zzmk(eventParcel.name);
            boolean bl2 = zzal.zzam(bundle);
            boolean bl3 = "_err".equals(eventParcel.name);
            zze.zza zza2 = this.zzbsu().zza(this.zzbuv(), string, bl, false, bl3);
            long l4 = zza2.ajN - this.zzbtb().zzbrr();
            if (l4 > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzbsz().zzbtr().zzj("Data loss. Too many events logged. count", zza2.ajN);
                }
                this.zzbsv().zze(16, "_ev", eventParcel.name);
                this.zzbsu().setTransactionSuccessful();
                return;
            }
            if (bl && (l4 = zza2.ajM - this.zzbtb().zzbrs()) > 0L) {
                if (l4 % 1000L == 1L) {
                    this.zzbsz().zzbtr().zzj("Data loss. Too many public events logged. count", zza2.ajM);
                }
                this.zzbsv().zze(16, "_ev", eventParcel.name);
                this.zzbsu().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l4 = zza2.ajP - this.zzbtb().zzbrt()) > 0L) {
                if (l4 == 1L) {
                    this.zzbsz().zzbtr().zzj("Too many error events logged. count", zza2.ajP);
                }
                this.zzbsu().setTransactionSuccessful();
                return;
            }
            this.zzbsv().zza(bundle, "_o", eventParcel.akg);
            long l5 = this.zzbsu().zzlp(string);
            if (l5 > 0L) {
                this.zzbsz().zzbtt().zzj("Data lost. Too many events stored on disk, deleted", l5);
            }
            zzh zzh2 = new zzh(this, eventParcel.akg, string, eventParcel.name, eventParcel.akh, 0L, bundle);
            zzi zzi3 = this.zzbsu().zzaq(string, zzh2.mName);
            if (zzi3 == null) {
                long l6 = this.zzbsu().zzlv(string);
                if (l6 >= (long)this.zzbtb().zzbrq()) {
                    this.zzbsz().zzbtr().zze("Too many event names used, ignoring event. name, supported count", zzh2.mName, this.zzbtb().zzbrq());
                    this.zzbsv().zze(8, null, null);
                    return;
                }
                zzi2 = new zzi(string, zzh2.mName, 0L, 0L, zzh2.pz);
            } else {
                zzh2 = zzh2.zza(this, zzi3.akb);
                zzi2 = zzi3.zzbi(zzh2.pz);
            }
            this.zzbsu().zza(zzi2);
            this.zza(zzh2, appMetadata);
            this.zzbsu().setTransactionSuccessful();
            if (this.zzbsz().zzaz(2)) {
                this.zzbsz().zzbty().zzj("Event recorded", zzh2);
            }
        }
        finally {
            this.zzbsu().endTransaction();
        }
        this.zzbva();
        this.zzbsz().zzbty().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull EventParcel eventParcel, @Size(min=1L) String string) {
        Object object;
        zzaov zzaov2;
        Object object2;
        this.zzzg();
        this.zzwu();
        this.zzbuw();
        com.google.android.gms.common.internal.zzab.zzaa((Object)((Object)eventParcel));
        com.google.android.gms.common.internal.zzab.zzhs((String)string);
        zzup.zzd zzd2 = new zzup.zzd();
        this.zzbsu().beginTransaction();
        try {
            zzi zzi2;
            long l;
            Object object3;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbsu().zzlo(string);
            if (zza2 == null) {
                this.zzbsz().zzbtx().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zza2.zzbqx()) {
                this.zzbsz().zzbtx().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzup.zze();
            zzd2.aoP = new zzup.zze[]{object2};
            object2.aoR = 1;
            object2.aoZ = "android";
            object2.zzck = zza2.zzsi();
            object2.ajA = zza2.zzbqu();
            object2.abU = zza2.zzxc();
            object2.apm = (int)zza2.zzbqt();
            object2.apd = zza2.zzbqv();
            object2.ajz = zza2.zzbqo();
            object2.api = zza2.zzbqw();
            zzaov2 = this.zzbta().zzly(zza2.zzsi());
            if (zzaov2 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)zzaov2.first))) {
                object2.apf = (String)zzaov2.first;
                object2.apg = (Boolean)zzaov2.second;
            }
            object2.apa = this.zzbss().zzth();
            object2.zzct = this.zzbss().zzbtk();
            object2.apc = (int)this.zzbss().zzbtl();
            object2.apb = this.zzbss().zzbtm();
            object2.aph = zza2.zzawj();
            object2.ajH = zza2.zzbqq();
            object = this.zzbsu().zzln(zza2.zzsi());
            object2.aoT = new zzup.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzup.zzg();
                object2.aoT[i] = object3;
                ((zzup.zzg)object3).name = object.get((int)i).mName;
                ((zzup.zzg)object3).apt = object.get((int)i).anU;
                this.zzbsv().zza((zzup.zzg)object3, object.get((int)i).zzcnr);
            }
            Bundle bundle = eventParcel.akf.zzbto();
            if ("_iap".equals(eventParcel.name)) {
                bundle.putLong("_c", 1L);
            }
            bundle.putString("_o", eventParcel.akg);
            object3 = this.zzbsu().zzaq(string, eventParcel.name);
            if (object3 == null) {
                l = 0L;
                zzi2 = new zzi(string, eventParcel.name, 1L, 0L, eventParcel.akh);
                this.zzbsu().zza(zzi2);
            } else {
                l = ((zzi)object3).akb;
                zzi2 = ((zzi)object3).zzbi(eventParcel.akh);
                zzi2 = zzi2.zzbtn();
                this.zzbsu().zza(zzi2);
            }
            zzh zzh2 = new zzh(this, eventParcel.akg, string, eventParcel.name, eventParcel.akh, l, bundle);
            zzup.zzb zzb2 = new zzup.zzb();
            object2.aoS = new zzup.zzb[]{zzb2};
            zzb2.aoL = zzh2.pz;
            zzb2.name = zzh2.mName;
            zzb2.aoM = zzh2.ajX;
            zzb2.aoK = new zzup.zzc[zzh2.ajY.size()];
            int n = 0;
            for (String string2 : zzh2.ajY) {
                zzup.zzc zzc2 = new zzup.zzc();
                zzb2.aoK[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzh2.ajY.get(string2);
                this.zzbsv().zza(zzc2, object4);
            }
            object2.apl = this.zza(zza2.zzsi(), object2.aoT, object2.aoS);
            object2.aoV = zzb2.aoL;
            object2.aoW = zzb2.aoL;
            long l2 = zza2.zzbqs();
            object2.aoY = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zza2.zzbqr();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.aoX = l3 != 0L ? Long.valueOf(l3) : null;
            zza2.zzbrb();
            object2.apj = (int)zza2.zzbqy();
            object2.ape = this.zzbtb().zzbqv();
            object2.aoU = this.zzyw().currentTimeMillis();
            object2.apk = Boolean.TRUE;
            zza2.zzat(object2.aoV);
            zza2.zzau(object2.aoW);
            this.zzbsu().zza(zza2);
            this.zzbsu().setTransactionSuccessful();
        }
        finally {
            this.zzbsu().endTransaction();
        }
        try {
            int n = zzd2.ao();
            object2 = new byte[n];
            zzaov2 = zzaov.zzba((byte[])object2);
            zzd2.zza(zzaov2);
            zzaov2.ab();
            object = this.zzbsv().zzj((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzbsz().zzbtr().zzj("Data loss. Failed to bundle and serialize", iOException);
            return null;
        }
    }

    void zza(zzh zzh2, AppMetadata appMetadata) {
        Object object;
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzaa((Object)zzh2);
        com.google.android.gms.common.internal.zzab.zzaa((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzab.zzhs((String)zzh2.zzcjj);
        com.google.android.gms.common.internal.zzab.zzbn((boolean)zzh2.zzcjj.equals(appMetadata.packageName));
        zzup.zze zze2 = new zzup.zze();
        zze2.aoR = 1;
        zze2.aoZ = "android";
        zze2.zzck = appMetadata.packageName;
        zze2.ajA = appMetadata.ajA;
        zze2.abU = appMetadata.abU;
        zze2.apm = (int)appMetadata.ajG;
        zze2.apd = appMetadata.ajB;
        zze2.ajz = appMetadata.ajz;
        zze2.api = appMetadata.ajC == 0L ? null : Long.valueOf(appMetadata.ajC);
        Pair<String, Boolean> pair = this.zzbta().zzly(appMetadata.packageName);
        if (pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.apf = (String)pair.first;
            zze2.apg = (Boolean)pair.second;
        } else if (!this.zzbss().zzdn(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzbsz().zzbtt().log("null secure ID");
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzbsz().zzbtt().log("empty secure ID");
            }
            zze2.app = object;
        }
        zze2.apa = this.zzbss().zzth();
        zze2.zzct = this.zzbss().zzbtk();
        zze2.apc = (int)this.zzbss().zzbtl();
        zze2.apb = this.zzbss().zzbtm();
        zze2.ape = null;
        zze2.aoU = null;
        zze2.aoV = null;
        zze2.aoW = null;
        object = this.zzbsu().zzlo(appMetadata.packageName);
        if (object == null) {
            object = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            ((com.google.android.gms.measurement.internal.zza)object).zzkz(this.zzbta().zzbub());
            ((com.google.android.gms.measurement.internal.zza)object).zzlc(appMetadata.ajH);
            ((com.google.android.gms.measurement.internal.zza)object).zzla(appMetadata.ajz);
            ((com.google.android.gms.measurement.internal.zza)object).zzlb(this.zzbta().zzlz(appMetadata.packageName));
            ((com.google.android.gms.measurement.internal.zza)object).zzay(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzat(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzau(0L);
            ((com.google.android.gms.measurement.internal.zza)object).setAppVersion(appMetadata.abU);
            ((com.google.android.gms.measurement.internal.zza)object).zzav(appMetadata.ajG);
            ((com.google.android.gms.measurement.internal.zza)object).zzld(appMetadata.ajA);
            ((com.google.android.gms.measurement.internal.zza)object).zzaw(appMetadata.ajB);
            ((com.google.android.gms.measurement.internal.zza)object).zzax(appMetadata.ajC);
            ((com.google.android.gms.measurement.internal.zza)object).setMeasurementEnabled(appMetadata.ajE);
            this.zzbsu().zza((com.google.android.gms.measurement.internal.zza)object);
        }
        zze2.aph = ((com.google.android.gms.measurement.internal.zza)object).zzawj();
        zze2.ajH = ((com.google.android.gms.measurement.internal.zza)object).zzbqq();
        List<zzak> list = this.zzbsu().zzln(appMetadata.packageName);
        zze2.aoT = new zzup.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzup.zzg zzg2;
            zze2.aoT[i] = zzg2 = new zzup.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.apt = list.get((int)i).anU;
            this.zzbsv().zza(zzg2, list.get((int)i).zzcnr);
        }
        long l = 0L;
        try {
            l = this.zzbsu().zzb(zze2);
        }
        catch (IOException iOException) {
            this.zzbsz().zzbtr().zzj("Data loss. Failed to insert raw event metadata", iOException);
            return;
        }
        this.zzbsu().zza(zzh2, l);
    }

    void zzyv() {
        if (this.zzbtb().zzabc()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    void zzbuw() {
        if (!this.zzbtb().zzabc()) {
            throw new IllegalStateException("Unexpected call on client side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        if (TextUtils.isEmpty((CharSequence)appMetadata.ajz)) {
            return;
        }
        if (!appMetadata.ajE) {
            this.zze(appMetadata);
            return;
        }
        int n = this.zzbsv().zzmo(userAttributeParcel.name);
        if (n != 0) {
            String string = this.zzbsv().zza(userAttributeParcel.name, this.zzbtb().zzbrk(), true);
            this.zzbsv().zze(n, "_ev", string);
            return;
        }
        n = this.zzbsv().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (n != 0) {
            String string = this.zzbsv().zza(userAttributeParcel.name, this.zzbtb().zzbrk(), true);
            this.zzbsv().zze(n, "_ev", string);
            return;
        }
        Object object = this.zzbsv().zzn(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzak zzak2 = new zzak(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.anQ, object);
        this.zzbsz().zzbtx().zze("Setting user property", zzak2.mName, object);
        this.zzbsu().beginTransaction();
        try {
            this.zze(appMetadata);
            boolean bl = this.zzbsu().zza(zzak2);
            this.zzbsu().setTransactionSuccessful();
            if (bl) {
                this.zzbsz().zzbtx().zze("User property set", zzak2.mName, zzak2.zzcnr);
            } else {
                this.zzbsz().zzbtr().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzcnr);
                this.zzbsv().zze(9, null, null);
            }
        }
        finally {
            this.zzbsu().endTransaction();
        }
    }

    @WorkerThread
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        if (TextUtils.isEmpty((CharSequence)appMetadata.ajz)) {
            return;
        }
        if (!appMetadata.ajE) {
            this.zze(appMetadata);
            return;
        }
        this.zzbsz().zzbtx().zzj("Removing user property", userAttributeParcel.name);
        this.zzbsu().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzbsu().zzar(appMetadata.packageName, userAttributeParcel.name);
            this.zzbsu().setTransactionSuccessful();
            this.zzbsz().zzbtx().zzj("User property removed", userAttributeParcel.name);
        }
        finally {
            this.zzbsu().endTransaction();
        }
    }

    @WorkerThread
    private boolean zzbux() {
        this.zzwu();
        return this.amJ != null;
    }

    private void zzad(List<Long> list) {
        com.google.android.gms.common.internal.zzab.zzbn((!list.isEmpty() ? 1 : 0) != 0);
        if (this.amJ != null) {
            this.zzbsz().zzbtr().log("Set uploading progress before finishing the previous upload");
        } else {
            this.amJ = new ArrayList<Long>(list);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void zzbuy() {
        String string;
        this.zzwu();
        this.zzzg();
        if (!this.zzbtb().zzabc()) {
            Boolean bl = this.zzbta().zzbuf();
            if (bl == null) {
                this.zzbsz().zzbtt().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzbsz().zzbtr().log("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzbux()) {
            this.zzbsz().zzbtt().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzbuo().zzadj()) {
            this.zzbsz().zzbtt().log("Network not connected, ignoring upload request");
            this.zzbva();
            return;
        }
        long l = this.zzyw().currentTimeMillis();
        this.zzbk(l - this.zzbtb().zzbsh());
        long l2 = this.zzbta().alv.get();
        if (l2 != 0L) {
            this.zzbsz().zzbtx().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzbsu().zzbtc()))) {
            int n = this.zzbtb().zzlk(string);
            int n2 = this.zzbtb().zzll(string);
            List<Pair<zzup.zze, Long>> list = this.zzbsu().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzup.zze, Long> object2 : list) {
                    zzup.zze zze2 = (zzup.zze)object2.first;
                    if (TextUtils.isEmpty((CharSequence)zze2.apf)) continue;
                    string2 = zze2.apf;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzup.zze zze3 = (zzup.zze)list.get((int)i).first;
                        if (TextUtils.isEmpty((CharSequence)zze3.apf) || zze3.apf.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                zzup.zzd zzd2 = new zzup.zzd();
                zzd2.aoP = new zzup.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < zzd2.aoP.length; ++i) {
                    zzd2.aoP[i] = (zzup.zze)list.get((int)i).first;
                    arrayList.add((Long)list.get((int)i).second);
                    zzd2.aoP[i].ape = this.zzbtb().zzbqv();
                    zzd2.aoP[i].aoU = l;
                    zzd2.aoP[i].apk = this.zzbtb().zzabc();
                }
                String string3 = null;
                if (this.zzbsz().zzaz(2)) {
                    string3 = zzal.zzb(zzd2);
                }
                byte[] byArray = this.zzbsv().zza(zzd2);
                String string4 = this.zzbtb().zzbsg();
                try {
                    URL uRL = new URL(string4);
                    this.zzad(arrayList);
                    this.zzbta().alw.set(l);
                    String string5 = "?";
                    if (zzd2.aoP.length > 0) {
                        string5 = zzd2.aoP[0].zzck;
                    }
                    this.zzbsz().zzbty().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzbuo().zza(string, uRL, byArray, null, new zzq.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzx.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzbsz().zzbtr().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        } else {
            String string6 = this.zzbsu().zzbh(l - this.zzbtb().zzbsh());
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                com.google.android.gms.measurement.internal.zza zza2 = this.zzbsu().zzlo(string6);
                if (zza2 != null) {
                    String string7 = this.zzbtb().zzap(zza2.zzbqo(), zza2.zzawj());
                    try {
                        void var11_23;
                        URL uRL = new URL(string7);
                        this.zzbsz().zzbty().zzj("Fetching remote configuration", zza2.zzsi());
                        zzuo.zzb zzb2 = this.zzbsw().zzmc(zza2.zzsi());
                        Object var11_21 = null;
                        String string8 = this.zzbsw().zzmd(zza2.zzsi());
                        if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string8)) {
                            ArrayMap arrayMap = new ArrayMap();
                            arrayMap.put("If-Modified-Since", string8);
                        }
                        this.zzbuo().zza(string6, uRL, (Map<String, String>)var11_23, new zzq.zza(){

                            @Override
                            public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                                zzx.this.zzb(string, n, throwable, byArray, map);
                            }
                        });
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzbsz().zzbtr().zzj("Failed to parse config URL. Not fetching", string7);
                    }
                }
                return;
            }
        }
    }

    boolean zzbk(long l) {
        return this.zzh(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzh(String string, long l) {
        this.zzbsu().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzbsu().zza(string, l, zza2);
            if (!zza2.isEmpty()) {
                int n;
                zzup.zze zze2 = zza2.amN;
                zze2.aoS = new zzup.zzb[zza2.zzala.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzala.size(); ++n) {
                    if (this.zzbsw().zzax(zza2.amN.zzck, zza2.zzala.get((int)n).name)) {
                        this.zzbsz().zzbtt().zzj("Dropping blacklisted raw event", zza2.zzala.get((int)n).name);
                        this.zzbsv().zze(11, "_ev", zza2.zzala.get((int)n).name);
                        continue;
                    }
                    if (this.zzbsw().zzay(zza2.amN.zzck, zza2.zzala.get((int)n).name)) {
                        boolean bl;
                        boolean bl2 = false;
                        if (zza2.zzala.get((int)n).aoK == null) {
                            zza2.zzala.get((int)n).aoK = new zzup.zzc[0];
                        }
                        for (zzup.zzc zzc2 : zza2.zzala.get((int)n).aoK) {
                            if (!"_c".equals(zzc2.name)) continue;
                            zzc2.aoO = 1L;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            this.zzbsz().zzbty().zzj("Marking event as conversion", zza2.zzala.get((int)n).name);
                            zzup.zzc[] zzcArray = Arrays.copyOf(zza2.zzala.get((int)n).aoK, zza2.zzala.get((int)n).aoK.length + 1);
                            zzup.zzc zzc3 = new zzup.zzc();
                            zzc3.name = "_c";
                            zzc3.aoO = 1L;
                            zzcArray[zzcArray.length - 1] = zzc3;
                            zza2.zzala.get((int)n).aoK = zzcArray;
                        }
                        if (bl = zzal.zzmk(zza2.zzala.get((int)n).name)) {
                            zze.zza zza3 = this.zzbsu().zza(this.zzbuv(), zza2.amN.zzck, false, bl, false);
                            long l2 = zza3.ajO - (long)this.zzbtb().zzlg(zza2.amN.zzck);
                            if (l2 > 0L) {
                                this.zzbsz().zzbtt().log("Too many conversions. Not logging as conversion.");
                                zzup.zzb zzb2 = zza2.zzala.get(n);
                                boolean bl3 = false;
                                zzup.zzc zzc4 = null;
                                for (zzup.zzc zzc5 : zza2.zzala.get((int)n).aoK) {
                                    if ("_c".equals(zzc5.name)) {
                                        zzc4 = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl3 = true;
                                }
                                if (bl3 && zzc4 != null) {
                                    zzup.zzc[] zzcArray = new zzup.zzc[zzb2.aoK.length - 1];
                                    int n3 = 0;
                                    for (zzup.zzc zzc6 : zzb2.aoK) {
                                        if (zzc6 == zzc4) continue;
                                        zzcArray[n3++] = zzc6;
                                    }
                                    zza2.zzala.get((int)n).aoK = zzcArray;
                                } else if (zzc4 != null) {
                                    zzc4.name = "_err";
                                    zzc4.aoO = 10L;
                                } else {
                                    this.zzbsz().zzbtr().log("Did not find conversion parameter. Error not tracked");
                                }
                            }
                        }
                    }
                    zze2.aoS[n2++] = zza2.zzala.get(n);
                }
                if (n2 < zza2.zzala.size()) {
                    zze2.aoS = Arrays.copyOf(zze2.aoS, n2);
                }
                zze2.apl = this.zza(zza2.amN.zzck, zza2.amN.aoT, zze2.aoS);
                zze2.aoV = zze2.aoS[0].aoL;
                zze2.aoW = zze2.aoS[0].aoL;
                for (n = 1; n < zze2.aoS.length; ++n) {
                    zzup.zzb zzb3 = zze2.aoS[n];
                    if (zzb3.aoL < zze2.aoV) {
                        zze2.aoV = zzb3.aoL;
                    }
                    if (zzb3.aoL <= zze2.aoW) continue;
                    zze2.aoW = zzb3.aoL;
                }
                String string2 = zza2.amN.zzck;
                com.google.android.gms.measurement.internal.zza zza4 = this.zzbsu().zzlo(string2);
                if (zza4 == null) {
                    this.zzbsz().zzbtr().log("Bundling raw events w/o app info");
                } else {
                    long l3 = zza4.zzbqs();
                    zze2.aoY = l3 != 0L ? Long.valueOf(l3) : null;
                    long l4 = zza4.zzbqr();
                    if (l4 == 0L) {
                        l4 = l3;
                    }
                    zze2.aoX = l4 != 0L ? Long.valueOf(l4) : null;
                    zza4.zzbrb();
                    zze2.apj = (int)zza4.zzbqy();
                    zza4.zzat(zze2.aoV);
                    zza4.zzau(zze2.aoW);
                    this.zzbsu().zza(zza4);
                }
                zze2.ajD = this.zzbsz().zzbtz();
                this.zzbsu().zza(zze2);
                this.zzbsu().zzac(zza2.amO);
                this.zzbsu().zzlu(string2);
                this.zzbsu().setTransactionSuccessful();
                boolean bl = true;
                return true;
            }
            this.zzbsu().setTransactionSuccessful();
            boolean bl = false;
            return false;
        }
        finally {
            this.zzbsu().endTransaction();
        }
    }

    private zzup.zza[] zza(String string, zzup.zzg[] zzgArray, zzup.zzb[] zzbArray) {
        com.google.android.gms.common.internal.zzab.zzhs((String)string);
        return this.zzbsp().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzhs((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzbsu().beginTransaction();
        try {
            boolean bl;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbsu().zzlo(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zza2 == null) {
                this.zzbsz().zzbtt().zzj("App does not exist in onConfigFetched", string);
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzbsw().zzmc(string) == null && !this.zzbsw().zzb(string, null, null) : !this.zzbsw().zzb(string, byArray, string2)) {
                    return;
                }
                zza2.zzaz(this.zzyw().currentTimeMillis());
                this.zzbsu().zza(zza2);
                if (n == 404) {
                    this.zzbsz().zzbtt().log("Config not found. Using empty config");
                } else {
                    this.zzbsz().zzbty().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzbuo().zzadj() && this.zzbuz()) {
                    this.zzbuy();
                } else {
                    this.zzbva();
                }
            } else {
                boolean bl3;
                zza2.zzba(this.zzyw().currentTimeMillis());
                this.zzbsu().zza(zza2);
                this.zzbsz().zzbty().zze("Fetching config failed. code, error", n, throwable);
                this.zzbsw().zzme(string);
                this.zzbta().alw.set(this.zzyw().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzbta().alx.set(this.zzyw().currentTimeMillis());
                }
                this.zzbva();
            }
            this.zzbsu().setTransactionSuccessful();
        }
        finally {
            this.zzbsu().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzwu();
        this.zzzg();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.amJ;
        this.amJ = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzbta().alv.set(this.zzyw().currentTimeMillis());
            this.zzbta().alw.set(0L);
            this.zzbva();
            this.zzbsz().zzbty().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzbsu().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzbsu().zzbg(l);
                }
                this.zzbsu().setTransactionSuccessful();
            }
            finally {
                this.zzbsu().endTransaction();
            }
            if (this.zzbuo().zzadj() && this.zzbuz()) {
                this.zzbuy();
            } else {
                this.zzbva();
            }
        } else {
            boolean bl;
            this.zzbsz().zzbty().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzbta().alw.set(this.zzyw().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzbta().alx.set(this.zzyw().currentTimeMillis());
            }
            this.zzbva();
        }
    }

    private boolean zzbuz() {
        this.zzwu();
        this.zzzg();
        boolean bl = this.zzbsu().zzbth();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzbsu().zzbtc());
    }

    @WorkerThread
    private void zzbva() {
        this.zzwu();
        this.zzzg();
        if (!this.zzbve()) {
            return;
        }
        if (!this.zzbuk() || !this.zzbuz()) {
            this.zzbup().unregister();
            this.zzbuq().cancel();
            return;
        }
        long l = this.zzbvb();
        if (l == 0L) {
            this.zzbup().unregister();
            this.zzbuq().cancel();
            return;
        }
        if (!this.zzbuo().zzadj()) {
            this.zzbup().zzadg();
            this.zzbuq().cancel();
            return;
        }
        long l2 = this.zzbta().alx.get();
        long l3 = this.zzbtb().zzbsi();
        if (!this.zzbsv().zzg(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzbup().unregister();
        long l4 = l - this.zzyw().currentTimeMillis();
        if (l4 <= 0L) {
            this.zzbuq().zzv(1L);
        } else {
            this.zzbsz().zzbty().zzj("Upload scheduled in approximately ms", l4);
            this.zzbuq().zzv(l4);
        }
    }

    private long zzbvb() {
        long l;
        long l2 = this.zzyw().currentTimeMillis();
        long l3 = this.zzbtb().zzbsl();
        long l4 = this.zzbtb().zzbsj();
        long l5 = this.zzbta().alv.get();
        long l6 = this.zzbta().alw.get();
        long l7 = this.zzbsu().zzbtf();
        long l8 = Math.max(l7, l = this.zzbsu().zzbtg());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (!this.zzbsv().zzg(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzbtb().zzbsn(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzbtb().zzbsm() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzas(boolean bl) {
        this.zzbva();
    }

    void zzb(zzaa zzaa2) {
        ++this.amK;
    }

    void zzbvc() {
        ++this.amL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzd(AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzaa((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzab.zzhs((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.ajz)) {
            return;
        }
        if (!appMetadata.ajE) {
            this.zze(appMetadata);
            return;
        }
        long l = this.zzyw().currentTimeMillis();
        this.zzbsu().beginTransaction();
        try {
            this.zza(appMetadata, l);
            this.zze(appMetadata);
            zzi zzi2 = this.zzbsu().zzaq(appMetadata.packageName, "_f");
            if (zzi2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
                this.zzb(userAttributeParcel, appMetadata);
                this.zzb(appMetadata, l);
                this.zzc(appMetadata, l);
            } else if (appMetadata.ajF) {
                this.zzd(appMetadata, l);
            }
            this.zzbsu().setTransactionSuccessful();
        }
        finally {
            this.zzbsu().endTransaction();
        }
    }

    @WorkerThread
    void zza(AppMetadata appMetadata, long l) {
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbsu().zzlo(appMetadata.packageName);
        if (zza2 != null && zza2.zzbqo() != null && !zza2.zzbqo().equals(appMetadata.ajz)) {
            this.zzbsz().zzbtt().log("New GMP App Id passed in. Removing cached database data.");
            this.zzbsu().zzlt(zza2.zzsi());
            zza2 = null;
        }
        if (zza2 != null && zza2.zzxc() != null && !zza2.zzxc().equals(appMetadata.abU)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zza2.zzxc());
            EventParcel eventParcel = new EventParcel("_au", new EventParams(bundle), "auto", l);
            this.zzb(eventParcel, appMetadata);
        }
    }

    @WorkerThread
    void zzb(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzc(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        EventParcel eventParcel = new EventParcel("_e", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzd(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        EventParcel eventParcel = new EventParcel("_cd", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    private void zze(AppMetadata appMetadata) {
        this.zzwu();
        this.zzzg();
        com.google.android.gms.common.internal.zzab.zzaa((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzab.zzhs((String)appMetadata.packageName);
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbsu().zzlo(appMetadata.packageName);
        String string = this.zzbta().zzlz(appMetadata.packageName);
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzkz(this.zzbta().zzbub());
            zza2.zzlb(string);
            bl = true;
        } else if (!string.equals(zza2.zzbqp())) {
            zza2.zzlb(string);
            zza2.zzkz(this.zzbta().zzbub());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.ajz) && !appMetadata.ajz.equals(zza2.zzbqo())) {
            zza2.zzla(appMetadata.ajz);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.ajH) && !appMetadata.ajH.equals(zza2.zzbqq())) {
            zza2.zzlc(appMetadata.ajH);
            bl = true;
        }
        if (appMetadata.ajB != 0L && appMetadata.ajB != zza2.zzbqv()) {
            zza2.zzaw(appMetadata.ajB);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.abU) && !appMetadata.abU.equals(zza2.zzxc())) {
            zza2.setAppVersion(appMetadata.abU);
            bl = true;
        }
        if (appMetadata.ajG != zza2.zzbqt()) {
            zza2.zzav(appMetadata.ajG);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.ajA) && !appMetadata.ajA.equals(zza2.zzbqu())) {
            zza2.zzld(appMetadata.ajA);
            bl = true;
        }
        if (appMetadata.ajC != zza2.zzbqw()) {
            zza2.zzax(appMetadata.ajC);
            bl = true;
        }
        if (appMetadata.ajE != zza2.zzbqx()) {
            zza2.setMeasurementEnabled(appMetadata.ajE);
            bl = true;
        }
        if (bl) {
            this.zzbsu().zza(zza2);
        }
    }

    @WorkerThread
    void zzbvd() {
        this.zzwu();
        this.zzzg();
        if (!this.amF) {
            this.zzbsz().zzbtw().log("This instance being marked as an uploader");
            this.zzbus();
        }
        this.amF = true;
    }

    @WorkerThread
    boolean zzbve() {
        this.zzwu();
        this.zzzg();
        return this.amF || this.zzbuu();
    }

    private class zza
    implements zze.zzb {
        zzup.zze amN;
        List<Long> amO;
        List<zzup.zzb> zzala;
        long amP;

        private zza() {
        }

        @Override
        public void zzc(zzup.zze zze2) {
            com.google.android.gms.common.internal.zzab.zzaa((Object)zze2);
            this.amN = zze2;
        }

        @Override
        public boolean zza(long l, zzup.zzb zzb2) {
            com.google.android.gms.common.internal.zzab.zzaa((Object)zzb2);
            if (this.zzala == null) {
                this.zzala = new ArrayList<zzup.zzb>();
            }
            if (this.amO == null) {
                this.amO = new ArrayList<Long>();
            }
            if (this.zzala.size() > 0 && this.zza(this.zzala.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.amP + (long)zzb2.ao();
            if (l2 >= (long)zzx.this.zzbtb().zzbse()) {
                return false;
            }
            this.amP = l2;
            this.zzala.add(zzb2);
            this.amO.add(l);
            return this.zzala.size() < zzx.this.zzbtb().zzbsf();
        }

        private long zza(zzup.zzb zzb2) {
            return zzb2.aoL / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzala == null || this.zzala.isEmpty();
        }
    }
}

