/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;

public class zzd
extends zzz {
    static final String ail = String.valueOf(zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean zzczb;

    zzd(zzx zzx2) {
        super(zzx2);
    }

    String zzbql() {
        return zzl.aiN.get();
    }

    public int zzbqm() {
        return 25;
    }

    public int zzbqn() {
        return 32;
    }

    public int zzbqo() {
        return 24;
    }

    int zzbqp() {
        return 24;
    }

    int zzbqq() {
        return 36;
    }

    int zzbqr() {
        return 256;
    }

    public int zzbqs() {
        return 36;
    }

    public int zzbqt() {
        return 2048;
    }

    int zzbqu() {
        return 500;
    }

    public long zzbqv() {
        return zzl.aiX.get().intValue();
    }

    public long zzbqw() {
        return zzl.aiY.get().intValue();
    }

    public long zzbqx() {
        return 1000L;
    }

    public int zzlf(@Size(min=1L) String string) {
        return this.zzb(string, zzl.aiZ);
    }

    int zzbqy() {
        return 25;
    }

    int zzbqz() {
        return 50;
    }

    long zzbra() {
        return 3600000L;
    }

    long zzbrb() {
        return 60000L;
    }

    long zzbrc() {
        return 61000L;
    }

    long zzlg(String string) {
        return this.zza(string, zzl.aiO);
    }

    int zzlh(String string) {
        return this.zzb(string, zzl.ajk);
    }

    long zzabx() {
        return zzl.ajl.get();
    }

    public String zzacc() {
        return "google_app_measurement.db";
    }

    public String zzacd() {
        return "google_app_measurement2.db";
    }

    public long zzbpz() {
        return 9452L;
    }

    public boolean zzabc() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzabd() {
        if (this.zzczb == null) {
            zzd zzd2 = this;
            synchronized (zzd2) {
                if (this.zzczb == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzt.zzawa();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzczb = string2 != null && string2.equals(string);
                    }
                    if (this.zzczb == null) {
                        this.zzczb = Boolean.TRUE;
                        this.zzbsd().zzbsv().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzczb;
    }

    public long zza(String string, zzl.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzbsa().zzaw(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzl.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzbsa().zzaw(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    private Boolean zzli(@Size(min=1L) String string) {
        zzab.zzhr((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzbsd().zzbsv().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzbsd().zzbsv().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzbsd().zzbsv().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzbsd().zzbsv().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzbrd() {
        if (this.zzabc()) {
            return false;
        }
        Boolean bl = this.zzli("firebase_analytics_collection_deactivated");
        return bl != null && bl == false;
    }

    public Boolean zzbre() {
        if (this.zzabc()) {
            return null;
        }
        return this.zzli("firebase_analytics_collection_enabled");
    }

    public boolean zzaqp() {
        return zzqf.zzaqp();
    }

    public long zzbrf() {
        return zzl.ajj.get();
    }

    public long zzbrg() {
        return zzl.ajf.get();
    }

    public long zzbrh() {
        return 1000L;
    }

    public long zzaci() {
        return Math.max(0L, zzl.aiP.get());
    }

    public int zzlj(String string) {
        return this.zzb(string, zzl.aiT);
    }

    public int zzlk(String string) {
        return Math.max(0, this.zzb(string, zzl.aiU));
    }

    public int zzll(String string) {
        int n = this.zzb(string, zzl.aja);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzbri() {
        return Math.max(0, zzl.aiV.get());
    }

    public int zzbrj() {
        return Math.max(1, zzl.aiW.get());
    }

    public String zzbrk() {
        return zzl.ajb.get();
    }

    public String zzap(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzl.aiR.get()).encodedAuthority(zzl.aiS.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zzbpz()));
        return builder.build().toString();
    }

    public long zzbrl() {
        return zzl.aiQ.get();
    }

    public long zzbrm() {
        return Math.max(0L, zzl.ajc.get());
    }

    public long zzbrn() {
        return Math.max(0L, zzl.aje.get());
    }

    public long zzbro() {
        return zzl.ajd.get();
    }

    public long zzbrp() {
        return Math.max(0L, zzl.ajg.get());
    }

    public long zzbrq() {
        return Math.max(0L, zzl.ajh.get());
    }

    public int zzbrr() {
        return Math.min(20, Math.max(0, zzl.aji.get()));
    }
}

