/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzt
extends zzaa {
    static final Pair<String, Long> ajW = new Pair((Object)"", (Object)0L);
    private SharedPreferences ah;
    public final zzc ajX = new zzc("health_monitor", this.zzbsf().zzaci());
    public final zzb ajY = new zzb("last_upload", 0L);
    public final zzb ajZ = new zzb("last_upload_attempt", 0L);
    public final zzb aka = new zzb("backoff", 0L);
    public final zzb akb = new zzb("last_delete_stale", 0L);
    public final zzb akc;
    private String akd;
    private boolean ake;
    private long akf;
    private SecureRandom akg;
    public final zzb akh = new zzb("time_before_start", 10000L);
    public final zzb aki = new zzb("session_timeout", 1800000L);
    public final zza akj = new zza("start_new_session", true);
    public final zzb akk = new zzb("last_pause_time", 0L);
    public final zzb akl = new zzb("time_active", 0L);
    public boolean akm;

    @WorkerThread
    private SecureRandom zzbte() {
        this.zzwu();
        if (this.akg == null) {
            this.akg = new SecureRandom();
        }
        return this.akg;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzlx(String string) {
        this.zzwu();
        long l = this.zzyw().elapsedRealtime();
        if (this.akd != null && l < this.akf) {
            return new Pair((Object)this.akd, (Object)this.ake);
        }
        this.akf = l + this.zzbsf().zzlg(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.akd = info.getId();
            if (this.akd == null) {
                this.akd = "";
            }
            this.ake = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzbsd().zzbtb().zzj("Unable to get advertising id", throwable);
            this.akd = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.akd, (Object)this.ake);
    }

    String zzly(String string) {
        String string2 = (String)this.zzlx((String)string).first;
        MessageDigest messageDigest = zzal.zzfa("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzbtf() {
        byte[] byArray = new byte[16];
        this.zzbte().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzbpu() {
        this.zzwu();
        return com.google.firebase.iid.zzc.zzcwr().getId();
    }

    @WorkerThread
    long zzbtg() {
        this.zzzg();
        this.zzwu();
        long l = this.akc.get();
        if (l == 0L) {
            l = 1 + this.zzbte().nextInt(86400000);
            this.akc.set(l);
        }
        return l;
    }

    zzt(zzx zzx2) {
        super(zzx2);
        this.akc = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zzwv() {
        this.ah = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.akm = this.ah.getBoolean("has_been_opened", false);
        if (!this.akm) {
            SharedPreferences.Editor editor = this.ah.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzbth() {
        this.zzwu();
        this.zzzg();
        return this.ah;
    }

    @WorkerThread
    void zzlz(String string) {
        this.zzwu();
        SharedPreferences.Editor editor = this.zzbth().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzbti() {
        this.zzwu();
        return this.zzbth().getString("gmp_app_id", null);
    }

    @WorkerThread
    Boolean zzbtj() {
        this.zzwu();
        if (!this.zzbth().contains("use_service")) {
            return null;
        }
        return this.zzbth().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzcb(boolean bl) {
        this.zzwu();
        this.zzbsd().zzbtc().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzbth().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzbtk() {
        this.zzwu();
        this.zzbsd().zzbtc().log("Clearing collection preferences.");
        boolean bl = this.zzbth().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzcc(true);
        }
        SharedPreferences.Editor editor = this.zzbth().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzwu();
        this.zzbsd().zzbtc().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzbth().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzcc(boolean bl) {
        this.zzwu();
        return this.zzbth().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzbtl() {
        this.zzwu();
        String string = this.zzbth().getString("previous_os_version", null);
        String string2 = this.zzbrw().zzbso();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzbth().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzaxp;
        private final boolean akn;
        private boolean ako;
        private boolean rN;

        public zza(String string, boolean bl) {
            zzab.zzhr((String)string);
            this.zzaxp = string;
            this.akn = bl;
        }

        @WorkerThread
        private void zzbtm() {
            if (this.ako) {
                return;
            }
            this.ako = true;
            this.rN = zzt.this.ah.getBoolean(this.zzaxp, this.akn);
        }

        @WorkerThread
        public boolean get() {
            this.zzbtm();
            return this.rN;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzt.this.ah.edit();
            editor.putBoolean(this.zzaxp, bl);
            editor.apply();
            this.rN = bl;
        }
    }

    public final class zzb {
        private final String zzaxp;
        private final long akq;
        private boolean ako;
        private long zzcve;

        public zzb(String string, long l) {
            zzab.zzhr((String)string);
            this.zzaxp = string;
            this.akq = l;
        }

        @WorkerThread
        private void zzbtm() {
            if (this.ako) {
                return;
            }
            this.ako = true;
            this.zzcve = zzt.this.ah.getLong(this.zzaxp, this.akq);
        }

        @WorkerThread
        public long get() {
            this.zzbtm();
            return this.zzcve;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzt.this.ah.edit();
            editor.putLong(this.zzaxp, l);
            editor.apply();
            this.zzcve = l;
        }
    }

    public final class zzc {
        final String akr;
        private final String aks;
        private final String akt;
        private final long al;

        private zzc(String string, long l) {
            zzab.zzhr((String)string);
            zzab.zzbo((l > 0L ? 1 : 0) != 0);
            this.akr = String.valueOf(string).concat(":start");
            this.aks = String.valueOf(string).concat(":count");
            this.akt = String.valueOf(string).concat(":value");
            this.al = l;
        }

        @WorkerThread
        private void zzadt() {
            zzt.this.zzwu();
            long l = zzt.this.zzyw().currentTimeMillis();
            SharedPreferences.Editor editor = zzt.this.ah.edit();
            editor.remove(this.aks);
            editor.remove(this.akt);
            editor.putLong(this.akr, l);
            editor.apply();
        }

        @WorkerThread
        private long zzadu() {
            zzt.this.zzwu();
            long l = this.zzadw();
            if (l == 0L) {
                this.zzadt();
                return 0L;
            }
            return Math.abs(l - zzt.this.zzyw().currentTimeMillis());
        }

        @WorkerThread
        public void zzev(String string) {
            this.zzh(string, 1L);
        }

        @WorkerThread
        public void zzh(String string, long l) {
            long l2;
            zzt.this.zzwu();
            long l3 = this.zzadw();
            if (l3 == 0L) {
                this.zzadt();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzt.this.ah.getLong(this.aks, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzt.this.ah.edit();
                editor.putString(this.akt, string);
                editor.putLong(this.aks, l);
                editor.apply();
                return;
            }
            long l4 = zzt.this.zzbte().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzt.this.ah.edit();
            if (bl) {
                editor.putString(this.akt, string);
            }
            editor.putLong(this.aks, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzadv() {
            zzt.this.zzwu();
            long l = this.zzadu();
            if (l < this.al) {
                return null;
            }
            if (l > this.al * 2L) {
                this.zzadt();
                return null;
            }
            String string = zzt.this.zzbth().getString(this.akt, null);
            long l2 = zzt.this.zzbth().getLong(this.aks, 0L);
            this.zzadt();
            if (string == null || l2 <= 0L) {
                return ajW;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzadw() {
            return zzt.this.zzbth().getLong(this.akr, 0L);
        }
    }
}

