/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzx;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public class zzac
extends zzaa {
    private zza arA;
    private AppMeasurement.zzb arB;
    private final Set<AppMeasurement.zzc> arC = new CopyOnWriteArraySet<AppMeasurement.zzc>();
    private boolean arD;

    protected zzac(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzym() {
    }

    @TargetApi(value=14)
    public void zzbxv() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.arA == null) {
                this.arA = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.arA);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.arA);
            this.zzbvg().zzbwj().log("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean bl) {
        this.zzaax();
        this.zzaam();
        this.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzch(bl);
            }
        });
    }

    @WorkerThread
    private void zzch(boolean bl) {
        this.zzyl();
        this.zzaam();
        this.zzaax();
        this.zzbvg().zzbwi().zzj("Setting app measurement enabled (FE)", bl);
        this.zzbvh().setMeasurementEnabled(bl);
        this.zzbva().zzbxz();
    }

    public void setMinimumSessionDuration(final long l) {
        this.zzaam();
        this.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzbvh().apZ.set(l);
                zzac.this.zzbvg().zzbwi().zzj("Minimum session duration set", l);
            }
        });
    }

    public void setSessionTimeoutDuration(final long l) {
        this.zzaam();
        this.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzbvh().aqa.set(l);
                zzac.this.zzbvg().zzbwi().zzj("Session timeout duration set", l);
            }
        });
    }

    public void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.zzaam();
        boolean bl2 = this.arB == null || zzal.zznh(string2);
        this.zza(string, string2, bundle, true, bl2, bl, null);
    }

    public void zzf(String string, String string2, Bundle bundle) {
        this.zzaam();
        boolean bl = this.arB == null || zzal.zznh(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public void zzd(String string, String string2, Bundle bundle, long l) {
        this.zzaam();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, this.zzaan().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    Bundle zzam(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzbvc().zzl(string, bundle.get(string));
                if (object == null) {
                    this.zzbvg().zzbwe().zzj("Param value can't be null", string);
                    continue;
                }
                this.zzbvc().zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    protected void zza(final String string, final String string2, final long l, Bundle bundle, final boolean bl, final boolean bl2, final boolean bl3, final String string3) {
        final Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        this.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zzb(string, string2, l, bundle2, bl, bl2, bl3, string3);
            }
        });
    }

    @WorkerThread
    private void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        com.google.android.gms.common.internal.zzac.zzhz((String)string2);
        com.google.android.gms.common.internal.zzac.zzy((Object)bundle);
        this.zzyl();
        this.zzaax();
        if (!this.anq.isEnabled()) {
            this.zzbvg().zzbwi().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.arD) {
            this.arD = true;
            this.zzbxx();
        }
        boolean bl4 = zzal.zznh(string2);
        if (bl && this.arB != null && !bl4) {
            this.zzbvg().zzbwi().zze("Passing event to registered event handler (FE)", string2, bundle);
            this.arB.zzb(string, string2, bundle, l);
        } else {
            if (!this.anq.zzbwv()) {
                return;
            }
            int n = this.zzbvc().zzmz(string2);
            if (n != 0) {
                String string4 = this.zzbvc().zza(string2, this.zzbvi().zzbtn(), true);
                int n2 = string2 != null ? string2.length() : 0;
                this.anq.zzbvc().zza(n, "_ev", string4, n2);
                return;
            }
            bundle.putString("_o", string);
            List list = zzf.zzz((Object)"_o");
            Bundle bundle2 = this.zzbvc().zza(string2, bundle, list, bl3);
            Bundle bundle3 = bl2 ? this.zzam(bundle2) : bundle2;
            this.zzbvg().zzbwi().zze("Logging event (FE)", string2, bundle3);
            EventParcel eventParcel = new EventParcel(string2, new EventParams(bundle3), string, l);
            this.zzbva().zzc(eventParcel, string3);
            for (AppMeasurement.zzc zzc2 : this.arC) {
                Bundle bundle4 = new Bundle(bundle3);
                zzc2.zzc(string, string2, bundle4, l);
            }
        }
    }

    public void zzd(String string, String string2, Object object) {
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        long l = this.zzaan().currentTimeMillis();
        int n = this.zzbvc().zznb(string2);
        if (n != 0) {
            String string3 = this.zzbvc().zza(string2, this.zzbvi().zzbto(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.anq.zzbvc().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = this.zzbvc().zzm(string2, object);
            if (n != 0) {
                String string4 = this.zzbvc().zza(string2, this.zzbvi().zzbto(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    String string5 = String.valueOf(object);
                    n3 = string5.length();
                }
                this.anq.zzbvc().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = this.zzbvc().zzn(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
        } else {
            this.zza(string, string2, l, null);
        }
    }

    void zza(final String string, final String string2, final long l, final Object object) {
        this.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzac.this.zza(string, string2, object, l);
            }
        });
    }

    @WorkerThread
    private void zza(String string, String string2, Object object, long l) {
        com.google.android.gms.common.internal.zzac.zzhz((String)string);
        com.google.android.gms.common.internal.zzac.zzhz((String)string2);
        this.zzyl();
        this.zzaam();
        this.zzaax();
        if (!this.anq.isEnabled()) {
            this.zzbvg().zzbwi().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.anq.zzbwv()) {
            return;
        }
        this.zzbvg().zzbwi().zze("Setting user property (FE)", string2, object);
        UserAttributeParcel userAttributeParcel = new UserAttributeParcel(string2, l, object, string);
        this.zzbva().zza(userAttributeParcel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserAttributeParcel> zzci(final boolean bl) {
        this.zzaam();
        this.zzaax();
        this.zzbvg().zzbwi().log("Fetching user attributes (FE)");
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.anq.zzbvf().zzm(new Runnable(){

                @Override
                public void run() {
                    zzac.this.zzbva().zza(atomicReference, bl);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzbvg().zzbwe().zzj("Interrupted waiting for get user properties", interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzbvg().zzbwe().log("Timed out waiting for get user properties");
            return Collections.emptyList();
        }
        return object;
    }

    @WorkerThread
    public void zzbxw() {
        this.zzyl();
        this.zzaam();
        this.zzaax();
        if (!this.anq.zzbwv()) {
            return;
        }
        this.zzbva().zzbxw();
        String string = this.zzbvh().zzbws();
        if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzbuz().zzbvv())) {
            Bundle bundle = new Bundle();
            bundle.putString("_po", string);
            this.zzf("auto", "_ou", bundle);
        }
    }

    @WorkerThread
    public void zza(AppMeasurement.zzb zzb2) {
        this.zzyl();
        this.zzaam();
        this.zzaax();
        if (zzb2 != null && zzb2 != this.arB) {
            com.google.android.gms.common.internal.zzac.zza((this.arB == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.arB = zzb2;
    }

    public void zza(AppMeasurement.zzc zzc2) {
        this.zzaam();
        this.zzaax();
        com.google.android.gms.common.internal.zzac.zzy((Object)zzc2);
        if (!this.arC.add(zzc2)) {
            this.zzbvg().zzbwe().log("OnEventListener already registered");
        }
    }

    @WorkerThread
    private void zzbxx() {
        try {
            Class<?> clazz = Class.forName(this.zzbxy());
            this.zzg(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzbvg().zzbwh().log("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzbxy() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    @WorkerThread
    public void zzg(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzbvg().zzbwe().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    @MainThread
    @TargetApi(value=14)
    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzmv(String string) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzac.this.zzd("auto", "_ldl", string);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            try {
                Uri uri;
                zzac.this.zzbvg().zzbwj().log("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    String string;
                    if (bundle == null && (string = zzac.this.zzbvc().zzt(uri)) != null) {
                        zzac.this.zzf("auto", "_cmp", (Bundle)string);
                    }
                    if (TextUtils.isEmpty((CharSequence)(string = uri.getQueryParameter("referrer")))) {
                        return;
                    }
                    if (!string.contains("gclid")) {
                        zzac.this.zzbvg().zzbwi().log("Activity created with data 'referrer' param without gclid");
                        return;
                    }
                    zzac.this.zzbvg().zzbwi().zzj("Activity created with referrer", string);
                    this.zzmv(string);
                }
            }
            catch (Throwable throwable) {
                zzac.this.zzbvg().zzbwc().zzj("Throwable caught in onActivityCreated", throwable);
            }
        }

        public void onActivityDestroyed(Activity activity) {
        }

        @MainThread
        public void onActivityPaused(Activity activity) {
            zzac.this.zzbve().zzbyh();
        }

        @MainThread
        public void onActivityResumed(Activity activity) {
            zzac.this.zzbve().zzbyf();
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }
}

