/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.zze;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzy
extends zzm.zza {
    private final zzx anq;
    private Boolean art;
    @Nullable
    private String aru;

    public zzy(zzx zzx2) {
        this(zzx2, null);
    }

    public zzy(zzx zzx2, @Nullable String string) {
        zzac.zzy((Object)zzx2);
        this.anq = zzx2;
        this.aru = string;
    }

    @WorkerThread
    void zzms(String string) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)string) && (stringArray = string.split(":", 2)).length == 2) {
            long l;
            try {
                l = Long.valueOf(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                this.anq.zzbvg().zzbwe().zzj("Combining sample with a non-number weight", stringArray[0]);
                return;
            }
            if (l > 0L) {
                this.anq.zzbvh().apP.zzi(stringArray[1], l);
            } else {
                this.anq.zzbvg().zzbwe().zzj("Combining sample with a non-positive weight", l);
            }
        }
    }

    @Override
    @BinderThread
    public void zzb(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.anq.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.anq.zzbxp();
                zzy.this.zzms(appMetadata.anU);
                zzy.this.anq.zzc(appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final AppMetadata appMetadata) {
        zzac.zzy((Object)((Object)eventParcel));
        this.zzf(appMetadata);
        this.anq.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.anq.zzbxp();
                zzy.this.zzms(appMetadata.anU);
                zzy.this.anq.zzb(eventParcel, appMetadata);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final EventParcel eventParcel, final String string, final String string2) {
        zzac.zzy((Object)((Object)eventParcel));
        zzac.zzhz((String)string);
        this.zzmt(string);
        this.anq.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.anq.zzbxp();
                zzy.this.zzms(string2);
                zzy.this.anq.zzb(eventParcel, string);
            }
        });
    }

    @Override
    @BinderThread
    public byte[] zza(final EventParcel eventParcel, final String string) {
        zzac.zzhz((String)string);
        zzac.zzy((Object)((Object)eventParcel));
        this.zzmt(string);
        this.anq.zzbvg().zzbwi().zzj("Log and bundle. event", eventParcel.name);
        long l = this.anq.zzaan().nanoTime() / 1000000L;
        Future<byte[]> future = this.anq.zzbvf().zze(new Callable<byte[]>(){

            public byte[] zzbxr() throws Exception {
                zzy.this.anq.zzbxp();
                return zzy.this.anq.zza(eventParcel, string);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbxr();
            }
        });
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.anq.zzbvg().zzbwc().log("Log and bundle returned null");
                byArray = new byte[]{};
            }
            long l2 = this.anq.zzaan().nanoTime() / 1000000L;
            this.anq.zzbvg().zzbwi().zzd("Log and bundle processed. event, size, time_ms", eventParcel.name, byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.anq.zzbvg().zzbwc().zze("Failed to log and bundle. event, error", eventParcel.name, exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final UserAttributeParcel userAttributeParcel, final AppMetadata appMetadata) {
        zzac.zzy((Object)((Object)userAttributeParcel));
        this.zzf(appMetadata);
        if (userAttributeParcel.getValue() == null) {
            this.anq.zzbvf().zzm(new Runnable(){

                @Override
                public void run() {
                    zzy.this.anq.zzbxp();
                    zzy.this.zzms(appMetadata.anU);
                    zzy.this.anq.zzc(userAttributeParcel, appMetadata);
                }
            });
        } else {
            this.anq.zzbvf().zzm(new Runnable(){

                @Override
                public void run() {
                    zzy.this.anq.zzbxp();
                    zzy.this.zzms(appMetadata.anU);
                    zzy.this.anq.zzb(userAttributeParcel, appMetadata);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<UserAttributeParcel> zza(final AppMetadata appMetadata, boolean bl) {
        this.zzf(appMetadata);
        Future<List<zzak>> future = this.anq.zzbvf().zzd(new Callable<List<zzak>>(){

            public List<zzak> zzbxs() throws Exception {
                zzy.this.anq.zzbxp();
                return zzy.this.anq.zzbvb().zzly(appMetadata.packageName);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbxs();
            }
        });
        try {
            List<zzak> list = future.get();
            ArrayList<UserAttributeParcel> arrayList = new ArrayList<UserAttributeParcel>(list.size());
            for (zzak zzak2 : list) {
                if (!bl && zzal.zznh(zzak2.mName)) continue;
                arrayList.add(new UserAttributeParcel(zzak2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.anq.zzbvg().zzbwc().zzj("Failed to get user attributes", exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final AppMetadata appMetadata) {
        this.zzf(appMetadata);
        this.anq.zzbvf().zzm(new Runnable(){

            @Override
            public void run() {
                zzy.this.anq.zzbxp();
                zzy.this.zzms(appMetadata.anU);
                zzy.this.anq.zzd(appMetadata);
            }
        });
    }

    @BinderThread
    private void zzf(AppMetadata appMetadata) {
        zzac.zzy((Object)((Object)appMetadata));
        this.zzmt(appMetadata.packageName);
        this.anq.zzbvc().zzne(appMetadata.anQ);
    }

    @BinderThread
    private void zzmt(String string) throws SecurityException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.anq.zzbvg().zzbwc().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzmu(string);
        }
        catch (SecurityException securityException) {
            this.anq.zzbvg().zzbwc().zzj("Measurement Service called with invalid calling package", string);
            throw securityException;
        }
    }

    protected void zzmu(String string) throws SecurityException {
        if (this.aru == null && zze.zzb((Context)this.anq.getContext(), (int)Binder.getCallingUid(), (String)string)) {
            this.aru = string;
        }
        if (string.equals(this.aru)) {
            return;
        }
        if (this.art == null) {
            this.art = ("com.google.android.gms".equals(this.aru) || com.google.android.gms.common.util.zzy.zzf((Context)this.anq.getContext(), (int)Binder.getCallingUid())) && !this.anq.zzbxg();
        }
        if (this.art.booleanValue()) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string));
    }
}

