/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzad
extends zzaa {
    private final zza arP;
    private zzm arQ;
    private Boolean arR;
    private final zzf arS;
    private final zzah arT;
    private final List<Runnable> arU = new ArrayList<Runnable>();
    private final zzf arV;

    protected zzad(zzx zzx2) {
        super(zzx2);
        this.arT = new zzah(zzx2.zzaan());
        this.arP = new zza();
        this.arS = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzabl();
            }
        };
        this.arV = new zzf(zzx2){

            @Override
            public void run() {
                zzad.this.zzbvg().zzbwe().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzym() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzyl();
        this.zzaax();
        return this.arQ != null;
    }

    @WorkerThread
    protected void zzbxz() {
        this.zzyl();
        this.zzaax();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.arQ;
                if (zzm2 == null) {
                    zzad.this.zzbvg().zzbwc().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzm2.zzb(zzad.this.zzbuy().zzmi(zzad.this.zzbvg().zzbwk()));
                    zzad.this.zzabk();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbvg().zzbwc().zzj("Failed to send measurementEnabled to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zzc(final EventParcel eventParcel, final String string) {
        zzac.zzy((Object)((Object)eventParcel));
        this.zzyl();
        this.zzaax();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.arQ;
                if (zzm2 == null) {
                    zzad.this.zzbvg().zzbwc().log("Discarding data. Failed to send event to service");
                    return;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        zzm2.zza(eventParcel, zzad.this.zzbuy().zzmi(zzad.this.zzbvg().zzbwk()));
                    } else {
                        zzm2.zza(eventParcel, string, zzad.this.zzbvg().zzbwk());
                    }
                    zzad.this.zzabk();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbvg().zzbwc().zzj("Failed to send event to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final UserAttributeParcel userAttributeParcel) {
        this.zzyl();
        this.zzaax();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.arQ;
                if (zzm2 == null) {
                    zzad.this.zzbvg().zzbwc().log("Discarding data. Failed to set user attribute");
                    return;
                }
                try {
                    zzm2.zza(userAttributeParcel, zzad.this.zzbuy().zzmi(zzad.this.zzbvg().zzbwk()));
                    zzad.this.zzabk();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbvg().zzbwc().zzj("Failed to send attribute to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<UserAttributeParcel>> atomicReference, final boolean bl) {
        this.zzyl();
        this.zzaax();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzm zzm2 = zzad.this.arQ;
                        if (zzm2 == null) {
                            zzad.this.zzbvg().zzbwc().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzm2.zza(zzad.this.zzbuy().zzmi(null), bl));
                        zzad.this.zzabk();
                    }
                    catch (RemoteException remoteException) {
                        zzad.this.zzbvg().zzbwc().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzbxw() {
        this.zzyl();
        this.zzaax();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzad.this.arQ;
                if (zzm2 == null) {
                    zzad.this.zzbvg().zzbwc().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzm2.zza(zzad.this.zzbuy().zzmi(zzad.this.zzbvg().zzbwk()));
                    zzad.this.zzabk();
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbvg().zzbwc().zzj("Failed to send app launch to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzabk() {
        this.zzyl();
        this.arT.start();
        if (!this.anq.zzbxg()) {
            this.arS.zzx(this.zzbvi().zzado());
        }
    }

    @WorkerThread
    void zzabz() {
        this.zzyl();
        this.zzaax();
        if (this.isConnected()) {
            return;
        }
        if (this.arR == null) {
            this.arR = this.zzbvh().zzbwq();
            if (this.arR == null) {
                this.zzbvg().zzbwj().log("State of service unknown");
                this.arR = this.zzbyb();
                this.zzbvh().zzcf(this.arR);
            }
        }
        if (this.arR.booleanValue()) {
            this.zzbvg().zzbwj().log("Using measurement service");
            this.arP.zzbye();
        } else {
            if (!this.anq.zzbxg() && this.zzbya()) {
                this.zzbvg().zzbwj().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                intent.setComponent(new ComponentName(this.getContext(), this.zzbvi().zzact() ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService"));
                this.arP.zzac(intent);
                return;
            }
            this.zzbvg().zzbwc().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    private boolean zzbya() {
        Intent intent;
        if (this.zzbvi().zzact()) {
            return false;
        }
        PackageManager packageManager = this.getContext().getPackageManager();
        List list = packageManager.queryIntentServices(intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzbyb() {
        this.zzyl();
        this.zzaax();
        if (this.zzbvi().zzact()) {
            return true;
        }
        this.zzbvg().zzbwj().log("Checking service availability");
        int n = zzc.zzapd().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzbvg().zzbwj().log("Service available");
                return true;
            }
            case 1: {
                this.zzbvg().zzbwj().log("Service missing");
                return false;
            }
            case 18: {
                this.zzbvg().zzbwe().log("Service updating");
                return true;
            }
            case 2: {
                this.zzbvg().zzbwi().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzbvg().zzbwe().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzbvg().zzbwe().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzm zzm2) {
        this.zzyl();
        zzac.zzy((Object)zzm2);
        this.arQ = zzm2;
        this.zzabk();
        this.zzbyd();
    }

    @WorkerThread
    public void disconnect() {
        this.zzyl();
        this.zzaax();
        try {
            zzb zzb2 = zzb.zzawu();
            zzb2.zza(this.getContext(), (ServiceConnection)this.arP);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.arQ = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzyl();
        if (this.arQ != null) {
            this.arQ = null;
            this.zzbvg().zzbwj().zzj("Disconnected from device MeasurementService", componentName);
            this.zzbyc();
        }
    }

    @WorkerThread
    private void zzabl() {
        this.zzyl();
        if (!this.isConnected()) {
            return;
        }
        this.zzbvg().zzbwj().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private void zzbyc() {
        this.zzyl();
        this.zzabz();
    }

    @WorkerThread
    private void zzo(Runnable runnable) throws IllegalStateException {
        this.zzyl();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.arU.size() >= this.zzbvi().zzbug()) {
                this.zzbvg().zzbwc().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.arU.add(runnable);
            if (!this.anq.zzbxg()) {
                this.arV.zzx(60000L);
            }
            this.zzabz();
        }
    }

    @WorkerThread
    private void zzbyd() {
        this.zzyl();
        this.zzbvg().zzbwj().zzj("Processing queued up service tasks", this.arU.size());
        for (Runnable runnable : this.arU) {
            this.zzbvf().zzm(runnable);
        }
        this.arU.clear();
        this.arV.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zze.zzb,
    zze.zzc {
        private volatile boolean arY;
        private volatile zzo arZ;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzac(Intent intent) {
            zzad.this.zzyl();
            Context context = zzad.this.getContext();
            zzb zzb2 = zzb.zzawu();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.arY) {
                    zzad.this.zzbvg().zzbwj().log("Connection attempt already in progress");
                    return;
                }
                this.arY = true;
                zzb2.zza(context, intent, (ServiceConnection)zzad.this.arP, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzhq((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.arY = false;
                    zzad.this.zzbvg().zzbwc().log("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzjl(iBinder);
                        zzad.this.zzbvg().zzbwj().log("Bound to IMeasurementService interface");
                    } else {
                        zzad.this.zzbvg().zzbwc().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzad.this.zzbvg().zzbwc().log("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    this.arY = false;
                    try {
                        zzb.zzawu().zza(zzad.this.getContext(), (ServiceConnection)zzad.this.arP);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzad.this.zzbvf().zzm(new Runnable((zzm)object){
                        final /* synthetic */ zzm asa;
                        {
                            this.asa = zzm2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.arY = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzbvg().zzbwj().log("Connected to service");
                                    zzad.this.zza(this.asa);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            zzac.zzhq((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzad.this.zzbvg().zzbwi().log("Service disconnected");
            zzad.this.zzbvf().zzm(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzbye() {
            zzad.this.zzyl();
            Context context = zzad.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.arY) {
                    zzad.this.zzbvg().zzbwj().log("Connection attempt already in progress");
                    return;
                }
                if (this.arZ != null) {
                    zzad.this.zzbvg().zzbwj().log("Already awaiting connection attempt");
                    return;
                }
                this.arZ = new zzo(context, Looper.getMainLooper(), this, this);
                zzad.this.zzbvg().zzbwj().log("Connecting to remote service");
                this.arY = true;
                this.arZ.zzatu();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            zzac.zzhq((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzm zzm2 = (zzm)this.arZ.zzatx();
                    this.arZ = null;
                    zzad.this.zzbvf().zzm(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.arY = false;
                                if (!zzad.this.isConnected()) {
                                    zzad.this.zzbvg().zzbwi().log("Connected to remote service");
                                    zzad.this.zza(zzm2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.arZ = null;
                    this.arY = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            zzac.zzhq((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzad.this.zzbvg().zzbwi().log("Service connection suspended");
            zzad.this.zzbvf().zzm(new Runnable(){

                @Override
                public void run() {
                    zzad.this.onServiceDisconnected(new ComponentName(zzad.this.getContext(), zzad.this.zzbvi().zzact() && !zzad.this.anq.zzbxg() ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzac.zzhq((String)"MeasurementServiceConnection.onConnectionFailed");
            zzp zzp2 = zzad.this.anq.zzbww();
            if (zzp2 != null) {
                zzp2.zzbwe().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.arY = false;
                this.arZ = null;
            }
        }
    }
}

