/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzx;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class zzad
extends zzaa {
    protected zza avd;
    private AppMeasurement.zzf ave;
    private AppMeasurement.zzf avf;
    private long avg;
    private final Map<Activity, zza> avh = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zzd> avi = new CopyOnWriteArrayList();
    private boolean avj;
    private final AtomicLong avk = new AtomicLong(0L);
    private AppMeasurement.zzf avl;
    private String avm;

    public zzad(zzx zzx2) {
        super(zzx2);
    }

    @Override
    protected void zzzy() {
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (!(l != 0L && l != 1L || (l = secureRandom.nextLong()) != 0L && l != 1L)) {
            this.zzbwb().zzbxa().log("ScreenService falling back to Random for screen instance id");
            l = 0L;
        }
        this.avk.set(l);
    }

    @WorkerThread
    public zza zzbyt() {
        this.zzacj();
        this.zzzx();
        return this.avd;
    }

    @MainThread
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        boolean bl;
        if (Build.VERSION.SDK_INT < 14) {
            this.zzbwb().zzbxb().log("Screen engagement recording is only available at API level 14+");
            return;
        }
        if (activity == null) {
            this.zzbwb().zzbxa().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        if (!this.zzbwa().zzdg()) {
            this.zzbwb().zzbxa().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.avj) {
            this.zzbwb().zzbxa().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.ave == null) {
            this.zzbwb().zzbxa().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.avh.get(activity) == null) {
            this.zzbwb().zzbxa().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzad.zzmt(activity.getClass().getCanonicalName());
        }
        boolean bl2 = this.ave.aqA.equals(string2);
        boolean bl3 = bl = this.ave.aqz == null && string == null || this.ave.aqz != null && this.ave.aqz.equals(string);
        if (bl2 && bl) {
            this.zzbwb().zzbxb().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() < 1 || string.length() > this.zzbwd().zzbug())) {
            this.zzbwb().zzbxa().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() < 1 || string2.length() > this.zzbwd().zzbug())) {
            this.zzbwb().zzbxa().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzbwb().zzbxe().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zza zza2 = new zza(string, string2, this.zzbyu());
        this.avh.put(activity, zza2);
        this.zza(activity, zza2, true);
    }

    @MainThread
    public void registerOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzaby();
        if (zzd2 == null) {
            this.zzbwb().zzbxa().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.avi.remove(zzd2);
        this.avi.add(zzd2);
    }

    @MainThread
    public void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzaby();
        this.avi.remove(zzd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private void zza(Activity activity, zza zza2, final boolean bl) {
        AppMeasurement.zzf zzf2 = null;
        if (this.ave != null) {
            zzf2 = this.ave;
        } else if (this.avf != null && Math.abs(this.zzabz().elapsedRealtime() - this.avg) < 1000L) {
            zzf2 = this.avf;
        }
        AppMeasurement.zzf zzf3 = null;
        if (zzf2 != null) {
            zzf3 = new AppMeasurement.zzf(zzf2);
        }
        boolean bl2 = true;
        this.avj = true;
        try {
            for (AppMeasurement.zzd zzd2 : this.avi) {
                try {
                    bl2 &= zzd2.zza(zzf3, zza2);
                }
                catch (Exception exception) {
                    this.zzbwb().zzbwy().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            this.zzbwb().zzbwy().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.avj = false;
        }
        if (bl2) {
            if (zza2.aqA == null) {
                zza2.aqA = zzad.zzmt(activity.getClass().getCanonicalName());
            }
            final zza zza3 = new zza(zza2);
            this.avf = this.ave;
            this.avg = this.zzabz().elapsedRealtime();
            this.ave = zza3;
            this.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    if (bl && zzad.this.avd != null) {
                        zzad.this.zza(zzad.this.avd);
                    }
                    zzad.this.avd = zza3;
                    zzad.this.zzbvt().zza(zza3);
                }
            });
        }
    }

    @WorkerThread
    private void zza(@NonNull zza zza2) {
        if (this.zzbvz().zzck(zza2.avr)) {
            zza2.avr = false;
        }
    }

    public static void zza(AppMeasurement.zzf zzf2, Bundle bundle) {
        if (bundle != null && zzf2 != null && !bundle.containsKey("_sc")) {
            if (zzf2.aqz != null) {
                bundle.putString("_sn", zzf2.aqz);
            }
            bundle.putString("_sc", zzf2.aqA);
            bundle.putLong("_si", zzf2.aqB);
        }
    }

    @WorkerThread
    public void zza(String string, AppMeasurement.zzf zzf2) {
        this.zzzx();
        if (this.avm == null || this.avm.equals(string) || zzf2 != null) {
            this.avm = string;
            this.avl = zzf2;
        }
    }

    static String zzmt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    zza zzv(@NonNull Activity activity) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)activity);
        zza zza2 = this.avh.get(activity);
        if (zza2 == null) {
            String string = zzad.zzmt(activity.getClass().getCanonicalName());
            zza2 = new zza(null, string, this.zzbyu());
            this.avh.put(activity, zza2);
        }
        return zza2;
    }

    @MainThread
    private long zzbyu() {
        long l = this.avk.getAndIncrement();
        if (l == 0L) {
            this.avk.compareAndSet(1L, 0L);
            return new Random(System.nanoTime() ^ this.zzabz().currentTimeMillis()).nextLong();
        }
        this.avk.compareAndSet(0L, 1L);
        return l;
    }

    @MainThread
    public void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zza zza2 = this.zzv(activity);
        zza2.aqB = bundle2.getLong("id");
        zza2.aqz = bundle2.getString("name");
        zza2.aqA = bundle2.getString("referrer_name");
    }

    @MainThread
    public void onActivityResumed(Activity activity) {
        zza zza2 = this.zzv(activity);
        this.zza(activity, zza2, false);
    }

    @MainThread
    public void onActivityPaused(Activity activity) {
        final zza zza2 = this.zzv(activity);
        this.avf = this.ave;
        this.avg = this.zzabz().elapsedRealtime();
        this.ave = null;
        this.zzbwa().zzm(new Runnable(){

            @Override
            public void run() {
                zzad.this.zza(zza2);
                zzad.this.avd = null;
                zzad.this.zzbvt().zza((AppMeasurement.zzf)null);
            }
        });
    }

    @MainThread
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zza zza2 = this.avh.get(activity);
        if (zza2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zza2.aqB);
        bundle2.putString("name", zza2.aqz);
        bundle2.putString("referrer_name", zza2.aqA);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public void onActivityDestroyed(Activity activity) {
        this.avh.remove(activity);
    }

    static class zza
    extends AppMeasurement.zzf {
        public boolean avr;

        public zza(String string, String string2, long l) {
            this.aqz = string;
            this.aqA = string2;
            this.aqB = l;
            this.avr = false;
        }

        public zza(zza zza2) {
            this.aqz = zza2.aqz;
            this.aqA = zza2.aqA;
            this.aqB = zza2.aqB;
            this.avr = zza2.avr;
        }
    }
}

