/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.zzc;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzae
extends zzaa {
    private final zza avs;
    private zzm avt;
    private Boolean avu;
    private final zzf avv;
    private final zzah avw;
    private final List<Runnable> avx = new ArrayList<Runnable>();
    private final zzf avy;

    protected zzae(zzx zzx2) {
        super(zzx2);
        this.avw = new zzah(zzx2.zzabz());
        this.avs = new zza();
        this.avv = new zzf(zzx2){

            @Override
            public void run() {
                zzae.this.zzacx();
            }
        };
        this.avy = new zzf(zzx2){

            @Override
            public void run() {
                zzae.this.zzbwb().zzbxa().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzzy() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzzx();
        this.zzacj();
        return this.avt != null;
    }

    @WorkerThread
    protected void zzbyv() {
        this.zzzx();
        this.zzacj();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzae.this.avt;
                if (zzm2 == null) {
                    zzae.this.zzbwb().zzbwy().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzm2.zzb(zzae.this.zzbvr().zzmi(zzae.this.zzbwb().zzbxf()));
                    zzae.this.zzacw();
                }
                catch (RemoteException remoteException) {
                    zzae.this.zzbwb().zzbwy().zzj("Failed to send measurementEnabled to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    void zza(zzm zzm2, AbstractSafeParcelable abstractSafeParcelable) {
        this.zzzx();
        this.zzaby();
        this.zzacj();
        boolean bl = Build.VERSION.SDK_INT >= 11 && !this.zzbwd().zzayi();
        ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
        int n = 100;
        int n2 = 100;
        this.zzbwd().zzbvb();
        int n3 = 1001;
        for (int i = 0; i < 1001 && n2 == 100; ++i) {
            Object object;
            n2 = 0;
            if (bl && (object = this.zzbvv().zzxe(100)) != null) {
                arrayList.addAll((Collection<AbstractSafeParcelable>)object);
                n2 = object.size();
            }
            if (abstractSafeParcelable != null && n2 < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)object.next();
                if (abstractSafeParcelable2 instanceof EventParcel) {
                    try {
                        zzm2.zza((EventParcel)abstractSafeParcelable2, this.zzbvr().zzmi(this.zzbwb().zzbxf()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzbwb().zzbwy().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof UserAttributeParcel) {
                    try {
                        zzm2.zza((UserAttributeParcel)abstractSafeParcelable2, this.zzbvr().zzmi(this.zzbwb().zzbxf()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzbwb().zzbwy().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                this.zzbwb().zzbwy().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected void zzc(final EventParcel eventParcel, final String string) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)eventParcel));
        this.zzzx();
        this.zzacj();
        final boolean bl = Build.VERSION.SDK_INT >= 11 && !this.zzbwd().zzayi();
        final boolean bl2 = bl && this.zzbvv().zza(eventParcel);
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzae.this.avt;
                if (zzm2 == null) {
                    zzae.this.zzbwb().zzbwy().log("Discarding data. Failed to send event to service");
                    return;
                }
                if (bl) {
                    zzae.this.zza(zzm2, bl2 ? null : eventParcel);
                } else {
                    try {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            zzm2.zza(eventParcel, zzae.this.zzbvr().zzmi(zzae.this.zzbwb().zzbxf()));
                        } else {
                            zzm2.zza(eventParcel, string, zzae.this.zzbwb().zzbxf());
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzae.this.zzbwb().zzbwy().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                }
                zzae.this.zzacw();
            }
        });
    }

    @WorkerThread
    protected void zzb(final UserAttributeParcel userAttributeParcel) {
        this.zzzx();
        this.zzacj();
        boolean bl = Build.VERSION.SDK_INT >= 11 && !this.zzbwd().zzayi();
        final boolean bl2 = bl && this.zzbvv().zza(userAttributeParcel);
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzae.this.avt;
                if (zzm2 == null) {
                    zzae.this.zzbwb().zzbwy().log("Discarding data. Failed to set user attribute");
                    return;
                }
                zzae.this.zza(zzm2, bl2 ? null : userAttributeParcel);
                zzae.this.zzacw();
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<UserAttributeParcel>> atomicReference, final boolean bl) {
        this.zzzx();
        this.zzacj();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzm zzm2 = zzae.this.avt;
                        if (zzm2 == null) {
                            zzae.this.zzbwb().zzbwy().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzm2.zza(zzae.this.zzbvr().zzmi(null), bl));
                        zzae.this.zzacw();
                    }
                    catch (RemoteException remoteException) {
                        zzae.this.zzbwb().zzbwy().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzbyq() {
        this.zzzx();
        this.zzacj();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzae.this.avt;
                if (zzm2 == null) {
                    zzae.this.zzbwb().zzbwy().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzae.this.zza(zzm2, null);
                    zzm2.zza(zzae.this.zzbvr().zzmi(zzae.this.zzbwb().zzbxf()));
                    zzae.this.zzacw();
                }
                catch (RemoteException remoteException) {
                    zzae.this.zzbwb().zzbwy().zzj("Failed to send app launch to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AppMeasurement.zzf zzf2) {
        this.zzzx();
        this.zzacj();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzm zzm2 = zzae.this.avt;
                if (zzm2 == null) {
                    zzae.this.zzbwb().zzbwy().log("Failed to send current screen to service");
                    return;
                }
                try {
                    if (zzf2 == null) {
                        zzm2.zza(0L, null, null, zzae.this.getContext().getPackageName());
                    } else {
                        zzm2.zza(zzf2.aqB, zzf2.aqz, zzf2.aqA, zzae.this.getContext().getPackageName());
                    }
                    zzae.this.zzacw();
                }
                catch (RemoteException remoteException) {
                    zzae.this.zzbwb().zzbwy().zzj("Failed to send current screen to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzacw() {
        this.zzzx();
        this.avw.start();
        if (!false) {
            this.avv.zzx(this.zzbwd().zzaez());
        }
    }

    @WorkerThread
    void zzadl() {
        this.zzzx();
        this.zzacj();
        if (this.isConnected()) {
            return;
        }
        if (this.avu == null) {
            this.avu = this.zzbwc().zzbxl();
            if (this.avu == null) {
                this.zzbwb().zzbxe().log("State of service unknown");
                this.avu = this.zzbyx();
                this.zzbwc().zzcg(this.avu);
            }
        }
        if (this.avu.booleanValue()) {
            this.zzbwb().zzbxe().log("Using measurement service");
            this.avs.zzbza();
        } else {
            if (!false && this.zzbyw()) {
                this.zzbwb().zzbxe().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                Context context = this.getContext();
                this.zzbwd().zzayi();
                intent.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                this.avs.zzac(intent);
                return;
            }
            this.zzbwb().zzbwy().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    private boolean zzbyw() {
        this.zzbwd().zzayi();
        PackageManager packageManager = this.getContext().getPackageManager();
        Intent intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzbyx() {
        this.zzzx();
        this.zzacj();
        this.zzbwd().zzayi();
        this.zzbwb().zzbxe().log("Checking service availability");
        int n = zzc.zzaql().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzbwb().zzbxe().log("Service available");
                return true;
            }
            case 1: {
                this.zzbwb().zzbxe().log("Service missing");
                return false;
            }
            case 18: {
                this.zzbwb().zzbxa().log("Service updating");
                return true;
            }
            case 2: {
                this.zzbwb().zzbxd().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzbwb().zzbxa().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzbwb().zzbxa().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzm zzm2) {
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzm2);
        this.avt = zzm2;
        this.zzacw();
        this.zzbyz();
    }

    @WorkerThread
    public void disconnect() {
        this.zzzx();
        this.zzacj();
        try {
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzaxr();
            zza2.zza(this.getContext(), (ServiceConnection)this.avs);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        this.avt = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzzx();
        if (this.avt != null) {
            this.avt = null;
            this.zzbwb().zzbxe().zzj("Disconnected from device MeasurementService", componentName);
            this.zzbyy();
        }
    }

    @WorkerThread
    private void zzacx() {
        this.zzzx();
        if (!this.isConnected()) {
            return;
        }
        this.zzbwb().zzbxe().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private void zzbyy() {
        this.zzzx();
        this.zzadl();
    }

    @WorkerThread
    private void zzo(Runnable runnable) throws IllegalStateException {
        this.zzzx();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.avx.size() >= this.zzbwd().zzbuy()) {
                this.zzbwb().zzbwy().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.avx.add(runnable);
            if (!false) {
                this.avy.zzx(60000L);
            }
            this.zzadl();
        }
    }

    @WorkerThread
    private void zzbyz() {
        this.zzzx();
        this.zzbwb().zzbxe().zzj("Processing queued up service tasks", this.avx.size());
        for (Runnable runnable : this.avx) {
            this.zzbwa().zzm(runnable);
        }
        this.avx.clear();
        this.avy.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zze.zzb,
    zze.zzc {
        private volatile boolean avE;
        private volatile zzp avF;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzac(Intent intent) {
            zzae.this.zzzx();
            Context context = zzae.this.getContext();
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzaxr();
            zza zza3 = this;
            synchronized (zza3) {
                if (this.avE) {
                    zzae.this.zzbwb().zzbxe().log("Connection attempt already in progress");
                    return;
                }
                this.avE = true;
                zza2.zza(context, intent, (ServiceConnection)zzae.this.avs, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            com.google.android.gms.common.internal.zzaa.zzhs((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.avE = false;
                    zzae.this.zzbwb().zzbwy().log("Service connected with null binder");
                    return;
                }
                zzm zzm2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzm2 = zzm.zza.zzjp(iBinder);
                        zzae.this.zzbwb().zzbxe().log("Bound to IMeasurementService interface");
                    } else {
                        zzae.this.zzbwb().zzbwy().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzae.this.zzbwb().zzbwy().log("Service connect failed to get IMeasurementService");
                }
                if (zzm2 == null) {
                    this.avE = false;
                    try {
                        com.google.android.gms.common.stats.zza.zzaxr().zza(zzae.this.getContext(), (ServiceConnection)zzae.this.avs);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzm2;
                    zzae.this.zzbwa().zzm(new Runnable((zzm)object){
                        final /* synthetic */ zzm avG;
                        {
                            this.avG = zzm2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.avE = false;
                                if (!zzae.this.isConnected()) {
                                    zzae.this.zzbwb().zzbxe().log("Connected to service");
                                    zzae.this.zza(this.avG);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            com.google.android.gms.common.internal.zzaa.zzhs((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzae.this.zzbwb().zzbxd().log("Service disconnected");
            zzae.this.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    zzae.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzbza() {
            zzae.this.zzzx();
            Context context = zzae.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.avE) {
                    zzae.this.zzbwb().zzbxe().log("Connection attempt already in progress");
                    return;
                }
                if (this.avF != null) {
                    zzae.this.zzbwb().zzbxe().log("Already awaiting connection attempt");
                    return;
                }
                this.avF = new zzp(context, Looper.getMainLooper(), this, this);
                zzae.this.zzbwb().zzbxe().log("Connecting to remote service");
                this.avE = true;
                this.avF.zzavd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            com.google.android.gms.common.internal.zzaa.zzhs((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzm zzm2 = (zzm)this.avF.zzavg();
                    this.avF = null;
                    zzae.this.zzbwa().zzm(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.avE = false;
                                if (!zzae.this.isConnected()) {
                                    zzae.this.zzbwb().zzbxd().log("Connected to remote service");
                                    zzae.this.zza(zzm2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.avF = null;
                    this.avE = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            com.google.android.gms.common.internal.zzaa.zzhs((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzae.this.zzbwb().zzbxd().log("Service connection suspended");
            zzae.this.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    zzae zzae2 = zzae.this;
                    Context context = zzae.this.getContext();
                    zzae.this.zzbwd().zzayi();
                    zzae2.onServiceDisconnected(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            com.google.android.gms.common.internal.zzaa.zzhs((String)"MeasurementServiceConnection.onConnectionFailed");
            zzq zzq2 = zzae.this.aqw.zzbxr();
            if (zzq2 != null) {
                zzq2.zzbxa().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.avE = false;
                this.avF = null;
            }
        }
    }
}

