/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;

public final class zzaf {
    private final Handler mHandler;
    private final Context mContext;
    private final zza avJ;

    public zzaf(zza zza2) {
        this.mContext = zza2.getContext();
        zzaa.zzy((Object)this.mContext);
        this.avJ = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzi(Context context, boolean bl) {
        zzaa.zzy((Object)context);
        return zzal.zzr(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public void onCreate() {
        zzx zzx2 = zzx.zzdq(this.mContext);
        zzq zzq2 = zzx2.zzbwb();
        zzx2.zzbwd().zzayi();
        zzq2.zzbxe().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public void onDestroy() {
        zzx zzx2 = zzx.zzdq(this.mContext);
        zzq zzq2 = zzx2.zzbwb();
        zzx2.zzbwd().zzayi();
        zzq2.zzbxe().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public int onStartCommand(Intent intent, int n, final int n2) {
        final zzx zzx2 = zzx.zzdq(this.mContext);
        final zzq zzq2 = zzx2.zzbwb();
        if (intent == null) {
            zzq2.zzbxa().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzx2.zzbwd().zzayi();
        zzq2.zzbxe().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzx2.zzbwa().zzm(new Runnable(){

                @Override
                public void run() {
                    zzx2.zzbyj();
                    zzx2.zzbye();
                    zzaf.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzaf.this.avJ.callServiceStopSelfResult(n2);
                            if (bl) {
                                zzx2.zzbwd().zzayi();
                                zzq2.zzbxe().log("Local AppMeasurementService processed last upload request");
                            }
                        }
                    });
                }
            });
        }
        return 2;
    }

    @MainThread
    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzbwb().zzbwy().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzy(zzx.zzdq(this.mContext));
        }
        this.zzbwb().zzbxa().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzbwb().zzbwy().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzbwb().zzbxe().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzbwb().zzbwy().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzbwb().zzbxe().zzj("onRebind called. action", string);
    }

    private zzq zzbwb() {
        return zzx.zzdq(this.mContext).zzbwb();
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

