/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzars;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzasa;
import com.google.android.gms.internal.zzwa;
import com.google.android.gms.internal.zzwc;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zze
extends zzaa {
    private static final Map<String, String> arj = new ArrayMap(17);
    private static final Map<String, String> ark;
    private static final Map<String, String> arl;
    private static final Map<String, String> arm;
    private final zzc arn;
    private final zzah aro = new zzah(this.zzabz());

    zze(zzx zzx2) {
        super(zzx2);
        String string = this.zzade();
        this.arn = new zzc(this.getContext(), string);
    }

    @Override
    protected void zzzy() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zzacj();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zzacj();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zzacj();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzbwb().zzbwy().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzzx();
        try {
            return this.arn.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbxa().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    String zzade() {
        return this.zzbwd().zzafe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzi zzap(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        this.zzzx();
        this.zzacj();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzi zzi2 = new zzi(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzbwb().zzbwy().log("Got multiple records for event aggregates, expected one");
            }
            zzi zzi3 = zzi2;
            return zzi3;
        }
    }

    @WorkerThread
    public void zza(zzi zzi2) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzi2);
        this.zzzx();
        this.zzacj();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzi2.zzctj);
        contentValues.put("name", zzi2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzi2.arD));
        contentValues.put("current_bundle_count", Long.valueOf(zzi2.arE));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzi2.arF));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert/update event aggregates (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing event aggregates", (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzaq(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        this.zzzx();
        this.zzacj();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzbwb().zzbxe().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzd("Error deleting user attribute", string, string2, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzz(String string, int n) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string, string, String.valueOf(n)});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zze("Error pruning currencies", string, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public boolean zza(zzak zzak2) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzak2);
        this.zzzx();
        this.zzacj();
        zzak zzak3 = this.zzar(zzak2.zzctj, zzak2.mName);
        if (zzak3 == null) {
            long l;
            if (zzal.zzmu(zzak2.mName)) {
                l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzak2.zzctj});
                this.zzbwd().zzbun();
                if (l >= 25L) {
                    return false;
                }
            } else {
                l = this.zzb("select count(1) from user_attributes where app_id=?", new String[]{zzak2.zzctj});
                this.zzbwd().zzbuo();
                if (l >= 50L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzak2.zzctj);
        contentValues.put("name", zzak2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzak2.avX));
        this.zza(contentValues, "value", zzak2.zzcyd);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert/update user property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing user property", (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzak zzar(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        this.zzzx();
        this.zzacj();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"set_timestamp", "value"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var5_6 = null;
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            zzak zzak2 = new zzak(string, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzbwb().zzbwy().log("Got multiple records for user property, expected one");
            }
            zzak zzak3 = zzak2;
            return zzak3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzak> zzly(String string) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        ArrayList<zzak> arrayList = new ArrayList<zzak>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzbwd().zzbuo()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzak> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzbwb().zzbwy().log("Read invalid user property value, ignoring it");
                    continue;
                }
                zzak zzak2 = new zzak(string, (String)object, l, object2);
                arrayList.add(zzak2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public com.google.android.gms.measurement.internal.zza zzlz(String string) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            com.google.android.gms.measurement.internal.zza zza2 = new com.google.android.gms.measurement.internal.zza(this.aqw, string);
            zza2.zzlj(cursor.getString(0));
            zza2.zzlk(cursor.getString(1));
            zza2.zzll(cursor.getString(2));
            zza2.zzba(cursor.getLong(3));
            zza2.zzav(cursor.getLong(4));
            zza2.zzaw(cursor.getLong(5));
            zza2.setAppVersion(cursor.getString(6));
            zza2.zzln(cursor.getString(7));
            zza2.zzay(cursor.getLong(8));
            zza2.zzaz(cursor.getLong(9));
            zza2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zza2.zzbd(cursor.getLong(11));
            zza2.zzbe(cursor.getLong(12));
            zza2.zzbf(cursor.getLong(13));
            zza2.zzbg(cursor.getLong(14));
            zza2.zzbb(cursor.getLong(15));
            zza2.zzbc(cursor.getLong(16));
            zza2.zzax(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zza2.zzlm(cursor.getString(18));
            zza2.zzbi(cursor.getLong(19));
            zza2.zzbh(cursor.getLong(20));
            zza2.zzbtg();
            if (cursor.moveToNext()) {
                this.zzbwb().zzbwy().log("Got multiple records for app, expected one");
            }
            com.google.android.gms.measurement.internal.zza zza3 = zza2;
            return zza3;
        }
    }

    @WorkerThread
    public void zza(com.google.android.gms.measurement.internal.zza zza2) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)zza2);
        this.zzzx();
        this.zzacj();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zza2.zzup());
        contentValues.put("app_instance_id", zza2.zzazn());
        contentValues.put("gmp_app_id", zza2.zzbth());
        contentValues.put("resettable_device_id_hash", zza2.zzbti());
        contentValues.put("last_bundle_index", Long.valueOf(zza2.zzbtr()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zza2.zzbtk()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zza2.zzbtl()));
        contentValues.put("app_version", zza2.zzaaf());
        contentValues.put("app_store", zza2.zzbtn());
        contentValues.put("gmp_version", Long.valueOf(zza2.zzbto()));
        contentValues.put("dev_cert_hash", Long.valueOf(zza2.zzbtp()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zza2.zzbtq()));
        contentValues.put("day", Long.valueOf(zza2.zzbtv()));
        contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzbtw()));
        contentValues.put("daily_events_count", Long.valueOf(zza2.zzbtx()));
        contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzbty()));
        contentValues.put("config_fetched_time", Long.valueOf(zza2.zzbts()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zza2.zzbtt()));
        contentValues.put("app_version_int", Long.valueOf(zza2.zzbtm()));
        contentValues.put("firebase_instance_id", zza2.zzbtj());
        contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzbua()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zza2.zzbtz()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert/update app (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing app", (Object)sQLiteException);
        }
    }

    public long zzma(String string) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = String.valueOf(this.zzbwd().zzlx(string));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error deleting over the limit events", (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        String[] stringArray = new String[]{string};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzbwb().zzbxa().zzj("Not updating daily counts, app is not known", string);
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.arq = cursor.getLong(1);
                zza2.arp = cursor.getLong(2);
                zza2.arr = cursor.getLong(3);
                zza2.ars = cursor.getLong(4);
                zza2.art = cursor.getLong(5);
            }
            if (bl) {
                ++zza2.arq;
            }
            if (bl2) {
                ++zza2.arp;
            }
            if (bl3) {
                ++zza2.arr;
            }
            if (bl4) {
                ++zza2.ars;
            }
            if (bl5) {
                ++zza2.art;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.arp));
            contentValues.put("daily_events_count", Long.valueOf(zza2.arq));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.arr));
            contentValues.put("daily_error_events_count", Long.valueOf(zza2.ars));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zza2.art));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string, byte[] byArray) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string});
            if (l == 0L) {
                this.zzbwb().zzbwy().log("Failed to update remote config (got 0)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing remote config", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzmb(String string) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_5 = null;
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzbwb().zzbwy().log("Got multiple records for app config, expected one");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public void zza(zzwc.zze zze2, boolean bl) {
        byte[] byArray;
        Object object;
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zze2));
        com.google.android.gms.common.internal.zzaa.zzib((String)zze2.zzcs);
        com.google.android.gms.common.internal.zzaa.zzy((Object)zze2.awZ);
        this.zzbwg();
        long l = this.zzabz().currentTimeMillis();
        if (zze2.awZ < l - this.zzbwd().zzbuv() || zze2.awZ > l + this.zzbwd().zzbuv()) {
            this.zzbwb().zzbxa().zze("Storing bundle outside of the max uploading time span. now, timestamp", l, zze2.awZ);
        }
        try {
            int n = zze2.cz();
            object = new byte[n];
            zzart zzart2 = zzart.zzbe((byte[])object);
            zze2.zza(zzart2);
            zzart2.cm();
            byArray = this.zzbvx().zzk((byte[])object);
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Data loss. Failed to serialize bundle", iOException);
            return;
        }
        this.zzbwb().zzbxe().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzcs);
        contentValues.put("bundle_end_timestamp", zze2.awZ);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert bundle (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing bundle", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzbwe() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue where app_id not in (select app_id from apps where measurement_enabled=0) order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            Object var4_6 = null;
            return null;
        }
    }

    public boolean zzbwf() {
        long l = this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null);
        return l != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzwc.zze, Long>> zzn(String string, int n, int n2) {
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzbt((n > 0 ? 1 : 0) != 0);
        com.google.android.gms.common.internal.zzaa.zzbt((n2 > 0 ? 1 : 0) != 0);
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzwc.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzwc.zze, Long>> arrayList = new ArrayList<Pair<zzwc.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzbvx().zzx((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzbwb().zzbwy().zze("Failed to unzip queued bundle", string, iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzars.zzbd((byte[])byArray);
                zzwc.zze zze2 = new zzwc.zze();
                try {
                    zzwc.zze cfr_ignored_0 = (zzwc.zze)zze2.zzb((zzars)object);
                }
                catch (IOException iOException) {
                    this.zzbwb().zzbwy().zze("Failed to merge queued bundle", string, iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzwc.zze, Long>)Pair.create((Object)((Object)zze2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzwc.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzbj(long l) {
        this.zzzx();
        this.zzacj();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzbwb().zzbwy().log("Deleted fewer rows from queue than expected");
        }
    }

    @WorkerThread
    void zzbwg() {
        this.zzzx();
        this.zzacj();
        if (!this.zzbwn()) {
            return;
        }
        long l = this.zzbwc().atc.get();
        long l2 = this.zzabz().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzbwd().zzbuw()) {
            this.zzbwc().atc.set(l2);
            this.zzbwh();
        }
    }

    @WorkerThread
    void zzbwh() {
        this.zzzx();
        this.zzacj();
        if (!this.zzbwn()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zzabz().currentTimeMillis()), String.valueOf(this.zzbwd().zzbuv())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzbwb().zzbxe().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, zzwa.zza[] zzaArray) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzmc(string);
            for (zzwa.zza zza2 : zzaArray) {
                this.zza(string, zza2);
            }
            ArrayList arrayList = new ArrayList();
            for (zzwa.zza zza3 : zzaArray) {
                arrayList.add(zza3.avZ);
            }
            this.zzc(string, arrayList);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzmc(String string) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string});
    }

    @WorkerThread
    void zzaa(String string, int n) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string, zzwa.zza zza2) {
        void var7_13;
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zza2));
        com.google.android.gms.common.internal.zzaa.zzy((Object)zza2.awb);
        com.google.android.gms.common.internal.zzaa.zzy((Object)zza2.awa);
        if (zza2.avZ == null) {
            this.zzbwb().zzbxa().log("Audience with no ID");
            return;
        }
        int n = zza2.avZ;
        for (zzwa.zzb zzb2 : zza2.awb) {
            if (zzb2.awd != null) continue;
            this.zzbwb().zzbxa().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.avZ);
            return;
        }
        for (zzasa zzasa2 : zza2.awa) {
            if (zzasa2.awd != null) continue;
            this.zzbwb().zzbxa().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", string, zza2.avZ);
            return;
        }
        boolean bl = true;
        zzasa[] zzasaArray = zza2.awb;
        int n2 = zzasaArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzwa.zzb zzb2 = zzasaArray[var7_13];
            if (!this.zza(string, n, zzb2)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzasaArray = zza2.awa;
            n2 = zzasaArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzasa zzasa3 = zzasaArray[var7_15];
                if (!this.zza(string, n, (zzwa.zze)zzasa3)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzaa(string, n);
        }
    }

    @WorkerThread
    private boolean zza(String string, int n, zzwa.zzb zzb2) {
        zzart zzart2;
        byte[] byArray;
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.awe)) {
            this.zzbwb().zzbxa().zze("Event filter had no event name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zzb2.awd));
            return false;
        }
        try {
            int n2 = zzb2.cz();
            byArray = new byte[n2];
            zzart2 = zzart.zzbe((byte[])byArray);
            zzb2.zza(zzart2);
            zzart2.cm();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Configuration loss. Failed to serialize event filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.awd);
        contentValues.put("event_name", zzb2.awe);
        contentValues.put("data", byArray);
        try {
            zzart2 = this.getWritableDatabase();
            long l = zzart2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert event filter (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing event filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string, int n, zzwa.zze zze2) {
        zzart zzart2;
        byte[] byArray;
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.awt)) {
            this.zzbwb().zzbxa().zze("Property filter had no property name. Audience definition ignored. audienceId, filterId", n, String.valueOf(zze2.awd));
            return false;
        }
        try {
            int n2 = zze2.cz();
            byArray = new byte[n2];
            zzart2 = zzart.zzbe((byte[])byArray);
            zze2.zza(zzart2);
            zzart2.cm();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Configuration loss. Failed to serialize property filter", iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.awd);
        contentValues.put("property_name", zze2.awt);
        contentValues.put("data", byArray);
        try {
            zzart2 = this.getWritableDatabase();
            long l = zzart2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert property filter (got -1)");
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing property filter", (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzwa.zzb>> zzas(String string, String string2) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzwa.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzars zzars2 = zzars.zzbd((byte[])byArray);
                zzwa.zzb zzb2 = new zzwa.zzb();
                try {
                    zzwa.zzb cfr_ignored_0 = (zzwa.zzb)zzb2.zzb(zzars2);
                }
                catch (IOException iOException) {
                    this.zzbwb().zzbwy().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzwa.zzb> arrayList = (ArrayList<zzwa.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzwa.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzwa.zze>> zzat(String string, String string2) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzwa.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzars zzars2 = zzars.zzbd((byte[])byArray);
                zzwa.zze zze2 = new zzwa.zze();
                try {
                    zzwa.zze cfr_ignored_0 = (zzwa.zze)zze2.zzb(zzars2);
                }
                catch (IOException iOException) {
                    this.zzbwb().zzbwy().zze("Failed to merge filter", string, iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzwa.zze> arrayList = (ArrayList<zzwa.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzwa.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzacj();
        this.zzzx();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Database error querying filters", (Object)sQLiteException);
            return false;
        }
        int n = this.zzbwd().zzlt(string);
        if (l <= (long)n) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object == null || !(object instanceof Integer)) {
                    return false;
                }
                arrayList.add(Integer.toString((Integer)object));
            }
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string2 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        int n2 = sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string2).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string2).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n)});
        return n2 > 0;
    }

    void zza(String string, int n, zzwc.zzf zzf2) {
        zzart zzart2;
        byte[] byArray;
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zzf2));
        try {
            int n2 = zzf2.cz();
            byArray = new byte[n2];
            zzart2 = zzart.zzbe((byte[])byArray);
            zzf2.zza(zzart2);
            zzart2.cm();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Configuration loss. Failed to serialize filter results", iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzart2 = this.getWritableDatabase();
            long l = zzart2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert filter results (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing filter results", (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, zzwc.zzf> zzmd(String string) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                Object var4_4 = null;
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzars zzars2 = zzars.zzbd((byte[])byArray);
                zzwc.zzf zzf2 = new zzwc.zzf();
                try {
                    zzwc.zzf cfr_ignored_0 = (zzwc.zzf)zzf2.zzb(zzars2);
                }
                catch (IOException iOException) {
                    this.zzbwb().zzbwy().zzd("Failed to merge filter results. appId, audienceId, error", string, n, iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    void zzme(String string) {
        this.zzacj();
        this.zzzx();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0;
            String[] stringArray = new String[]{string};
            n = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("apps", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("event_filters", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("property_filters", "app_id=?", stringArray);
            if ((n += sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray)) > 0) {
                this.zzbwb().zzbxe().zze("Deleted application data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zze("Error deleting application data. appId, error", string, (Object)sQLiteException);
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string, Object object) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzy((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Double) {
            contentValues.put(string, (Double)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zze.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzbwb().zzbwy().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzbwb().zzbwy().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzbwb().zzbwy().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzbwi() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public long zzmf(String string) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        this.zzzx();
        this.zzacj();
        return this.zzau(string, "first_open_count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected long zzau(String string, String string2) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        com.google.android.gms.common.internal.zzaa.zzib((String)string2);
        this.zzzx();
        this.zzacj();
        long l = 0L;
        long l2 = -1L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            long l3;
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                l3 = sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5);
                if (l3 == -1L) {
                    this.zzbwb().zzbwy().zzj("Failed to insert column (got -1)", string2);
                    long l4 = -1L;
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            l3 = sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string});
            if (l3 == 0L) {
                this.zzbwb().zzbwy().zzj("Failed to update column (got 0)", string2);
                long l5 = -1L;
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zze("Error inserting column", string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public long zzbwj() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zza(zzwc.zze zze2) throws IOException {
        byte[] byArray;
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zze2));
        com.google.android.gms.common.internal.zzaa.zzib((String)zze2.zzcs);
        try {
            int n = zze2.cz();
            byArray = new byte[n];
            zzart zzart2 = zzart.zzbe((byte[])byArray);
            zze2.zza(zzart2);
            zzart2.cm();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Data loss. Failed to serialize event metadata", iOException);
            throw iOException;
        }
        long l = this.zzbvx().zzz(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzcs);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing raw event metadata", (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzbwk() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public boolean zzbwl() {
        long l = this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null);
        return l != 0L;
    }

    public void zzaf(List<Long> list) {
        com.google.android.gms.common.internal.zzaa.zzy(list);
        this.zzzx();
        this.zzacj();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzbwb().zzbwy().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzmg(String string) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string, string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Failed to remove unused event metadata", (Object)sQLiteException);
        }
    }

    public long zzmh(String string) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzbk(long l) {
        this.zzzx();
        this.zzacj();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzbwb().zzbxe().log("No expired configs for apps with pending events");
                Object var5_5 = null;
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zzbwm() {
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                long l = -1L;
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, long l, long l2, zzb zzb2) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzb2);
        this.zzzx();
        this.zzacj();
        try (Cursor cursor = null;){
            String[] stringArray;
            String string2;
            String string3;
            String string4;
            Object[] objectArray;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string)) {
                objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l)} : new String[]{String.valueOf(l)};
                string4 = l2 != -1L ? "rowid <= ? and " : "";
                cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                if (!cursor.moveToFirst()) {
                    return;
                }
                string = cursor.getString(0);
                string3 = cursor.getString(1);
                cursor.close();
            } else {
                objectArray = l2 != -1L ? new String[]{string, String.valueOf(l2)} : new String[]{string};
                string4 = l2 != -1L ? " and rowid <= ?" : "";
                cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), objectArray);
                if (!cursor.moveToFirst()) {
                    return;
                }
                string3 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string, string3}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzbwb().zzbwy().log("Raw event metadata record is missing");
                return;
            }
            objectArray = cursor.getBlob(0);
            string4 = zzars.zzbd((byte[])objectArray);
            zzwc.zze zze2 = new zzwc.zze();
            try {
                zzwc.zze cfr_ignored_0 = (zzwc.zze)zze2.zzb((zzars)string4);
            }
            catch (IOException iOException) {
                this.zzbwb().zzbwy().zze("Data loss. Failed to merge raw event metadata", string, iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzbwb().zzbxa().log("Get multiple raw event metadata records, expected one");
            }
            cursor.close();
            zzb2.zzb(zze2);
            if (l2 != -1L) {
                string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                stringArray = new String[]{string, string3, String.valueOf(l2)};
            } else {
                string2 = "app_id = ? and metadata_fingerprint = ?";
                stringArray = new String[]{string, string3};
            }
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzbwb().zzbxa().log("Raw event data disappeared while in transaction");
                return;
            }
            do {
                long l3 = cursor.getLong(0);
                objectArray = cursor.getBlob(3);
                string4 = zzars.zzbd((byte[])objectArray);
                zzwc.zzb zzb3 = new zzwc.zzb();
                try {
                    zzwc.zzb cfr_ignored_1 = (zzwc.zzb)zzb3.zzb((zzars)string4);
                }
                catch (IOException iOException) {
                    this.zzbwb().zzbwy().zze("Data loss. Failed to merge raw event", string, iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.awO = cursor.getLong(2);
                if (zzb2.zza(l3, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public void zza(zzh zzh2, long l, boolean bl) {
        Object object;
        zzwc.zzc zzc2;
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzh2);
        com.google.android.gms.common.internal.zzaa.zzib((String)zzh2.zzctj);
        zzwc.zzb zzb2 = new zzwc.zzb();
        zzb2.awP = zzh2.arB;
        zzb2.awN = new zzwc.zzc[zzh2.arC.size()];
        int n = 0;
        for (String string : zzh2.arC) {
            zzc2 = new zzwc.zzc();
            zzb2.awN[n++] = zzc2;
            zzc2.name = string;
            Object object2 = zzh2.arC.get(string);
            this.zzbvx().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.cz();
            object = new byte[n2];
            zzc2 = zzart.zzbe((byte[])object);
            zzb2.zza((zzart)zzc2);
            zzc2.cm();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Data loss. Failed to serialize event params/data", iOException);
            return;
        }
        this.zzbwb().zzbxe().zze("Saving event, name, data size", zzh2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzh2.zzctj);
        contentValues.put("name", zzh2.mName);
        contentValues.put("timestamp", Long.valueOf(zzh2.vO));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzbwb().zzbwy().log("Failed to insert raw event (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzbwb().zzbwy().zzj("Error storing raw event", (Object)sQLiteException);
        }
    }

    private boolean zzbwn() {
        return this.getContext().getDatabasePath(this.zzade()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static boolean zza(zzq zzq2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzq2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    static void zza(zzq zzq2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzq2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zze.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzq2.zzbxa().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzq zzq2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzq2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zze.zza(zzq2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zze.zza(zzq2, sQLiteDatabase, string, string3, map);
        }
        catch (SQLiteException sQLiteException) {
            zzq2.zzbwy().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzq zzq2, SQLiteDatabase sQLiteDatabase) {
        if (zzq2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (Build.VERSION.SDK_INT >= 9) {
            File file = new File(sQLiteDatabase.getPath());
            if (!file.setReadable(false, false)) {
                zzq2.zzbxa().log("Failed to turn off database read permission");
            }
            if (!file.setWritable(false, false)) {
                zzq2.zzbxa().log("Failed to turn off database write permission");
            }
            if (!file.setReadable(true, true)) {
                zzq2.zzbxa().log("Failed to turn on database read permission for owner");
            }
            if (!file.setWritable(true, true)) {
                zzq2.zzbxa().log("Failed to turn on database write permission for owner");
            }
        }
    }

    static {
        arj.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        arj.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        arj.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        arj.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        arj.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        arj.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        arj.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        arj.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        arj.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        arj.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        arj.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        arj.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        arj.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        arj.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        arj.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        arj.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        arj.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        ark = new ArrayMap(1);
        ark.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        arl = new ArrayMap(1);
        arl.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        arm = new ArrayMap(1);
        arm.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zze.this.aro.zzz(zze.this.zzbwd().zzbup())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zze.this.aro.start();
                zze.this.zzbwb().zzbwy().log("Opening the database failed, dropping and recreating it");
                String string = zze.this.zzade();
                if (!zze.this.getContext().getDatabasePath(string).delete()) {
                    zze.this.zzbwb().zzbwy().zzj("Failed to delete corrupted db file", string);
                }
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zze.this.aro.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zze.this.zzbwb().zzbwy().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", arj);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", arl);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", ark);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
            zze.zza(zze.this.zzbwb(), sQLiteDatabase, "app2", "CREATE TABLE IF NOT EXISTS app2 ( app_id TEXT NOT NULL, first_open_count INTEGER NOT NULL, PRIMARY KEY (app_id));", "app_id,first_open_count", arm);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zze.zza(zze.this.zzbwb(), sQLiteDatabase);
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    static interface zzb {
        public void zzb(zzwc.zze var1);

        public boolean zza(long var1, zzwc.zzb var3);
    }

    public static class zza {
        long arp;
        long arq;
        long arr;
        long ars;
        long art;
    }
}

