/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzyx;
import com.google.android.gms.internal.measurement.zzyy;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbn;
import com.google.android.gms.measurement.internal.zzbo;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzy;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzfa
implements zzcq {
    private static volatile zzfa zzatc;
    private zzbn zzatd;
    private zzat zzate;
    private zzq zzatf;
    private zzay zzatg;
    private zzew zzath;
    private zzj zzati;
    private final zzfg zzatj;
    private final zzbt zzadj;
    private boolean zzvz = false;
    private boolean zzatk;
    @VisibleForTesting
    private long zzatl;
    private List<Runnable> zzatm;
    private int zzatn;
    private int zzato;
    private boolean zzatp;
    private boolean zzatq;
    private boolean zzatr;
    private FileLock zzats;
    private FileChannel zzatt;
    private List<Long> zzatu;
    private List<Long> zzatv;
    private long zzatw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzfa zzm(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzatc != null) return zzatc;
        Class<zzfa> clazz = zzfa.class;
        synchronized (zzfa.class) {
            if (zzatc != null) return zzatc;
            zzff zzff2 = new zzff(context);
            zzatc = new zzfa(zzff2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzatc;
        }
    }

    private zzfa(zzff zzff2) {
        this(zzff2, null);
    }

    private zzfa(zzff zzff2, zzbt zzbt2) {
        Preconditions.checkNotNull((Object)zzff2);
        this.zzadj = zzbt2 = zzbt.zza((Context)zzff2.zzri, null);
        this.zzatw = -1L;
        zzfa zzfa2 = this;
        zzfg zzfg2 = new zzfg(zzfa2);
        zzfg2.zzq();
        this.zzatj = zzfg2;
        zzfa2 = this;
        zzat zzat2 = new zzat(zzfa2);
        zzat2.zzq();
        this.zzate = zzat2;
        zzfa2 = this;
        zzbn zzbn2 = new zzbn(zzfa2);
        zzbn2.zzq();
        this.zzatd = zzbn2;
        this.zzadj.zzgn().zzc((Runnable)new zzfb(this, zzff2));
    }

    @WorkerThread
    private final void zza(zzff zzff2) {
        this.zzadj.zzgn().zzaf();
        zzfa zzfa2 = this;
        zzq zzq2 = new zzq(zzfa2);
        zzq2.zzq();
        this.zzatf = zzq2;
        this.zzadj.zzgq().zza((zzp)this.zzatd);
        zzfa2 = this;
        zzj zzj2 = new zzj(zzfa2);
        zzj2.zzq();
        this.zzati = zzj2;
        zzfa2 = this;
        zzew zzew2 = new zzew(zzfa2);
        zzew2.zzq();
        this.zzath = zzew2;
        zzfa2 = this;
        this.zzatg = new zzay(zzfa2);
        if (this.zzatn != this.zzato) {
            this.zzadj.zzgo().zzjd().zze("Not all upload components initialized", (Object)this.zzatn, (Object)this.zzato);
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        this.zzadj.zzgn().zzaf();
        this.zzjq().zzif();
        if (this.zzadj.zzgp().zzane.get() == 0L) {
            this.zzadj.zzgp().zzane.set(this.zzadj.zzbx().currentTimeMillis());
        }
        this.zzlv();
    }

    public final zzk zzgr() {
        return this.zzadj.zzgr();
    }

    public final zzn zzgq() {
        return this.zzadj.zzgq();
    }

    public final zzap zzgo() {
        return this.zzadj.zzgo();
    }

    public final zzbo zzgn() {
        return this.zzadj.zzgn();
    }

    private final zzbn zzln() {
        zzfa.zza(this.zzatd);
        return this.zzatd;
    }

    public final zzat zzlo() {
        zzfa.zza(this.zzate);
        return this.zzate;
    }

    public final zzq zzjq() {
        zzfa.zza(this.zzatf);
        return this.zzatf;
    }

    private final zzay zzlp() {
        if (this.zzatg == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzatg;
    }

    private final zzew zzlq() {
        zzfa.zza(this.zzath);
        return this.zzath;
    }

    public final zzj zzjp() {
        zzfa.zza(this.zzati);
        return this.zzati;
    }

    public final zzfg zzjo() {
        zzfa.zza(this.zzatj);
        return this.zzatj;
    }

    public final zzan zzgl() {
        return this.zzadj.zzgl();
    }

    public final Context getContext() {
        return this.zzadj.getContext();
    }

    public final Clock zzbx() {
        return this.zzadj.zzbx();
    }

    public final zzfk zzgm() {
        return this.zzadj.zzgm();
    }

    @WorkerThread
    private final void zzaf() {
        this.zzadj.zzgn().zzaf();
    }

    final void zzlr() {
        if (!this.zzvz) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzez zzez2) {
        if (zzez2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzez2.isInitialized()) {
            String string = String.valueOf(((Object)((Object)zzez2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzh zzh2) {
        this.zzaf();
        this.zzlr();
        Preconditions.checkNotEmpty((String)zzh2.packageName);
        this.zzg(zzh2);
    }

    private final long zzls() {
        long l = this.zzadj.zzbx().currentTimeMillis();
        zzba zzba2 = this.zzadj.zzgp();
        zzba2.zzcl();
        zzba2.zzaf();
        long l2 = zzba2.zzani.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzba2.zzgm().zzmd().nextInt(86400000);
            zzba2.zzani.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzc(zzad zzad2, String string) {
        zzg zzg2 = this.zzjq().zzbl(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzak())) {
            this.zzadj.zzgo().zzjk().zzg("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzad2.name)) {
                this.zzadj.zzgo().zzjg().zzg("Could not find package. appId", zzap.zzbv((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzadj.zzgo().zzjd().zzg("App version does not match; dropping event. appId", zzap.zzbv((String)string));
            return;
        }
        zzh zzh2 = new zzh(string, zzg2.getGmpAppId(), zzg2.zzak(), zzg2.zzha(), zzg2.zzhb(), zzg2.zzhc(), zzg2.zzhd(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzhq(), 0L, 0, zzg2.zzhr(), zzg2.zzhs(), false, zzg2.zzgw());
        this.zzc(zzad2, zzh2);
    }

    @WorkerThread
    final void zzc(zzad zzad2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzh2);
        Preconditions.checkNotEmpty((String)zzh2.packageName);
        this.zzaf();
        this.zzlr();
        String string = zzh2.packageName;
        long l = zzad2.zzaip;
        if (!this.zzjo().zze(zzad2, zzh2)) {
            return;
        }
        if (!zzh2.zzagg) {
            this.zzg(zzh2);
            return;
        }
        this.zzjq().beginTransaction();
        try {
            zzl zzl2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzq zzq2 = this.zzjq();
            Preconditions.checkNotEmpty((String)string3);
            zzq2.zzaf();
            zzq2.zzcl();
            if (l2 < 0L) {
                zzq2.zzgo().zzjg().zze("Invalid time querying timed out conditional properties", zzap.zzbv((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzq2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzadj.zzgo().zzjk().zzd("User property timed out", (Object)((zzl)object22).packageName, (Object)this.zzadj.zzgl().zzbu(((zzl)object22).zzahb.name), ((zzl)object22).zzahb.getValue());
                if (((zzl)object22).zzahc != null) {
                    this.zzd(new zzad(((zzl)object22).zzahc, l), zzh2);
                }
                this.zzjq().zzk(string, ((zzl)object22).zzahb.name);
            }
            l2 = l;
            string3 = string;
            zzq2 = this.zzjq();
            Preconditions.checkNotEmpty((String)string3);
            zzq2.zzaf();
            zzq2.zzcl();
            if (l2 < 0L) {
                zzq2.zzgo().zzjg().zze("Invalid time querying expired conditional properties", zzap.zzbv((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzq2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzl)object4.next();
                if (object == null) continue;
                this.zzadj.zzgo().zzjk().zzd("User property expired", (Object)((zzl)object).packageName, (Object)this.zzadj.zzgl().zzbu(((zzl)object).zzahb.name), ((zzl)object).zzahb.getValue());
                this.zzjq().zzh(string, ((zzl)object).zzahb.name);
                if (((zzl)object).zzahe != null) {
                    object22.add(((zzl)object).zzahe);
                }
                this.zzjq().zzk(string, ((zzl)object).zzahb.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzad)e;
                this.zzd(new zzad((zzad)object, l), zzh2);
            }
            long l3 = l;
            String string4 = zzad2.name;
            string3 = string;
            zzq2 = this.zzjq();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzq2.zzaf();
            zzq2.zzcl();
            if (l3 < 0L) {
                zzq2.zzgo().zzjg().zzd("Invalid time querying triggered conditional properties", zzap.zzbv((String)string3), (Object)zzq2.zzgl().zzbs(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzq2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzl2 = (zzl)iterator.next();
                if (zzl2 == null) continue;
                zzfh zzfh2 = zzl2.zzahb;
                zzfj zzfj2 = new zzfj(zzl2.packageName, zzl2.origin, zzfh2.name, l, zzfh2.getValue());
                if (this.zzjq().zza(zzfj2)) {
                    this.zzadj.zzgo().zzjk().zzd("User property triggered", (Object)zzl2.packageName, (Object)this.zzadj.zzgl().zzbu(zzfj2.name), zzfj2.value);
                } else {
                    this.zzadj.zzgo().zzjd().zzd("Too many active user properties, ignoring", zzap.zzbv((String)zzl2.packageName), (Object)this.zzadj.zzgl().zzbu(zzfj2.name), zzfj2.value);
                }
                if (zzl2.zzahd != null) {
                    object.add(zzl2.zzahd);
                }
                zzl2.zzahb = new zzfh(zzfj2);
                zzl2.active = true;
                this.zzjq().zza(zzl2);
            }
            this.zzd(zzad2, zzh2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzl2 = (zzad)e;
                this.zzd(new zzad((zzad)zzl2, l), zzh2);
            }
            this.zzjq().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzd(zzad var1_1, zzh var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzaf();
        this.zzlr();
        var5_4 = var2_2.packageName;
        if (!this.zzjo().zze(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzagg) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzln().zzo(var5_4, var1_1.name)) {
            this.zzadj.zzgo().zzjg().zze("Dropping blacklisted event. appId", zzap.zzbv((String)var5_4), (Object)this.zzadj.zzgl().zzbs(var1_1.name));
            var6_5 = this.zzln().zzck(var5_4) != false || this.zzln().zzcl(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzadj.zzgm().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzjq().zzbl(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzhg(), var7_7.zzhf());
                if (Math.abs(this.zzadj.zzbx().currentTimeMillis() - var8_9) > (Long)zzaf.zzakc.get()) {
                    this.zzadj.zzgo().zzjk().zzbx("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzadj.zzgo().isLoggable(2)) {
            this.zzadj.zzgo().zzjl().zzg("Logging event", (Object)this.zzadj.zzgl().zzb(var1_1));
        }
        this.zzjq().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzjq().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzfk.zzcq((String)var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzjq().zza(this.zzls(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzahr - (long)((Integer)zzaf.zzajn.get()).intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzadj.zzgo().zzjd().zze("Data loss. Too many events logged. appId, count", zzap.zzbv((String)var5_4), (Object)var8_10.zzahr);
                        }
                        this.zzjq().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zzahq - (long)((Integer)zzaf.zzajp.get()).intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzadj.zzgo().zzjd().zze("Data loss. Too many public events logged. appId, count", zzap.zzbv((String)var5_4), (Object)var8_10.zzahq);
                        }
                        this.zzadj.zzgm().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzjq().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzadj.zzgq().zzb(var19_12, zzaf.zzajo);
                        var9_11 = var8_10.zzaht - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzadj.zzgo().zzjd().zze("Too many error events logged. appId, count", zzap.zzbv((String)var5_4), (Object)var8_10.zzaht);
                            }
                            this.zzjq().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzaid.zziv();
                    this.zzadj.zzgm().zza(var11_15, "_o", (Object)var1_1.origin);
                    if (this.zzadj.zzgm().zzcw(var5_4)) {
                        this.zzadj.zzgm().zza(var11_15, "_dbg", (Object)1L);
                        this.zzadj.zzgm().zza(var11_15, "_r", (Object)1L);
                    }
                    if ((var12_16 = this.zzjq().zzbm(var5_4)) > 0L) {
                        this.zzadj.zzgo().zzjg().zze("Data lost. Too many events stored on disk, deleted. appId", zzap.zzbv((String)var5_4), (Object)var12_16);
                    }
                    var14_17 = new zzy(this.zzadj, var1_1.origin, var5_4, var1_1.name, var1_1.zzaip, 0L, var11_15);
                    var15_18 = this.zzjq().zzg(var5_4, var14_17.name);
                    if (var15_18 == null) {
                        if (this.zzjq().zzbp(var5_4) >= 500L && var6_6) {
                            this.zzadj.zzgo().zzjd().zzd("Too many event names used, ignoring event. appId, name, supported count", zzap.zzbv((String)var5_4), (Object)this.zzadj.zzgl().zzbs(var14_17.name), (Object)500);
                            this.zzadj.zzgm().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzz(var5_4, var14_17.name, 0L, 0L, var14_17.timestamp, 0L, null, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this.zzadj, var15_18.zzaig);
                        var16_19 = var15_18.zzai(var14_17.timestamp);
                    }
                    this.zzjq().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzaf();
                    var18_20.zzlr();
                    Preconditions.checkNotNull((Object)var19_12);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_12.zztt);
                    Preconditions.checkArgument((boolean)var19_12.zztt.equals(var20_14.packageName));
                    var21_21 = new zzgi();
                    new zzgi().zzaxa = 1;
                    var21_21.zzaxi = "android";
                    var21_21.zztt = var20_14.packageName;
                    var21_21.zzage = var20_14.zzage;
                    var21_21.zzts = var20_14.zzts;
                    var21_21.zzaxu = var20_14.zzagd == -2147483648L ? null : Integer.valueOf((int)var20_14.zzagd);
                    var21_21.zzaxm = var20_14.zzadt;
                    var21_21.zzafx = var20_14.zzafx;
                    var21_21.zzawj = var20_14.zzagk;
                    var21_21.zzaxq = var20_14.zzagf == 0L ? null : Long.valueOf(var20_14.zzagf);
                    var22_22 = var18_20.zzadj.zzgp().zzby(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzagi) {
                            var21_21.zzaxo = (String)var22_22.first;
                            var21_21.zzaxp = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzadj.zzgk().zzl(var18_20.zzadj.getContext()) && var20_14.zzagj) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.zzadj.getContext().getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzadj.zzgo().zzjg().zzg("null secure ID. appId", zzap.zzbv((String)var21_21.zztt));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzadj.zzgo().zzjg().zzg("empty secure ID. appId", zzap.zzbv((String)var21_21.zztt));
                        }
                        var21_21.zzaxx = var23_23;
                    }
                    var18_20.zzadj.zzgk().zzcl();
                    var21_21.zzaxk = Build.MODEL;
                    var18_20.zzadj.zzgk().zzcl();
                    var21_21.zzaxj = Build.VERSION.RELEASE;
                    var21_21.zzaxl = (int)var18_20.zzadj.zzgk().zzis();
                    var21_21.zzaia = var18_20.zzadj.zzgk().zzit();
                    var21_21.zzaxn = null;
                    var21_21.zzaxd = null;
                    var21_21.zzaxe = null;
                    var21_21.zzaxf = null;
                    var21_21.zzaxz = var20_14.zzagh;
                    if (var18_20.zzadj.isEnabled() && zzn.zzhz()) {
                        var21_21.zzaya = null;
                    }
                    if ((var23_23 = var18_20.zzjq().zzbl(var20_14.packageName)) == null) {
                        var23_23 = new zzg(var18_20.zzadj, var20_14.packageName);
                        var23_23.zzam(var18_20.zzadj.zzgm().zzmf());
                        var23_23.zzaq(var20_14.zzafz);
                        var23_23.zzan(var20_14.zzafx);
                        var23_23.zzap(var18_20.zzadj.zzgp().zzbz(var20_14.packageName));
                        var23_23.zzx(0L);
                        var23_23.zzs(0L);
                        var23_23.zzt(0L);
                        var23_23.setAppVersion(var20_14.zzts);
                        var23_23.zzu(var20_14.zzagd);
                        var23_23.zzar(var20_14.zzage);
                        var23_23.zzv(var20_14.zzadt);
                        var23_23.zzw(var20_14.zzagf);
                        var23_23.setMeasurementEnabled(var20_14.zzagg);
                        var23_23.zzag(var20_14.zzagh);
                        var18_20.zzjq().zza((zzg)var23_23);
                    }
                    var21_21.zzafw = var23_23.getAppInstanceId();
                    var21_21.zzafz = var23_23.getFirebaseInstanceId();
                    var24_24 = var18_20.zzjq().zzbk(var20_14.packageName);
                    var21_21.zzaxc = new zzgl[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzaxc[var25_25] = var26_27 = new zzgl();
                        var26_27.name = var24_24.get((int)var25_25).name;
                        var26_27.zzayl = var24_24.get((int)var25_25).zzaue;
                        var18_20.zzjo().zza(var26_27, var24_24.get((int)var25_25).value);
                    }
                    try {
                        var25_26 = var18_20.zzjq().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzadj.zzgo().zzjd().zze("Data loss. Failed to insert raw event metadata. appId", zzap.zzbv((String)var21_21.zztt), (Object)var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzjq();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzaid == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzaid) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzln().zzp(var29_29.zztt, var29_29.name);
                    var31_33 = var28_30.zzjq().zza(var28_30.zzls(), var29_29.zztt, false, false, false, false, false);
                    if (var30_32 && var31_33.zzahu < (long)var28_30.zzadj.zzgq().zzat(var29_29.zztt)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzy)var19_12, var25_26, v1)) {
                    var18_20.zzatl = 0L;
                }
            }
            this.zzjq().setTransactionSuccessful();
            if (this.zzadj.zzgo().isLoggable(2)) {
                this.zzadj.zzgo().zzjl().zzg("Event recorded", (Object)this.zzadj.zzgl().zza(var14_17));
            }
        }
        finally {
            this.zzjq().endTransaction();
        }
        this.zzlv();
        this.zzadj.zzgo().zzjl().zzg("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzad zzad2) {
        long l;
        String string2;
        block10: {
            string2 = zzad2.zzaid.getString("currency");
            if ("ecommerce_purchase".equals(zzad2.name)) {
                double d = zzad2.zzaid.zzbq("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzad2.zzaid.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzadj.zzgo().zzjg().zze("Data lost. Currency value is too big. appId", zzap.zzbv((String)string), (Object)d);
                    return false;
                }
            }
            l = zzad2.zzaid.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzfj zzfj2 = this.zzjq().zzi(string, string5);
            if (zzfj2 == null || !(zzfj2.value instanceof Long)) {
                String string6 = string;
                int n = this.zzadj.zzgq().zzb(string6, zzaf.zzakh) - 1;
                string6 = string;
                zzq zzq2 = this.zzjq();
                Preconditions.checkNotEmpty((String)string6);
                zzq2.zzaf();
                zzq2.zzcl();
                try {
                    zzq2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzq2.zzgo().zzjd().zze("Error pruning currencies. appId", zzap.zzbv((String)string6), (Object)sQLiteException);
                }
                zzfj2 = new zzfj(string, zzad2.origin, string5, this.zzadj.zzbx().currentTimeMillis(), (Object)l);
            } else {
                long l2 = (Long)zzfj2.value;
                zzfj2 = new zzfj(string, zzad2.origin, string5, this.zzadj.zzbx().currentTimeMillis(), (Object)(l2 + l));
            }
            if (!this.zzjq().zza(zzfj2)) {
                this.zzadj.zzgo().zzjd().zzd("Too many unique user properties are set. Ignoring user property. appId", zzap.zzbv((String)string), (Object)this.zzadj.zzgl().zzbu(zzfj2.name), zzfj2.value);
                this.zzadj.zzgm().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzlt() {
        this.zzaf();
        this.zzlr();
        this.zzatr = true;
        try {
            String string;
            zzk zzk2 = this.zzadj.zzgr();
            Boolean bl = this.zzadj.zzgg().zzle();
            if (bl == null) {
                this.zzadj.zzgo().zzjg().zzbx("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzadj.zzgo().zzjd().zzbx("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzatl > 0L) {
                this.zzlv();
                return;
            }
            zzcq zzcq2 = this;
            zzcq2.zzaf();
            if (zzcq2.zzatu != null) {
                this.zzadj.zzgo().zzjl().zzbx("Uploading requested multiple times");
                return;
            }
            if (!this.zzlo().zzfb()) {
                this.zzadj.zzgo().zzjl().zzbx("Network not connected, ignoring upload request");
                this.zzlv();
                return;
            }
            long l = this.zzadj.zzbx().currentTimeMillis();
            long l2 = l - zzn.zzhx();
            this.zzd(null, l2);
            long l3 = this.zzadj.zzgp().zzane.get();
            if (l3 != 0L) {
                this.zzadj.zzgo().zzjk().zzg("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzjq().zzid()))) {
                if (this.zzatw == -1L) {
                    this.zzatw = this.zzjq().zzik();
                }
                Object object = string;
                int n = this.zzadj.zzgq().zzb((String)object, zzaf.zzajj);
                object = string;
                zzcq2 = this.zzadj.zzgq();
                int n2 = Math.max(0, zzcq2.zzb((String)object, zzaf.zzajk));
                List<Pair<zzgi, Long>> list = this.zzjq().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzgi zzgi2 = (zzgi)((Object)object3.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzgi2.zzaxo)) continue;
                        string2 = zzgi2.zzaxo;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzgi)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzgi)((Object)object2)).zzaxo) || ((zzgi)((Object)object2)).zzaxo.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new zzgh();
                    new zzgh().zzawy = new zzgi[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzn.zzhz() && this.zzadj.zzgq().zzav(string);
                    for (int i = 0; i < ((zzgh)((Object)object3)).zzawy.length; ++i) {
                        ((zzgh)((Object)object3)).zzawy[i] = (zzgi)((Object)list.get((int)i).first);
                        object2.add((Long)list.get((int)i).second);
                        ((zzgh)((Object)object3)).zzawy[i].zzaxn = this.zzadj.zzgq().zzhc();
                        ((zzgh)((Object)object3)).zzawy[i].zzaxd = l;
                        zzk2 = this.zzadj.zzgr();
                        ((zzgh)((Object)object3)).zzawy[i].zzaxs = false;
                        if (bl2) continue;
                        ((zzgh)((Object)object3)).zzawy[i].zzaya = null;
                    }
                    String string3 = null;
                    if (this.zzadj.zzgo().isLoggable(2)) {
                        string3 = this.zzjo().zzb((zzgh)((Object)object3));
                    }
                    byte[] byArray = this.zzjo().zza((zzgh)((Object)object3));
                    String string4 = (String)zzaf.zzajt.get();
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzcq2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzcq2.zzatu != null) {
                            zzcq2.zzadj.zzgo().zzjd().zzbx("Set uploading progress before finishing the previous upload");
                        } else {
                            zzcq2.zzatu = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzadj.zzgp().zzanf.set(l);
                        String string5 = "?";
                        if (((zzgh)((Object)object3)).zzawy.length > 0) {
                            string5 = ((zzgh)((Object)object3)).zzawy[0].zztt;
                        }
                        this.zzadj.zzgo().zzjl().zzd("Uploading data. app, uncompressed size, data", (Object)string5, (Object)byArray.length, (Object)string3);
                        this.zzatq = true;
                        zzfc zzfc2 = new zzfc(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzcq2 = this.zzlo();
                        zzcq2.zzaf();
                        zzcq2.zzcl();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzfc2);
                        zzcq2.zzgn().zzd((Runnable)new zzax((zzat)zzcq2, (String)object, uRL2, byArray2, null, zzfc2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzadj.zzgo().zzjd().zze("Failed to parse upload URL. Not uploading. appId", zzap.zzbv((String)string), (Object)string4);
                    }
                }
            } else {
                zzg zzg2;
                this.zzatw = -1L;
                String string6 = this.zzjq().zzah(l - zzn.zzhx());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzg2 = this.zzjq().zzbl(string6)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzatr = false;
            this.zzlw();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzjq().beginTransaction();
        try {
            block125: {
                Object object;
                int n;
                zzgg zzgg2;
                int sQLiteException;
                int n4;
                int n5;
                Object object2;
                Object object3;
                zza zza2;
                block123: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzatw;
                    long l3 = l;
                    object3 = null;
                    object2 = this.zzjq();
                    Preconditions.checkNotNull((Object)zza3);
                    object2.zzaf();
                    object2.zzcl();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = object2.getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block123;
                            object3 = cursor.getString(0);
                            string3 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block123;
                            string3 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object3, string3}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzgo().zzjd().zzg("Raw event metadata record is missing. appId", zzap.zzbv((String)object3));
                            break block123;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string4 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray.length);
                        zzgi zzgi2 = new zzgi();
                        try {
                            zzgi2.zza((zzyx)string4);
                        }
                        catch (IOException iOException) {
                            object2.zzgo().zzjd().zze("Data loss. Failed to merge raw event metadata. appId", zzap.zzbv((String)object3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block123;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzgo().zzjg().zzg("Get multiple raw event metadata records, expected one. appId", zzap.zzbv((String)object3));
                        }
                        cursor.close();
                        zza3.zzb(zzgi2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object3, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object3, string3};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzgo().zzjg().zzg("Raw event data disappeared while in transaction. appId", zzap.zzbv((String)object3));
                            break block123;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string4 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray.length);
                            zzgf zzgf2 = new zzgf();
                            try {
                                zzgf2.zza((zzyx)string4);
                            }
                            catch (IOException iOException) {
                                object2.zzgo().zzjd().zze("Data loss. Failed to merge raw event. appId", zzap.zzbv((String)object3), (Object)iOException);
                                continue;
                            }
                            zzgf2.name = cursor.getString(1);
                            zzgf2.zzawu = cursor.getLong(2);
                            if (!zza3.zza(l4, zzgf2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzauc == null || ((zza)object2).zzauc.isEmpty()) break block125;
                boolean bl = false;
                zzgi zzgi3 = zza2.zzaua;
                zza2.zzaua.zzaxb = new zzgf[zza2.zzauc.size()];
                int n6 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzadj.zzgq().zzax(zzgi3.zztt);
                for (n5 = 0; n5 < zza2.zzauc.size(); ++n5) {
                    zzgf zzgf3;
                    block127: {
                        int zzggArray2;
                        boolean bl3;
                        block126: {
                            boolean bl4;
                            bl3 = bl;
                            zzgf3 = zza2.zzauc.get(n5);
                            if (this.zzln().zzo(zza2.zzaua.zztt, zzgf3.name)) {
                                this.zzadj.zzgo().zzjg().zze("Dropping blacklisted raw event. appId", zzap.zzbv((String)zza2.zzaua.zztt), (Object)this.zzadj.zzgl().zzbs(zzgf3.name));
                                if (this.zzln().zzck(zza2.zzaua.zztt) || this.zzln().zzcl(zza2.zzaua.zztt) || "_err".equals(zzgf3.name)) continue;
                                this.zzadj.zzgm().zza(zza2.zzaua.zztt, 11, "_ev", zzgf3.name, 0);
                                continue;
                            }
                            n4 = this.zzln().zzp(zza2.zzaua.zztt, zzgf3.name);
                            if (n4 != 0) break block126;
                            this.zzjo();
                            object2 = zzgf3.name;
                            Preconditions.checkNotEmpty((String)object2);
                            zzq zzq2 = object2;
                            sQLiteException = -1;
                            switch (((String)((Object)zzq2)).hashCode()) {
                                case 94660: {
                                    if (!((String)((Object)zzq2)).equals("_in")) break;
                                    sQLiteException = 0;
                                    break;
                                }
                                case 95027: {
                                    if (!((String)((Object)zzq2)).equals("_ui")) break;
                                    sQLiteException = 1;
                                    break;
                                }
                                case 95025: {
                                    if (!((String)((Object)zzq2)).equals("_ug")) break;
                                    sQLiteException = 2;
                                }
                            }
                            switch (sQLiteException) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    bl4 = true;
                                    break;
                                }
                                default: {
                                    bl4 = false;
                                }
                            }
                            if (!bl4) break block127;
                        }
                        boolean bl5 = false;
                        boolean n2 = false;
                        if (zzgf3.zzawt == null) {
                            zzgf3.zzawt = new zzgg[0];
                        }
                        zzgg[] i = zzgf3.zzawt;
                        int zzgg3 = zzgf3.zzawt.length;
                        for (zzggArray2 = 0; zzggArray2 < zzgg3; ++zzggArray2) {
                            zzgg2 = i[zzggArray2];
                            if ("_c".equals(zzgg2.name)) {
                                zzgg2.zzawx = 1L;
                                bl5 = true;
                                continue;
                            }
                            if (!"_r".equals(zzgg2.name)) continue;
                            zzgg2.zzawx = 1L;
                            n2 = true;
                        }
                        if (!bl5 && n4 != 0) {
                            this.zzadj.zzgo().zzjl().zzg("Marking event as conversion", (Object)this.zzadj.zzgl().zzbs(zzgf3.name));
                            i = Arrays.copyOf(zzgf3.zzawt, zzgf3.zzawt.length + 1);
                            zzgg zzgg4 = new zzgg();
                            new zzgg().name = "_c";
                            zzgg4.zzawx = 1L;
                            i[i.length - 1] = zzgg4;
                            zzgf3.zzawt = i;
                        }
                        if (!n2) {
                            this.zzadj.zzgo().zzjl().zzg("Marking event as real-time", (Object)this.zzadj.zzgl().zzbs(zzgf3.name));
                            i = Arrays.copyOf(zzgf3.zzawt, zzgf3.zzawt.length + 1);
                            zzgg zzgf4 = new zzgg();
                            new zzgg().name = "_r";
                            zzgf4.zzawx = 1L;
                            i[i.length - 1] = zzgf4;
                            zzgf3.zzawt = i;
                        }
                        bl = true;
                        if (this.zzjq().zza((long)this.zzls(), (String)zza2.zzaua.zztt, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzahu > (long)this.zzadj.zzgq().zzat(zza2.zzaua.zztt)) {
                            for (zzgg3 = 0; zzgg3 < zzgf3.zzawt.length; ++zzgg3) {
                                if (!"_r".equals(zzgf3.zzawt[zzgg3].name)) continue;
                                zzgg[] string6 = new zzgg[zzgf3.zzawt.length - 1];
                                if (zzgg3 > 0) {
                                    System.arraycopy(zzgf3.zzawt, 0, string6, 0, zzgg3);
                                }
                                if (zzgg3 < string6.length) {
                                    System.arraycopy(zzgf3.zzawt, zzgg3 + 1, string6, zzgg3, string6.length - zzgg3);
                                }
                                zzgf3.zzawt = string6;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzfk.zzcq((String)zzgf3.name) && n4 != 0) {
                            object3 = zza2.zzaua.zztt;
                            if (this.zzjq().zza((long)this.zzls(), (String)zza2.zzaua.zztt, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzahs > (long)this.zzadj.zzgq().zzb((String)object3, zzaf.zzajq)) {
                                this.zzadj.zzgo().zzjg().zzg("Too many conversions. Not logging as conversion. appId", zzap.zzbv((String)zza2.zzaua.zztt));
                                zzggArray2 = 0;
                                zzgg2 = null;
                                zzgg[] l8 = zzgf3.zzawt;
                                int n3 = zzgf3.zzawt.length;
                                for (n = 0; n < n3; ++n) {
                                    object = l8[n];
                                    if ("_c".equals(object.name)) {
                                        zzgg2 = object;
                                        continue;
                                    }
                                    if (!"_err".equals(object.name)) continue;
                                    zzggArray2 = 1;
                                }
                                if (zzggArray2 != 0 && zzgg2 != null) {
                                    zzgf3.zzawt = (zzgg[])ArrayUtils.removeAll((Object[])zzgf3.zzawt, (Object[])new zzgg[]{zzgg2});
                                } else if (zzgg2 != null) {
                                    zzgg2.name = "_err";
                                    zzgg2.zzawx = 10L;
                                } else {
                                    this.zzadj.zzgo().zzjd().zzg("Did not find conversion parameter. appId", zzap.zzbv((String)zza2.zzaua.zztt));
                                }
                            }
                        }
                    }
                    if (this.zzadj.zzgq().zzbf(zza2.zzaua.zztt) && n4 != 0) {
                        int n10;
                        object3 = zzgf3.zzawt;
                        object2 = this;
                        int n11 = -1;
                        sQLiteException = -1;
                        for (n10 = 0; n10 < ((zzgg[])object3).length; ++n10) {
                            if ("value".equals(object3[n10].name)) {
                                n11 = n10;
                                continue;
                            }
                            if (!"currency".equals(((zzgg)((Object)object3[n10])).name)) continue;
                            sQLiteException = n10;
                        }
                        if (n11 != -1) {
                            if (object3[n11].zzawx == null && ((zzgg)((Object)object3[n11])).zzauh == null) {
                                ((zzfa)object2).zzadj.zzgo().zzji().zzbx("Value must be specified with a numeric type.");
                                object3 = zzfa.zza((zzgg[])object3, n11);
                                object3 = zzfa.zza(zzfa.zza((zzgg[])object3, "_c"), 18, "value");
                            } else {
                                n10 = 0;
                                if (sQLiteException == -1) {
                                    n10 = 1;
                                } else {
                                    String n14 = ((zzgg)((Object)object3[sQLiteException])).zzamp;
                                    if (n14 == null || n14.length() != 3) {
                                        n10 = 1;
                                    } else {
                                        int n12;
                                        for (int i = 0; i < n14.length(); i += Character.charCount(n12)) {
                                            n12 = n14.codePointAt(i);
                                            if (Character.isLetter(n12)) continue;
                                            n10 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n10 != 0) {
                                    ((zzfa)object2).zzadj.zzgo().zzji().zzbx("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    object3 = zzfa.zza((zzgg[])object3, n11);
                                    object3 = zzfa.zza(zzfa.zza((zzgg[])object3, "_c"), 19, "currency");
                                }
                            }
                        }
                        zzgf3.zzawt = object3;
                    }
                    if (bl2 && "_e".equals(zzgf3.name)) {
                        if (zzgf3.zzawt == null || zzgf3.zzawt.length == 0) {
                            this.zzadj.zzgo().zzjg().zzg("Engagement event does not contain any parameters. appId", zzap.zzbv((String)zza2.zzaua.zztt));
                        } else {
                            this.zzjo();
                            Long l6 = (Long)zzfg.zzb(zzgf3, "_et");
                            if (l6 == null) {
                                this.zzadj.zzgo().zzjg().zzg("Engagement event does not include duration. appId", zzap.zzbv((String)zza2.zzaua.zztt));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzgi3.zzaxb[n6++] = zzgf3;
                }
                if (n6 < zza2.zzauc.size()) {
                    zzgi3.zzaxb = Arrays.copyOf(zzgi3.zzaxb, n6);
                }
                if (bl2) {
                    zzfj zzfj2 = this.zzjq().zzi(zzgi3.zztt, "_lte");
                    zzfj2 = zzfj2 == null || zzfj2.value == null ? new zzfj(zzgi3.zztt, "auto", "_lte", this.zzadj.zzbx().currentTimeMillis(), (Object)l5) : new zzfj(zzgi3.zztt, "auto", "_lte", this.zzadj.zzbx().currentTimeMillis(), (Object)((Long)zzfj2.value + l5));
                    zzgl zzgl2 = new zzgl();
                    new zzgl().name = "_lte";
                    zzgl2.zzayl = this.zzadj.zzbx().currentTimeMillis();
                    zzgl2.zzawx = (Long)zzfj2.value;
                    boolean bl6 = false;
                    for (n4 = 0; n4 < zzgi3.zzaxc.length; ++n4) {
                        if (!"_lte".equals(zzgi3.zzaxc[n4].name)) continue;
                        zzgi3.zzaxc[n4] = zzgl2;
                        bl6 = true;
                        break;
                    }
                    if (!bl6) {
                        zzgi3.zzaxc = Arrays.copyOf(zzgi3.zzaxc, zzgi3.zzaxc.length + 1);
                        zzgi3.zzaxc[zza2.zzaua.zzaxc.length - 1] = zzgl2;
                    }
                    if (l5 > 0L) {
                        this.zzjq().zza(zzfj2);
                        this.zzadj.zzgo().zzjk().zzg("Updated lifetime engagement user property with value. Value", zzfj2.value);
                    }
                }
                zzgi3.zzaxt = this.zza(zzgi3.zztt, zzgi3.zzaxc, zzgi3.zzaxb);
                if (this.zzadj.zzgq().zzaw(zza2.zzaua.zztt)) {
                    HashMap<String, zzgg> hashMap = new HashMap<String, zzgg>();
                    zzgf[] zzgfArray = new zzgf[zzgi3.zzaxb.length];
                    int n13 = 0;
                    SecureRandom secureRandom = this.zzadj.zzgm().zzmd();
                    zzgf[] zzgfArray2 = zzgi3.zzaxb;
                    int n7 = zzgi3.zzaxb.length;
                    for (int i = 0; i < n7; ++i) {
                        boolean bl5;
                        long l2;
                        boolean bl6;
                        long l3;
                        long l4;
                        zzgf zzgf2;
                        block124: {
                            zzgf2 = zzgfArray2[i];
                            if (zzgf2.name.equals("_ep")) {
                                this.zzjo();
                                String l9 = (String)zzfg.zzb(zzgf2, "_en");
                                zzgg2 = (zzz)hashMap.get(l9);
                                if (zzgg2 == null) {
                                    zzgg2 = this.zzjq().zzg(zza2.zzaua.zztt, l9);
                                    hashMap.put(l9, zzgg2);
                                }
                                if (((zzz)zzgg2).zzaij != null) continue;
                                if (((zzz)zzgg2).zzaik > 1L) {
                                    this.zzjo();
                                    zzgf2.zzawt = zzfg.zza(zzgf2.zzawt, "_sr", ((zzz)zzgg2).zzaik);
                                }
                                if (((zzz)zzgg2).zzail != null && ((zzz)zzgg2).zzail.booleanValue()) {
                                    this.zzjo();
                                    zzgf2.zzawt = zzfg.zza(zzgf2.zzawt, "_efs", 1L);
                                }
                                zzgfArray[n13++] = zzgf2;
                                continue;
                            }
                            l4 = this.zzln().zzcj(zza2.zzaua.zztt);
                            this.zzadj.zzgm();
                            l3 = zzfk.zzc((long)zzgf2.zzawu, (long)l4);
                            n = 1;
                            Long l10 = 1L;
                            object3 = "_dbg";
                            object2 = zzgf2;
                            if (TextUtils.isEmpty((CharSequence)object3) || l10 == null) {
                                bl6 = false;
                            } else {
                                zzgg[] zzggArray = ((zzgf)((Object)((Object)object2))).zzawt;
                                int n8 = ((zzgf)((Object)((Object)object2))).zzawt.length;
                                for (int j = 0; j < n8; ++j) {
                                    zzgg zzgg5 = zzggArray[j];
                                    if (!((String)object3).equals(zzgg5.name)) continue;
                                    bl6 = l10 instanceof Long && ((Object)l10).equals(zzgg5.zzawx) || l10 instanceof String && ((Object)l10).equals(zzgg5.zzamp) || l10 instanceof Double && ((Object)l10).equals(zzgg5.zzauh);
                                    break block124;
                                }
                                bl6 = false;
                            }
                        }
                        if (!bl6) {
                            n = this.zzln().zzq(zza2.zzaua.zztt, zzgf2.name);
                        }
                        if (n <= 0) {
                            this.zzadj.zzgo().zzjg().zze("Sample rate must be positive. event, rate", (Object)zzgf2.name, (Object)n);
                            zzgfArray[n13++] = zzgf2;
                            continue;
                        }
                        object = (zzz)hashMap.get(zzgf2.name);
                        if (object == null && (object = this.zzjq().zzg(zza2.zzaua.zztt, zzgf2.name)) == null) {
                            this.zzadj.zzgo().zzjg().zze("Event being bundled has no eventAggregate. appId, eventName", (Object)zza2.zzaua.zztt, (Object)zzgf2.name);
                            object = new zzz(zza2.zzaua.zztt, zzgf2.name, 1L, 1L, zzgf2.zzawu.longValue(), 0L, null, null, null, null);
                        }
                        this.zzjo();
                        Long l6 = (Long)zzfg.zzb(zzgf2, "_eid");
                        Boolean bl7 = l6 != null;
                        if (n == 1) {
                            zzgfArray[n13++] = zzgf2;
                            if (!bl7.booleanValue() || object.zzaij == null && object.zzaik == null && object.zzail == null) continue;
                            object = object.zza(null, null, null);
                            hashMap.put(zzgf2.name, (zzgg)((Object)object));
                            continue;
                        }
                        if (secureRandom.nextInt(n) == 0) {
                            this.zzjo();
                            zzgf2.zzawt = zzfg.zza(zzgf2.zzawt, "_sr", n);
                            zzgfArray[n13++] = zzgf2;
                            if (bl7.booleanValue()) {
                                object = object.zza(null, Long.valueOf(n), null);
                            }
                            hashMap.put(zzgf2.name, (zzgg)object.zza(zzgf2.zzawu.longValue(), l3));
                            continue;
                        }
                        if (this.zzadj.zzgq().zzbh(zza2.zzaua.zztt)) {
                            if (object.zzaii != null) {
                                l2 = object.zzaii;
                            } else {
                                this.zzadj.zzgm();
                                l2 = zzfk.zzc((long)zzgf2.zzawv, (long)l4);
                            }
                            bl5 = l2 != l3;
                        } else {
                            l2 = object.zzaih;
                            boolean bl8 = bl5 = Math.abs(zzgf2.zzawu - l2) >= 86400000L;
                        }
                        if (bl5) {
                            this.zzjo();
                            zzgf2.zzawt = zzfg.zza(zzgf2.zzawt, "_efs", 1L);
                            this.zzjo();
                            zzgf2.zzawt = zzfg.zza(zzgf2.zzawt, "_sr", n);
                            zzgfArray[n13++] = zzgf2;
                            if (bl7.booleanValue()) {
                                object = object.zza(null, Long.valueOf(n), Boolean.valueOf(true));
                            }
                            hashMap.put(zzgf2.name, (zzgg)object.zza(zzgf2.zzawu.longValue(), l3));
                            continue;
                        }
                        if (!bl7.booleanValue()) continue;
                        hashMap.put(zzgf2.name, (zzgg)object.zza(l6, null, null));
                    }
                    if (n13 < zzgi3.zzaxb.length) {
                        zzgi3.zzaxb = Arrays.copyOf(zzgfArray, n13);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzjq().zza((zzz)entry.getValue());
                    }
                }
                zzgi3.zzaxe = Long.MAX_VALUE;
                zzgi3.zzaxf = Long.MIN_VALUE;
                for (n5 = 0; n5 < zzgi3.zzaxb.length; ++n5) {
                    zzgf zzgf5 = zzgi3.zzaxb[n5];
                    if (zzgf5.zzawu < zzgi3.zzaxe) {
                        zzgi3.zzaxe = zzgf5.zzawu;
                    }
                    if (zzgf5.zzawu <= zzgi3.zzaxf) continue;
                    zzgi3.zzaxf = zzgf5.zzawu;
                }
                String string7 = zza2.zzaua.zztt;
                zzg zzg2 = this.zzjq().zzbl(string7);
                if (zzg2 == null) {
                    this.zzadj.zzgo().zzjd().zzg("Bundling raw events w/o app info. appId", zzap.zzbv((String)zza2.zzaua.zztt));
                } else if (zzgi3.zzaxb.length > 0) {
                    long l12 = zzg2.zzgz();
                    zzgi3.zzaxh = l12 != 0L ? Long.valueOf(l12) : null;
                    long l13 = zzg2.zzgy();
                    if (l13 == 0L) {
                        l13 = l12;
                    }
                    zzgi3.zzaxg = l13 != 0L ? Long.valueOf(l13) : null;
                    zzg2.zzhh();
                    zzgi3.zzaxr = (int)zzg2.zzhe();
                    zzg2.zzs(zzgi3.zzaxe.longValue());
                    zzg2.zzt(zzgi3.zzaxf.longValue());
                    zzgi3.zzagv = zzg2.zzhp();
                    this.zzjq().zza(zzg2);
                }
                if (zzgi3.zzaxb.length > 0) {
                    zzk zzk2 = this.zzadj.zzgr();
                    zzgb zzgb2 = this.zzln().zzcf(zza2.zzaua.zztt);
                    if (zzgb2 == null || zzgb2.zzawe == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzaua.zzafx)) {
                            zzgi3.zzaxy = -1L;
                        } else {
                            this.zzadj.zzgo().zzjg().zzg("Did not find measurement config or missing version info. appId", zzap.zzbv((String)zza2.zzaua.zztt));
                        }
                    } else {
                        zzgi3.zzaxy = zzgb2.zzawe;
                    }
                    this.zzjq().zza(zzgi3, bl);
                }
                object3 = zza2.zzaub;
                object2 = this.zzjq();
                Preconditions.checkNotNull((Object)object3);
                object2.zzaf();
                object2.zzcl();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (sQLiteException = 0; sQLiteException < object3.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object3.get(sQLiteException));
                }
                stringBuilder.append(")");
                int n15 = object2.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
                if (n15 != object3.size()) {
                    object2.zzgo().zzjd().zze("Deleted fewer rows from raw events table than expected", (Object)n15, (Object)object3.size());
                }
                object3 = string7;
                object2 = this.zzjq();
                stringBuilder = object2.getWritableDatabase();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object3, object3});
                }
                catch (SQLiteException sQLiteException2) {
                    object2.zzgo().zzjd().zze("Failed to remove unused event metadata. appId", zzap.zzbv((String)object3), (Object)sQLiteException2);
                }
                this.zzjq().setTransactionSuccessful();
                return true;
            }
            this.zzjq().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    @VisibleForTesting
    private static zzgg[] zza(zzgg[] zzggArray, @NonNull String string) {
        int n = -1;
        for (int i = 0; i < zzggArray.length; ++i) {
            if (!string.equals(zzggArray[i].name)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return zzggArray;
        }
        return zzfa.zza(zzggArray, n);
    }

    @VisibleForTesting
    private static zzgg[] zza(zzgg[] zzggArray, int n) {
        zzgg[] zzggArray2 = new zzgg[zzggArray.length - 1];
        if (n > 0) {
            System.arraycopy(zzggArray, 0, zzggArray2, 0, n);
        }
        if (n < zzggArray2.length) {
            System.arraycopy(zzggArray, n + 1, zzggArray2, n, zzggArray2.length - n);
        }
        return zzggArray2;
    }

    @VisibleForTesting
    private static zzgg[] zza(zzgg[] zzggArray, int n, String string) {
        for (int i = 0; i < zzggArray.length; ++i) {
            if (!"_err".equals(zzggArray[i].name)) continue;
            return zzggArray;
        }
        zzgg[] zzggArray2 = new zzgg[zzggArray.length + 2];
        System.arraycopy(zzggArray, 0, zzggArray2, 0, zzggArray.length);
        zzgg zzgg2 = new zzgg();
        new zzgg().name = "_err";
        zzgg2.zzawx = n;
        zzgg zzgg3 = new zzgg();
        new zzgg().name = "_ev";
        zzgg3.zzamp = string;
        zzggArray2[zzggArray2.length - 2] = zzgg2;
        zzggArray2[zzggArray2.length - 1] = zzgg3;
        return zzggArray2;
    }

    private final zzgd[] zza(String string, zzgl[] zzglArray, zzgf[] zzgfArray) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzjp().zza(string, zzgfArray, zzglArray);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzaf();
        this.zzlr();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzatu;
            this.zzatu = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzadj.zzgp().zzane.set(this.zzadj.zzbx().currentTimeMillis());
                    this.zzadj.zzgp().zzanf.set(0L);
                    this.zzlv();
                    this.zzadj.zzgo().zzjl().zze("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zzjq().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzq zzq2 = this.zzjq();
                                zzq2.zzaf();
                                zzq2.zzcl();
                                SQLiteDatabase sQLiteDatabase = zzq2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzq2.zzgo().zzjd().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzatv != null && this.zzatv.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzjq().setTransactionSuccessful();
                    }
                    finally {
                        this.zzjq().endTransaction();
                    }
                    this.zzatv = null;
                    if (this.zzlo().zzfb() && this.zzlu()) {
                        this.zzlt();
                    } else {
                        this.zzatw = -1L;
                        this.zzlv();
                    }
                    this.zzatl = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzadj.zzgo().zzjd().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzatl = this.zzadj.zzbx().elapsedRealtime();
                    this.zzadj.zzgo().zzjl().zzg("Disable upload, time", (Object)this.zzatl);
                }
            } else {
                this.zzadj.zzgo().zzjl().zze("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzadj.zzgp().zzanf.set(this.zzadj.zzbx().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzadj.zzgp().zzang.set(this.zzadj.zzbx().currentTimeMillis());
                }
                if (this.zzadj.zzgq().zzaz(string)) {
                    this.zzjq().zzc(list);
                }
                this.zzlv();
            }
            return;
        }
        finally {
            this.zzatq = false;
            this.zzlw();
        }
    }

    private final boolean zzlu() {
        this.zzaf();
        this.zzlr();
        return this.zzjq().zzii() || !TextUtils.isEmpty((CharSequence)this.zzjq().zzid());
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzaf();
        if (TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && (!zzn.zzic() || TextUtils.isEmpty((CharSequence)zzg2.zzgw()))) {
            this.zzb(zzg2.zzal(), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = this.zzadj.zzgq();
        Object object3 = new Uri.Builder();
        String string = object.getGmpAppId();
        if (TextUtils.isEmpty((CharSequence)string) && zzn.zzic()) {
            string = object.zzgw();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzaf.zzajh.get()).encodedAuthority((String)zzaf.zzaji.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.getAppInstanceId()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzhc()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzadj.zzgo().zzjl().zzg("Fetching remote configuration", (Object)zzg2.zzal());
            zzgb zzgb2 = this.zzln().zzcf(zzg2.zzal());
            ArrayMap arrayMap = null;
            String string4 = this.zzln().zzcg(zzg2.zzal());
            if (zzgb2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzatp = true;
            zzfd zzfd2 = new zzfd(this);
            string = arrayMap;
            object3 = uRL;
            object = zzg2.zzal();
            object2 = this.zzlo();
            object2.zzaf();
            ((zzez)((Object)object2)).zzcl();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzfd2);
            object2.zzgn().zzd((Runnable)new zzax((zzat)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzfd2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzadj.zzgo().zzjd().zze("Failed to parse config URL. Not fetching. appId", zzap.zzbv((String)zzg2.zzal()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzaf();
        this.zzlr();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzadj.zzgo().zzjl().zzg("onConfigFetched. Response size", (Object)byArray.length);
            this.zzjq().beginTransaction();
            try {
                boolean bl;
                zzg zzg2 = this.zzjq().zzbl(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzadj.zzgo().zzjg().zzg("App does not exist in onConfigFetched. appId", zzap.zzbv((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzln().zzcf(string) == null && !this.zzln().zza(string, null, null) : !this.zzln().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzy(this.zzadj.zzbx().currentTimeMillis());
                    this.zzjq().zza(zzg2);
                    if (n == 404) {
                        this.zzadj.zzgo().zzji().zzg("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzadj.zzgo().zzjl().zze("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzlo().zzfb() && this.zzlu()) {
                        this.zzlt();
                    } else {
                        this.zzlv();
                    }
                } else {
                    zzg2.zzz(this.zzadj.zzbx().currentTimeMillis());
                    this.zzjq().zza(zzg2);
                    this.zzadj.zzgo().zzjl().zze("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzln().zzch(string);
                    this.zzadj.zzgp().zzanf.set(this.zzadj.zzbx().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzadj.zzgp().zzang.set(this.zzadj.zzbx().currentTimeMillis());
                    }
                    this.zzlv();
                }
                this.zzjq().setTransactionSuccessful();
            }
            finally {
                this.zzjq().endTransaction();
            }
            return;
        }
        finally {
            this.zzatp = false;
            this.zzlw();
        }
    }

    @WorkerThread
    private final void zzlv() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzaf();
            this.zzlr();
            if (!this.zzlz()) {
                return;
            }
            if (this.zzatl > 0L) {
                l3 = this.zzadj.zzbx().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzatl);
                if (l2 > 0L) {
                    this.zzadj.zzgo().zzjl().zzg("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzlp().unregister();
                    this.zzlq().cancel();
                    return;
                }
                this.zzatl = 0L;
            }
            if (!this.zzadj.zzkr() || !this.zzlu()) {
                this.zzadj.zzgo().zzjl().zzbx("Nothing to upload or uploading impossible");
                this.zzlp().unregister();
                this.zzlq().cancel();
                return;
            }
            zzfa zzfa2 = this;
            long l4 = zzfa2.zzadj.zzbx().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzaf.zzakd.get());
            boolean bl = zzfa2.zzjq().zzij() || zzfa2.zzjq().zzie();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzfa2.zzadj.zzgq().zzhy())) && !".none.".equals(string) ? Math.max(0L, (Long)zzaf.zzajy.get()) : Math.max(0L, (Long)zzaf.zzajx.get())) : Math.max(0L, (Long)zzaf.zzajw.get());
            long l7 = zzfa2.zzadj.zzgp().zzane.get();
            long l8 = zzfa2.zzadj.zzgp().zzanf.get();
            long l9 = zzfa2.zzjq().zzig();
            long l10 = zzfa2.zzjq().zzih();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzfa2.zzjo().zzb(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzaf.zzakf.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzaf.zzake.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzadj.zzgo().zzjl().zzbx("Next upload time is 0");
            this.zzlp().unregister();
            this.zzlq().cancel();
            return;
        }
        if (!this.zzlo().zzfb()) {
            this.zzadj.zzgo().zzjl().zzbx("No network");
            this.zzlp().zzey();
            this.zzlq().cancel();
            return;
        }
        l2 = this.zzadj.zzgp().zzang.get();
        long l16 = Math.max(0L, (Long)zzaf.zzaju.get());
        if (!this.zzjo().zzb(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzlp().unregister();
        long l17 = l3 - this.zzadj.zzbx().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzaf.zzajz.get());
            this.zzadj.zzgp().zzane.set(this.zzadj.zzbx().currentTimeMillis());
        }
        this.zzadj.zzgo().zzjl().zzg("Upload scheduled in approximately ms", (Object)l17);
        this.zzlq().zzh(l17);
    }

    @WorkerThread
    final void zzg(Runnable runnable) {
        this.zzaf();
        if (this.zzatm == null) {
            this.zzatm = new ArrayList<Runnable>();
        }
        this.zzatm.add(runnable);
    }

    @WorkerThread
    private final void zzlw() {
        this.zzaf();
        if (this.zzatp || this.zzatq || this.zzatr) {
            this.zzadj.zzgo().zzjl().zzd("Not stopping services. fetch, network, upload", (Object)this.zzatp, (Object)this.zzatq, (Object)this.zzatr);
            return;
        }
        this.zzadj.zzgo().zzjl().zzbx("Stopping uploading service(s)");
        if (this.zzatm == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzatm.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzatm.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzg zzg2) {
        try {
            if (zzg2.zzha() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzadj.getContext()).getPackageInfo((String)zzg2.zzal(), (int)0).versionCode;
                if (zzg2.zzha() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzadj.getContext()).getPackageInfo((String)zzg2.zzal(), (int)0).versionName;
                if (zzg2.zzak() != null && zzg2.zzak().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzlx() {
        this.zzaf();
        String string = "google_app_measurement.db";
        File file = this.zzadj.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzatt = new RandomAccessFile(file2, "rw").getChannel();
            this.zzats = this.zzatt.tryLock();
            if (this.zzats != null) {
                this.zzadj.zzgo().zzjl().zzbx("Storage concurrent access okay");
                return true;
            }
            this.zzadj.zzgo().zzjd().zzbx("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzadj.zzgo().zzjd().zzg("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzadj.zzgo().zzjd().zzg("Failed to access storage lock file", (Object)iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzaf();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzadj.zzgo().zzjd().zzbx("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzadj.zzgo().zzjg().zzg("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzadj.zzgo().zzjd().zzg("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzaf();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzadj.zzgo().zzjd().zzbx("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzadj.zzgo().zzjd().zzg("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzadj.zzgo().zzjd().zzg("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @WorkerThread
    final void zzly() {
        this.zzaf();
        this.zzlr();
        if (!this.zzatk) {
            this.zzadj.zzgo().zzjj().zzbx("This instance being marked as an uploader");
            zzfa zzfa2 = this;
            zzfa2.zzaf();
            zzfa2.zzlr();
            if (zzfa2.zzlz() && zzfa2.zzlx()) {
                int n;
                int n2 = zzfa2.zza(zzfa2.zzatt);
                int n3 = n = zzfa2.zzadj.zzgf().zzja();
                int n4 = n2;
                zzfa zzfa3 = zzfa2;
                zzfa3.zzaf();
                if (n4 > n3) {
                    zzfa3.zzadj.zzgo().zzjd().zze("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
                } else if (n4 < n3) {
                    if (zzfa3.zza(n3, zzfa3.zzatt)) {
                        zzfa3.zzadj.zzgo().zzjl().zze("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
                    } else {
                        zzfa3.zzadj.zzgo().zzjd().zze("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
                    }
                }
            }
            this.zzatk = true;
            this.zzlv();
        }
    }

    @WorkerThread
    private final boolean zzlz() {
        this.zzaf();
        this.zzlr();
        return this.zzatk;
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzh zzh2) {
        if (this.zzatu != null) {
            this.zzatv = new ArrayList<Long>();
            this.zzatv.addAll(this.zzatu);
        }
        String string = zzh2.packageName;
        zzq zzq2 = this.zzjq();
        Preconditions.checkNotEmpty((String)string);
        zzq2.zzaf();
        zzq2.zzcl();
        try {
            SQLiteDatabase sQLiteDatabase = zzq2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzq2.zzgo().zzjl().zze("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzq2.zzgo().zzjd().zze("Error resetting analytics data. appId, error", zzap.zzbv((String)string), (Object)sQLiteException);
        }
        zzh zzh3 = this.zza(this.zzadj.getContext(), zzh2.packageName, zzh2.zzafx, zzh2.zzagg, zzh2.zzagi, zzh2.zzagj, zzh2.zzagx, zzh2.zzagk);
        if (!this.zzadj.zzgq().zzbd(zzh2.packageName) || zzh2.zzagg) {
            this.zzf(zzh3);
        }
    }

    private final zzh zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzadj.zzgo().zzjd().zzbx("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzadj.zzgo().zzjd().zzg("Error retrieving installer package name. appId", zzap.zzbv((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzadj.zzgo().zzjd().zze("Error retrieving newly installed package info. appId, appName", zzap.zzbv((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzk zzk2 = this.zzadj.zzgr();
        long l3 = 0L;
        if (this.zzadj.zzgq().zzbe(string)) {
            l3 = l;
        }
        return new zzh(string, string2, string5, (long)n, string4, this.zzadj.zzgq().zzhc(), this.zzadj.zzgm().zzd(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3);
    }

    @WorkerThread
    final void zzb(zzfh zzfh2, zzh zzh2) {
        zzfj zzfj2;
        this.zzaf();
        this.zzlr();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzafx) && TextUtils.isEmpty((CharSequence)zzh2.zzagk)) {
            return;
        }
        if (!zzh2.zzagg) {
            this.zzg(zzh2);
            return;
        }
        if (this.zzadj.zzgq().zze(zzh2.packageName, zzaf.zzalj) && "_ap".equals(zzfh2.name) && (zzfj2 = this.zzjq().zzi(zzh2.packageName, "_ap")) != null && "auto".equals(zzfh2.origin) && !"auto".equals(zzfj2.origin)) {
            this.zzadj.zzgo().zzjk().zzbx("Not setting lower priority ad personalization property");
            return;
        }
        int n = this.zzadj.zzgm().zzcs(zzfh2.name);
        if (n != 0) {
            this.zzadj.zzgm();
            String string = zzfk.zza((String)zzfh2.name, (int)24, (boolean)true);
            int n2 = zzfh2.name != null ? zzfh2.name.length() : 0;
            this.zzadj.zzgm().zza(zzh2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzadj.zzgm().zzi(zzfh2.name, zzfh2.getValue());
        if (n != 0) {
            this.zzadj.zzgm();
            String string = zzfk.zza((String)zzfh2.name, (int)24, (boolean)true);
            Object object = zzfh2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzadj.zzgm().zza(zzh2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzadj.zzgm().zzj(zzfh2.name, zzfh2.getValue());
        if (object == null) {
            return;
        }
        zzfj zzfj3 = new zzfj(zzh2.packageName, zzfh2.origin, zzfh2.name, zzfh2.zzaue, object);
        this.zzadj.zzgo().zzjk().zze("Setting user property", (Object)this.zzadj.zzgl().zzbu(zzfj3.name), object);
        this.zzjq().beginTransaction();
        try {
            this.zzg(zzh2);
            boolean bl = this.zzjq().zza(zzfj3);
            this.zzjq().setTransactionSuccessful();
            if (bl) {
                this.zzadj.zzgo().zzjk().zze("User property set", (Object)this.zzadj.zzgl().zzbu(zzfj3.name), zzfj3.value);
            } else {
                this.zzadj.zzgo().zzjd().zze("Too many unique user properties are set. Ignoring user property", (Object)this.zzadj.zzgl().zzbu(zzfj3.name), zzfj3.value);
                this.zzadj.zzgm().zza(zzh2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzfh zzfh2, zzh zzh2) {
        zzfj zzfj2;
        this.zzaf();
        this.zzlr();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzafx) && TextUtils.isEmpty((CharSequence)zzh2.zzagk)) {
            return;
        }
        if (!zzh2.zzagg) {
            this.zzg(zzh2);
            return;
        }
        if (this.zzadj.zzgq().zze(zzh2.packageName, zzaf.zzalj) && "_ap".equals(zzfh2.name) && (zzfj2 = this.zzjq().zzi(zzh2.packageName, "_ap")) != null && "auto".equals(zzfh2.origin) && !"auto".equals(zzfj2.origin)) {
            this.zzadj.zzgo().zzjk().zzbx("Not removing higher priority ad personalization property");
            return;
        }
        this.zzadj.zzgo().zzjk().zzg("Removing user property", (Object)this.zzadj.zzgl().zzbu(zzfh2.name));
        this.zzjq().beginTransaction();
        try {
            this.zzg(zzh2);
            this.zzjq().zzh(zzh2.packageName, zzfh2.name);
            this.zzjq().setTransactionSuccessful();
            this.zzadj.zzgo().zzjk().zzg("User property removed", (Object)this.zzadj.zzgl().zzbu(zzfh2.name));
            return;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    final void zzb(zzez zzez2) {
        ++this.zzatn;
    }

    final void zzma() {
        ++this.zzato;
    }

    final zzbt zzmb() {
        return this.zzadj;
    }

    @WorkerThread
    final void zzf(zzh zzh2) {
        int n;
        this.zzaf();
        this.zzlr();
        Preconditions.checkNotNull((Object)zzh2);
        Preconditions.checkNotEmpty((String)zzh2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzh2.zzafx) && TextUtils.isEmpty((CharSequence)zzh2.zzagk)) {
            return;
        }
        zzg zzg2 = this.zzjq().zzbl(zzh2.packageName);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzh2.zzafx)) {
            zzg2.zzy(0L);
            this.zzjq().zza(zzg2);
            this.zzln().zzci(zzh2.packageName);
        }
        if (!zzh2.zzagg) {
            this.zzg(zzh2);
            return;
        }
        long l = zzh2.zzagx;
        if (l == 0L) {
            l = this.zzadj.zzbx().currentTimeMillis();
        }
        if ((n = zzh2.zzagy) != 0 && n != 1) {
            this.zzadj.zzgo().zzjg().zze("Incorrect app type, assuming installed app. appId, appType", zzap.zzbv((String)zzh2.packageName), (Object)n);
            n = 0;
        }
        this.zzjq().beginTransaction();
        try {
            zzad zzad2;
            Bundle bundle;
            long l2 = l;
            zzh zzh3 = zzh2;
            zzfa zzfa2 = this;
            zzg zzg3 = zzfa2.zzjq().zzbl(zzh3.packageName);
            if (zzg3 != null) {
                zzfa2.zzadj.zzgm();
                if (zzfk.zza((String)zzh3.zzafx, (String)zzg3.getGmpAppId(), (String)zzh3.zzagk, (String)zzg3.zzgw())) {
                    zzfa2.zzadj.zzgo().zzjg().zzg("New GMP App Id passed in. Removing cached database data. appId", zzap.zzbv((String)zzg3.zzal()));
                    String string = zzg3.zzal();
                    zzq zzq2 = zzfa2.zzjq();
                    zzq2.zzcl();
                    zzq2.zzaf();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzq2.getWritableDatabase();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzq2.zzgo().zzjl().zze("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzq2.zzgo().zzjd().zze("Error deleting application data. appId, error", zzap.zzbv((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null) {
                if (zzg3.zzha() != Integer.MIN_VALUE) {
                    if (zzg3.zzha() != zzh3.zzagd) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzg3.zzak());
                        zzad2 = new zzad("_au", new zzaa(bundle), "auto", l2);
                        zzfa2.zzc(zzad2, zzh3);
                    }
                } else if (zzg3.zzak() != null && !zzg3.zzak().equals(zzh3.zzts)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzg3.zzak());
                    zzad2 = new zzad("_au", new zzaa(bundle), "auto", l2);
                    zzfa2.zzc(zzad2, zzh3);
                }
            }
            this.zzg(zzh2);
            zzz zzz2 = null;
            if (n == 0) {
                zzz2 = this.zzjq().zzg(zzh2.packageName, "_f");
            } else if (n == 1) {
                zzz2 = this.zzjq().zzg(zzh2.packageName, "_v");
            }
            if (zzz2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzfh zzfh2;
                    zzfh zzfh3 = new zzfh("_fot", l, (Object)l3, "auto");
                    this.zzb(zzfh3, zzh2);
                    if (this.zzadj.zzgq().zzbg(zzh2.zzafx)) {
                        zzh3 = zzh2;
                        zzfa2 = this;
                        zzfa2.zzaf();
                        zzfa2.zzadj.zzkg().zzcd(zzh3.packageName);
                    }
                    l2 = l;
                    zzh3 = zzh2;
                    zzfa2 = this;
                    zzfa2.zzaf();
                    zzfa2.zzlr();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzfa2.zzadj.zzgq().zzbd(zzh3.packageName) && zzh3.zzagz) {
                        zzg3.putLong("_dac", 1L);
                    }
                    if (zzfa2.zzadj.getContext().getPackageManager() == null) {
                        zzfa2.zzadj.zzgo().zzjd().zzg("PackageManager is null, first open report might be inaccurate. appId", zzap.zzbv((String)zzh3.packageName));
                    } else {
                        zzad2 = null;
                        try {
                            zzad2 = Wrappers.packageManager((Context)zzfa2.zzadj.getContext()).getPackageInfo(zzh3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzfa2.zzadj.zzgo().zzjd().zze("Package info is null, first open report might be inaccurate. appId", zzap.zzbv((String)zzh3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzad2 != null && zzad2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzad2.firstInstallTime != zzad2.lastUpdateTime) {
                                zzg3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzfh2 = new zzfh("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzfa2.zzb(zzfh2, zzh3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzfa2.zzadj.getContext()).getApplicationInfo(zzh3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzfa2.zzadj.zzgo().zzjd().zze("Application info is null, first open report might be inaccurate. appId", zzap.zzbv((String)zzh3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzh3.packageName;
                    zzq zzq3 = zzfa2.zzjq();
                    Preconditions.checkNotEmpty((String)string);
                    zzq3.zzaf();
                    zzq3.zzcl();
                    long l4 = zzq3.zzn(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    zzfh2 = new zzad("_f", new zzaa((Bundle)zzg3), "auto", l2);
                    zzfa2.zzc((zzad)zzfh2, zzh3);
                } else if (n == 1) {
                    zzfh zzfh4 = new zzfh("_fvt", l, (Object)l3, "auto");
                    this.zzb(zzfh4, zzh2);
                    l2 = l;
                    zzh3 = zzh2;
                    zzfa2 = this;
                    zzfa2.zzaf();
                    zzfa2.zzlr();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzfa2.zzadj.zzgq().zzbd(zzh3.packageName) && zzh3.zzagz) {
                        zzg3.putLong("_dac", 1L);
                    }
                    bundle = new zzad("_v", new zzaa((Bundle)zzg3), "auto", l2);
                    zzfa2.zzc((zzad)bundle, zzh3);
                }
                l2 = l;
                zzh3 = zzh2;
                zzfa2 = this;
                zzg3 = new Bundle();
                zzg3.putLong("_et", 1L);
                bundle = new zzad("_e", new zzaa((Bundle)zzg3), "auto", l2);
                zzfa2.zzc((zzad)bundle, zzh3);
            } else if (zzh2.zzagw) {
                l2 = l;
                zzh3 = zzh2;
                zzfa2 = this;
                zzg3 = new Bundle();
                bundle = new zzad("_cd", new zzaa((Bundle)zzg3), "auto", l2);
                zzfa2.zzc((zzad)bundle, zzh3);
            }
            this.zzjq().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    @WorkerThread
    private final zzh zzco(String string) {
        zzg zzg2 = this.zzjq().zzbl(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzak())) {
            this.zzadj.zzgo().zzjk().zzg("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzadj.zzgo().zzjd().zzg("App version does not match; dropping. appId", zzap.zzbv((String)string));
            return null;
        }
        return new zzh(string, zzg2.getGmpAppId(), zzg2.zzak(), zzg2.zzha(), zzg2.zzhb(), zzg2.zzhc(), zzg2.zzhd(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzhq(), 0L, 0, zzg2.zzhr(), zzg2.zzhs(), false, zzg2.zzgw());
    }

    @WorkerThread
    final void zze(zzl zzl2) {
        zzh zzh2 = this.zzco(zzl2.packageName);
        if (zzh2 != null) {
            this.zzb(zzl2, zzh2);
        }
    }

    @WorkerThread
    final void zzb(zzl zzl2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzl2);
        Preconditions.checkNotEmpty((String)zzl2.packageName);
        Preconditions.checkNotNull((Object)zzl2.origin);
        Preconditions.checkNotNull((Object)zzl2.zzahb);
        Preconditions.checkNotEmpty((String)zzl2.zzahb.name);
        this.zzaf();
        this.zzlr();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzafx) && TextUtils.isEmpty((CharSequence)zzh2.zzagk)) {
            return;
        }
        if (!zzh2.zzagg) {
            this.zzg(zzh2);
            return;
        }
        zzl zzl3 = new zzl(zzl2);
        new zzl(zzl2).active = false;
        this.zzjq().beginTransaction();
        try {
            boolean bl = false;
            zzl zzl4 = this.zzjq().zzj(zzl3.packageName, zzl3.zzahb.name);
            if (zzl4 != null && !zzl4.origin.equals(zzl3.origin)) {
                this.zzadj.zzgo().zzjg().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzadj.zzgl().zzbu(zzl3.zzahb.name), (Object)zzl3.origin, (Object)zzl4.origin);
            }
            if (zzl4 != null && zzl4.active) {
                zzl3.origin = zzl4.origin;
                zzl3.creationTimestamp = zzl4.creationTimestamp;
                zzl3.triggerTimeout = zzl4.triggerTimeout;
                zzl3.triggerEventName = zzl4.triggerEventName;
                zzl3.zzahd = zzl4.zzahd;
                zzl3.active = zzl4.active;
                zzl3.zzahb = new zzfh(zzl3.zzahb.name, zzl4.zzahb.zzaue, zzl3.zzahb.getValue(), zzl4.zzahb.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzl3.triggerEventName)) {
                zzl3.zzahb = new zzfh(zzl3.zzahb.name, zzl3.creationTimestamp, zzl3.zzahb.getValue(), zzl3.zzahb.origin);
                zzl3.active = true;
                bl = true;
            }
            if (zzl3.active) {
                zzfh zzfh2 = zzl3.zzahb;
                zzfj zzfj2 = new zzfj(zzl3.packageName, zzl3.origin, zzfh2.name, zzfh2.zzaue, zzfh2.getValue());
                if (this.zzjq().zza(zzfj2)) {
                    this.zzadj.zzgo().zzjk().zzd("User property updated immediately", (Object)zzl3.packageName, (Object)this.zzadj.zzgl().zzbu(zzfj2.name), zzfj2.value);
                } else {
                    this.zzadj.zzgo().zzjd().zzd("(2)Too many active user properties, ignoring", zzap.zzbv((String)zzl3.packageName), (Object)this.zzadj.zzgl().zzbu(zzfj2.name), zzfj2.value);
                }
                if (bl && zzl3.zzahd != null) {
                    zzad zzad2 = new zzad(zzl3.zzahd, zzl3.creationTimestamp);
                    this.zzd(zzad2, zzh2);
                }
            }
            if (this.zzjq().zza(zzl3)) {
                this.zzadj.zzgo().zzjk().zzd("Conditional property added", (Object)zzl3.packageName, (Object)this.zzadj.zzgl().zzbu(zzl3.zzahb.name), zzl3.zzahb.getValue());
            } else {
                this.zzadj.zzgo().zzjd().zzd("Too many conditional properties, ignoring", zzap.zzbv((String)zzl3.packageName), (Object)this.zzadj.zzgl().zzbu(zzl3.zzahb.name), zzl3.zzahb.getValue());
            }
            this.zzjq().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    @WorkerThread
    final void zzf(zzl zzl2) {
        zzh zzh2 = this.zzco(zzl2.packageName);
        if (zzh2 != null) {
            this.zzc(zzl2, zzh2);
        }
    }

    @WorkerThread
    final void zzc(zzl zzl2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzl2);
        Preconditions.checkNotEmpty((String)zzl2.packageName);
        Preconditions.checkNotNull((Object)zzl2.zzahb);
        Preconditions.checkNotEmpty((String)zzl2.zzahb.name);
        this.zzaf();
        this.zzlr();
        if (TextUtils.isEmpty((CharSequence)zzh2.zzafx) && TextUtils.isEmpty((CharSequence)zzh2.zzagk)) {
            return;
        }
        if (!zzh2.zzagg) {
            this.zzg(zzh2);
            return;
        }
        this.zzjq().beginTransaction();
        try {
            this.zzg(zzh2);
            zzl zzl3 = this.zzjq().zzj(zzl2.packageName, zzl2.zzahb.name);
            if (zzl3 != null) {
                this.zzadj.zzgo().zzjk().zze("Removing conditional user property", (Object)zzl2.packageName, (Object)this.zzadj.zzgl().zzbu(zzl2.zzahb.name));
                this.zzjq().zzk(zzl2.packageName, zzl2.zzahb.name);
                if (zzl3.active) {
                    this.zzjq().zzh(zzl2.packageName, zzl2.zzahb.name);
                }
                if (zzl2.zzahe != null) {
                    Bundle bundle = null;
                    if (zzl2.zzahe.zzaid != null) {
                        bundle = zzl2.zzahe.zzaid.zziv();
                    }
                    zzad zzad2 = this.zzadj.zzgm().zza(zzl2.packageName, zzl2.zzahe.name, bundle, zzl3.origin, zzl2.zzahe.zzaip, true, false);
                    this.zzd(zzad2, zzh2);
                }
            } else {
                this.zzadj.zzgo().zzjg().zze("Conditional user property doesn't exist", zzap.zzbv((String)zzl2.packageName), (Object)this.zzadj.zzgl().zzbu(zzl2.zzahb.name));
            }
            this.zzjq().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjq().endTransaction();
        }
    }

    @WorkerThread
    private final zzg zzg(zzh zzh2) {
        this.zzaf();
        this.zzlr();
        Preconditions.checkNotNull((Object)zzh2);
        Preconditions.checkNotEmpty((String)zzh2.packageName);
        zzg zzg2 = this.zzjq().zzbl(zzh2.packageName);
        String string = this.zzadj.zzgp().zzbz(zzh2.packageName);
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzadj, zzh2.packageName);
            zzg2.zzam(this.zzadj.zzgm().zzmf());
            zzg2.zzap(string);
            bl = true;
        } else if (!string.equals(zzg2.zzgx())) {
            zzg2.zzap(string);
            zzg2.zzam(this.zzadj.zzgm().zzmf());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzh2.zzafx, (CharSequence)zzg2.getGmpAppId())) {
            zzg2.zzan(zzh2.zzafx);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzh2.zzagk, (CharSequence)zzg2.zzgw())) {
            zzg2.zzao(zzh2.zzagk);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzh2.zzafz) && !zzh2.zzafz.equals(zzg2.getFirebaseInstanceId())) {
            zzg2.zzaq(zzh2.zzafz);
            bl = true;
        }
        if (zzh2.zzadt != 0L && zzh2.zzadt != zzg2.zzhc()) {
            zzg2.zzv(zzh2.zzadt);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzh2.zzts) && !zzh2.zzts.equals(zzg2.zzak())) {
            zzg2.setAppVersion(zzh2.zzts);
            bl = true;
        }
        if (zzh2.zzagd != zzg2.zzha()) {
            zzg2.zzu(zzh2.zzagd);
            bl = true;
        }
        if (zzh2.zzage != null && !zzh2.zzage.equals(zzg2.zzhb())) {
            zzg2.zzar(zzh2.zzage);
            bl = true;
        }
        if (zzh2.zzagf != zzg2.zzhd()) {
            zzg2.zzw(zzh2.zzagf);
            bl = true;
        }
        if (zzh2.zzagg != zzg2.isMeasurementEnabled()) {
            zzg2.setMeasurementEnabled(zzh2.zzagg);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzh2.zzagv) && !zzh2.zzagv.equals(zzg2.zzho())) {
            zzg2.zzas(zzh2.zzagv);
            bl = true;
        }
        if (zzh2.zzagh != zzg2.zzhq()) {
            zzg2.zzag(zzh2.zzagh);
            bl = true;
        }
        if (zzh2.zzagi != zzg2.zzhr()) {
            zzg2.zze(zzh2.zzagi);
            bl = true;
        }
        if (zzh2.zzagj != zzg2.zzhs()) {
            zzg2.zzf(zzh2.zzagj);
            bl = true;
        }
        if (bl) {
            this.zzjq().zza(zzg2);
        }
        return zzg2;
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzad zzad2, @Size(min=1L) String string) {
        Long l;
        this.zzlr();
        this.zzaf();
        this.zzadj.zzga();
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotEmpty((String)string);
        zzgh zzgh2 = new zzgh();
        this.zzjq().beginTransaction();
        try {
            zzz zzz2;
            long l2;
            zzgl zzgl2;
            zzg zzg2 = this.zzjq().zzbl(string);
            if (zzg2 == null) {
                this.zzadj.zzgo().zzjk().zzg("Log and bundle not available. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzg2.isMeasurementEnabled()) {
                this.zzadj.zzgo().zzjk().zzg("Log and bundle disabled. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzad2.name) || "ecommerce_purchase".equals(zzad2.name)) && !this.zza(string, zzad2)) {
                this.zzadj.zzgo().zzjg().zzg("Failed to handle purchase event at single event bundle creation. appId", zzap.zzbv((String)string));
            }
            boolean bl = this.zzadj.zzgq().zzax(string);
            l = 0L;
            if (bl && "_e".equals(zzad2.name)) {
                if (zzad2.zzaid == null || zzad2.zzaid.size() == 0) {
                    this.zzadj.zzgo().zzjg().zzg("The engagement event does not contain any parameters. appId", zzap.zzbv((String)string));
                } else if (zzad2.zzaid.getLong("_et") == null) {
                    this.zzadj.zzgo().zzjg().zzg("The engagement event does not include duration. appId", zzap.zzbv((String)string));
                } else {
                    l = zzad2.zzaid.getLong("_et");
                }
            }
            zzgi zzgi2 = new zzgi();
            zzgh2.zzawy = new zzgi[]{zzgi2};
            zzgi2.zzaxa = 1;
            zzgi2.zzaxi = "android";
            zzgi2.zztt = zzg2.zzal();
            zzgi2.zzage = zzg2.zzhb();
            zzgi2.zzts = zzg2.zzak();
            long l3 = zzg2.zzha();
            zzgi2.zzaxu = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzgi2.zzaxm = zzg2.zzhc();
            zzgi2.zzafx = zzg2.getGmpAppId();
            if (TextUtils.isEmpty((CharSequence)zzgi2.zzafx)) {
                zzgi2.zzawj = zzg2.zzgw();
            }
            zzgi2.zzaxq = zzg2.zzhd();
            if (this.zzadj.isEnabled() && zzn.zzhz() && this.zzadj.zzgq().zzav(zzgi2.zztt)) {
                zzgi2.zzaya = null;
            }
            Pair pair = this.zzadj.zzgp().zzby(zzg2.zzal());
            if (zzg2.zzhr() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzgi2.zzaxo = (String)pair.first;
                zzgi2.zzaxp = (Boolean)pair.second;
            }
            this.zzadj.zzgk().zzcl();
            zzgi2.zzaxk = Build.MODEL;
            this.zzadj.zzgk().zzcl();
            zzgi2.zzaxj = Build.VERSION.RELEASE;
            zzgi2.zzaxl = (int)this.zzadj.zzgk().zzis();
            zzgi2.zzaia = this.zzadj.zzgk().zzit();
            zzgi2.zzafw = zzg2.getAppInstanceId();
            zzgi2.zzafz = zzg2.getFirebaseInstanceId();
            List<zzfj> list = this.zzjq().zzbk(zzg2.zzal());
            zzgi2.zzaxc = new zzgl[list.size()];
            zzfj zzfj2 = null;
            if (bl) {
                zzfj2 = this.zzjq().zzi(zzgi2.zztt, "_lte");
                if (zzfj2 == null || zzfj2.value == null) {
                    zzfj2 = new zzfj(zzgi2.zztt, "auto", "_lte", this.zzadj.zzbx().currentTimeMillis(), (Object)l);
                } else if (l > 0L) {
                    zzfj2 = new zzfj(zzgi2.zztt, "auto", "_lte", this.zzadj.zzbx().currentTimeMillis(), (Object)((Long)zzfj2.value + l));
                }
            }
            zzgl zzgl3 = null;
            for (int i = 0; i < list.size(); ++i) {
                zzgi2.zzaxc[i] = zzgl2 = new zzgl();
                zzgl2.name = list.get((int)i).name;
                zzgl2.zzayl = list.get((int)i).zzaue;
                this.zzjo().zza(zzgl2, list.get((int)i).value);
                if (!bl || !"_lte".equals(zzgl2.name)) continue;
                zzgl3 = zzgl2;
                zzgl2.zzawx = (Long)zzfj2.value;
                zzgl3.zzayl = this.zzadj.zzbx().currentTimeMillis();
            }
            if (bl && zzgl3 == null) {
                zzgl3 = new zzgl();
                new zzgl().name = "_lte";
                zzgl3.zzayl = this.zzadj.zzbx().currentTimeMillis();
                zzgl3.zzawx = (Long)zzfj2.value;
                zzgi2.zzaxc = Arrays.copyOf(zzgi2.zzaxc, zzgi2.zzaxc.length + 1);
                zzgi2.zzaxc[zzgi2.zzaxc.length - 1] = zzgl3;
            }
            if (l > 0L) {
                this.zzjq().zza(zzfj2);
            }
            Bundle bundle = zzad2.zzaid.zziv();
            if ("_iap".equals(zzad2.name)) {
                bundle.putLong("_c", 1L);
                this.zzadj.zzgo().zzjk().zzbx("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzad2.origin);
            if (this.zzadj.zzgm().zzcw(zzgi2.zztt)) {
                this.zzadj.zzgm().zza(bundle, "_dbg", (Object)1L);
                this.zzadj.zzgm().zza(bundle, "_r", (Object)1L);
            }
            if ((zzgl2 = this.zzjq().zzg(string, zzad2.name)) == null) {
                l2 = 0L;
                zzz2 = new zzz(string, zzad2.name, 1L, 0L, zzad2.zzaip, 0L, null, null, null, null);
                this.zzjq().zza(zzz2);
            } else {
                l2 = ((zzz)zzgl2).zzaig;
                zzz2 = zzgl2.zzai(zzad2.zzaip).zziu();
                this.zzjq().zza(zzz2);
            }
            zzy zzy2 = new zzy(this.zzadj, zzad2.origin, string, zzad2.name, zzad2.zzaip, l2, bundle);
            zzgf zzgf2 = new zzgf();
            zzgi2.zzaxb = new zzgf[]{zzgf2};
            zzgf2.zzawu = zzy2.timestamp;
            zzgf2.name = zzy2.name;
            zzgf2.zzawv = zzy2.zzaic;
            zzgf2.zzawt = new zzgg[zzy2.zzaid.size()];
            int n = 0;
            for (String string2 : zzy2.zzaid) {
                zzgg zzgg2 = new zzgg();
                zzgf2.zzawt[n++] = zzgg2;
                zzgg2.name = string2;
                Object object = zzy2.zzaid.get(string2);
                this.zzjo().zza(zzgg2, object);
            }
            zzgi2.zzaxt = this.zza(zzg2.zzal(), zzgi2.zzaxc, zzgi2.zzaxb);
            zzgi2.zzaxe = zzgf2.zzawu;
            zzgi2.zzaxf = zzgf2.zzawu;
            long l4 = zzg2.zzgz();
            zzgi2.zzaxh = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzg2.zzgy();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzgi2.zzaxg = l5 != 0L ? Long.valueOf(l5) : null;
            zzg2.zzhh();
            zzgi2.zzaxr = (int)zzg2.zzhe();
            zzgi2.zzaxn = this.zzadj.zzgq().zzhc();
            zzgi2.zzaxd = this.zzadj.zzbx().currentTimeMillis();
            zzgi2.zzaxs = Boolean.TRUE;
            zzg2.zzs(zzgi2.zzaxe.longValue());
            zzg2.zzt(zzgi2.zzaxf.longValue());
            this.zzjq().zza(zzg2);
            this.zzjq().setTransactionSuccessful();
        }
        finally {
            this.zzjq().endTransaction();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzgh2.zzvu()];
            l = zzyy.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgh2.zza((zzyy)l);
            l.zzyt();
            return this.zzjo().zzb(byArray);
        }
        catch (IOException iOException) {
            this.zzadj.zzgo().zzjd().zze("Data loss. Failed to bundle and serialize. appId", zzap.zzbv((String)string), (Object)iOException);
            return null;
        }
    }

    final String zzh(zzh zzh2) {
        Future future = this.zzadj.zzgn().zzb((Callable)new zzfe(this, zzh2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzadj.zzgo().zzjd().zze("Failed to get app instance id. appId", zzap.zzbv((String)zzh2.packageName), (Object)exception);
            return null;
        }
    }

    final void zzo(boolean bl) {
        this.zzlv();
    }

    static /* synthetic */ void zza(zzfa zzfa2, zzff zzff2) {
        zzfa2.zza(zzff2);
    }

    static /* synthetic */ zzg zza(zzfa zzfa2, zzh zzh2) {
        return zzfa2.zzg(zzh2);
    }

    final class zza
    implements zzs {
        zzgi zzaua;
        List<Long> zzaub;
        List<zzgf> zzauc;
        private long zzaud;

        private zza() {
        }

        @Override
        public final void zzb(zzgi zzgi2) {
            Preconditions.checkNotNull((Object)((Object)zzgi2));
            this.zzaua = zzgi2;
        }

        @Override
        public final boolean zza(long l, zzgf zzgf2) {
            Preconditions.checkNotNull((Object)((Object)zzgf2));
            if (this.zzauc == null) {
                this.zzauc = new ArrayList<zzgf>();
            }
            if (this.zzaub == null) {
                this.zzaub = new ArrayList<Long>();
            }
            if (this.zzauc.size() > 0 && zza.zza(this.zzauc.get(0)) != zza.zza(zzgf2)) {
                return false;
            }
            long l2 = this.zzaud + (long)zzgf2.zzvu();
            if (l2 >= (long)Math.max(0, (Integer)zzaf.zzajl.get())) {
                return false;
            }
            this.zzaud = l2;
            this.zzauc.add(zzgf2);
            this.zzaub.add(l);
            return this.zzauc.size() < Math.max(1, (Integer)zzaf.zzajm.get());
        }

        private static long zza(zzgf zzgf2) {
            return zzgf2.zzawu / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzfb zzfb2) {
            this();
        }
    }
}

