/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzbz;
import com.google.android.gms.measurement.internal.zzca;
import com.google.android.gms.measurement.internal.zzcb;
import com.google.android.gms.measurement.internal.zzcc;
import com.google.android.gms.measurement.internal.zzcd;
import com.google.android.gms.measurement.internal.zzce;
import com.google.android.gms.measurement.internal.zzcf;
import com.google.android.gms.measurement.internal.zzcg;
import com.google.android.gms.measurement.internal.zzch;
import com.google.android.gms.measurement.internal.zzci;
import com.google.android.gms.measurement.internal.zzcj;
import com.google.android.gms.measurement.internal.zzck;
import com.google.android.gms.measurement.internal.zzcl;
import com.google.android.gms.measurement.internal.zzcm;
import com.google.android.gms.measurement.internal.zzcn;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzcp;
import com.google.android.gms.measurement.internal.zzcq;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzby
extends zzak {
    private final zzfo zzamv;
    private Boolean zzaqi;
    @Nullable
    private String zzaqj;

    public zzby(zzfo zzfo2) {
        this(zzfo2, null);
    }

    private zzby(zzfo zzfo2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzfo2);
        this.zzamv = zzfo2;
        this.zzaqj = null;
    }

    @BinderThread
    public final void zzb(zzk zzk2) {
        this.zzb(zzk2, false);
        this.zze(new zzbz(this, zzk2));
    }

    @BinderThread
    public final void zza(zzag zzag2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzag2);
        this.zzb(zzk2, false);
        this.zze(new zzcj(this, zzag2, zzk2));
    }

    @VisibleForTesting
    final zzag zzb(zzag zzag2, zzk zzk2) {
        String string;
        zzk zzk3 = zzk2;
        zzag zzag3 = zzag2;
        zzby zzby2 = this;
        if (!"_cmp".equals(zzag3.name) || zzag3.zzahu == null || zzag3.zzahu.size() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzag3.zzahu.getString("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzby2.zzamv.zzgv().zzbe(zzk3.packageName)) {
            this.zzamv.zzgt().zzjm().zzg("Event has been filtered ", (Object)zzag2.toString());
            return new zzag("_cmpx", zzag2.zzahu, zzag2.origin, zzag2.zzaig);
        }
        return zzag2;
    }

    @BinderThread
    public final void zza(zzag zzag2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zze(new zzck(this, zzag2, string));
    }

    @BinderThread
    public final byte[] zza(zzag zzag2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzag2);
        this.zzc(string, true);
        this.zzamv.zzgt().zzjn().zzg("Log and bundle. event", (Object)this.zzamv.zzgq().zzbt(zzag2.name));
        long l = this.zzamv.zzbx().nanoTime() / 1000000L;
        Future future = this.zzamv.zzgs().zzc((Callable)new zzcl(this, zzag2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zzamv.zzgt().zzjg().zzg("Log and bundle returned null. appId", zzas.zzbw((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zzamv.zzbx().nanoTime() / 1000000L;
            this.zzamv.zzgt().zzjn().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zzamv.zzgq().zzbt(zzag2.name), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamv.zzgt().zzjg().zzd("Failed to log and bundle. appId, event, error", zzas.zzbw((String)string), (Object)this.zzamv.zzgq().zzbt(zzag2.name), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzfv zzfv2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzfv2);
        this.zzb(zzk2, false);
        if (zzfv2.getValue() == null) {
            this.zze(new zzcm(this, zzfv2, zzk2));
            return;
        }
        this.zze(new zzcn(this, zzfv2, zzk2));
    }

    @BinderThread
    public final List<zzfv> zza(zzk zzk2, boolean bl) {
        this.zzb(zzk2, false);
        Future future = this.zzamv.zzgs().zzb((Callable)new zzco(this, zzk2));
        try {
            List list = (List)future.get();
            ArrayList<zzfv> arrayList = new ArrayList<zzfv>(list.size());
            for (zzfx zzfx2 : list) {
                if (!bl && zzfy.zzcy((String)zzfx2.name)) continue;
                arrayList.add(new zzfv(zzfx2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamv.zzgt().zzjg().zze("Failed to get user attributes. appId", zzas.zzbw((String)zzk2.packageName), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzk zzk2) {
        this.zzb(zzk2, false);
        this.zze(new zzcp(this, zzk2));
    }

    @BinderThread
    private final void zzb(zzk zzk2, boolean bl) {
        Preconditions.checkNotNull((Object)zzk2);
        this.zzc(zzk2.packageName, false);
        this.zzamv.zzgr().zzu(zzk2.zzafi, zzk2.zzafv);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzamv.zzgt().zzjg().zzby("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzby zzby2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzby2 = this;
                    if (!bl2) break block9;
                    if (zzby2.zzaqi == null) {
                        zzby2.zzaqi = "com.google.android.gms".equals(zzby2.zzaqj) || UidVerifier.isGooglePlayServicesUid((Context)zzby2.zzamv.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzby2.zzamv.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzby2.zzaqi.booleanValue()) break block10;
                }
                if (zzby2.zzaqj == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzby2.zzamv.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzby2.zzaqj = string2;
                }
                if (!string2.equals(zzby2.zzaqj)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzamv.zzgt().zzjg().zzg("Measurement Service called with invalid calling package. appId", zzas.zzbw((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zze(new zzcq(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzk zzk2) {
        this.zzb(zzk2, false);
        return this.zzamv.zzh(zzk2);
    }

    @BinderThread
    public final void zza(zzo zzo2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotNull((Object)zzo2.zzags);
        this.zzb(zzk2, false);
        zzo zzo3 = new zzo(zzo2);
        new zzo(zzo2).packageName = zzk2.packageName;
        if (zzo2.zzags.getValue() == null) {
            this.zze(new zzca(this, zzo3, zzk2));
            return;
        }
        this.zze(new zzcb(this, zzo3, zzk2));
    }

    @BinderThread
    public final void zzb(zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotNull((Object)zzo2.zzags);
        this.zzc(zzo2.packageName, true);
        zzo zzo3 = new zzo(zzo2);
        if (zzo2.zzags.getValue() == null) {
            this.zze(new zzcc(this, zzo3));
            return;
        }
        this.zze(new zzcd(this, zzo3));
    }

    @BinderThread
    public final List<zzfv> zza(String string, String string2, boolean bl, zzk zzk2) {
        this.zzb(zzk2, false);
        Future future = this.zzamv.zzgs().zzb((Callable)new zzce(this, zzk2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzfv> arrayList = new ArrayList<zzfv>(list.size());
            for (zzfx zzfx2 : list) {
                if (!bl && zzfy.zzcy((String)zzfx2.name)) continue;
                arrayList.add(new zzfv(zzfx2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamv.zzgt().zzjg().zze("Failed to get user attributes. appId", zzas.zzbw((String)zzk2.packageName), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzfv> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future future = this.zzamv.zzgs().zzb((Callable)new zzcf(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzfv> arrayList = new ArrayList<zzfv>(list.size());
            for (zzfx zzfx2 : list) {
                if (!bl && zzfy.zzcy((String)zzfx2.name)) continue;
                arrayList.add(new zzfv(zzfx2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamv.zzgt().zzjg().zze("Failed to get user attributes. appId", zzas.zzbw((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzo> zza(String string, String string2, zzk zzk2) {
        this.zzb(zzk2, false);
        Future future = this.zzamv.zzgs().zzb((Callable)new zzcg(this, zzk2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamv.zzgt().zzjg().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzo> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future future = this.zzamv.zzgs().zzb((Callable)new zzch(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamv.zzgt().zzjg().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzk zzk2) {
        this.zzc(zzk2.packageName, false);
        this.zze(new zzci(this, zzk2));
    }

    @VisibleForTesting
    private final void zze(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (((Boolean)zzai.zzakn.get()).booleanValue() && this.zzamv.zzgs().zzkf()) {
            runnable.run();
            return;
        }
        this.zzamv.zzgs().zzc(runnable);
    }

    static /* synthetic */ zzfo zza(zzby zzby2) {
        return zzby2.zzamv;
    }
}

