/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfq;
import com.google.android.gms.internal.measurement.zzxz;
import com.google.android.gms.internal.measurement.zzya;
import com.google.android.gms.internal.measurement.zzyc;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzt;
import java.io.IOException;
import java.util.Map;

public final class zzbq
extends zzfm
implements zzs {
    @VisibleForTesting
    private static int zzaol = 65535;
    @VisibleForTesting
    private static int zzaom = 2;
    private final Map<String, Map<String, String>> zzaon = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaoo = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaop = new ArrayMap();
    private final Map<String, zzfp> zzaoq = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzaor;
    private final Map<String, String> zzaos = new ArrayMap();

    zzbq(zzfn zzfn2) {
        super(zzfn2);
        this.zzaor = new ArrayMap();
    }

    @WorkerThread
    private final void zzcf(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzaoq.get(string) == null) {
            byte[] byArray = ((zzfl)this).zzjt().zzbo(string);
            if (byArray == null) {
                this.zzaon.put(string, null);
                this.zzaoo.put(string, null);
                this.zzaop.put(string, null);
                this.zzaoq.put(string, null);
                this.zzaos.put(string, null);
                this.zzaor.put(string, null);
                return;
            }
            zzfp zzfp2 = this.zza(string, byArray);
            this.zzaon.put(string, zzbq.zza(zzfp2));
            this.zza(string, zzfp2);
            this.zzaoq.put(string, zzfp2);
            this.zzaos.put(string, null);
        }
    }

    @WorkerThread
    protected final zzfp zzcg(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        this.zzcf(string);
        return this.zzaoq.get(string);
    }

    @WorkerThread
    protected final String zzch(String string) {
        this.zzaf();
        return this.zzaos.get(string);
    }

    @WorkerThread
    protected final void zzci(String string) {
        this.zzaf();
        this.zzaos.put(string, null);
    }

    @WorkerThread
    final void zzcj(String string) {
        this.zzaf();
        this.zzaoq.remove(string);
    }

    @WorkerThread
    public final String zzf(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        Map<String, String> map = this.zzaon.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzfp zzfp2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzfp2 != null && zzfp2.zzawo != null) {
            zzfq[] zzfqArray = zzfp2.zzawo;
            int n = zzfp2.zzawo.length;
            for (int i = 0; i < n; ++i) {
                zzfq zzfq2 = zzfqArray[i];
                if (zzfq2 == null) continue;
                arrayMap.put(zzfq2.zzoj, zzfq2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzfp zzfp2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzfp2 != null && zzfp2.zzawp != null) {
            zzfo[] zzfoArray = zzfp2.zzawp;
            int n = zzfp2.zzawp.length;
            for (int i = 0; i < n; ++i) {
                zzfo zzfo2 = zzfoArray[i];
                if (TextUtils.isEmpty((CharSequence)zzfo2.name)) {
                    this.zzgt().zzjj().zzby("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzcu.zzco((String)zzfo2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzfo2.name = string2;
                }
                arrayMap.put(zzfo2.name, zzfo2.zzawj);
                arrayMap2.put(zzfo2.name, zzfo2.zzawk);
                if (zzfo2.zzawl == null) continue;
                if (zzfo2.zzawl < zzaom || zzfo2.zzawl > zzaol) {
                    this.zzgt().zzjj().zze("Invalid sampling rate. Event name, sample rate", (Object)zzfo2.name, (Object)zzfo2.zzawl);
                    continue;
                }
                arrayMap3.put(zzfo2.name, zzfo2.zzawl);
            }
        }
        this.zzaoo.put(string, (Map<String, Boolean>)arrayMap);
        this.zzaop.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzaor.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        zzfp zzfp2 = this.zza(string, byArray);
        if (zzfp2 == null) {
            return false;
        }
        this.zza(string, zzfp2);
        this.zzaoq.put(string, zzfp2);
        this.zzaos.put(string, string2);
        this.zzaon.put(string, zzbq.zza(zzfp2));
        Object object = zzfp2.zzawq;
        String string3 = string;
        Object object2 = ((zzfl)this).zzjs();
        Preconditions.checkNotNull((Object)object);
        for (zzfi zzfi2 : object) {
            String string4;
            zzfj zzfj2;
            int n;
            zzyc[] zzycArray = zzfi2.zzavi;
            int n2 = zzfi2.zzavi.length;
            for (n = 0; n < n2; ++n) {
                zzfj2 = zzycArray[n];
                string4 = zzcu.zzco((String)zzfj2.zzavn);
                if (string4 != null) {
                    zzfj2.zzavn = string4;
                }
                zzfk[] zzfkArray = zzfj2.zzavo;
                int n3 = zzfj2.zzavo.length;
                for (int i = 0; i < n3; ++i) {
                    zzfk zzfk2 = zzfkArray[i];
                    String string5 = zzcv.zzco((String)zzfk2.zzavv);
                    if (string5 == null) continue;
                    zzfk2.zzavv = string5;
                }
            }
            zzycArray = zzfi2.zzavh;
            n2 = zzfi2.zzavh.length;
            for (n = 0; n < n2; ++n) {
                zzfj2 = zzycArray[n];
                string4 = zzcw.zzco((String)((com.google.android.gms.internal.measurement.zzfm)((Object)zzfj2)).zzawc);
                if (string4 == null) continue;
                ((com.google.android.gms.internal.measurement.zzfm)((Object)zzfj2)).zzawc = string4;
            }
        }
        ((zzfl)((Object)object2)).zzjt().zza(string3, (zzfi[])object);
        try {
            zzfp2.zzawq = null;
            byte[] byArray2 = new byte[zzfp2.zzvx()];
            object2 = byArray2;
            zzya zzya2 = zzya.zzk((byte[])byArray2, (int)0, (int)((zzm)object2).length);
            zzfp2.zza(zzya2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzgt().zzjj().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzas.zzbw((String)string), (Object)iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzfl)this).zzjt();
        Preconditions.checkNotEmpty((String)string3);
        object2.zzaf();
        ((zzfm)((Object)object2)).zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzt)((Object)object2)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object2.zzgt().zzjg().zzg("Failed to update remote config (got 0). appId", zzas.zzbw((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object2.zzgt().zzjg().zze("Error storing remote config. appId", zzas.zzbw((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        if (this.zzcl(string) && zzfx.zzcy((String)string2)) {
            return true;
        }
        if (this.zzcm(string) && zzfx.zzct((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaoo.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzp(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaop.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzq(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        Map<String, Integer> map = this.zzaor.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzck(String string) {
        String string2 = this.zzf(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgt().zzjj().zze("Unable to parse timezone offset. appId", zzas.zzbw((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzfp zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzfp();
        }
        byte[] byArray2 = byArray;
        zzxz zzxz2 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray2.length);
        zzfp zzfp2 = new zzfp();
        try {
            zzfp2.zza(zzxz2);
            this.zzgt().zzjo().zze("Parsed config. version, gmp_app_id", (Object)zzfp2.zzawm, (Object)zzfp2.zzafi);
        }
        catch (IOException iOException) {
            this.zzgt().zzjj().zze("Unable to merge remote config. appId", zzas.zzbw((String)string), (Object)iOException);
            return new zzfp();
        }
        return zzfp2;
    }

    final boolean zzcl(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzcm(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }
}

