/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzxz;
import com.google.android.gms.internal.measurement.zzya;
import com.google.android.gms.internal.measurement.zzyc;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzw;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzt
extends zzfm {
    private static final String[] zzagz = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzaha = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzahb = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;"};
    private static final String[] zzahc = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzahd = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzahe = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzw zzahf;
    private final zzfi zzahg = new zzfi(this.zzbx());

    zzt(zzfn zzfn2) {
        super(zzfn2);
        String string = "google_app_measurement.db";
        this.zzahf = new zzw(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzcl();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzcl();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzcl();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzgt().zzjg().zze("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzaf();
        try {
            return this.zzahf.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjj().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzac zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            zzac zzac2 = new zzac(string, string2, l, l2, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for event aggregates, expected one. appId", zzas.zzbw((String)string));
            }
            zzac zzac3 = zzac2;
            return zzac3;
        }
    }

    @WorkerThread
    public final void zza(zzac zzac2) {
        Preconditions.checkNotNull((Object)zzac2);
        this.zzaf();
        this.zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzac2.zztt);
        contentValues.put("name", zzac2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzac2.zzahv));
        contentValues.put("current_bundle_count", Long.valueOf(zzac2.zzahw));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzac2.zzahx));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzac2.zzahy));
        contentValues.put("last_bundled_day", zzac2.zzahz);
        contentValues.put("last_sampled_complex_event_id", zzac2.zzaia);
        contentValues.put("last_sampling_rate", zzac2.zzaib);
        Long l = null;
        if (zzac2.zzaic != null && zzac2.zzaic.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update event aggregates (got -1). appId", zzas.zzbw((String)zzac2.zztt));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing event aggregates. appId", zzas.zzbw((String)zzac2.zztt), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzgt().zzjo().zzg("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzd("Error deleting user attribute. appId", zzas.zzbw((String)string), (Object)this.zzgq().zzbv(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzfw zzfw2) {
        Preconditions.checkNotNull((Object)zzfw2);
        this.zzaf();
        this.zzcl();
        if (this.zzi(zzfw2.zztt, zzfw2.name) == null && (zzfx.zzct((String)zzfw2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzfw2.zztt}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzfw2.zztt, zzfw2.origin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzfw2.zztt);
        contentValues.put("origin", zzfw2.origin);
        contentValues.put("name", zzfw2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzfw2.zzaum));
        zzt.zza(contentValues, "value", zzfw2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update user property (got -1). appId", zzas.zzbw((String)zzfw2.zztt));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing user property. appId", zzas.zzbw((String)zzfw2.zztt), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzfw zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzfw zzfw2 = new zzfw(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for user property, expected one. appId", zzas.zzbw((String)string));
            }
            zzfw zzfw3 = zzfw2;
            return zzfw3;
        }
    }

    @WorkerThread
    public final List<zzfw> zzbl(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<zzfw> arrayList = new ArrayList<zzfw>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzfw> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzgt().zzjg().zzg("Read invalid user property value, ignoring it. appId", zzas.zzbw((String)string));
                    continue;
                }
                zzfw zzfw2 = new zzfw(string, string2, (String)object, l, object2);
                arrayList.add(zzfw2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzfw> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<zzfw> arrayList = new ArrayList<zzfw>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzfw> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgt().zzjg().zzg("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzgt().zzjg().zzd("(2)Read invalid user property value, ignoring it", zzas.zzbw((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzfw zzfw2 = new zzfw(string, string2, (String)object, l, object2);
                arrayList.add(zzfw2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzo zzo2) {
        Preconditions.checkNotNull((Object)zzo2);
        this.zzaf();
        this.zzcl();
        if (this.zzi(zzo2.packageName, zzo2.zzags.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzo2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzo2.packageName);
        contentValues.put("origin", zzo2.origin);
        contentValues.put("name", zzo2.zzags.name);
        zzt.zza(contentValues, "value", zzo2.zzags.getValue());
        contentValues.put("active", Boolean.valueOf(zzo2.active));
        contentValues.put("trigger_event_name", zzo2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzo2.triggerTimeout));
        this.zzgr();
        contentValues.put("timed_out_event", zzfx.zza((Parcelable)zzo2.zzagt));
        contentValues.put("creation_timestamp", Long.valueOf(zzo2.creationTimestamp));
        this.zzgr();
        contentValues.put("triggered_event", zzfx.zza((Parcelable)zzo2.zzagu));
        contentValues.put("triggered_timestamp", Long.valueOf(zzo2.zzags.zzaum));
        contentValues.put("time_to_live", Long.valueOf(zzo2.timeToLive));
        this.zzgr();
        contentValues.put("expired_event", zzfx.zza((Parcelable)zzo2.zzagv));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update conditional user property (got -1)", zzas.zzbw((String)zzo2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing conditional user property", zzas.zzbw((String)zzo2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzo zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzag zzag2 = (zzag)this.zzjr().zza(cursor.getBlob(5), zzag.CREATOR);
            long l2 = cursor.getLong(6);
            zzag zzag3 = (zzag)this.zzjr().zza(cursor.getBlob(7), zzag.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzag zzag4 = (zzag)this.zzjr().zza(cursor.getBlob(10), zzag.CREATOR);
            zzfu zzfu2 = new zzfu(string2, l3, object, string3);
            zzo zzo2 = new zzo(string, string3, zzfu2, l2, bl, string4, zzag2, l, zzag3, l4, zzag4);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zze("Got multiple records for conditional property, expected one", zzas.zzbw((String)string), (Object)this.zzgq().zzbv(string2));
            }
            zzo zzo3 = zzo2;
            return zzo3;
        }
    }

    @WorkerThread
    public final int zzk(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzd("Error deleting conditional property", zzas.zzbw((String)string), (Object)this.zzgq().zzbv(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzo> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzo> zzb(String string, String[] stringArray) {
        this.zzaf();
        this.zzcl();
        ArrayList<zzo> arrayList = new ArrayList<zzo>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzo> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgt().zzjg().zzg("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzag zzag2 = (zzag)this.zzjr().zza(cursor.getBlob(7), zzag.CREATOR);
                long l2 = cursor.getLong(8);
                zzag zzag3 = (zzag)this.zzjr().zza(cursor.getBlob(9), zzag.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzag zzag4 = (zzag)this.zzjr().zza(cursor.getBlob(12), zzag.CREATOR);
                zzfu zzfu2 = new zzfu(string3, l3, object2, string2);
                zzo zzo2 = new zzo((String)object, string2, zzfu2, l2, bl, string4, zzag2, l, zzag3, l4, zzag4);
                arrayList.add(zzo2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzg zzbm(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzg zzg2 = new zzg(this.zzamx.zzmh(), string);
            zzg2.zzaj(cursor.getString(0));
            zzg2.zzak(cursor.getString(1));
            zzg2.zzam(cursor.getString(2));
            zzg2.zzt(cursor.getLong(3));
            zzg2.zzo(cursor.getLong(4));
            zzg2.zzp(cursor.getLong(5));
            zzg2.setAppVersion(cursor.getString(6));
            zzg2.zzao(cursor.getString(7));
            zzg2.zzr(cursor.getLong(8));
            zzg2.zzs(cursor.getLong(9));
            zzg2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzg2.zzw(cursor.getLong(11));
            zzg2.zzx(cursor.getLong(12));
            zzg2.zzy(cursor.getLong(13));
            zzg2.zzz(cursor.getLong(14));
            zzg2.zzu(cursor.getLong(15));
            zzg2.zzv(cursor.getLong(16));
            zzg2.zzq(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzg2.zzan(cursor.getString(18));
            zzg2.zzab(cursor.getLong(19));
            zzg2.zzaa(cursor.getLong(20));
            zzg2.zzap(cursor.getString(21));
            zzg2.zzac(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzg2.zze(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzg2.zzf(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzg2.zzal(cursor.getString(25));
            zzg2.zzha();
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for app, expected one. appId", zzas.zzbw((String)string));
            }
            zzg zzg3 = zzg2;
            return zzg3;
        }
    }

    @WorkerThread
    public final void zza(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        this.zzaf();
        this.zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzal());
        contentValues.put("app_instance_id", zzg2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzg2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzg2.zzhc());
        contentValues.put("last_bundle_index", Long.valueOf(zzg2.zzhj()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzg2.zzhd()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzg2.zzhe()));
        contentValues.put("app_version", zzg2.zzak());
        contentValues.put("app_store", zzg2.zzhg());
        contentValues.put("gmp_version", Long.valueOf(zzg2.zzhh()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzg2.zzhi()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzg2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzg2.zzhn()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzg2.zzho()));
        contentValues.put("daily_events_count", Long.valueOf(zzg2.zzhp()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzg2.zzhq()));
        contentValues.put("config_fetched_time", Long.valueOf(zzg2.zzhk()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzg2.zzhl()));
        contentValues.put("app_version_int", Long.valueOf(zzg2.zzhf()));
        contentValues.put("firebase_instance_id", zzg2.getFirebaseInstanceId());
        contentValues.put("daily_error_events_count", Long.valueOf(zzg2.zzhs()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzg2.zzhr()));
        contentValues.put("health_monitor_sample", zzg2.zzht());
        contentValues.put("android_id", Long.valueOf(zzg2.zzhv()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzg2.zzhw()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzg2.zzhx()));
        contentValues.put("admob_app_id", zzg2.zzhb());
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzg2.zzal()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update app (got -1). appId", zzas.zzbw((String)zzg2.zzal()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing app. appId", zzas.zzbw((String)zzg2.zzal()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzbn(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgv().zzb(string2, zzai.zzajj);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error deleting over the limit events. appId", zzas.zzbw((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzu zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        String[] stringArray = new String[]{string};
        zzu zzu2 = new zzu();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzgt().zzjj().zzg("Not updating daily counts, app is not known. appId", zzas.zzbw((String)string));
                zzu zzu3 = zzu2;
                return zzu3;
            }
            if (cursor.getLong(0) == l) {
                zzu2.zzahi = cursor.getLong(1);
                zzu2.zzahh = cursor.getLong(2);
                zzu2.zzahj = cursor.getLong(3);
                zzu2.zzahk = cursor.getLong(4);
                zzu2.zzahl = cursor.getLong(5);
            }
            if (bl) {
                ++zzu2.zzahi;
            }
            if (bl2) {
                ++zzu2.zzahh;
            }
            if (bl3) {
                ++zzu2.zzahj;
            }
            if (bl4) {
                ++zzu2.zzahk;
            }
            if (bl5) {
                ++zzu2.zzahl;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzu2.zzahh));
            contentValues.put("daily_events_count", Long.valueOf(zzu2.zzahi));
            contentValues.put("daily_conversions_count", Long.valueOf(zzu2.zzahj));
            contentValues.put("daily_error_events_count", Long.valueOf(zzu2.zzahk));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzu2.zzahl));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzu zzu4 = zzu2;
            return zzu4;
        }
    }

    @WorkerThread
    public final byte[] zzbo(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for app config, expected one. appId", zzas.zzbw((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(com.google.android.gms.internal.measurement.zzfw zzfw2, boolean bl) {
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzfw2));
        Preconditions.checkNotEmpty((String)zzfw2.zztt);
        Preconditions.checkNotNull((Object)zzfw2.zzaxo);
        this.zzij();
        long l = this.zzbx().currentTimeMillis();
        if (zzfw2.zzaxo < l - zzq.zzib() || zzfw2.zzaxo > l + zzq.zzib()) {
            this.zzgt().zzjj().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzas.zzbw((String)zzfw2.zztt), (Object)l, (Object)zzfw2.zzaxo);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzfw2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray2, (int)0, (int)byArray3.length);
            zzfw2.zza(zzya2);
            zzya2.zzza();
            byArray = this.zzjr().zzb(byArray2);
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Data loss. Failed to serialize bundle. appId", zzas.zzbw((String)zzfw2.zztt), (Object)iOException);
            return false;
        }
        this.zzgt().zzjo().zzg("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzfw2.zztt);
        contentValues.put("bundle_end_timestamp", zzfw2.zzaxo);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzfw2.zzayl != null) {
            contentValues.put("retry_count", zzfw2.zzayl);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert bundle (got -1). appId", zzas.zzbw((String)zzfw2.zztt));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing bundle. appId", zzas.zzbw((String)zzfw2.zztt), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzih() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzii() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<com.google.android.gms.internal.measurement.zzfw, Long>> zzb(String string, int n, int n2) {
        this.zzaf();
        this.zzcl();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<com.google.android.gms.internal.measurement.zzfw, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<com.google.android.gms.internal.measurement.zzfw, Long>> arrayList = new ArrayList<Pair<com.google.android.gms.internal.measurement.zzfw, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzjr().zza((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to unzip queued bundle. appId", zzas.zzbw((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzxz.zzj((byte[])byArray, (int)0, (int)byArray2.length);
                com.google.android.gms.internal.measurement.zzfw zzfw2 = new com.google.android.gms.internal.measurement.zzfw();
                try {
                    zzfw2.zza((zzxz)object);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to merge queued bundle. appId", zzas.zzbw((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzfw2.zzayl = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<com.google.android.gms.internal.measurement.zzfw, Long>)Pair.create((Object)((Object)zzfw2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<com.google.android.gms.internal.measurement.zzfw, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzij() {
        this.zzaf();
        this.zzcl();
        if (!this.zzip()) {
            return;
        }
        long l = this.zzgu().zzanf.get();
        long l2 = this.zzbx().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzai.zzajs.get()) {
            this.zzgu().zzanf.set(l2);
            zzt zzt2 = this;
            zzt2.zzaf();
            zzt2.zzcl();
            if (zzt2.zzip()) {
                SQLiteDatabase sQLiteDatabase = zzt2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzt2.zzbx().currentTimeMillis()), String.valueOf(zzq.zzib())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzt2.zzgt().zzjo().zzg("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzip()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzgt().zzjj().zzby("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, com.google.android.gms.internal.measurement.zzfi[] zzfiArray) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzfiArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzt zzt2 = this;
            zzt2.zzcl();
            zzt2.zzaf();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzt2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzfiArray;
            int n2 = zzfiArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzfj zzfj2;
                int n3;
                int n4;
                com.google.android.gms.internal.measurement.zzfi zzfi2 = object2[n];
                object = zzfi2;
                string2 = string;
                zzt2 = this;
                zzt2.zzcl();
                zzt2.zzaf();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzavi);
                Preconditions.checkNotNull((Object)object.zzavh);
                if (object.zzavg == null) {
                    zzt2.zzgt().zzjj().zzg("Audience with no ID. appId", zzas.zzbw((String)string2));
                    continue;
                }
                int n5 = object.zzavg;
                zzyc[] zzycArray = object.zzavi;
                int n6 = object.zzavi.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzycArray[n4].zzavm != null) continue;
                    zzt2.zzgt().zzjj().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzas.zzbw((String)string2), (Object)object.zzavg);
                    continue block3;
                }
                zzycArray = object.zzavh;
                n6 = object.zzavh.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzycArray[n4].zzavm != null) continue;
                    zzt2.zzgt().zzjj().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzas.zzbw((String)string2), (Object)object.zzavg);
                    continue block3;
                }
                boolean bl = true;
                zzyc[] zzycArray2 = object.zzavi;
                n4 = object.zzavi.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzfj2 = zzycArray2[n3];
                    if (zzt2.zza(string2, n5, zzfj2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzycArray2 = object.zzavh;
                    n4 = object.zzavh.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzfj2 = zzycArray2[n3];
                        if (zzt2.zza(string2, n5, (com.google.android.gms.internal.measurement.zzfm)((Object)zzfj2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzt zzt3 = zzt2;
                zzt3.zzcl();
                zzt3.zzaf();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzt3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            com.google.android.gms.internal.measurement.zzfi[] zzfiArray2 = zzfiArray;
            n = zzfiArray.length;
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.internal.measurement.zzfi zzfi3 = zzfiArray2[i];
                object2.add(zzfi3.zzavg);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfj zzfj2) {
        byte[] byArray;
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzfj2));
        if (TextUtils.isEmpty((CharSequence)zzfj2.zzavn)) {
            this.zzgt().zzjj().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzas.zzbw((String)string), (Object)n, (Object)String.valueOf(zzfj2.zzavm));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzfj2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfj2.zza(zzya2);
            zzya2.zzza();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Configuration loss. Failed to serialize event filter. appId", zzas.zzbw((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzfj2.zzavm);
        contentValues.put("event_name", zzfj2.zzavn);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert event filter (got -1). appId", zzas.zzbw((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing event filter. appId", zzas.zzbw((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, com.google.android.gms.internal.measurement.zzfm zzfm2) {
        byte[] byArray;
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzfm2));
        if (TextUtils.isEmpty((CharSequence)zzfm2.zzawc)) {
            this.zzgt().zzjj().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzas.zzbw((String)string), (Object)n, (Object)String.valueOf(zzfm2.zzavm));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzfm2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfm2.zza(zzya2);
            zzya2.zzza();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Configuration loss. Failed to serialize property filter. appId", zzas.zzbw((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzfm2.zzavm);
        contentValues.put("property_name", zzfm2.zzawc);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert property filter (got -1). appId", zzas.zzbw((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing property filter. appId", zzas.zzbw((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzfj>> zzl(String string, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfj>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzxz zzxz2 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzfj zzfj2 = new zzfj();
                try {
                    zzfj2.zza(zzxz2);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to merge filter. appId", zzas.zzbw((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfj> arrayList = (ArrayList<zzfj>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfj>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzfj2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<com.google.android.gms.internal.measurement.zzfm>> zzm(String string, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<com.google.android.gms.internal.measurement.zzfm>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzxz zzxz2 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray.length);
                com.google.android.gms.internal.measurement.zzfm zzfm2 = new com.google.android.gms.internal.measurement.zzfm();
                try {
                    zzfm2.zza(zzxz2);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to merge filter", zzas.zzbw((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<com.google.android.gms.internal.measurement.zzfm> arrayList = (ArrayList<com.google.android.gms.internal.measurement.zzfm>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<com.google.android.gms.internal.measurement.zzfm>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzfm2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzcl();
        this.zzaf();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Database error querying filters. appId", zzas.zzbw((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgv().zzb(string2, zzai.zzajz);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, com.google.android.gms.internal.measurement.zzfx> zzbp(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzxz zzxz2 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray.length);
                com.google.android.gms.internal.measurement.zzfx zzfx2 = new com.google.android.gms.internal.measurement.zzfx();
                try {
                    zzfx2.zza(zzxz2);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zzd("Failed to merge filter results. appId, audienceId, error", zzas.zzbw((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzfx2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzgt().zzjg().zzby("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzgt().zzjg().zzby("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzgt().zzjg().zzg("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzik() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzn(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzgt().zzjg().zze("Failed to insert column (got -1). appId", zzas.zzbw((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzgt().zzjg().zze("Failed to update column (got 0). appId", zzas.zzbw((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzd("Error inserting column. appId", zzas.zzbw((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzil() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(com.google.android.gms.internal.measurement.zzfw zzfw2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzfw2));
        Preconditions.checkNotEmpty((String)zzfw2.zztt);
        try {
            object = byArray = new byte[zzfw2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzfw2.zza(zzya2);
            zzya2.zzza();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Data loss. Failed to serialize event metadata. appId", zzas.zzbw((String)zzfw2.zztt), (Object)iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = (Object)this.zzjr();
        Preconditions.checkNotNull((Object)byArray2);
        object.zzgr().zzaf();
        MessageDigest messageDigest = zzfx.getMessageDigest();
        if (messageDigest == null) {
            object.zzgt().zzjg().zzby("Failed to get MD5");
            l = 0L;
        } else {
            l = zzfx.zzc((byte[])messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzfw2.zztt);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing raw event metadata. appId", zzas.zzbw((String)zzfw2.zztt), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzim() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzin() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbq(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzad(long l) {
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgt().zzjo().zzby("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzio() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzft, Long> zza(String string, Long l) {
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgt().zzjo().zzby("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzxz zzxz2 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray2.length);
            zzft zzft2 = new zzft();
            try {
                zzft2.zza(zzxz2);
            }
            catch (IOException iOException) {
                this.zzgt().zzjg().zzd("Failed to merge main event. appId, eventId", zzas.zzbw((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzft2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzft zzft2) {
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzft2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzft2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzft2.zza(zzya2);
            zzya2.zzza();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzas.zzbw((String)string), (Object)l, (Object)iOException);
            return false;
        }
        this.zzgt().zzjo().zze("Saving complex main event, appId, data size", (Object)this.zzgq().zzbt(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert complex main event (got -1). appId", zzas.zzbw((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing complex main event. appId", zzas.zzbw((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzab zzab2, long l, boolean bl) {
        Object object;
        com.google.android.gms.internal.measurement.zzfu zzfu2;
        String string2;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzab2);
        Preconditions.checkNotEmpty((String)zzab2.zztt);
        zzft zzft2 = new zzft();
        new zzft().zzaxe = zzab2.zzaht;
        zzft2.zzaxc = new com.google.android.gms.internal.measurement.zzfu[zzab2.zzahu.size()];
        int n = 0;
        for (String string2 : zzab2.zzahu) {
            zzfu2 = new com.google.android.gms.internal.measurement.zzfu();
            zzft2.zzaxc[n++] = zzfu2;
            zzfu2.name = string2;
            Object object2 = zzab2.zzahu.get(string2);
            this.zzjr().zza(zzfu2, object2);
        }
        try {
            byte[] byArray = new byte[zzft2.zzvx()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzfu2 = zzya.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzft2.zza((zzya)zzfu2);
            zzfu2.zzza();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Data loss. Failed to serialize event params/data. appId", zzas.zzbw((String)zzab2.zztt), (Object)iOException);
            return false;
        }
        this.zzgt().zzjo().zze("Saving event, name, data size", (Object)this.zzgq().zzbt(zzab2.name), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzab2.zztt);
        string2.put("name", zzab2.name);
        string2.put("timestamp", Long.valueOf(zzab2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert raw event (got -1). appId", zzas.zzbw((String)zzab2.zztt));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing raw event. appId", zzas.zzbw((String)zzab2.zztt), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzip() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzfi zza(zzt zzt2) {
        return zzt2.zzahg;
    }

    static /* synthetic */ String[] zziq() {
        return zzagz;
    }

    static /* synthetic */ String[] zzir() {
        return zzaha;
    }

    static /* synthetic */ String[] zzis() {
        return zzahb;
    }

    static /* synthetic */ String[] zzit() {
        return zzahd;
    }

    static /* synthetic */ String[] zziu() {
        return zzahc;
    }

    static /* synthetic */ String[] zziv() {
        return zzahe;
    }
}

