/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.playintegrity.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Strings;
import com.google.firebase.FirebaseException;
import org.json.JSONException;
import org.json.JSONObject;

class GeneratePlayIntegrityChallengeResponse {
    @VisibleForTesting
    static final String CHALLENGE_KEY = "challenge";
    @VisibleForTesting
    static final String TIME_TO_LIVE_KEY = "ttl";
    private String challenge;
    private String timeToLive;

    @NonNull
    public static GeneratePlayIntegrityChallengeResponse fromJsonString(@NonNull String jsonString) throws FirebaseException, JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        String challenge = Strings.emptyToNull((String)jsonObject.optString(CHALLENGE_KEY));
        String timeToLive = Strings.emptyToNull((String)jsonObject.optString(TIME_TO_LIVE_KEY));
        if (challenge == null || timeToLive == null) {
            throw new FirebaseException("Unexpected server response.");
        }
        return new GeneratePlayIntegrityChallengeResponse(challenge, timeToLive);
    }

    private GeneratePlayIntegrityChallengeResponse(@NonNull String challenge, @NonNull String timeToLive) {
        Preconditions.checkNotNull((Object)challenge);
        Preconditions.checkNotNull((Object)timeToLive);
        this.challenge = challenge;
        this.timeToLive = timeToLive;
    }

    @NonNull
    public String getChallenge() {
        return this.challenge;
    }

    @NonNull
    public String getTimeToLive() {
        return this.timeToLive;
    }
}

