/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.zzac;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zzh;
import com.google.firebase.appindexing.internal.zzn;
import java.util.Arrays;

public abstract class IndexableBuilder<T extends IndexableBuilder<?>> {
    final Bundle zzaha;
    final String zzTW;
    Thing.zza zzbVe;
    String zzD;

    protected IndexableBuilder(@NonNull String string) {
        zzac.zzw((Object)string);
        zzac.zzdv((String)string);
        this.zzaha = new Bundle();
        this.zzTW = string;
    }

    @KeepName
    public T put(@NonNull String string, String ... stringArray) {
        zzac.zzw((Object)string);
        zzac.zzw((Object)stringArray);
        if (stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < Math.min(stringArray.length, 100); ++i) {
                int n2;
                stringArray[n] = stringArray[i];
                if (stringArray[i] == null) {
                    n2 = i;
                    zzh.zziu(new StringBuilder(59).append("String at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                if (stringArray[n].length() > 20000) {
                    n2 = i;
                    zzh.zziu(new StringBuilder(53).append("String at ").append(n2).append(" is too long, truncating string.").toString());
                    stringArray[n] = zzn.zzE(stringArray[n], 20000);
                }
                ++n;
            }
            if (n > 0) {
                stringArray = Arrays.copyOfRange(stringArray, 0, n);
                this.zzaha.putStringArray(string, IndexableBuilder.zzd(stringArray));
            }
        } else {
            zzh.zziu("String array is empty and is ignored by put method.");
        }
        return this.zzTz();
    }

    @KeepName
    public T put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
        zzac.zzw((Object)string);
        zzac.zzw((Object)indexableArray);
        Thing[] thingArray = new Thing[indexableArray.length];
        for (int i = 0; i < indexableArray.length; ++i) {
            if (indexableArray[i] != null && !(indexableArray[i] instanceof Thing)) {
                throw new FirebaseAppIndexingInvalidArgumentException("Invalid Indexable encountered. Use Indexable.Builder or convenience methods under Indexables to create the Indexable.");
            }
            thingArray[i] = (Thing)indexableArray[i];
        }
        this.zza(string, thingArray);
        return this.zzTz();
    }

    private T zza(@NonNull String string, Thing ... thingArray) {
        zzac.zzw((Object)string);
        zzac.zzw((Object)thingArray);
        if (thingArray.length > 0) {
            int n = 0;
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[n] = thingArray[i];
                if (thingArray[i] == null) {
                    int n2 = i;
                    zzh.zziu(new StringBuilder(58).append("Thing at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                thingArray = Arrays.copyOfRange(thingArray, 0, n);
                this.zzaha.putParcelableArray(string, (Parcelable[])IndexableBuilder.zzd(thingArray));
            }
        } else {
            zzh.zziu("Thing array is empty and is ignored by put method.");
        }
        return this.zzTz();
    }

    @KeepName
    public T put(@NonNull String string, boolean ... blArray) {
        zzac.zzw((Object)string);
        zzac.zzw((Object)blArray);
        if (blArray.length > 0) {
            this.zzaha.putBooleanArray(string, IndexableBuilder.zza(blArray));
        } else {
            zzh.zziu("Boolean array is empty and is ignored by put method.");
        }
        return this.zzTz();
    }

    @KeepName
    public T put(@NonNull String string, long ... lArray) {
        zzac.zzw((Object)string);
        zzac.zzw((Object)lArray);
        if (lArray.length > 0) {
            this.zzaha.putLongArray(string, IndexableBuilder.zzb(lArray));
        } else {
            zzh.zziu("Long array is empty and is ignored by put method.");
        }
        return this.zzTz();
    }

    @KeepName
    public final T setName(@NonNull String string) {
        zzac.zzw((Object)string);
        return this.put("name", string);
    }

    @KeepName
    public final T setUrl(@NonNull String string) {
        zzac.zzw((Object)string);
        this.zzD = string;
        return this.zzTz();
    }

    @KeepName
    public final T setImage(@NonNull String string) {
        zzac.zzw((Object)string);
        return this.put("image", string);
    }

    @KeepName
    public final T setDescription(@NonNull String string) {
        zzac.zzw((Object)string);
        return this.put("description", string);
    }

    @KeepName
    public final T setSameAs(@NonNull String string) {
        zzac.zzw((Object)string);
        return this.put("sameAs", string);
    }

    @KeepName
    public T setMetadata(@NonNull Indexable.Metadata.Builder builder) {
        zzac.zza((this.zzbVe == null ? 1 : 0) != 0, (Object)"setMetadata may only be called once");
        zzac.zzw((Object)builder);
        this.zzbVe = builder.zzTy();
        return this.zzTz();
    }

    @KeepName
    public final Indexable build() {
        return new Thing(new Bundle(this.zzaha), this.zzbVe == null ? Indexable.Metadata.zzbVa : this.zzbVe, this.zzD, this.zzTW);
    }

    protected <S extends IndexableBuilder> T put(@NonNull String string, S ... SArray) {
        zzac.zzw((Object)string);
        zzac.zzw(SArray);
        if (SArray.length > 0) {
            Thing[] thingArray = new Thing[SArray.length];
            for (int i = 0; i < SArray.length; ++i) {
                if (SArray[i] == null) {
                    int n = i;
                    zzh.zziu(new StringBuilder(60).append("Builder at ").append(n).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                thingArray[i] = (Thing)((IndexableBuilder)SArray[i]).build();
            }
            if (thingArray.length > 0) {
                this.zza(string, thingArray);
            }
        } else {
            zzh.zziu("Builder array is empty and is ignored by put method.");
        }
        return this.zzTz();
    }

    private T zzTz() {
        return (T)this;
    }

    private static <S> S[] zzd(S[] SArray) {
        if (SArray.length < 100) {
            return SArray;
        }
        zzh.zziu("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(SArray, 100);
    }

    private static long[] zzb(long[] lArray) {
        if (lArray.length < 100) {
            return lArray;
        }
        zzh.zziu("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(lArray, 100);
    }

    private static boolean[] zza(boolean[] blArray) {
        if (blArray.length < 100) {
            return blArray;
        }
        zzh.zziu("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(blArray, 100);
    }
}

