/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbo;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zzw;
import java.util.Arrays;

public class IndexableBuilder<T extends IndexableBuilder<?>> {
    private final Bundle zzajQ;
    private final String zzVB;
    private Thing.zza zzbVH;
    private String zzD;

    protected IndexableBuilder(@NonNull String string) {
        zzbo.zzu((Object)string);
        zzbo.zzcF((String)string);
        this.zzajQ = new Bundle();
        this.zzVB = string;
    }

    public T put(@NonNull String string, String ... stringArray) {
        String[] stringArray2 = stringArray;
        String string2 = string;
        Bundle bundle = this.zzajQ;
        zzbo.zzu((Object)string2);
        zzbo.zzu((Object)stringArray2);
        String[] stringArray3 = Arrays.copyOf(stringArray2, stringArray2.length);
        if (stringArray3.length > 0) {
            int n = 0;
            for (int i = 0; i < Math.min(stringArray3.length, 100); ++i) {
                int n2;
                stringArray3[n] = stringArray3[i];
                if (stringArray3[i] == null) {
                    n2 = i;
                    zzw.zzgo(new StringBuilder(59).append("String at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                if (stringArray3[n].length() > 20000) {
                    String string3;
                    n2 = i;
                    zzw.zzgo(new StringBuilder(53).append("String at ").append(n2).append(" is too long, truncating string.").toString());
                    String string4 = stringArray3[n];
                    if (string4.length() <= 20000) {
                        string3 = string4;
                    } else {
                        int n3 = 20000;
                        if (Character.isHighSurrogate(string4.charAt(19999)) && Character.isLowSurrogate(string4.charAt(20000))) {
                            --n3;
                        }
                        string3 = string4.substring(0, n3);
                    }
                    stringArray3[n] = string3;
                }
                ++n;
            }
            if (n > 0) {
                stringArray3 = Arrays.copyOfRange(stringArray3, 0, n);
                bundle.putStringArray(string2, IndexableBuilder.zzc(stringArray3));
            }
        } else {
            zzw.zzgo("String array is empty and is ignored by put method.");
        }
        return (T)this;
    }

    public T put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
        zzbo.zzu((Object)string);
        zzbo.zzu((Object)indexableArray);
        Thing[] thingArray = new Thing[indexableArray.length];
        for (int i = 0; i < indexableArray.length; ++i) {
            if (indexableArray[i] != null && !(indexableArray[i] instanceof Thing)) {
                throw new FirebaseAppIndexingInvalidArgumentException("Invalid Indexable encountered. Use Indexable.Builder or convenience methods under Indexables to create the Indexable.");
            }
            thingArray[i] = (Thing)indexableArray[i];
        }
        this.zza(string, thingArray);
        return (T)this;
    }

    private final T zza(@NonNull String string, Thing ... thingArray) {
        zzbo.zzu((Object)string);
        zzbo.zzu((Object)thingArray);
        if (thingArray.length > 0) {
            int n = 0;
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[n] = thingArray[i];
                if (thingArray[i] == null) {
                    int n2 = i;
                    zzw.zzgo(new StringBuilder(58).append("Thing at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                thingArray = Arrays.copyOfRange(thingArray, 0, n);
                this.zzajQ.putParcelableArray(string, (Parcelable[])IndexableBuilder.zzc(thingArray));
            }
        } else {
            zzw.zzgo("Thing array is empty and is ignored by put method.");
        }
        return (T)this;
    }

    public T put(@NonNull String string, boolean ... blArray) {
        boolean[] blArray2 = blArray;
        String string2 = string;
        Bundle bundle = this.zzajQ;
        zzbo.zzu((Object)string2);
        zzbo.zzu((Object)blArray2);
        if (blArray2.length > 0) {
            boolean[] blArray3;
            boolean[] blArray4 = blArray2;
            if (blArray2.length < 100) {
                blArray3 = blArray4;
            } else {
                zzw.zzgo("Input Array of elements is too big, cutting off.");
                blArray3 = Arrays.copyOf(blArray4, 100);
            }
            bundle.putBooleanArray(string2, blArray3);
        } else {
            zzw.zzgo("Boolean array is empty and is ignored by put method.");
        }
        return (T)this;
    }

    public T put(@NonNull String string, long ... lArray) {
        long[] lArray2 = lArray;
        String string2 = string;
        Bundle bundle = this.zzajQ;
        zzbo.zzu((Object)string2);
        zzbo.zzu((Object)lArray2);
        if (lArray2.length > 0) {
            long[] lArray3;
            long[] lArray4 = lArray2;
            if (lArray2.length < 100) {
                lArray3 = lArray4;
            } else {
                zzw.zzgo("Input Array of elements is too big, cutting off.");
                lArray3 = Arrays.copyOf(lArray4, 100);
            }
            bundle.putLongArray(string2, lArray3);
        } else {
            zzw.zzgo("Long array is empty and is ignored by put method.");
        }
        return (T)this;
    }

    public final T setName(@NonNull String string) {
        zzbo.zzu((Object)string);
        return this.put("name", string);
    }

    public final T setUrl(@NonNull String string) {
        zzbo.zzu((Object)string);
        this.zzD = string;
        return (T)this;
    }

    public final T setImage(@NonNull String string) {
        zzbo.zzu((Object)string);
        return this.put("image", string);
    }

    public final T setDescription(@NonNull String string) {
        zzbo.zzu((Object)string);
        return this.put("description", string);
    }

    public final T setSameAs(@NonNull String string) {
        zzbo.zzu((Object)string);
        return this.put("sameAs", string);
    }

    public T setMetadata(@NonNull Indexable.Metadata.Builder builder) {
        zzbo.zza((this.zzbVH == null ? 1 : 0) != 0, (Object)"setMetadata may only be called once");
        zzbo.zzu((Object)builder);
        this.zzbVH = builder.zzEA();
        return (T)this;
    }

    public final Indexable build() {
        return new Thing(new Bundle(this.zzajQ), this.zzbVH == null ? Indexable.Metadata.zzbVD : this.zzbVH, this.zzD, this.zzVB);
    }

    protected <S extends IndexableBuilder> T put(@NonNull String string, S ... SArray) {
        zzbo.zzu((Object)string);
        zzbo.zzu(SArray);
        if (SArray.length > 0) {
            Thing[] thingArray = new Thing[SArray.length];
            for (int i = 0; i < SArray.length; ++i) {
                if (SArray[i] == null) {
                    int n = i;
                    zzw.zzgo(new StringBuilder(60).append("Builder at ").append(n).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                thingArray[i] = (Thing)((IndexableBuilder)SArray[i]).build();
            }
            if (thingArray.length > 0) {
                this.zza(string, thingArray);
            }
        } else {
            zzw.zzgo("Builder array is empty and is ignored by put method.");
        }
        return (T)this;
    }

    private static <S> S[] zzc(S[] SArray) {
        if (SArray.length < 100) {
            return SArray;
        }
        zzw.zzgo("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(SArray, 100);
    }
}

