/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzbe;
import com.google.android.gms.internal.icing.zzcm;
import com.google.android.gms.internal.icing.zzcr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbg
extends zzbe<Boolean>
implements zzcr<Boolean>,
RandomAccess {
    private static final zzbg zzdo = new zzbg();
    private boolean[] zzdp;
    private int size;

    public static zzbg zzt() {
        return zzdo;
    }

    zzbg() {
        this(new boolean[10], 0);
    }

    private zzbg(boolean[] blArray, int n) {
        this.zzdp = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzdp, n2, this.zzdp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbg)) {
            return super.equals(object);
        }
        zzbg zzbg2 = (zzbg)object;
        if (this.size != zzbg2.size) {
            return false;
        }
        boolean[] blArray = zzbg2.zzdp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzdp[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzcm.zzg(this.zzdp[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzq();
        zzcm.checkNotNull(collection);
        if (!(collection instanceof zzbg)) {
            return super.addAll(collection);
        }
        zzbg zzbg2 = (zzbg)collection;
        if (zzbg2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbg2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbg2.size;
        if (n > this.zzdp.length) {
            this.zzdp = Arrays.copyOf(this.zzdp, n);
        }
        System.arraycopy(zzbg2.zzdp, 0, this.zzdp, this.size, zzbg2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzdp[i])) continue;
            System.arraycopy(this.zzdp, i + 1, this.zzdp, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzbg zzbg2 = this;
        zzbg2.zzq();
        zzbg2.zzf(n);
        boolean bl3 = zzbg2.zzdp[n];
        zzbg2.zzdp[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbg zzbg2 = this;
        zzbg2.zzq();
        zzbg2.zzf(n);
        boolean bl = zzbg2.zzdp[n];
        if (n < zzbg2.size - 1) {
            System.arraycopy(zzbg2.zzdp, n + 1, zzbg2.zzdp, n, zzbg2.size - n);
        }
        --zzbg2.size;
        ++zzbg2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        int n2 = n;
        zzbg zzbg2 = this;
        zzbg2.zzq();
        if (n2 < 0 || n2 > zzbg2.size) {
            throw new IndexOutOfBoundsException(zzbg2.zzg(n2));
        }
        if (zzbg2.size < zzbg2.zzdp.length) {
            System.arraycopy(zzbg2.zzdp, n2, zzbg2.zzdp, n2 + 1, zzbg2.size - n2);
        } else {
            boolean[] blArray = new boolean[zzbg2.size * 3 / 2 + 1];
            System.arraycopy(zzbg2.zzdp, 0, blArray, 0, n2);
            System.arraycopy(zzbg2.zzdp, n2, blArray, n2 + 1, zzbg2.size - n2);
            zzbg2.zzdp = blArray;
        }
        zzbg2.zzdp[n2] = bl2;
        ++zzbg2.size;
        ++zzbg2.modCount;
    }

    @Override
    public final /* synthetic */ zzcr zzh(int n) {
        int n2 = n;
        zzbg zzbg2 = this;
        if (n2 < zzbg2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbg(Arrays.copyOf(zzbg2.zzdp, n2), zzbg2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbg zzbg2 = this;
        zzbg2.zzf(n);
        return zzbg2.zzdp[n];
    }

    static {
        zzdo.zzp();
    }
}

