/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzbe;
import com.google.android.gms.internal.icing.zzcm;
import com.google.android.gms.internal.icing.zzcr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbx
extends zzbe<Double>
implements zzcr<Double>,
RandomAccess {
    private static final zzbx zzei = new zzbx();
    private double[] zzej;
    private int size;

    public static zzbx zzae() {
        return zzei;
    }

    zzbx() {
        this(new double[10], 0);
    }

    private zzbx(double[] dArray, int n) {
        this.zzej = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzej, n2, this.zzej, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbx)) {
            return super.equals(object);
        }
        zzbx zzbx2 = (zzbx)object;
        if (this.size != zzbx2.size) {
            return false;
        }
        double[] dArray = zzbx2.zzej;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzej[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzej[i]);
            n = n * 31 + zzcm.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzq();
        zzcm.checkNotNull(collection);
        if (!(collection instanceof zzbx)) {
            return super.addAll(collection);
        }
        zzbx zzbx2 = (zzbx)collection;
        if (zzbx2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbx2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbx2.size;
        if (n > this.zzej.length) {
            this.zzej = Arrays.copyOf(this.zzej, n);
        }
        System.arraycopy(zzbx2.zzej, 0, this.zzej, this.size, zzbx2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzej[i])) continue;
            System.arraycopy(this.zzej, i + 1, this.zzej, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzbx zzbx2 = this;
        zzbx2.zzq();
        zzbx2.zzf(n);
        double d3 = zzbx2.zzej[n];
        zzbx2.zzej[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbx zzbx2 = this;
        zzbx2.zzq();
        zzbx2.zzf(n);
        double d = zzbx2.zzej[n];
        if (n < zzbx2.size - 1) {
            System.arraycopy(zzbx2.zzej, n + 1, zzbx2.zzej, n, zzbx2.size - n);
        }
        --zzbx2.size;
        ++zzbx2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        int n2 = n;
        zzbx zzbx2 = this;
        zzbx2.zzq();
        if (n2 < 0 || n2 > zzbx2.size) {
            throw new IndexOutOfBoundsException(zzbx2.zzg(n2));
        }
        if (zzbx2.size < zzbx2.zzej.length) {
            System.arraycopy(zzbx2.zzej, n2, zzbx2.zzej, n2 + 1, zzbx2.size - n2);
        } else {
            double[] dArray = new double[zzbx2.size * 3 / 2 + 1];
            System.arraycopy(zzbx2.zzej, 0, dArray, 0, n2);
            System.arraycopy(zzbx2.zzej, n2, dArray, n2 + 1, zzbx2.size - n2);
            zzbx2.zzej = dArray;
        }
        zzbx2.zzej[n2] = d2;
        ++zzbx2.size;
        ++zzbx2.modCount;
    }

    @Override
    public final /* synthetic */ zzcr zzh(int n) {
        int n2 = n;
        zzbx zzbx2 = this;
        if (n2 < zzbx2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbx(Arrays.copyOf(zzbx2.zzej, n2), zzbx2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbx zzbx2 = this;
        zzbx2.zzf(n);
        return zzbx2.zzej[n];
    }

    static {
        zzei.zzp();
    }
}

