/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzbe;
import com.google.android.gms.internal.icing.zzcm;
import com.google.android.gms.internal.icing.zzcr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdg
extends zzbe<Long>
implements zzcr<Long>,
RandomAccess {
    private static final zzdg zzjm = new zzdg();
    private long[] zzjn;
    private int size;

    public static zzdg zzbl() {
        return zzjm;
    }

    zzdg() {
        this(new long[10], 0);
    }

    private zzdg(long[] lArray, int n) {
        this.zzjn = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzjn, n2, this.zzjn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdg)) {
            return super.equals(object);
        }
        zzdg zzdg2 = (zzdg)object;
        if (this.size != zzdg2.size) {
            return false;
        }
        long[] lArray = zzdg2.zzjn;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzjn[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzcm.zzk(this.zzjn[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzf(n);
        return this.zzjn[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzq();
        zzcm.checkNotNull(collection);
        if (!(collection instanceof zzdg)) {
            return super.addAll(collection);
        }
        zzdg zzdg2 = (zzdg)collection;
        if (zzdg2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdg2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdg2.size;
        if (n > this.zzjn.length) {
            this.zzjn = Arrays.copyOf(this.zzjn, n);
        }
        System.arraycopy(zzdg2.zzjn, 0, this.zzjn, this.size, zzdg2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzjn[i])) continue;
            System.arraycopy(this.zzjn, i + 1, this.zzjn, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdg zzdg2 = this;
        zzdg2.zzq();
        zzdg2.zzf(n);
        long l3 = zzdg2.zzjn[n];
        zzdg2.zzjn[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdg zzdg2 = this;
        zzdg2.zzq();
        zzdg2.zzf(n);
        long l = zzdg2.zzjn[n];
        if (n < zzdg2.size - 1) {
            System.arraycopy(zzdg2.zzjn, n + 1, zzdg2.zzjn, n, zzdg2.size - n);
        }
        --zzdg2.size;
        ++zzdg2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        int n2 = n;
        zzdg zzdg2 = this;
        zzdg2.zzq();
        if (n2 < 0 || n2 > zzdg2.size) {
            throw new IndexOutOfBoundsException(zzdg2.zzg(n2));
        }
        if (zzdg2.size < zzdg2.zzjn.length) {
            System.arraycopy(zzdg2.zzjn, n2, zzdg2.zzjn, n2 + 1, zzdg2.size - n2);
        } else {
            long[] lArray = new long[zzdg2.size * 3 / 2 + 1];
            System.arraycopy(zzdg2.zzjn, 0, lArray, 0, n2);
            System.arraycopy(zzdg2.zzjn, n2, lArray, n2 + 1, zzdg2.size - n2);
            zzdg2.zzjn = lArray;
        }
        zzdg2.zzjn[n2] = l2;
        ++zzdg2.size;
        ++zzdg2.modCount;
    }

    @Override
    public final /* synthetic */ zzcr zzh(int n) {
        int n2 = n;
        zzdg zzdg2 = this;
        if (n2 < zzdg2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdg(Arrays.copyOf(zzdg2.zzjn, n2), zzdg2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzjm.zzp();
    }
}

