/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.builders.IndexableBuilder;
import com.google.firebase.appindexing.internal.zza;
import com.google.firebase.appindexing.internal.zzb;
import com.google.firebase.appindexing.internal.zzu;
import java.util.Arrays;

public interface Action {

    public static class Builder {
        public static final String ACTIVATE_ACTION = "ActivateAction";
        public static final String ADD_ACTION = "AddAction";
        public static final String BOOKMARK_ACTION = "BookmarkAction";
        public static final String COMMENT_ACTION = "CommentAction";
        public static final String LIKE_ACTION = "LikeAction";
        public static final String LISTEN_ACTION = "ListenAction";
        public static final String SEND_ACTION = "SendAction";
        public static final String SHARE_ACTION = "ShareAction";
        public static final String VIEW_ACTION = "ViewAction";
        public static final String WATCH_ACTION = "WatchAction";
        public static final String STATUS_TYPE_ACTIVE = "http://schema.org/ActiveActionStatus";
        public static final String STATUS_TYPE_COMPLETED = "http://schema.org/CompletedActionStatus";
        public static final String STATUS_TYPE_FAILED = "http://schema.org/FailedActionStatus";
        private final Bundle zzaw = new Bundle();
        private final String zzbu;
        private String zzbv;
        private String zzbw;
        private String zzbx;
        private zzb zzby;
        private String zzbz;

        public Builder(@NonNull String string) {
            this.zzbu = string;
        }

        public Builder put(@NonNull String string, String ... stringArray) {
            IndexableBuilder.zza(this.zzaw, string, stringArray);
            return this;
        }

        public Builder put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
            IndexableBuilder.zza(this.zzaw, string, indexableArray);
            return this;
        }

        public Builder put(@NonNull String string, boolean ... blArray) {
            IndexableBuilder.zza(this.zzaw, string, blArray);
            return this;
        }

        public Builder put(@NonNull String string, long ... lArray) {
            IndexableBuilder.zza(this.zzaw, string, lArray);
            return this;
        }

        public Builder put(@NonNull String string, double ... dArray) {
            double[] dArray2 = dArray;
            String string2 = string;
            Bundle bundle = this.zzaw;
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)dArray2);
            if (dArray2.length > 0) {
                double[] dArray3;
                double[] dArray4 = dArray2;
                if (dArray2.length < 100) {
                    dArray3 = dArray4;
                } else {
                    zzu.zze("Input Array of elements is too big, cutting off.");
                    dArray3 = Arrays.copyOf(dArray4, 100);
                }
                bundle.putDoubleArray(string2, dArray3);
            } else {
                zzu.zze("Double array is empty and is ignored by put method.");
            }
            return this;
        }

        public final Builder setUrl(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzbw = string;
            return this.put("url", string);
        }

        public Builder setObject(@NonNull String string, @NonNull String string2) {
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)string2);
            this.zzbv = string;
            this.zzbw = string2;
            return this;
        }

        public Builder setObject(@NonNull String string, @NonNull String string2, @NonNull String string3) {
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)string3);
            this.zzbv = string;
            this.zzbw = string2;
            this.zzbx = string3;
            return this;
        }

        public final Builder setName(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzbv = string;
            return this.put("name", string);
        }

        public Builder setMetadata(@NonNull Metadata.Builder builder) {
            Preconditions.checkNotNull((Object)builder);
            this.zzby = builder.zzh();
            return this;
        }

        public Builder setActionStatus(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzbz = string;
            return this;
        }

        public Action build() {
            Preconditions.checkNotNull((Object)this.zzbv, (Object)"setObject is required before calling build().");
            Preconditions.checkNotNull((Object)this.zzbw, (Object)"setObject is required before calling build().");
            return new zza(this.zzbu, this.zzbv, this.zzbw, this.zzbx, this.zzby == null ? new Metadata.Builder().zzh() : this.zzby, this.zzbz, this.zzaw);
        }
    }

    public static interface Metadata {

        public static class Builder {
            private boolean zzca = true;
            private boolean zzcb = false;

            public Builder() {
            }

            public Builder setUpload(boolean bl) {
                this.zzca = bl;
                return this;
            }

            public final zzb zzh() {
                return new zzb(this.zzca, null, null, null, false);
            }
        }
    }
}

