/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.zzaa;
import com.google.firebase.appindexing.internal.zzv;
import com.google.firebase.appindexing.internal.zzz;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;

@SafeParcelable.Class(creator="ThingCreator")
public final class Thing
extends AbstractSafeParcelable
implements ReflectedParcelable,
Indexable {
    public static final Parcelable.Creator<Thing> CREATOR = new zzaa();
    @SafeParcelable.Field(id=1000, getter="getVersionCode")
    private final int zzdf;
    @SafeParcelable.Field(id=1, getter="getPropertyBundle")
    private final Bundle zzaw;
    @SafeParcelable.Field(id=2, getter="getMetadata")
    private final zza zzcf;
    @SafeParcelable.Field(id=3, getter="getUrl")
    private final String zzdg;
    @SafeParcelable.Field(id=4, getter="getType")
    private final String type;

    @SafeParcelable.Constructor
    public Thing(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) Bundle bundle, @SafeParcelable.Param(id=2) zza zza2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2) {
        this.zzdf = n;
        this.zzaw = bundle;
        this.zzcf = zza2;
        this.zzdg = string;
        this.type = string2;
        this.zzaw.setClassLoader(this.getClass().getClassLoader());
    }

    public Thing(@NonNull Bundle bundle, @NonNull zza zza2, String string, @NonNull String string2) {
        this.zzdf = 10;
        this.zzaw = bundle;
        this.zzcf = zza2;
        this.zzdg = string;
        this.type = string2;
    }

    public final zza zzk() {
        return this.zzcf;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Thing thing = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)1, (Bundle)thing.zzaw, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)thing.zzcf, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)thing.zzdg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)thing.type, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)thing.zzdf);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private static void zza(@NonNull Bundle bundle, @NonNull StringBuilder stringBuilder) {
        try {
            Set set = bundle.keySet();
            String[] stringArray = set.toArray(new String[set.size()]);
            Arrays.sort(stringArray, zzz.zzdh);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                stringBuilder.append("{ key: '").append(string).append("' value: ");
                Object object = bundle.get(string);
                if (object == null) {
                    stringBuilder.append("<null>");
                } else if (object.getClass().isArray()) {
                    stringBuilder.append("[ ");
                    for (int j = 0; j < Array.getLength(object); ++j) {
                        stringBuilder.append("'").append(Array.get(object, j)).append("' ");
                    }
                    stringBuilder.append("]");
                } else {
                    stringBuilder.append(object.toString());
                }
                stringBuilder.append(" } ");
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("<error>");
            return;
        }
    }

    public final String toString() {
        Thing thing = this;
        StringBuilder stringBuilder = new StringBuilder().append(thing.type.equals("Thing") ? "Indexable" : thing.type).append(" { { id: ");
        if (this.zzdg == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append("'").append(this.zzdg).append("'");
        }
        stringBuilder.append(" } Properties { ");
        Thing.zza(this.zzaw, stringBuilder);
        stringBuilder.append("} ");
        stringBuilder.append("Metadata { ");
        stringBuilder.append(this.zzcf.toString());
        stringBuilder.append(" } ");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static final /* synthetic */ int zzc(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    @SafeParcelable.Reserved(value={1000})
    @SafeParcelable.Class(creator="MetadataCreator")
    public static final class zza
    extends AbstractSafeParcelable
    implements Indexable.Metadata {
        public static final Parcelable.Creator<zza> CREATOR = new zzv();
        @SafeParcelable.Field(id=1, getter="getWorksOffline")
        private final boolean zzcd;
        @SafeParcelable.Field(id=2, getter="getScore")
        private final int score;
        @SafeParcelable.Field(id=3, getter="getAccountEmail")
        private final String zzce;
        @SafeParcelable.Field(id=4, getter="getPropertyBundle")
        private final Bundle zzaw;

        @SafeParcelable.Constructor
        public zza(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) Bundle bundle) {
            this.zzcd = bl;
            this.score = n;
            this.zzce = string;
            this.zzaw = bundle == null ? new Bundle() : bundle;
        }

        public final Bundle zzd() {
            return this.zzaw;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            zza zza2 = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)zza2.zzcd);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)zza2.score);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zza2.zzce, (boolean)false);
            SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)zza2.zzaw, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("worksOffline: ").append(this.zzcd).append(", score: ").append(this.score);
            if (!this.zzce.isEmpty()) {
                stringBuilder.append(", accountEmail: ").append(this.zzce);
            }
            if (this.zzaw != null && !this.zzaw.isEmpty()) {
                stringBuilder.append(", Properties { ");
                Thing.zza(this.zzaw, stringBuilder);
                stringBuilder.append("}");
            }
            return stringBuilder.toString();
        }
    }
}

