/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzch;
import com.google.android.gms.internal.icing.zzdq;
import com.google.android.gms.internal.icing.zzdx;
import com.google.android.gms.internal.icing.zzfg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdd
extends zzch<Double>
implements zzdx<Double>,
zzfg,
RandomAccess {
    private static final zzdd zzgq = new zzdd(new double[0], 0);
    private double[] zzgr;
    private int size;

    public static zzdd zzax() {
        return zzgq;
    }

    zzdd() {
        this(new double[10], 0);
    }

    private zzdd(double[] dArray, int n) {
        this.zzgr = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzai();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzgr, n2, this.zzgr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdd)) {
            return super.equals(object);
        }
        zzdd zzdd2 = (zzdd)object;
        if (this.size != zzdd2.size) {
            return false;
        }
        double[] dArray = zzdd2.zzgr;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzgr[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzgr[i]);
            n = n * 31 + zzdq.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzai();
        zzdq.checkNotNull(collection);
        if (!(collection instanceof zzdd)) {
            return super.addAll(collection);
        }
        zzdd zzdd2 = (zzdd)collection;
        if (zzdd2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdd2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdd2.size;
        if (n > this.zzgr.length) {
            this.zzgr = Arrays.copyOf(this.zzgr, n);
        }
        System.arraycopy(zzdd2.zzgr, 0, this.zzgr, this.size, zzdd2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzai();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzgr[i])) continue;
            System.arraycopy(this.zzgr, i + 1, this.zzgr, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdd zzdd2 = this;
        zzdd2.zzai();
        zzdd2.zzh(n);
        double d3 = zzdd2.zzgr[n];
        zzdd2.zzgr[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdd zzdd2 = this;
        zzdd2.zzai();
        zzdd2.zzh(n);
        double d = zzdd2.zzgr[n];
        if (n < zzdd2.size - 1) {
            System.arraycopy(zzdd2.zzgr, n + 1, zzdd2.zzgr, n, zzdd2.size - n - 1);
        }
        --zzdd2.size;
        ++zzdd2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        int n2 = n;
        zzdd zzdd2 = this;
        zzdd2.zzai();
        if (n2 < 0 || n2 > zzdd2.size) {
            throw new IndexOutOfBoundsException(zzdd2.zzi(n2));
        }
        if (zzdd2.size < zzdd2.zzgr.length) {
            System.arraycopy(zzdd2.zzgr, n2, zzdd2.zzgr, n2 + 1, zzdd2.size - n2);
        } else {
            double[] dArray = new double[zzdd2.size * 3 / 2 + 1];
            System.arraycopy(zzdd2.zzgr, 0, dArray, 0, n2);
            System.arraycopy(zzdd2.zzgr, n2, dArray, n2 + 1, zzdd2.size - n2);
            zzdd2.zzgr = dArray;
        }
        zzdd2.zzgr[n2] = d2;
        ++zzdd2.size;
        ++zzdd2.modCount;
    }

    @Override
    public final /* synthetic */ zzdx zzj(int n) {
        int n2 = n;
        zzdd zzdd2 = this;
        if (n2 < zzdd2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdd(Arrays.copyOf(zzdd2.zzgr, n2), zzdd2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdd zzdd2 = this;
        zzdd2.zzh(n);
        return zzdd2.zzgr[n];
    }

    static {
        zzgq.zzah();
    }
}

