/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import com.google.firebase.appindexing.builders.AlarmInstanceBuilder;
import com.google.firebase.appindexing.builders.IndexableBuilder;

public final class AlarmBuilder
extends IndexableBuilder<AlarmBuilder> {
    public static final String SUNDAY = "Sunday";
    public static final String MONDAY = "Monday";
    public static final String TUESDAY = "Tuesday";
    public static final String WEDNESDAY = "Wednesday";
    public static final String THURSDAY = "Thursday";
    public static final String FRIDAY = "Friday";
    public static final String SATURDAY = "Saturday";

    AlarmBuilder() {
        super("Alarm");
    }

    public final AlarmBuilder setHour(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Invalid alarm hour");
        }
        return (AlarmBuilder)this.put("hour", new long[]{n});
    }

    public final AlarmBuilder setMinute(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("Invalid alarm minute");
        }
        return (AlarmBuilder)this.put("minute", new long[]{n});
    }

    public final AlarmBuilder setMessage(String string) {
        return (AlarmBuilder)this.put("message", string);
    }

    public final AlarmBuilder setRingtone(String string) {
        return (AlarmBuilder)this.put("ringtone", string);
    }

    public final AlarmBuilder setVibrate(boolean bl) {
        return (AlarmBuilder)this.put("vibrate", bl);
    }

    public final AlarmBuilder setEnabled(boolean bl) {
        return (AlarmBuilder)this.put("enabled", bl);
    }

    public final AlarmBuilder setIdentifier(String string) {
        return (AlarmBuilder)this.put("identifier", string);
    }

    public final AlarmBuilder setDayOfWeek(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            if (SUNDAY.equals(string) || MONDAY.equals(string) || TUESDAY.equals(string) || WEDNESDAY.equals(string) || THURSDAY.equals(string) || FRIDAY.equals(string) || SATURDAY.equals(string)) continue;
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "Invalid weekday ".concat(string2) : new String("Invalid weekday "));
        }
        return (AlarmBuilder)this.put("dayOfWeek", stringArray);
    }

    public final AlarmBuilder setAlarmInstances(AlarmInstanceBuilder ... alarmInstanceBuilderArray) {
        return (AlarmBuilder)this.put("alarmInstances", alarmInstanceBuilderArray);
    }
}

