/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.icing.zzbb;
import com.google.android.gms.internal.icing.zzbd;
import com.google.android.gms.internal.icing.zzbe;
import com.google.android.gms.internal.icing.zzbf;
import com.google.android.gms.internal.icing.zzbg;
import com.google.android.gms.internal.icing.zzbq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzbc
implements zzbg {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzbc> zzcj = new ArrayMap();
    private final ContentResolver zzck;
    private final Uri uri;
    private final ContentObserver zzcl = new zzbe(this, null);
    private final Object zzcm = new Object();
    private volatile Map<String, String> zzcn;
    @GuardedBy(value="this")
    private final List<zzbd> zzco = new ArrayList<zzbd>();
    private static final String[] zzcp = new String[]{"key", "value"};

    private zzbc(ContentResolver contentResolver, Uri uri) {
        this.zzck = contentResolver;
        this.uri = uri;
        contentResolver.registerContentObserver(uri, false, this.zzcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbc zza(ContentResolver contentResolver, Uri uri) {
        Class<zzbc> clazz = zzbc.class;
        synchronized (zzbc.class) {
            zzbc zzbc2 = zzcj.get(uri);
            if (zzbc2 == null) {
                try {
                    zzbc2 = new zzbc(contentResolver, uri);
                    zzcj.put(uri, zzbc2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzbc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> zzm() {
        Map<String, String> map = this.zzcn;
        if (map == null) {
            Object object = this.zzcm;
            synchronized (object) {
                map = this.zzcn;
                if (map == null) {
                    this.zzcn = map = this.zzo();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzn() {
        zzbc zzbc2;
        Object object = this.zzcm;
        synchronized (object) {
            this.zzcn = null;
            zzbq.zzt();
        }
        zzbc zzbc3 = zzbc2 = this;
        synchronized (zzbc2) {
            Iterator<zzbd> iterator = zzbc2.zzco.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzr();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zzo() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzbf.zza(new zzbb(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzp() {
        for (zzbc zzbc2 : zzcj.values()) {
            zzbc2.zzck.unregisterContentObserver(zzbc2.zzcl);
        }
        zzcj.clear();
    }

    @Override
    public final /* synthetic */ Object zzi(String string) {
        String string2 = string;
        return this.zzm().get(string2);
    }

    final /* synthetic */ Map zzq() {
        Cursor cursor = this.zzck.query(this.uri, zzcp, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

