/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzcp;
import com.google.android.gms.internal.icing.zzeb;
import com.google.android.gms.internal.icing.zzee;
import com.google.android.gms.internal.icing.zzfq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdl
extends zzcp<Double>
implements zzee<Double>,
zzfq,
RandomAccess {
    private static final zzdl zzgz = new zzdl(new double[0], 0);
    private double[] zzha;
    private int size;

    public static zzdl zzax() {
        return zzgz;
    }

    zzdl() {
        this(new double[10], 0);
    }

    private zzdl(double[] dArray, int n) {
        this.zzha = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzha, n2, this.zzha, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdl)) {
            return super.equals(object);
        }
        zzdl zzdl2 = (zzdl)object;
        if (this.size != zzdl2.size) {
            return false;
        }
        double[] dArray = zzdl2.zzha;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzha[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzha[i]);
            n = n * 31 + zzeb.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzaj();
        zzeb.checkNotNull(collection);
        if (!(collection instanceof zzdl)) {
            return super.addAll(collection);
        }
        zzdl zzdl2 = (zzdl)collection;
        if (zzdl2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdl2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdl2.size;
        if (n > this.zzha.length) {
            this.zzha = Arrays.copyOf(this.zzha, n);
        }
        System.arraycopy(zzdl2.zzha, 0, this.zzha, this.size, zzdl2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzha[i])) continue;
            System.arraycopy(this.zzha, i + 1, this.zzha, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdl zzdl2 = this;
        zzdl2.zzaj();
        zzdl2.zzh(n);
        double d3 = zzdl2.zzha[n];
        zzdl2.zzha[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdl zzdl2 = this;
        zzdl2.zzaj();
        zzdl2.zzh(n);
        double d = zzdl2.zzha[n];
        if (n < zzdl2.size - 1) {
            System.arraycopy(zzdl2.zzha, n + 1, zzdl2.zzha, n, zzdl2.size - n - 1);
        }
        --zzdl2.size;
        ++zzdl2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdl zzdl2 = this;
        zzdl2.zzaj();
        if (n < 0 || n > zzdl2.size) {
            throw new IndexOutOfBoundsException(zzdl2.zzi(n));
        }
        if (zzdl2.size < zzdl2.zzha.length) {
            System.arraycopy(zzdl2.zzha, n, zzdl2.zzha, n + 1, zzdl2.size - n);
        } else {
            double[] dArray = new double[zzdl2.size * 3 / 2 + 1];
            System.arraycopy(zzdl2.zzha, 0, dArray, 0, n);
            System.arraycopy(zzdl2.zzha, n, dArray, n + 1, zzdl2.size - n);
            zzdl2.zzha = dArray;
        }
        zzdl2.zzha[n] = d2;
        ++zzdl2.size;
        ++zzdl2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdl zzdl2 = this;
        zzdl2.zzaj();
        if (zzdl2.size == zzdl2.zzha.length) {
            double[] dArray = new double[zzdl2.size * 3 / 2 + 1];
            System.arraycopy(zzdl2.zzha, 0, dArray, 0, zzdl2.size);
            zzdl2.zzha = dArray;
        }
        zzdl2.zzha[zzdl2.size++] = d2;
        return true;
    }

    @Override
    public final /* synthetic */ zzee zzj(int n) {
        int n2 = n;
        zzdl zzdl2 = this;
        if (n2 < zzdl2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdl(Arrays.copyOf(zzdl2.zzha, n2), zzdl2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdl zzdl2 = this;
        zzdl2.zzh(n);
        return zzdl2.zzha[n];
    }

    static {
        zzgz.zzai();
    }
}

