/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzbqn;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseNetworkException;
import com.google.firebase.FirebaseTooManyRequestsException;
import com.google.firebase.auth.FirebaseAuthActionCodeException;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthRecentLoginRequiredException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseAuthWeakPasswordException;

public final class zzbix {
    private static final SparseArray<Pair<String, String>> zzbVV = new SparseArray();

    public static FirebaseException zzcb(Status status) {
        int n = status.getStatusCode();
        switch (n) {
            case 17000: 
            case 17002: 
            case 17004: 
            case 17008: 
            case 17009: 
            case 17024: {
                return new FirebaseAuthInvalidCredentialsException(zzbix.zzpw(n), zzbix.zzpx(n));
            }
            case 17014: {
                return new FirebaseAuthRecentLoginRequiredException(zzbix.zzpw(n), zzbix.zzpx(n));
            }
            case 17007: 
            case 17012: 
            case 17025: {
                return new FirebaseAuthUserCollisionException(zzbix.zzpw(n), zzbix.zzpx(n));
            }
            case 17005: 
            case 17011: 
            case 17017: 
            case 17021: {
                return new FirebaseAuthInvalidUserException(zzbix.zzpw(n), zzbix.zzpx(n));
            }
            case 17026: {
                String string = zzbix.zza(zzbix.zzpx(n), status);
                return new FirebaseAuthWeakPasswordException(zzbix.zzpw(n), string, status.getStatusMessage());
            }
            case 17006: {
                return new FirebaseAuthException(zzbix.zzpw(n), zzbix.zzpx(n));
            }
            case 17010: {
                String string = zzbix.zza("We have blocked all requests from this device due to unusual activity. Try again later.", status);
                return new FirebaseTooManyRequestsException(string);
            }
            case 17020: {
                return new FirebaseNetworkException("A network error (such as timeout, interrupted connection or unreachable host) has occurred.");
            }
            case 17499: {
                String string = zzbix.zza("An internal error has occurred.", status);
                return new FirebaseException(string);
            }
            case 17016: {
                return new FirebaseException("User was not linked to an account with the given provider.");
            }
            case 17015: {
                return new FirebaseException("User has already been linked to the given provider.");
            }
            case 17495: {
                return new zzbqn("Please sign in before trying to get a token.");
            }
            case 17029: {
                return new FirebaseAuthActionCodeException("ERROR_EXPIRED_ACTION_CODE", "The out of band code has expired.");
            }
            case 17030: {
                return new FirebaseAuthActionCodeException("ERROR_INVALID_ACTION_CODE", "The out of band code is invalid. This can happen if the code is malformed, expired, or has already been used.");
            }
        }
        return new FirebaseException("An internal error has occurred.");
    }

    private static String zza(String string, Status status) {
        return TextUtils.isEmpty((CharSequence)status.getStatusMessage()) ? string : String.format(String.valueOf(string).concat(" [ %s ]"), status.getStatusMessage());
    }

    private static String zzpw(int n) {
        Pair pair = (Pair)zzbVV.get(n);
        return pair != null ? (String)pair.first : "INTERNAL_ERROR";
    }

    private static String zzpx(int n) {
        Pair pair = (Pair)zzbVV.get(n);
        return pair != null ? (String)pair.second : "An internal error happened";
    }

    static {
        zzbVV.put(17000, (Object)new Pair((Object)"ERROR_INVALID_CUSTOM_TOKEN", (Object)"The custom token format is incorrect. Please check the documentation."));
        zzbVV.put(17002, (Object)new Pair((Object)"ERROR_CUSTOM_TOKEN_MISMATCH", (Object)"The custom token corresponds to a different audience."));
        zzbVV.put(17004, (Object)new Pair((Object)"ERROR_INVALID_CREDENTIAL", (Object)"The supplied auth credential is malformed or has expired."));
        zzbVV.put(17008, (Object)new Pair((Object)"ERROR_INVALID_EMAIL", (Object)"The email address is badly formatted."));
        zzbVV.put(17009, (Object)new Pair((Object)"ERROR_WRONG_PASSWORD", (Object)"The password is invalid or the user does not have a password."));
        zzbVV.put(17024, (Object)new Pair((Object)"ERROR_USER_MISMATCH", (Object)"The supplied credentials do not correspond to the previously signed in user."));
        zzbVV.put(17014, (Object)new Pair((Object)"ERROR_REQUIRES_RECENT_LOGIN", (Object)"This operation is sensitive and requires recent authentication. Log in again before retrying this request."));
        zzbVV.put(17012, (Object)new Pair((Object)"ERROR_ACCOUNT_EXISTS_WITH_DIFFERENT_CREDENTIAL", (Object)"An account already exists with the same email address but different sign-in credentials. Sign in using a provider associated with this email address."));
        zzbVV.put(17007, (Object)new Pair((Object)"ERROR_EMAIL_ALREADY_IN_USE", (Object)"The email address is already in use by another account."));
        zzbVV.put(17025, (Object)new Pair((Object)"ERROR_CREDENTIAL_ALREADY_IN_USE", (Object)"This credential is already associated with a different user account."));
        zzbVV.put(17005, (Object)new Pair((Object)"ERROR_USER_DISABLED", (Object)"The user account has been disabled by an administrator."));
        zzbVV.put(17021, (Object)new Pair((Object)"ERROR_USER_TOKEN_EXPIRED", (Object)"The user's credential is no longer valid. The user must sign in again."));
        zzbVV.put(17011, (Object)new Pair((Object)"ERROR_USER_NOT_FOUND", (Object)"There is no user record corresponding to this identifier. The user may have been deleted."));
        zzbVV.put(17017, (Object)new Pair((Object)"ERROR_INVALID_USER_TOKEN", (Object)"The user's credential is no longer valid. The user must sign in again."));
        zzbVV.put(17006, (Object)new Pair((Object)"ERROR_OPERATION_NOT_ALLOWED", (Object)"This operation is not allowed. You must enable this service in the console."));
        zzbVV.put(17026, (Object)new Pair((Object)"ERROR_WEAK_PASSWORD", (Object)"The given password is invalid."));
    }
}

