/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbrp;
import com.google.android.gms.internal.zzbrq;
import com.google.android.gms.internal.zzbrr;
import com.google.android.gms.internal.zzbrv;
import com.google.android.gms.internal.zzbrx;
import com.google.android.gms.internal.zzbry;
import com.google.android.gms.internal.zzbrz;
import com.google.android.gms.internal.zzbsa;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzbrg
implements zzbrq<Date>,
zzbrz<Date> {
    private final DateFormat zzcmh;
    private final DateFormat zzcmi;
    private final DateFormat zzcmj;

    zzbrg() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzbrg(String string) {
        this(new SimpleDateFormat(string, Locale.US), new SimpleDateFormat(string));
    }

    public zzbrg(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzbrg(DateFormat dateFormat, DateFormat dateFormat2) {
        this.zzcmh = dateFormat;
        this.zzcmi = dateFormat2;
        this.zzcmj = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.zzcmj.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzbrr zza(Date date, Type type, zzbry zzbry2) {
        DateFormat dateFormat = this.zzcmi;
        synchronized (dateFormat) {
            String string = this.zzcmh.format(date);
            return new zzbrx(string);
        }
    }

    public Date zza(zzbrr zzbrr2, Type type, zzbrp zzbrp2) throws zzbrv {
        if (!(zzbrr2 instanceof zzbrx)) {
            throw new zzbrv("The date should be a string value");
        }
        Date date = this.zza(zzbrr2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string = String.valueOf(this.getClass());
        String string2 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" cannot deserialize to ").append(string2).toString());
    }

    private Date zza(zzbrr zzbrr2) {
        DateFormat dateFormat = this.zzcmi;
        synchronized (dateFormat) {
            try {
                return this.zzcmi.parse(zzbrr2.zzabu());
            }
            catch (ParseException parseException) {
                try {
                    return this.zzcmh.parse(zzbrr2.zzabu());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.zzcmj.parse(zzbrr2.zzabu());
                    }
                    catch (ParseException parseException3) {
                        throw new zzbsa(zzbrr2.zzabu(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzbrg.class.getSimpleName());
        stringBuilder.append('(').append(this.zzcmi.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzbrr zzbrr2, Type type, zzbrp zzbrp2) throws zzbrv {
        return this.zza(zzbrr2, type, zzbrp2);
    }
}

