/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbiu;
import com.google.android.gms.internal.zzbix;
import com.google.android.gms.internal.zzbiz;
import com.google.android.gms.internal.zzbjc;
import com.google.android.gms.internal.zzbjp;
import com.google.android.gms.internal.zzbkb;
import com.google.android.gms.internal.zzbke;
import com.google.android.gms.internal.zzbkg;
import com.google.android.gms.internal.zzbkh;
import com.google.android.gms.internal.zzbkk;
import com.google.android.gms.internal.zzbkl;
import com.google.android.gms.internal.zzbkm;
import com.google.android.gms.internal.zzbql;
import com.google.android.gms.internal.zzbqm;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzbql {
    private FirebaseApp zzbVx;
    private List<AuthStateListener> mListeners;
    private zzbiu zzbVy;
    private FirebaseUser zzbVz;
    private zzbkl zzbVA;
    private zzbkm zzbVB;
    private static Map<String, FirebaseAuth> zzbha = new ArrayMap();
    private static FirebaseAuth zzbVC;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzc(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zzb(firebaseApp), new zzbkl(firebaseApp.getApplicationContext(), firebaseApp.zzTu(), zzbiz.zzUg()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzbiu zzbiu2, zzbkl zzbkl2) {
        this.zzbVx = (FirebaseApp)zzac.zzw((Object)firebaseApp);
        this.zzbVy = (zzbiu)((Object)zzac.zzw((Object)((Object)zzbiu2)));
        this.zzbVA = (zzbkl)zzac.zzw((Object)zzbkl2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzbVB = zzbkm.zzUK();
        this.zzTT();
    }

    static zzbiu zzb(FirebaseApp firebaseApp) {
        zzbjc.zza zza2 = new zzbjc.zza.zza(firebaseApp.getOptions().getApiKey()).zzUj();
        return zzbjc.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzbVz;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzac.zzw((Object)firebaseUser);
        if (this.zzbVz == null) {
            this.zzbVz = firebaseUser;
        } else {
            this.zzbVz.zzaT(firebaseUser.isAnonymous());
            this.zzbVz.zzR(firebaseUser.getProviderData());
        }
        if (bl) {
            this.zzbVA.zzf(this.zzbVz);
        }
        if (bl2) {
            this.zza(this.zzbVz);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzbjp zzbjp2, boolean bl) {
        boolean bl2;
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)((Object)zzbjp2));
        if (this.zzbVz == null) {
            bl2 = true;
        } else {
            String string;
            zzbjp zzbjp3 = this.zzbVz.zzTW();
            String string2 = zzbjp3.getAccessToken();
            boolean bl3 = !string2.equals(string = zzbjp2.getAccessToken());
            boolean bl4 = this.zzbVz.getUid().equals(firebaseUser.getUid());
            bl2 = !bl4 || bl3;
        }
        if (bl2) {
            if (this.zzbVz != null) {
                this.zzbVz.zza(zzbjp2);
            }
            this.zza(firebaseUser, bl, false);
            this.zza(this.zzbVz);
        }
        if (bl) {
            this.zzbVA.zza(firebaseUser, zzbjp2);
        }
    }

    public void zzTS() {
        if (this.zzbVz != null) {
            this.zzbVA.zzh(this.zzbVz);
            this.zzbVz = null;
        }
        this.zzbVA.zzUJ();
        this.zza(null);
    }

    private static FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzd(firebaseApp);
    }

    private static synchronized FirebaseAuth zzd(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzbha.get(firebaseApp.zzTu());
        if (firebaseAuth == null) {
            firebaseAuth = new zzbkg(firebaseApp);
            firebaseApp.zza((zzbql)firebaseAuth);
            if (zzbVC == null) {
                zzbVC = firebaseAuth;
            }
            zzbha.put(firebaseApp.zzTu(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.zzbVB.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzTY() : null;
        final zzbqm zzbqm2 = new zzbqm(string);
        this.zzbVB.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.zzbVx.zza(zzbqm2);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zzaS(boolean bl) {
        return this.zza(this.zzbVz, bl);
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzbix.zzcb(new Status(17495)));
        }
        zzbjp zzbjp2 = this.zzbVz.zzTW();
        if (zzbjp2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzbjp2.getAccessToken()));
        }
        return this.zzbVy.zza(this.zzbVx, firebaseUser, zzbjp2.zzUs(), new zzbkb(){

            @Override
            public void zza(@NonNull zzbjp zzbjp2, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, zzbjp2, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzac.zzw((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbVy.zzb(this.zzbVx, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzbkb)new zza());
        }
        return this.zzbVy.zza(this.zzbVx, authCredential, (zzbkb)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbVy.zza(this.zzbVx, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.zzbVy.zza(this.zzbVx, firebaseUser, authCredential, (zzbkb)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zza(this.zzbVx, string, (zzbkb)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        return this.zzbVy.zzb(this.zzbVx, string, string2, (zzbkb)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzbVz != null && this.zzbVz.isAnonymous()) {
            zzbkh zzbkh2 = (zzbkh)this.zzbVz;
            zzbke zzbke2 = new zzbke(zzbkh2);
            return Tasks.forResult((Object)zzbke2);
        }
        return this.zzbVy.zza(this.zzbVx, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzac.zzw((Object)firebaseUser);
        return this.zzbVy.zzb(this.zzbVx, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        return this.zzbVy.zzb(this.zzbVx, firebaseUser, authCredential, (zzbkb)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzdv((String)string);
        zzac.zzw((Object)firebaseUser);
        return this.zzbVy.zzd(this.zzbVx, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        return this.zzbVy.zza(this.zzbVx, string, string2, (zzbkb)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zza(this.zzbVx, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)((Object)userProfileChangeRequest));
        return this.zzbVy.zza(this.zzbVx, firebaseUser, userProfileChangeRequest, (zzbkb)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzdv((String)string);
        return this.zzbVy.zzb(this.zzbVx, firebaseUser, string, (zzbkb)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzdv((String)string);
        return this.zzbVy.zzc(this.zzbVx, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zzb(this.zzbVx, string);
    }

    @NonNull
    public Task<Void> zzix(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zzc(this.zzbVx, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zzd(this.zzbVx, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zze(this.zzbVx, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzac.zzdv((String)string);
        return this.zzbVy.zzf(this.zzbVx, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        return this.zzbVy.zza(this.zzbVx, string, string2);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzac.zzw((Object)firebaseUser);
        return this.zzbVy.zza(firebaseUser, new zzbkk(){

            @Override
            public void zzTU() {
                if (FirebaseAuth.this.zzbVz.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzTS();
                }
            }
        });
    }

    public void signOut() {
        this.zzTS();
    }

    protected void zzTT() {
        zzbjp zzbjp2;
        this.zzbVz = this.zzbVA.zzUI();
        if (this.zzbVz != null && (zzbjp2 = this.zzbVA.zzg(this.zzbVz)) != null) {
            this.zza(this.zzbVz, zzbjp2, false);
        }
    }

    class zza
    implements zzbkb {
        zza() {
        }

        @Override
        public void zza(@NonNull zzbjp zzbjp2, @NonNull FirebaseUser firebaseUser) {
            zzac.zzw((Object)((Object)zzbjp2));
            zzac.zzw((Object)firebaseUser);
            firebaseUser.zza(zzbjp2);
            FirebaseAuth.this.zza(firebaseUser, zzbjp2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

