/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbum;
import com.google.android.gms.internal.zzbur;
import com.google.android.gms.internal.zzbvo;
import com.google.android.gms.internal.zzbvp;
import com.google.android.gms.internal.zzbvs;
import com.google.android.gms.internal.zzbwg;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzbvk {
    private final Map<Type, zzbum<?>> zzcpg;

    public zzbvk(Map<Type, zzbum<?>> map) {
        this.zzcpg = map;
    }

    public <T> zzbvp<T> zzb(zzbwg<T> zzbwg2) {
        final Type type = zzbwg2.zzadQ();
        Class<T> clazz = zzbwg2.zzadP();
        final zzbum<?> zzbum2 = this.zzcpg.get(type);
        if (zzbum2 != null) {
            return new zzbvp<T>(){

                @Override
                public T zzadx() {
                    return zzbum2.zza(type);
                }
            };
        }
        final zzbum<?> zzbum3 = this.zzcpg.get(clazz);
        if (zzbum3 != null) {
            return new zzbvp<T>(){

                @Override
                public T zzadx() {
                    return zzbum3.zza(type);
                }
            };
        }
        zzbvp<T> zzbvp2 = this.zzk(clazz);
        if (zzbvp2 != null) {
            return zzbvp2;
        }
        zzbvp<T> zzbvp3 = this.zzc(type, clazz);
        if (zzbvp3 != null) {
            return zzbvp3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzbvp<T> zzk(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzbvp<T>(){

                @Override
                public T zzadx() {
                    try {
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzbvp<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzbvp<T>(){

                    @Override
                    public T zzadx() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzbvp<T>(){

                    @Override
                    public T zzadx() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string = String.valueOf(type.toString());
                            throw new zzbur(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                        }
                        String string = String.valueOf(type.toString());
                        throw new zzbur(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzbvp<T>(){

                    @Override
                    public T zzadx() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzbvp<T>(){

                    @Override
                    public T zzadx() {
                        return new LinkedList();
                    }
                };
            }
            return new zzbvp<T>(){

                @Override
                public T zzadx() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzbvp<T>(){

                    @Override
                    public T zzadx() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzbwg.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).zzadP())) {
                return new zzbvp<T>(){

                    @Override
                    public T zzadx() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzbvp<T>(){

                @Override
                public T zzadx() {
                    return new zzbvo();
                }
            };
        }
        return null;
    }

    private <T> zzbvp<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzbvp<T>(){
            private final zzbvs zzcpJ = zzbvs.zzadC();

            @Override
            public T zzadx() {
                try {
                    Object t = this.zzcpJ.zze(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string).length()).append("Unable to invoke no-args constructor for ").append(string).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.zzcpg.toString();
    }
}

